/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.processor.interceptor;

import java.io.Serializable;
import java.util.Date;
import org.apache.camel.Exchange;
import org.apache.camel.Message;
import org.apache.camel.RouteNode;
import org.apache.camel.model.ProcessorDefinition;
import org.apache.camel.processor.interceptor.TraceEventMessage;
import org.apache.camel.spi.TracedRouteNodes;
import org.apache.camel.util.MessageHelper;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class DefaultTraceEventMessage
implements Serializable,
TraceEventMessage {
    private static final long serialVersionUID = -4549012920528941203L;
    private Date timestamp;
    private String fromEndpointUri;
    private String previousNode;
    private String toNode;
    private String exchangeId;
    private String shortExchangeId;
    private String exchangePattern;
    private String properties;
    private String headers;
    private String body;
    private String bodyType;
    private String outHeaders;
    private String outBody;
    private String outBodyType;
    private String causedByException;
    private final transient Exchange tracedExchange;

    public DefaultTraceEventMessage(Date timestamp, ProcessorDefinition<?> toNode, Exchange exchange) {
        this.tracedExchange = exchange;
        Message in = exchange.getIn();
        this.timestamp = timestamp;
        this.fromEndpointUri = exchange.getFromEndpoint() != null ? exchange.getFromEndpoint().getEndpointUri() : null;
        this.previousNode = DefaultTraceEventMessage.extractFromNode(exchange);
        this.toNode = DefaultTraceEventMessage.extractToNode(exchange);
        this.exchangeId = exchange.getExchangeId();
        this.shortExchangeId = DefaultTraceEventMessage.extractShortExchangeId(exchange);
        this.exchangePattern = exchange.getPattern().toString();
        this.properties = exchange.getProperties().isEmpty() ? null : exchange.getProperties().toString();
        this.headers = in.getHeaders().isEmpty() ? null : in.getHeaders().toString();
        this.body = MessageHelper.extractBodyAsString(in);
        this.bodyType = MessageHelper.getBodyTypeName(in);
        if (exchange.hasOut()) {
            Message out = exchange.getOut();
            this.outHeaders = out.getHeaders().isEmpty() ? null : out.getHeaders().toString();
            this.outBody = MessageHelper.extractBodyAsString(out);
            this.outBodyType = MessageHelper.getBodyTypeName(out);
        }
        this.causedByException = exchange.getException() != null ? exchange.getException().toString() : null;
    }

    private static String extractShortExchangeId(Exchange exchange) {
        return exchange.getExchangeId().substring(exchange.getExchangeId().indexOf("/") + 1);
    }

    private static String extractFromNode(Exchange exchange) {
        if (exchange.getUnitOfWork() != null) {
            TracedRouteNodes traced = exchange.getUnitOfWork().getTracedRouteNodes();
            RouteNode last = traced.getSecondLastNode();
            return last != null ? last.getLabel(exchange) : null;
        }
        return null;
    }

    private static String extractToNode(Exchange exchange) {
        if (exchange.getUnitOfWork() != null) {
            TracedRouteNodes traced = exchange.getUnitOfWork().getTracedRouteNodes();
            RouteNode last = traced.getLastNode();
            return last != null ? last.getLabel(exchange) : null;
        }
        return null;
    }

    @Override
    public Date getTimestamp() {
        return this.timestamp;
    }

    @Override
    public String getFromEndpointUri() {
        return this.fromEndpointUri;
    }

    @Override
    public String getPreviousNode() {
        return this.previousNode;
    }

    @Override
    public String getToNode() {
        return this.toNode;
    }

    @Override
    public String getExchangeId() {
        return this.exchangeId;
    }

    @Override
    public String getShortExchangeId() {
        return this.shortExchangeId;
    }

    @Override
    public String getExchangePattern() {
        return this.exchangePattern;
    }

    @Override
    public String getProperties() {
        return this.properties;
    }

    @Override
    public String getHeaders() {
        return this.headers;
    }

    @Override
    public String getBody() {
        return this.body;
    }

    @Override
    public String getBodyType() {
        return this.bodyType;
    }

    @Override
    public String getOutBody() {
        return this.outBody;
    }

    @Override
    public String getOutBodyType() {
        return this.outBodyType;
    }

    public String getOutHeaders() {
        return this.outHeaders;
    }

    public void setOutHeaders(String outHeaders) {
        this.outHeaders = outHeaders;
    }

    @Override
    public String getCausedByException() {
        return this.causedByException;
    }

    public void setTimestamp(Date timestamp) {
        this.timestamp = timestamp;
    }

    public void setFromEndpointUri(String fromEndpointUri) {
        this.fromEndpointUri = fromEndpointUri;
    }

    public void setPreviousNode(String previousNode) {
        this.previousNode = previousNode;
    }

    public void setToNode(String toNode) {
        this.toNode = toNode;
    }

    public void setExchangeId(String exchangeId) {
        this.exchangeId = exchangeId;
    }

    public void setShortExchangeId(String shortExchangeId) {
        this.shortExchangeId = shortExchangeId;
    }

    public void setExchangePattern(String exchangePattern) {
        this.exchangePattern = exchangePattern;
    }

    public void setProperties(String properties) {
        this.properties = properties;
    }

    public void setHeaders(String headers) {
        this.headers = headers;
    }

    public void setBody(String body) {
        this.body = body;
    }

    public void setBodyType(String bodyType) {
        this.bodyType = bodyType;
    }

    public void setOutBody(String outBody) {
        this.outBody = outBody;
    }

    public void setOutBodyType(String outBodyType) {
        this.outBodyType = outBodyType;
    }

    public void setCausedByException(String causedByException) {
        this.causedByException = causedByException;
    }

    @Override
    public Exchange getTracedExchange() {
        return this.tracedExchange;
    }

    public String toString() {
        return "TraceEventMessage[" + this.exchangeId + "] on node: " + this.toNode;
    }
}

