/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.model.dataformat;

import java.security.Key;
import java.security.spec.AlgorithmParameterSpec;
import javax.xml.bind.annotation.XmlAccessType;
import javax.xml.bind.annotation.XmlAccessorType;
import javax.xml.bind.annotation.XmlAttribute;
import javax.xml.bind.annotation.XmlRootElement;
import org.apache.camel.model.DataFormatDefinition;
import org.apache.camel.spi.DataFormat;
import org.apache.camel.spi.RouteContext;
import org.apache.camel.util.CamelContextHelper;
import org.apache.camel.util.ObjectHelper;

@XmlRootElement(name="crypto")
@XmlAccessorType(value=XmlAccessType.FIELD)
public class CryptoDataFormat
extends DataFormatDefinition {
    @XmlAttribute
    private String algorithm;
    @XmlAttribute
    private String cryptoProvider;
    @XmlAttribute
    private String keyRef;
    @XmlAttribute
    private String initVectorRef;
    @XmlAttribute
    private String algorithmParameterRef;
    @XmlAttribute
    private Integer buffersize;
    @XmlAttribute
    private String macAlgorithm = "HmacSHA1";
    @XmlAttribute
    private Boolean shouldAppendHMAC;
    @XmlAttribute
    private Boolean inline;

    public CryptoDataFormat() {
        super("crypto");
    }

    protected DataFormat createDataFormat(RouteContext routeContext) {
        DataFormat cryptoFormat = super.createDataFormat(routeContext);
        if (ObjectHelper.isNotEmpty(this.keyRef)) {
            Key key = CamelContextHelper.mandatoryLookup(routeContext.getCamelContext(), this.keyRef, Key.class);
            this.setProperty(cryptoFormat, "key", key);
        }
        if (ObjectHelper.isNotEmpty(this.algorithmParameterRef)) {
            AlgorithmParameterSpec spec = CamelContextHelper.mandatoryLookup(routeContext.getCamelContext(), this.algorithmParameterRef, AlgorithmParameterSpec.class);
            this.setProperty(cryptoFormat, "AlgorithmParameterSpec", spec);
        }
        if (ObjectHelper.isNotEmpty(this.initVectorRef)) {
            byte[] iv = CamelContextHelper.mandatoryLookup(routeContext.getCamelContext(), this.initVectorRef, byte[].class);
            this.setProperty(cryptoFormat, "InitializationVector", iv);
        }
        return cryptoFormat;
    }

    protected void configureDataFormat(DataFormat dataFormat) {
        Boolean answer = ObjectHelper.toBoolean(this.shouldAppendHMAC);
        if (answer != null && !answer.booleanValue()) {
            this.setProperty(dataFormat, "shouldAppendHMAC", Boolean.FALSE);
        } else {
            this.setProperty(dataFormat, "shouldAppendHMAC", Boolean.TRUE);
        }
        answer = ObjectHelper.toBoolean(this.inline);
        if (answer != null && answer.booleanValue()) {
            this.setProperty(dataFormat, "shouldInlineInitializationVector", Boolean.TRUE);
        } else {
            this.setProperty(dataFormat, "shouldInlineInitializationVector", Boolean.FALSE);
        }
        if (this.algorithm != null) {
            this.setProperty(dataFormat, "algorithm", this.algorithm);
        }
        if (this.cryptoProvider != null) {
            this.setProperty(dataFormat, "cryptoProvider", this.cryptoProvider);
        }
        if (this.macAlgorithm != null) {
            this.setProperty(dataFormat, "macAlgorithm", this.macAlgorithm);
        }
        if (this.buffersize != null) {
            this.setProperty(dataFormat, "buffersize", this.buffersize);
        }
    }

    public void setAlgorithm(String algorithm) {
        this.algorithm = algorithm;
    }

    public void setCryptoProvider(String cryptoProvider) {
        this.cryptoProvider = cryptoProvider;
    }

    public void setKeyReference(String keyReference) {
        this.keyRef = keyReference;
    }

    public void setInitVectorRef(String initVectorRef) {
        this.initVectorRef = initVectorRef;
    }

    public void setAlgorithmParameterRef(String algorithmParameterRef) {
        this.algorithmParameterRef = algorithmParameterRef;
    }

    public void setBuffersize(Integer buffersize) {
        this.buffersize = buffersize;
    }

    public void setMacAlgorithm(String macAlgorithm) {
        this.macAlgorithm = macAlgorithm;
    }

    public void setShouldAppendHMAC(Boolean shouldAppendHMAC) {
        this.shouldAppendHMAC = shouldAppendHMAC;
    }

    public void setShouldInlineInitVector(Boolean inline) {
        this.inline = inline;
    }
}

