/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.model;

import java.util.Collections;
import java.util.List;
import javax.xml.bind.annotation.XmlAccessType;
import javax.xml.bind.annotation.XmlAccessorType;
import javax.xml.bind.annotation.XmlAttribute;
import javax.xml.bind.annotation.XmlRootElement;
import javax.xml.bind.annotation.XmlTransient;
import org.apache.camel.Processor;
import org.apache.camel.RuntimeCamelException;
import org.apache.camel.converter.IOConverter;
import org.apache.camel.model.ProcessorDefinition;
import org.apache.camel.processor.ConvertBodyProcessor;
import org.apache.camel.spi.RouteContext;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@XmlRootElement(name="convertBodyTo")
@XmlAccessorType(value=XmlAccessType.FIELD)
public class ConvertBodyDefinition
extends ProcessorDefinition<ConvertBodyDefinition> {
    @XmlAttribute
    private String type;
    @XmlAttribute(required=false)
    private String charset;
    @XmlTransient
    private Class<?> typeClass;

    public ConvertBodyDefinition() {
    }

    public ConvertBodyDefinition(String type) {
        this.setType(type);
    }

    public ConvertBodyDefinition(Class<?> typeClass) {
        this.setTypeClass(typeClass);
        this.setType(typeClass.getName());
    }

    public ConvertBodyDefinition(Class<?> typeClass, String charset) {
        this.setTypeClass(typeClass);
        this.setType(typeClass.getName());
        this.setCharset(charset);
    }

    public String toString() {
        return "convertBodyTo[" + this.getType() + "]";
    }

    @Override
    public String getShortName() {
        return "convertBodyTo";
    }

    @Override
    public Processor createProcessor(RouteContext routeContext) throws Exception {
        if (this.getTypeClass() == null) {
            this.typeClass = routeContext.getCamelContext().getClassResolver().resolveClass(this.getType());
            if (this.getTypeClass() == null) {
                throw new RuntimeCamelException("Cannot load the class with the class name: " + this.getType());
            }
        }
        if (this.charset != null) {
            IOConverter.validateCharset(this.charset);
        }
        return new ConvertBodyProcessor(this.getTypeClass(), this.getCharset());
    }

    @Override
    public List<ProcessorDefinition> getOutputs() {
        return Collections.EMPTY_LIST;
    }

    public String getType() {
        return this.type;
    }

    public void setType(String type) {
        this.type = type;
    }

    public Class<?> getTypeClass() {
        return this.typeClass;
    }

    public void setTypeClass(Class<?> typeClass) {
        this.typeClass = typeClass;
    }

    public String getCharset() {
        return this.charset;
    }

    public void setCharset(String charset) {
        this.charset = charset;
    }
}

