/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.management;

import javax.management.ObjectName;
import org.apache.camel.CamelContext;
import org.apache.camel.Endpoint;
import org.apache.camel.management.DefaultManagementAgent;
import org.apache.camel.management.DefaultManagementStrategy;
import org.apache.camel.management.mbean.ManagedCamelContext;
import org.apache.camel.management.mbean.ManagedComponent;
import org.apache.camel.management.mbean.ManagedConsumer;
import org.apache.camel.management.mbean.ManagedEndpoint;
import org.apache.camel.management.mbean.ManagedErrorHandler;
import org.apache.camel.management.mbean.ManagedEventNotifier;
import org.apache.camel.management.mbean.ManagedProcessor;
import org.apache.camel.management.mbean.ManagedProducer;
import org.apache.camel.management.mbean.ManagedRoute;
import org.apache.camel.management.mbean.ManagedService;
import org.apache.camel.management.mbean.ManagedThreadPool;
import org.apache.camel.management.mbean.ManagedTracer;
import org.apache.camel.model.ProcessorDefinition;
import org.apache.camel.spi.ManagementAgent;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.fusesource.commons.management.Statistic;
import org.fusesource.commons.management.basic.StatisticImpl;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ManagedManagementStrategy
extends DefaultManagementStrategy {
    private static final transient Log LOG = LogFactory.getLog(ManagedManagementStrategy.class);

    public ManagedManagementStrategy() {
    }

    public ManagedManagementStrategy(CamelContext camelContext) {
        this(new DefaultManagementAgent(camelContext));
    }

    public ManagedManagementStrategy(ManagementAgent managementAgent) {
        this.setManagementAgent(managementAgent);
    }

    @Override
    public void manageObject(Object managedObject) throws Exception {
        this.manageNamedObject(managedObject, null);
    }

    @Override
    public void manageNamedObject(Object managedObject, Object preferedName) throws Exception {
        ObjectName objectName = this.getObjectName(managedObject, preferedName);
        if (objectName != null) {
            this.getManagementAgent().register(managedObject, objectName);
        }
    }

    @Override
    public <T> T getManagedObjectName(Object managedObject, String customName, Class<T> nameType) throws Exception {
        if (managedObject == null) {
            return null;
        }
        ObjectName objectName = null;
        if (managedObject instanceof ManagedCamelContext) {
            ManagedCamelContext mcc = (ManagedCamelContext)managedObject;
            objectName = this.getManagementNamingStrategy().getObjectNameForCamelContext(mcc.getContext());
        } else if (managedObject instanceof ManagedComponent) {
            ManagedComponent mc = (ManagedComponent)managedObject;
            objectName = this.getManagementNamingStrategy().getObjectNameForComponent(mc.getComponent(), mc.getComponentName());
        } else if (managedObject instanceof ManagedEndpoint) {
            ManagedEndpoint me = (ManagedEndpoint)managedObject;
            objectName = this.getManagementNamingStrategy().getObjectNameForEndpoint(me.getEndpoint());
        } else if (managedObject instanceof Endpoint) {
            objectName = this.getManagementNamingStrategy().getObjectNameForEndpoint((Endpoint)managedObject);
        } else if (managedObject instanceof ManagedRoute) {
            ManagedRoute mr = (ManagedRoute)managedObject;
            objectName = this.getManagementNamingStrategy().getObjectNameForRoute(mr.getRoute());
        } else if (managedObject instanceof ManagedErrorHandler) {
            ManagedErrorHandler meh = (ManagedErrorHandler)managedObject;
            objectName = this.getManagementNamingStrategy().getObjectNameForErrorHandler(meh.getRouteContext(), meh.getErrorHandler(), meh.getErrorHandlerBuilder());
        } else if (managedObject instanceof ManagedProcessor) {
            ManagedProcessor mp = (ManagedProcessor)managedObject;
            objectName = this.getManagementNamingStrategy().getObjectNameForProcessor(mp.getContext(), mp.getProcessor(), mp.getDefinition());
        } else if (managedObject instanceof ManagedConsumer) {
            ManagedConsumer ms = (ManagedConsumer)managedObject;
            objectName = this.getManagementNamingStrategy().getObjectNameForConsumer(ms.getContext(), ms.getConsumer());
        } else if (managedObject instanceof ManagedProducer) {
            ManagedProducer ms = (ManagedProducer)managedObject;
            objectName = this.getManagementNamingStrategy().getObjectNameForProducer(ms.getContext(), ms.getProducer());
        } else if (managedObject instanceof ManagedTracer) {
            ManagedTracer mt = (ManagedTracer)managedObject;
            objectName = this.getManagementNamingStrategy().getObjectNameForTracer(mt.getContext(), mt.getTracer());
        } else if (managedObject instanceof ManagedEventNotifier) {
            ManagedEventNotifier men = (ManagedEventNotifier)managedObject;
            objectName = this.getManagementNamingStrategy().getObjectNameForEventNotifier(men.getContext(), men.getEventNotifier());
        } else if (managedObject instanceof ManagedThreadPool) {
            ManagedThreadPool mes = (ManagedThreadPool)managedObject;
            objectName = this.getManagementNamingStrategy().getObjectNameForThreadPool(mes.getContext(), mes.getThreadPool());
        } else if (managedObject instanceof ManagedService) {
            ManagedService ms = (ManagedService)managedObject;
            objectName = this.getManagementNamingStrategy().getObjectNameForService(ms.getContext(), ms.getService());
        }
        return nameType.cast(objectName);
    }

    @Override
    public void unmanageObject(Object managedObject) throws Exception {
        ObjectName objectName = this.getManagedObjectName(managedObject, null, ObjectName.class);
        this.unmanageNamedObject(objectName);
    }

    @Override
    public void unmanageNamedObject(Object name) throws Exception {
        ObjectName objectName = this.getObjectName(null, name);
        if (objectName != null) {
            this.getManagementAgent().unregister(objectName);
        }
    }

    @Override
    public boolean isManaged(Object managableObject, Object name) {
        try {
            ObjectName objectName = this.getObjectName(managableObject, name);
            if (objectName != null) {
                return this.getManagementAgent().isRegistered(objectName);
            }
        }
        catch (Exception e) {
            LOG.warn((Object)"Cannot check whether the managed object is registered. This exception will be ignored.", (Throwable)e);
        }
        return false;
    }

    @Override
    public boolean manageProcessor(ProcessorDefinition<?> definition) {
        return true;
    }

    @Override
    public Statistic createStatistic(String name, Object owner, Statistic.UpdateMode updateMode) {
        return new StatisticImpl(updateMode);
    }

    private ObjectName getObjectName(Object managedObject, Object preferedName) throws Exception {
        ObjectName objectName;
        if (preferedName != null && preferedName instanceof String) {
            String customName = (String)preferedName;
            objectName = this.getManagedObjectName(managedObject, customName, ObjectName.class);
        } else {
            objectName = preferedName != null && preferedName instanceof ObjectName ? (ObjectName)preferedName : this.getManagedObjectName(managedObject, null, ObjectName.class);
        }
        return objectName;
    }
}

