#!/bin/bash
export PERFECUT_ARTIFACT=hawtio

#MVN_SETTINGS="--settings ${HOME}/.m2/fuseide-settings.xml"

#. `dirname $0 2> /dev/null`/common.sh

ACTION=$1

basedir="$(cd $(dirname "${BASH_SOURCE[0]}"); pwd -P)/$(basename "${BASH_SOURCE[0]}")"
[[ ! -f "$basedir" ]] && basedir="$(cd $(dirname "$0"); pwd -P)/$(basename "$0")"
[[ ! -f "$basedir" ]] && basedir="" && echo 'No full path to running script found!' && exit 1

basedir="${basedir%/*}"
cd $basedir
export basedir=`pwd`
cd - > /dev/null

if [ -z "$JAVA_HOME" ] ; then
  export JAVA_HOME="/usr/lib/jvm/java-6-sun"
  export PATH="${JAVA_HOME}/bin:${PATH}"
fi

if [ -z "$M2_HOME" ] ; then
  export M2_HOME="/opt/apache-maven-3.0.4"
fi
export MVN=${M2_HOME}/bin/mvn

git stash
git checkout fuse-release
git pull

BUILDNO=`cat ${PERFECUT_ARTIFACT}-buildno.txt`

BUILDNO=$((${BUILDNO}+1))
BUILD=`printf "%02d" "$((${BUILDNO}))"` 

echo ============================================================================
echo " Incrementing build train to: ${PERFECUT_ARTIFACT}-${BUILD}"
echo "Using MVN_SETTINGS: ${MVN_SETTINGS}"
echo ============================================================================

echo ${BUILDNO} > ${PERFECUT_ARTIFACT}-buildno.txt
VERSION=1.2-M-redhat-${BUILDNO}
git commit -a -m "getting ready for version ${VERSION}"
git push origin fuse-release

echo "Creating release branch for ${VERSION}"

git branch release-${VERSION}
git checkout release-${VERSION}

# root project uses regular maven versions
find * -name 'pom.xml' | xargs perl -pi -e "s/<version>.*-SNAPSHOT<\/version>/<version>${VERSION}<\/version>/g"

#echo "Zapping P2 cache of fusesource and snapshot stuff"
#rm -rf /mnt/hudson/.m2/repository/p2/osgi/bundle/org.fusesource*
#rm -rf /mnt/hudson/.m2/repository/p2/osgi/bundle/com.fusesource*
rm -rf /mnt/hudson/.m2/repository/p2/osgi/bundle/*/*SNAPSHOT

#rm -rf /mnt/hudson/.m2/repository/org/fusesource/
#rm -rf /mnt/hudson/.m2/repository/com/fusesource/

rm -rf "${basedir}/rsync_repo"

${MVN} \
   -P release,grunt \
   -Ddeploy.altRepository=localfile::default::file://${basedir}/rsync_repo \
   -DaltDeploymentRepository=localfile::default::file://${basedir}/rsync_repo \
   clean deploy

if [ $? -eq 0 ]         # Test exit status of "mvn" command.
then
  echo "Maven worked!"
else  
  echo "Maven failed. Exit now..."
  git stash
  exit $?
fi

echo "Now committing branch"

git commit -a -m "Release ${VERSION}"

echo "Pushing to the fuseenterprise private repo"
git push origin release-${VERSION}
git chekcout fuse-release

echo "Release ${VERSION} completed"

rsync -avz -e "ssh -i /root/.ssh/id_rsa.deploy" ${basedir}/rsync_repo/ 174.129.212.216:/home/nexus/opt/sonatype-work/nexus/storage/jboss-fuse-6.1.x-001

echo "Now updating github fuse to use this new version"
rm -rf fuse*
git clone git@github.com:jboss-fuse/fuse.git
cd fuse
git branch perfectus-hawtio
git checkout perfectus-hawtio
sed -i "s/<\(hawtio-version\)>.*redhat.*<\/\1>/<\1>$VERSION<\/\1>/g" pom.xml
git commit -m "[${VERSION}] Updating to hawtio version" pom.xml
git push origin -f perfectus-hawtio

# echo "Now updating perfectus to use this new version"
# rm -rf fuseenterprise*
# git clone -b 6.1.x.redhat-stable ssh://git@forge.fusesource.com/fuseenterprise.git
# cd fuseenterprise
# sed -i "s/<\(hawtio-version\)>.*<\/\1>/<\1>$VERSION<\/\1>/g" pom.xml
# git commit -m "[${VERSION}] Updating to hawtio version" pom.xml
# git push origin 6.1.x.redhat-stable
# 
