/*
 * Licensed to the Apache Software Foundation (ASF) under one or more
 * contributor license agreements.  See the NOTICE file distributed with
 * this work for additional information regarding copyright ownership.
 * The ASF licenses this file to You under the Apache License, Version 2.0
 * (the "License"); you may not use this file except in compliance with
 * the License.  You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package org.apache.servicemix.jbi.cluster.engine;

import java.util.Hashtable;
import java.util.Properties;

import org.springframework.osgi.context.BundleContextAware;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.beans.factory.DisposableBean;
import org.osgi.framework.BundleContext;
import org.osgi.framework.ServiceRegistration;

public class OsgiSimpleClusterRegistration extends SimpleClusterRegistration
                                           implements BundleContextAware, InitializingBean, DisposableBean {

    private BundleContext bundleContext;
    private ServiceRegistration serviceRegistration;

    public BundleContext getBundleContext() {
        return bundleContext;
    }

    public void setBundleContext(BundleContext bundleContext) {
        this.bundleContext = bundleContext;
    }

    public void afterPropertiesSet() throws Exception {
        init();
        serviceRegistration = bundleContext.registerService(ClusterRegistration.class.getName(), this, new Hashtable<String, Object>());
    }

    public void destroy() throws Exception {
        if (serviceRegistration != null) {
            serviceRegistration.unregister();
        }
    }
}
