/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.view;

import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.camel.CamelContext;
import org.apache.camel.model.ChoiceDefinition;
import org.apache.camel.model.FromDefinition;
import org.apache.camel.model.MulticastDefinition;
import org.apache.camel.model.ProcessorDefinition;
import org.apache.camel.model.RouteDefinition;
import org.apache.camel.model.ToDefinition;
import org.apache.camel.model.language.ExpressionDefinition;
import org.apache.camel.util.CollectionStringBuffer;
import org.apache.camel.view.NodeData;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class GraphGeneratorSupport {
    protected final transient Log log = LogFactory.getLog(this.getClass());
    protected String dir;
    protected int clusterCounter;
    protected String extension;
    private final String imagePrefix = "http://camel.apache.org/images/eip/";
    private final Map<Object, NodeData> nodeMap = new HashMap<Object, NodeData>();
    private final boolean makeParentDirs = true;
    private Map<String, List<RouteDefinition>> routeGroupMap;

    protected GraphGeneratorSupport(String dir, String extension) {
        this.dir = dir;
        this.extension = extension;
    }

    public String getRoutesText(CamelContext context) throws IOException {
        List<RouteDefinition> routes = context.getRouteDefinitions();
        this.routeGroupMap = this.createRouteGroupMap(routes);
        return this.createRouteMapText();
    }

    private String createRouteMapText() {
        StringWriter buffer = new StringWriter();
        PrintWriter writer = new PrintWriter(buffer);
        this.generateFile(writer, this.routeGroupMap);
        writer.close();
        return buffer.toString();
    }

    public void drawRoutes(CamelContext context) throws IOException {
        File parent = new File(this.dir);
        parent.mkdirs();
        List<RouteDefinition> routes = context.getRouteDefinitions();
        this.routeGroupMap = this.createRouteGroupMap(routes);
        this.generateFile(parent, "routes" + this.extension, this.routeGroupMap);
        if (this.routeGroupMap.size() >= 1) {
            Set<Map.Entry<String, List<RouteDefinition>>> entries = this.routeGroupMap.entrySet();
            for (Map.Entry<String, List<RouteDefinition>> entry : entries) {
                HashMap<String, List<RouteDefinition>> map = new HashMap<String, List<RouteDefinition>>();
                String group = entry.getKey();
                map.put(group, entry.getValue());
                this.generateFile(parent, group + this.extension, map);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void generateFile(File parent, String fileName, Map<String, List<RouteDefinition>> map) throws IOException {
        this.nodeMap.clear();
        this.clusterCounter = 0;
        PrintWriter writer = new PrintWriter(new FileWriter(new File(parent, fileName)));
        try {
            this.generateFile(writer, map);
        }
        finally {
            writer.close();
        }
    }

    protected abstract void generateFile(PrintWriter var1, Map<String, List<RouteDefinition>> var2);

    protected boolean isMulticastNode(ProcessorDefinition node) {
        return node instanceof MulticastDefinition || node instanceof ChoiceDefinition;
    }

    protected String getLabel(List<ExpressionDefinition> expressions) {
        CollectionStringBuffer buffer = new CollectionStringBuffer();
        for (ExpressionDefinition expression : expressions) {
            buffer.append(this.getLabel(expression));
        }
        return buffer.toString();
    }

    protected String getLabel(ExpressionDefinition expression) {
        if (expression != null) {
            return expression.getLabel();
        }
        return "";
    }

    protected NodeData getNodeData(Object node) {
        Object key = node;
        if (node instanceof FromDefinition) {
            FromDefinition fromType = (FromDefinition)node;
            key = fromType.getUriOrRef();
        } else if (node instanceof ToDefinition) {
            ToDefinition toType = (ToDefinition)node;
            key = toType.getUriOrRef();
        }
        NodeData answer = this.nodeMap.get(key);
        if (answer == null) {
            String id = "node" + (this.nodeMap.size() + 1);
            answer = new NodeData(id, node, "http://camel.apache.org/images/eip/");
            this.nodeMap.put(key, answer);
        }
        return answer;
    }

    protected Map<String, List<RouteDefinition>> createRouteGroupMap(List<RouteDefinition> routes) {
        HashMap<String, List<RouteDefinition>> map = new HashMap<String, List<RouteDefinition>>();
        for (RouteDefinition route : routes) {
            this.addRouteToMap(map, route);
        }
        return map;
    }

    protected void addRouteToMap(Map<String, List<RouteDefinition>> map, RouteDefinition route) {
        List<RouteDefinition> list;
        String group = route.getGroup();
        if (group == null) {
            group = "Camel Routes";
        }
        if ((list = map.get(group)) == null) {
            list = new ArrayList<RouteDefinition>();
            map.put(group, list);
        }
        list.add(route);
    }
}

