/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.processor.interceptor;

import org.apache.camel.Exchange;
import org.apache.camel.Processor;
import org.apache.camel.model.ProcessorDefinition;
import org.apache.camel.processor.DelayProcessorSupport;
import org.apache.camel.processor.interceptor.Delayer;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DelayInterceptor
extends DelayProcessorSupport {
    private final ProcessorDefinition<?> node;
    private Delayer delayer;

    public DelayInterceptor(ProcessorDefinition<?> node, Processor target, Delayer delayer) {
        super(target);
        this.node = node;
        this.delayer = delayer;
    }

    @Override
    public String toString() {
        return "DelayInterceptor[delay: " + this.delayer.getDelay() + " on: " + this.node + "]";
    }

    @Override
    public void delay(Exchange exchange) throws Exception {
        if (this.delayer.isEnabled()) {
            long time = this.currentSystemTime() + this.delayer.getDelay();
            this.waitUntil(time, exchange);
        }
    }
}

