/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.processor;

import org.apache.camel.Exchange;
import org.apache.camel.Processor;
import org.apache.camel.impl.DefaultUnitOfWork;
import org.apache.camel.processor.DelegateProcessor;
import org.apache.camel.util.ObjectHelper;

public final class UnitOfWorkProcessor
extends DelegateProcessor {
    public UnitOfWorkProcessor(Processor processor) {
        super(processor);
    }

    public String toString() {
        return "UnitOfWork(" + this.processor + ")";
    }

    protected void processNext(Exchange exchange) throws Exception {
        if (exchange.getUnitOfWork() == null) {
            DefaultUnitOfWork uow = new DefaultUnitOfWork(exchange);
            exchange.setUnitOfWork(uow);
            try {
                uow.start();
            }
            catch (Exception e) {
                throw ObjectHelper.wrapRuntimeCamelException(e);
            }
            try {
                this.processor.process(exchange);
            }
            catch (Exception e) {
                exchange.setException(e);
            }
            exchange.getUnitOfWork().done(exchange);
            try {
                uow.stop();
            }
            catch (Exception e) {
                throw ObjectHelper.wrapRuntimeCamelException(e);
            }
            exchange.setUnitOfWork(null);
        } else {
            this.processor.process(exchange);
        }
    }
}

