/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.model.language;

import javax.xml.bind.annotation.XmlAccessType;
import javax.xml.bind.annotation.XmlAccessorType;
import javax.xml.bind.annotation.XmlAttribute;
import javax.xml.bind.annotation.XmlRootElement;
import javax.xml.bind.annotation.XmlTransient;
import org.apache.camel.Expression;
import org.apache.camel.Predicate;
import org.apache.camel.RuntimeCamelException;
import org.apache.camel.model.language.NamespaceAwareExpression;
import org.apache.camel.spi.ClassResolver;
import org.apache.camel.spi.RouteContext;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@XmlRootElement(name="xquery")
@XmlAccessorType(value=XmlAccessType.FIELD)
public class XQueryExpression
extends NamespaceAwareExpression {
    @XmlAttribute(required=false)
    private String type;
    @XmlTransient
    private Class<?> resultType;

    public XQueryExpression() {
    }

    public XQueryExpression(String expression) {
        super(expression);
    }

    @Override
    public String getLanguage() {
        return "xquery";
    }

    public String getType() {
        return this.type;
    }

    public void setType(String type) {
        this.type = type;
    }

    public Class<?> getResultType() {
        return this.resultType;
    }

    public void setResultType(Class<?> resultType) {
        this.resultType = resultType;
    }

    @Override
    protected void configureExpression(RouteContext routeContext, Expression expression) {
        super.configureExpression(routeContext, expression);
        this.updateResultType(routeContext.getCamelContext().getClassResolver());
        if (this.resultType != null) {
            this.setProperty(expression, "resultType", this.resultType);
        }
    }

    @Override
    protected void configurePredicate(RouteContext routeContext, Predicate predicate) {
        super.configurePredicate(routeContext, predicate);
        this.updateResultType(routeContext.getCamelContext().getClassResolver());
        if (this.resultType != null) {
            this.setProperty(predicate, "resultType", this.resultType);
        }
    }

    private void updateResultType(ClassResolver resolver) {
        if (this.resultType == null && this.type != null) {
            try {
                this.resultType = resolver.resolveMandatoryClass(this.type);
            }
            catch (ClassNotFoundException e) {
                throw new RuntimeCamelException(e);
            }
        }
    }
}

