/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.model.language;

import javax.xml.bind.annotation.XmlAccessType;
import javax.xml.bind.annotation.XmlAccessorType;
import javax.xml.bind.annotation.XmlAttribute;
import javax.xml.bind.annotation.XmlRootElement;
import org.apache.camel.Expression;
import org.apache.camel.language.tokenizer.TokenizeLanguage;
import org.apache.camel.model.language.ExpressionDefinition;
import org.apache.camel.spi.RouteContext;

@XmlRootElement(name="tokenize")
@XmlAccessorType(value=XmlAccessType.FIELD)
public class TokenizerExpression
extends ExpressionDefinition {
    @XmlAttribute(required=true)
    private String token;
    @XmlAttribute(required=false)
    private String headerName;
    @XmlAttribute(required=false)
    private Boolean regex;

    public String getLanguage() {
        return "tokenize";
    }

    public String getToken() {
        return this.token;
    }

    public void setToken(String token) {
        this.token = token;
    }

    public String getHeaderName() {
        return this.headerName;
    }

    public void setHeaderName(String headerName) {
        this.headerName = headerName;
    }

    public void setRegex(boolean regex) {
        this.regex = regex;
    }

    public Boolean getRegex() {
        return this.regex;
    }

    public Expression createExpression(RouteContext routeContext) {
        TokenizeLanguage language = new TokenizeLanguage();
        language.setToken(this.token);
        language.setHeaderName(this.headerName);
        if (this.regex != null) {
            language.setRegex(this.regex);
        }
        return language.createExpression();
    }

    public String toString() {
        return "tokenize{" + (this.headerName != null ? "header: " + this.headerName : "body()") + " using token: " + this.token + "}";
    }
}

