/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.impl;

import org.apache.camel.Consumer;
import org.apache.camel.Endpoint;
import org.apache.camel.Processor;
import org.apache.camel.impl.LoggingExceptionHandler;
import org.apache.camel.impl.ServiceSupport;
import org.apache.camel.spi.ExceptionHandler;
import org.apache.camel.util.ServiceHelper;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class DefaultConsumer
extends ServiceSupport
implements Consumer {
    protected final transient Log log = LogFactory.getLog(this.getClass());
    private final Endpoint endpoint;
    private final Processor processor;
    private ExceptionHandler exceptionHandler;

    public DefaultConsumer(Endpoint endpoint, Processor processor) {
        this.endpoint = endpoint;
        this.processor = processor;
    }

    public String toString() {
        return "Consumer[" + this.endpoint.getEndpointUri() + "]";
    }

    public Endpoint getEndpoint() {
        return this.endpoint;
    }

    public Processor getProcessor() {
        return this.processor;
    }

    public ExceptionHandler getExceptionHandler() {
        if (this.exceptionHandler == null) {
            this.exceptionHandler = new LoggingExceptionHandler(this.getClass());
        }
        return this.exceptionHandler;
    }

    public void setExceptionHandler(ExceptionHandler exceptionHandler) {
        this.exceptionHandler = exceptionHandler;
    }

    protected void doStop() throws Exception {
        if (this.log.isDebugEnabled()) {
            this.log.debug((Object)("Stopping consumer: " + this));
        }
        ServiceHelper.stopServices(this.processor);
    }

    protected void doStart() throws Exception {
        if (this.log.isDebugEnabled()) {
            this.log.debug((Object)("Starting consumer: " + this));
        }
        ServiceHelper.startServices(this.processor);
    }

    protected void handleException(Throwable t) {
        Throwable newt = t == null ? new IllegalArgumentException("Handling [null] exception") : t;
        this.getExceptionHandler().handleException(newt);
    }
}

