/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.file.strategy;

import java.io.File;
import org.apache.camel.Exchange;
import org.apache.camel.component.file.GenericFile;
import org.apache.camel.component.file.GenericFileExclusiveReadLockStrategy;
import org.apache.camel.component.file.GenericFileOperations;
import org.apache.camel.util.ExchangeHelper;
import org.apache.camel.util.FileUtil;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MarkerFileExclusiveReadLockStrategy
implements GenericFileExclusiveReadLockStrategy<File> {
    private static final transient Log LOG = LogFactory.getLog(MarkerFileExclusiveReadLockStrategy.class);

    @Override
    public boolean acquireExclusiveReadLock(GenericFileOperations<File> fileGenericFileOperations, GenericFile<File> file, Exchange exchange) throws Exception {
        File lock;
        boolean acquired;
        String lockFileName = file.getAbsoluteFilePath() + ".camelLock";
        if (LOG.isTraceEnabled()) {
            LOG.trace((Object)("Locking the file: " + file + " using the lock file name: " + lockFileName));
        }
        if (acquired = (lock = new File(lockFileName)).createNewFile()) {
            exchange.setProperty("CamelFileLock", lock);
            exchange.setProperty("CamelFileLockName", lockFileName);
        }
        return acquired;
    }

    @Override
    public void releaseExclusiveReadLock(GenericFileOperations<File> operations, GenericFile<File> file, Exchange exchange) throws Exception {
        File lock = ExchangeHelper.getMandatoryProperty(exchange, "CamelFileLock", File.class);
        String lockFileName = ExchangeHelper.getMandatoryProperty(exchange, "CamelFileLockName", String.class);
        if (LOG.isTraceEnabled()) {
            LOG.trace((Object)("Unlocking file: " + lockFileName));
        }
        boolean deleted = FileUtil.deleteFile(lock);
        if (LOG.isTraceEnabled()) {
            LOG.trace((Object)("Lock file: " + lockFileName + " was deleted: " + deleted));
        }
    }

    @Override
    public void setTimeout(long timeout) {
    }
}

