/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.file;

import org.apache.camel.Exchange;
import org.apache.camel.component.file.GenericFile;
import org.apache.camel.component.file.GenericFileEndpoint;
import org.apache.camel.component.file.GenericFileOperations;
import org.apache.camel.component.file.GenericFileProcessStrategy;
import org.apache.camel.impl.LoggingExceptionHandler;
import org.apache.camel.spi.ExceptionHandler;
import org.apache.camel.spi.Synchronization;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class GenericFileOnCompletion<T>
implements Synchronization {
    private final transient Log log = LogFactory.getLog(GenericFileOnCompletion.class);
    private GenericFileEndpoint<T> endpoint;
    private GenericFileOperations<T> operations;
    private ExceptionHandler exceptionHandler;
    private GenericFile<T> file;
    private String originalFileName;

    public GenericFileOnCompletion(GenericFileEndpoint<T> endpoint, GenericFileOperations<T> operations, GenericFile<T> file, String originalFileName) {
        this.endpoint = endpoint;
        this.operations = operations;
        this.file = file;
        this.originalFileName = originalFileName;
    }

    @Override
    public void onComplete(Exchange exchange) {
        this.onCompletion(exchange);
    }

    @Override
    public void onFailure(Exchange exchange) {
        this.onCompletion(exchange);
    }

    public ExceptionHandler getExceptionHandler() {
        if (this.exceptionHandler == null) {
            this.exceptionHandler = new LoggingExceptionHandler(this.getClass());
        }
        return this.exceptionHandler;
    }

    public void setExceptionHandler(ExceptionHandler exceptionHandler) {
        this.exceptionHandler = exceptionHandler;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void onCompletion(Exchange exchange) {
        GenericFileProcessStrategy<T> processStrategy = this.endpoint.getGenericFileProcessStrategy();
        if (this.log.isDebugEnabled()) {
            this.log.debug((Object)("Done processing file: " + this.file + " using exchange: " + exchange));
        }
        boolean committed = false;
        try {
            boolean failed = exchange.isFailed();
            if (!failed) {
                this.processStrategyCommit(processStrategy, exchange, this.file);
                committed = true;
            } else if (exchange.getException() != null) {
                this.handleException(exchange.getException());
            }
        }
        finally {
            if (!committed) {
                this.processStrategyRollback(processStrategy, exchange, this.file);
            }
            this.endpoint.getInProgressRepository().remove(this.originalFileName);
        }
    }

    protected void processStrategyCommit(GenericFileProcessStrategy<T> processStrategy, Exchange exchange, GenericFile<T> file) {
        if (this.endpoint.isIdempotent().booleanValue()) {
            this.endpoint.getIdempotentRepository().add(file.getFileName());
        }
        try {
            if (this.log.isTraceEnabled()) {
                this.log.trace((Object)("Commit file strategy: " + processStrategy + " for file: " + file));
            }
            processStrategy.commit(this.operations, this.endpoint, exchange, file);
        }
        catch (Exception e) {
            this.handleException(e);
        }
    }

    protected void processStrategyRollback(GenericFileProcessStrategy<T> processStrategy, Exchange exchange, GenericFile<T> file) {
        if (this.log.isWarnEnabled()) {
            this.log.warn((Object)("Rollback file strategy: " + processStrategy + " for file: " + file));
        }
        try {
            processStrategy.rollback(this.operations, this.endpoint, exchange, file);
        }
        catch (Exception e) {
            this.handleException(e);
        }
    }

    protected void handleException(Throwable t) {
        Throwable newt = t == null ? new IllegalArgumentException("Handling [null] exception") : t;
        this.getExceptionHandler().handleException(newt);
    }

    public String toString() {
        return "GenericFileOnCompletion";
    }
}

