/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.builder;

import org.apache.camel.Exchange;
import org.apache.camel.Expression;
import org.apache.camel.Processor;

public final class ProcessorBuilder {
    private ProcessorBuilder() {
    }

    public static Processor setBody(final Expression expression) {
        return new Processor(){

            public void process(Exchange exchange) {
                Object newBody = expression.evaluate(exchange, Object.class);
                exchange.getIn().setBody(newBody);
            }

            public String toString() {
                return "setBody(" + expression + ")";
            }
        };
    }

    public static Processor setOutBody(final Expression expression) {
        return new Processor(){

            public void process(Exchange exchange) {
                Object newBody = expression.evaluate(exchange, Object.class);
                exchange.getOut().setBody(newBody);
            }

            public String toString() {
                return "setOutBody(" + expression + ")";
            }
        };
    }

    public static Processor setFaultBody(final Expression expression) {
        return new Processor(){

            public void process(Exchange exchange) {
                Object newBody = expression.evaluate(exchange, Object.class);
                exchange.getOut().setFault(true);
                exchange.getOut().setBody(newBody);
            }

            public String toString() {
                return "setFaultBody(" + expression + ")";
            }
        };
    }

    public static Processor setHeader(final String name, final Expression expression) {
        return new Processor(){

            public void process(Exchange exchange) {
                Object value = expression.evaluate(exchange, Object.class);
                exchange.getIn().setHeader(name, value);
            }

            public String toString() {
                return "setHeader(" + name + ", " + expression + ")";
            }
        };
    }

    public static Processor setOutHeader(final String name, final Expression expression) {
        return new Processor(){

            public void process(Exchange exchange) {
                Object value = expression.evaluate(exchange, Object.class);
                exchange.getOut().setHeader(name, value);
            }

            public String toString() {
                return "setOutHeader(" + name + ", " + expression + ")";
            }
        };
    }

    public static Processor setFaultHeader(final String name, final Expression expression) {
        return new Processor(){

            public void process(Exchange exchange) {
                Object value = expression.evaluate(exchange, Object.class);
                exchange.getOut().setFault(true);
                exchange.getOut().setHeader(name, value);
            }

            public String toString() {
                return "setFaultHeader(" + name + ", " + expression + ")";
            }
        };
    }

    public static Processor setProperty(final String name, final Expression expression) {
        return new Processor(){

            public void process(Exchange exchange) {
                Object value = expression.evaluate(exchange, Object.class);
                exchange.setProperty(name, value);
            }

            public String toString() {
                return "setProperty(" + name + ", " + expression + ")";
            }
        };
    }

    public static Processor removeHeader(final String name) {
        return new Processor(){

            public void process(Exchange exchange) {
                exchange.getIn().removeHeader(name);
            }

            public String toString() {
                return "removeHeader(" + name + ")";
            }
        };
    }

    public static Processor removeFaultHeader(final String name) {
        return new Processor(){

            public void process(Exchange exchange) {
                exchange.getOut().setFault(true);
                exchange.getOut().removeHeader(name);
            }

            public String toString() {
                return "removeFaultHeader(" + name + ")";
            }
        };
    }

    public static Processor removeProperty(final String name) {
        return new Processor(){

            public void process(Exchange exchange) {
                exchange.removeProperty(name);
            }

            public String toString() {
                return "removeProperty(" + name + ")";
            }
        };
    }

    public static Processor throwException(final Exception ex) {
        return new Processor(){

            public void process(Exchange exchange) throws Exception {
                throw ex;
            }

            public String toString() {
                return "throwException(" + ex.toString() + ")";
            }
        };
    }
}

