/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.processor;

import java.util.Iterator;
import java.util.List;
import org.apache.camel.Exchange;
import org.apache.camel.Predicate;
import org.apache.camel.Processor;
import org.apache.camel.processor.DelegateAsyncProcessor;
import org.apache.camel.processor.Traceable;
import org.apache.camel.util.ObjectHelper;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CatchProcessor
extends DelegateAsyncProcessor
implements Traceable {
    private final List<Class> exceptions;
    private final Predicate onWhen;
    private final Predicate handled;

    public CatchProcessor(List<Class> exceptions, Processor processor, Predicate onWhen, Predicate handled) {
        super(processor);
        this.exceptions = exceptions;
        this.onWhen = onWhen;
        this.handled = handled;
    }

    @Override
    public String toString() {
        return "Catch[" + this.exceptions + " -> " + this.getProcessor() + "]";
    }

    @Override
    public String getTraceLabel() {
        return "catch";
    }

    public Throwable catches(Exchange exchange, Throwable exception) {
        Iterator<Throwable> it = ObjectHelper.createExceptionIterator(exception);
        while (it.hasNext()) {
            Throwable e = it.next();
            for (Class type : this.exceptions) {
                if (!type.isInstance(e) || !this.matchesWhen(exchange)) continue;
                return e;
            }
        }
        return null;
    }

    public boolean handles(Exchange exchange) {
        if (this.handled == null) {
            return true;
        }
        return this.handled.matches(exchange);
    }

    public List<Class> getExceptions() {
        return this.exceptions;
    }

    protected boolean matchesWhen(Exchange exchange) {
        if (this.onWhen == null) {
            return true;
        }
        return this.onWhen.matches(exchange);
    }
}

