/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.impl;

import org.apache.camel.Exchange;
import org.apache.camel.LoggingLevel;
import org.apache.camel.RollbackExchangeException;
import org.apache.camel.processor.Logger;
import org.apache.camel.spi.ExceptionHandler;
import org.apache.camel.util.ExchangeHelper;
import org.apache.commons.logging.LogFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class LoggingExceptionHandler
implements ExceptionHandler {
    private final Logger logger;

    public LoggingExceptionHandler(Class<?> ownerType) {
        this(new Logger(LogFactory.getLog(ownerType), LoggingLevel.ERROR));
    }

    public LoggingExceptionHandler(Logger logger) {
        this.logger = logger;
    }

    @Override
    public void handleException(Throwable exception) {
        this.handleException(null, null, exception);
    }

    @Override
    public void handleException(String message, Throwable exception) {
        this.handleException(message, null, exception);
    }

    @Override
    public void handleException(String message, Exchange exchange, Throwable exception) {
        String msg = ExchangeHelper.createExceptionMessage(message, exchange, exception);
        if (this.isCausedByRollbackExchangeException(exception)) {
            this.logger.log(msg);
        } else {
            this.logger.log(msg, exception);
        }
    }

    protected boolean isCausedByRollbackExchangeException(Throwable exception) {
        if (exception instanceof RollbackExchangeException) {
            return true;
        }
        if (exception.getCause() != null) {
            return this.isCausedByRollbackExchangeException(exception.getCause());
        }
        return false;
    }
}

