/*
 * Licensed to the Apache Software Foundation (ASF) under one
 * or more contributor license agreements.  See the NOTICE file
 * distributed with this work for additional information
 * regarding copyright ownership.  The ASF licenses this file
 * to you under the Apache License, Version 2.0 (the
 * "License"); you may not use this file except in compliance
 * with the License.  You may obtain a copy of the License at
 *
 *   http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing,
 * software distributed under the License is distributed on an
 * "AS IS" BASIS, WITHOUT WARRANTIESOR CONDITIONS OF ANY
 * KIND, either express or implied.  See the License for the
 * specific language governing permissions and limitations
 * under the License.
 */
package org.apache.aries.util.filesystem.impl;

import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.util.zip.ZipFile;

import org.apache.aries.util.filesystem.IFile;
import org.apache.aries.util.io.IOUtils;

public class NestedCloseableDirectory extends CloseableDirectory {

	private final File tempFile;
	private final ZipFile zip;
	
	public NestedCloseableDirectory(IFile archive, NestedZipDirectory delegate) throws IOException {
		super(delegate);
		
		tempFile = File.createTempFile("archiveExtract", ".jar");

		FileOutputStream fos = null; 
		try {
			fos = new FileOutputStream(tempFile);
			IOUtils.copy(archive.open(), fos);	
			this.delegate = new NestedZipDirectory(delegate, this);
			
			zip = new ZipFile(tempFile);
		} catch (IOException e) {
			IOUtils.close(fos);
			tempFile.delete();
			throw e;
		}
	}
	
	public ZipFile getZipFile() {
		return zip;
	}

	@Override
	protected void cleanup() {
		try {
			zip.close();
		} catch (IOException e) {}
		tempFile.delete();
	}
}
