/**
 * Copyright (C) FuseSource, Inc.
 * http://fusesource.com
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *    http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package org.fusesource.fabric.zookeeper;

public interface ZkDefs {

    String SUCCESS = "success";
    String ERROR = "error";

    String DEFAULT_VERSION = "1.0";
    String DEFAULT_PROFILE = "default";

    String LOCAL_IP = "localip";
    String LOCAL_HOSTNAME = "localhostname";
    String PUBLIC_IP = "publicip";
    String PUBLIC_HOSTNAME = "publichostname";
    String MANUAL_IP = "manualip";
    String RESOLVER = "resolver";

    String MINIMUM_PORT ="minimum.port";
    String MAXIMUM_PORT ="maximum.port";

    String GLOBAL_RESOLVER_PROPERTY = "global.resolver";
    String LOCAL_RESOLVER_PROPERTY = "local.resolver";
    String DEFAULT_RESOLVER = LOCAL_HOSTNAME;
    String[] VALID_RESOLVERS = new String[]{LOCAL_HOSTNAME,LOCAL_IP,PUBLIC_IP,PUBLIC_HOSTNAME, MANUAL_IP};

}
