/**
 * Licensed to the Apache Software Foundation (ASF) under one or more
 * contributor license agreements.  See the NOTICE file distributed with
 * this work for additional information regarding copyright ownership.
 * The ASF licenses this file to You under the Apache License, Version 2.0
 * (the "License"); you may not use this file except in compliance with
 * the License.  You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package org.apache.camel.component.timer;

import java.util.Timer;

import org.apache.camel.ContextTestSupport;
import org.apache.camel.Endpoint;
import org.apache.camel.RuntimeCamelException;
import org.apache.camel.builder.RouteBuilder;
import org.apache.camel.component.mock.MockEndpoint;

/**
 * @version 
 */
public class TimerEndpointTest extends ContextTestSupport {

    @Override
    public boolean isUseRouteBuilder() {
        return false;
    }

    public void testTimerEndpoint() throws Exception {
        final TimerEndpoint te = new TimerEndpoint();
        te.setCamelContext(context);
        te.setTimer(new Timer(true));
        te.setEndpointUriIfNotSpecified("timer://foo");

        context.addRoutes(new RouteBuilder() {
            @Override
            public void configure() throws Exception {
                from(te).to("mock:result");
            }
        });
        context.start();

        MockEndpoint mock = getMockEndpoint("mock:result");
        mock.expectedMinimumMessageCount(1);

        assertMockEndpointsSatisfied();
    }

    public void testTimerEndpointYetAgain() throws Exception {
        final TimerEndpoint te = new TimerEndpoint("timer://foo", context.getComponent("timer"), "foo");
        te.setTimer(new Timer(true));

        context.addRoutes(new RouteBuilder() {
            @Override
            public void configure() throws Exception {
                from(te).to("mock:result");
            }
        });
        context.start();

        MockEndpoint mock = getMockEndpoint("mock:result");
        mock.expectedMinimumMessageCount(1);

        assertMockEndpointsSatisfied();
    }

    public void testTimerEndpointNoProducer() throws Exception {
        Endpoint te = context.getEndpoint("timer://foo");
        try {
            te.createProducer();
            fail("Should have thrown an exception");
        } catch (RuntimeCamelException e) {
            // expected
        }
    }

}
