/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.processor;

import org.apache.camel.Exchange;
import org.apache.camel.Processor;
import org.apache.camel.RollbackExchangeException;
import org.apache.camel.processor.Traceable;

public class RollbackProcessor
implements Processor,
Traceable {
    private boolean markRollbackOnly;
    private String message;

    public RollbackProcessor() {
    }

    public RollbackProcessor(String message) {
        this.message = message;
    }

    public void process(Exchange exchange) throws Exception {
        exchange.setProperty("CamelRollbackOnly", Boolean.TRUE);
        if (this.markRollbackOnly) {
            return;
        }
        if (this.message != null) {
            exchange.setException(new RollbackExchangeException(this.message, exchange));
        } else {
            exchange.setException(new RollbackExchangeException(exchange));
        }
    }

    public String toString() {
        if (this.message != null) {
            return "Rollback[" + this.message + "]";
        }
        return "Rollback";
    }

    public String getTraceLabel() {
        return "rollback";
    }

    public boolean isMarkRollbackOnly() {
        return this.markRollbackOnly;
    }

    public void setMarkRollbackOnly(boolean markRollbackOnly) {
        this.markRollbackOnly = markRollbackOnly;
    }
}

