/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.model;

import javax.xml.bind.annotation.XmlAccessType;
import javax.xml.bind.annotation.XmlAccessorType;
import javax.xml.bind.annotation.XmlAttribute;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlRootElement;
import javax.xml.bind.annotation.XmlTransient;
import org.apache.camel.Endpoint;
import org.apache.camel.ExchangePattern;
import org.apache.camel.Expression;
import org.apache.camel.Processor;
import org.apache.camel.model.ExpressionSubElementDefinition;
import org.apache.camel.model.SendDefinition;
import org.apache.camel.processor.WireTapProcessor;
import org.apache.camel.spi.RouteContext;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@XmlRootElement(name="wireTap")
@XmlAccessorType(value=XmlAccessType.FIELD)
public class WireTapDefinition
extends SendDefinition<WireTapDefinition> {
    @XmlTransient
    private Processor newExchangeProcessor;
    @XmlAttribute(name="processorRef", required=false)
    private String newExchangeProcessorRef;
    @XmlElement(name="body", required=false)
    private ExpressionSubElementDefinition newExchangeExpression;

    public WireTapDefinition() {
    }

    public WireTapDefinition(String uri) {
        this.setUri(uri);
    }

    public WireTapDefinition(Endpoint endpoint) {
        this.setEndpoint(endpoint);
    }

    @Override
    public Processor createProcessor(RouteContext routeContext) throws Exception {
        Endpoint endpoint = this.resolveEndpoint(routeContext);
        WireTapProcessor answer = new WireTapProcessor(endpoint, this.getPattern());
        if (this.newExchangeProcessorRef != null) {
            this.newExchangeProcessor = routeContext.lookup(this.newExchangeProcessorRef, Processor.class);
        }
        answer.setNewExchangeProcessor(this.newExchangeProcessor);
        if (this.newExchangeExpression != null) {
            answer.setNewExchangeExpression(this.newExchangeExpression.createExpression(routeContext));
        }
        return answer;
    }

    @Override
    public ExchangePattern getPattern() {
        return ExchangePattern.InOnly;
    }

    public String toString() {
        return "WireTap[" + this.getLabel() + "]";
    }

    @Override
    public String getShortName() {
        return "wireTap";
    }

    public Processor getNewExchangeProcessor() {
        return this.newExchangeProcessor;
    }

    public void setNewExchangeProcessor(Processor processor) {
        this.newExchangeProcessor = processor;
    }

    public String getNewExchangeProcessorRef() {
        return this.newExchangeProcessorRef;
    }

    public void setNewExchangeProcessorRef(String ref) {
        this.newExchangeProcessorRef = ref;
    }

    public ExpressionSubElementDefinition getNewExchangeExpression() {
        return this.newExchangeExpression;
    }

    public void setNewExchangeExpression(ExpressionSubElementDefinition expression) {
        this.newExchangeExpression = expression;
    }

    public void setNewExchangeExpression(Expression expression) {
        this.newExchangeExpression = new ExpressionSubElementDefinition(expression);
    }
}

