/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.management;

import java.net.InetAddress;
import java.net.UnknownHostException;
import javax.management.MalformedObjectNameException;
import javax.management.ObjectName;
import org.apache.camel.CamelContext;
import org.apache.camel.Component;
import org.apache.camel.Consumer;
import org.apache.camel.Endpoint;
import org.apache.camel.Processor;
import org.apache.camel.Producer;
import org.apache.camel.Route;
import org.apache.camel.Service;
import org.apache.camel.builder.ErrorHandlerBuilder;
import org.apache.camel.builder.ErrorHandlerBuilderRef;
import org.apache.camel.model.ProcessorDefinition;
import org.apache.camel.spi.InterceptStrategy;
import org.apache.camel.spi.ManagementNamingStrategy;
import org.apache.camel.spi.RouteContext;
import org.apache.camel.util.ObjectHelper;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DefaultManagementNamingStrategy
implements ManagementNamingStrategy {
    public static final String VALUE_UNKNOWN = "unknown";
    public static final String KEY_NAME = "name";
    public static final String KEY_TYPE = "type";
    public static final String KEY_CONTEXT = "context";
    public static final String TYPE_CONTEXT = "context";
    public static final String TYPE_ENDPOINT = "endpoints";
    public static final String TYPE_PROCESSOR = "processors";
    public static final String TYPE_CONSUMER = "consumers";
    public static final String TYPE_PRODUCER = "producers";
    public static final String TYPE_ROUTE = "routes";
    public static final String TYPE_COMPONENT = "components";
    public static final String TYPE_TRACER = "tracer";
    public static final String TYPE_ERRORHANDLER = "errorhandlers";
    public static final String TYPE_SERVICE = "services";
    protected String domainName;
    protected String hostName = "localhost";

    public DefaultManagementNamingStrategy() {
        this("org.apache.camel");
    }

    public DefaultManagementNamingStrategy(String domainName) {
        if (domainName != null) {
            this.domainName = domainName;
        }
        try {
            this.hostName = InetAddress.getLocalHost().getHostName();
        }
        catch (UnknownHostException unknownHostException) {
            // empty catch block
        }
    }

    @Override
    public ObjectName getObjectNameForCamelContext(CamelContext context) throws MalformedObjectNameException {
        StringBuffer buffer = new StringBuffer();
        buffer.append(this.domainName).append(":");
        buffer.append("context=").append(this.getContextId(context)).append(",");
        buffer.append("type=context,");
        buffer.append("name=").append(ObjectName.quote(context.getName()));
        return this.createObjectName(buffer);
    }

    @Override
    public ObjectName getObjectNameForEndpoint(Endpoint endpoint) throws MalformedObjectNameException {
        StringBuffer buffer = new StringBuffer();
        buffer.append(this.domainName).append(":");
        buffer.append("context=").append(this.getContextId(endpoint.getCamelContext())).append(",");
        buffer.append("type=endpoints,");
        buffer.append("name=").append(ObjectName.quote(this.getEndpointId(endpoint)));
        return this.createObjectName(buffer);
    }

    @Override
    public ObjectName getObjectNameForComponent(Component component, String name) throws MalformedObjectNameException {
        StringBuffer buffer = new StringBuffer();
        buffer.append(this.domainName).append(":");
        buffer.append("context=").append(this.getContextId(component.getCamelContext())).append(",");
        buffer.append("type=components,");
        buffer.append("name=").append(ObjectName.quote(name));
        return this.createObjectName(buffer);
    }

    @Override
    public ObjectName getObjectNameForProcessor(CamelContext context, Processor processor, ProcessorDefinition<?> definition) throws MalformedObjectNameException {
        StringBuffer buffer = new StringBuffer();
        buffer.append(this.domainName).append(":");
        buffer.append("context=").append(this.getContextId(context)).append(",");
        buffer.append("type=").append(TYPE_PROCESSOR).append(",");
        if (definition.hasCustomIdAssigned()) {
            String nodeId = definition.getId();
            buffer.append("name=").append(ObjectName.quote(nodeId));
        } else {
            buffer.append("name=").append(processor.getClass().getSimpleName()).append("(").append(ObjectHelper.getIdentityHashCode(processor)).append(")");
        }
        return this.createObjectName(buffer);
    }

    @Override
    public ObjectName getObjectNameForErrorHandler(RouteContext routeContext, Processor errorHandler, ErrorHandlerBuilder builder) throws MalformedObjectNameException {
        StringBuffer buffer = new StringBuffer();
        buffer.append(this.domainName).append(":");
        buffer.append("context=").append(this.getContextId(routeContext.getCamelContext())).append(",");
        buffer.append("type=").append(TYPE_ERRORHANDLER).append(",");
        String ref = null;
        if (builder instanceof ErrorHandlerBuilderRef) {
            ErrorHandlerBuilderRef builderRef = (ErrorHandlerBuilderRef)builder;
            ref = builderRef.getRef();
            builder = ErrorHandlerBuilderRef.lookupErrorHandlerBuilder(routeContext, builderRef.getRef());
            if (builder instanceof ErrorHandlerBuilderRef && !(builderRef = (ErrorHandlerBuilderRef)builder).getRef().equals("CamelDefaultErrorHandlerBuilder")) {
                builder = ErrorHandlerBuilderRef.lookupErrorHandlerBuilder(routeContext, builderRef.getRef());
                ref = builderRef.getRef();
            }
        }
        if (ref != null) {
            String name = builder.getClass().getSimpleName() + "(ref:" + ref + ")";
            buffer.append("name=").append(ObjectName.quote(name));
        } else {
            buffer.append("name=").append(builder.getClass().getSimpleName()).append("(").append(ObjectHelper.getIdentityHashCode(builder)).append(")");
        }
        return this.createObjectName(buffer);
    }

    @Override
    public ObjectName getObjectNameForConsumer(CamelContext context, Consumer consumer) throws MalformedObjectNameException {
        StringBuffer buffer = new StringBuffer();
        buffer.append(this.domainName).append(":");
        buffer.append("context=").append(this.getContextId(context)).append(",");
        buffer.append("type=").append(TYPE_CONSUMER).append(",");
        String name = consumer.getClass().getSimpleName();
        if (ObjectHelper.isEmpty(name)) {
            name = "Consumer";
        }
        buffer.append("name=").append(name).append("(").append(ObjectHelper.getIdentityHashCode(consumer)).append(")");
        return this.createObjectName(buffer);
    }

    @Override
    public ObjectName getObjectNameForProducer(CamelContext context, Producer producer) throws MalformedObjectNameException {
        StringBuffer buffer = new StringBuffer();
        buffer.append(this.domainName).append(":");
        buffer.append("context=").append(this.getContextId(context)).append(",");
        buffer.append("type=").append(TYPE_PRODUCER).append(",");
        String name = producer.getClass().getSimpleName();
        if (ObjectHelper.isEmpty(name)) {
            name = "Producer";
        }
        buffer.append("name=").append(name).append("(").append(ObjectHelper.getIdentityHashCode(producer)).append(")");
        return this.createObjectName(buffer);
    }

    @Override
    public ObjectName getObjectNameForTracer(CamelContext context, InterceptStrategy tracer) throws MalformedObjectNameException {
        StringBuffer buffer = new StringBuffer();
        buffer.append(this.domainName).append(":");
        buffer.append("context=").append(this.getContextId(context)).append(",");
        buffer.append("type=tracer,");
        buffer.append("name=").append("Tracer").append("(").append(ObjectHelper.getIdentityHashCode(tracer)).append(")");
        return this.createObjectName(buffer);
    }

    @Override
    public ObjectName getObjectNameForRoute(Route route) throws MalformedObjectNameException {
        Endpoint ep = route.getEndpoint();
        String id = route.getId();
        StringBuffer buffer = new StringBuffer();
        buffer.append(this.domainName).append(":");
        buffer.append("context=").append(this.getContextId(ep.getCamelContext())).append(",");
        buffer.append("type=routes,");
        buffer.append("name=").append(ObjectName.quote(id));
        return this.createObjectName(buffer);
    }

    @Override
    public ObjectName getObjectNameForService(CamelContext context, Service service) throws MalformedObjectNameException {
        StringBuffer buffer = new StringBuffer();
        buffer.append(this.domainName).append(":");
        buffer.append("context=").append(this.getContextId(context)).append(",");
        buffer.append("type=services,");
        buffer.append("name=").append(service.getClass().getSimpleName()).append("(").append(ObjectHelper.getIdentityHashCode(service)).append(")");
        return this.createObjectName(buffer);
    }

    public String getDomainName() {
        return this.domainName;
    }

    public void setDomainName(String domainName) {
        this.domainName = domainName;
    }

    public String getHostName() {
        return this.hostName;
    }

    public void setHostName(String hostName) {
        this.hostName = hostName;
    }

    protected String getContextId(CamelContext context) {
        return this.hostName + "/" + (context != null ? context.getName() : VALUE_UNKNOWN);
    }

    protected String getEndpointId(Endpoint ep) {
        if (ep.isSingleton()) {
            return ep.getEndpointKey();
        }
        String uri = ep.getEndpointKey();
        int pos = uri.indexOf(63);
        String id = pos == -1 ? uri : uri.substring(0, pos);
        id = id + "?id=" + ObjectHelper.getIdentityHashCode(ep);
        return id;
    }

    protected ObjectName createObjectName(StringBuffer buffer) throws MalformedObjectNameException {
        String text = buffer.toString();
        try {
            return new ObjectName(text);
        }
        catch (MalformedObjectNameException e) {
            throw new MalformedObjectNameException("Could not create ObjectName from: " + text + ". Reason: " + e);
        }
    }
}

