/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.impl;

import java.util.ArrayList;
import java.util.List;
import org.apache.camel.Exchange;
import org.apache.camel.Message;
import org.apache.camel.Service;
import org.apache.camel.impl.DefaultMessage;
import org.apache.camel.impl.DefaultTracedRouteNodes;
import org.apache.camel.spi.Synchronization;
import org.apache.camel.spi.TracedRouteNodes;
import org.apache.camel.spi.UnitOfWork;
import org.apache.camel.util.EventHelper;
import org.apache.camel.util.UuidGenerator;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class DefaultUnitOfWork
implements UnitOfWork,
Service {
    private static final transient Log LOG = LogFactory.getLog(DefaultUnitOfWork.class);
    private String id;
    private List<Synchronization> synchronizations;
    private Message originalInMessage;
    private final TracedRouteNodes tracedRouteNodes = new DefaultTracedRouteNodes();

    public DefaultUnitOfWork(Exchange exchange) {
        if (exchange.getIn().getClass().getSimpleName().equals("JmsMessage")) {
            this.originalInMessage = new DefaultMessage();
            this.originalInMessage.setBody(exchange.getIn().getBody());
        } else {
            this.originalInMessage = exchange.getIn().copy();
        }
        EventHelper.notifyExchangeCreated(exchange.getContext(), exchange);
        if (exchange.getContext() != null) {
            exchange.getContext().getInflightRepository().add(exchange);
        }
    }

    public void start() throws Exception {
        this.id = null;
    }

    public void stop() throws Exception {
        if (this.synchronizations != null) {
            this.synchronizations.clear();
        }
        if (this.tracedRouteNodes != null) {
            this.tracedRouteNodes.clear();
        }
        this.originalInMessage = null;
    }

    public synchronized void addSynchronization(Synchronization synchronization) {
        if (this.synchronizations == null) {
            this.synchronizations = new ArrayList<Synchronization>();
        }
        this.synchronizations.add(synchronization);
    }

    public synchronized void removeSynchronization(Synchronization synchronization) {
        if (this.synchronizations != null) {
            this.synchronizations.remove(synchronization);
        }
    }

    public void handoverSynchronization(Exchange target) {
        if (this.synchronizations == null || this.synchronizations.isEmpty()) {
            return;
        }
        for (Synchronization synchronization : this.synchronizations) {
            target.addOnCompletion(synchronization);
        }
        this.synchronizations.clear();
    }

    public void done(Exchange exchange) {
        boolean failed = exchange.isFailed();
        try {
            if (failed) {
                EventHelper.notifyExchangeFailed(exchange.getContext(), exchange);
            } else {
                EventHelper.notifyExchangeDone(exchange.getContext(), exchange);
            }
        }
        catch (Exception e) {
            LOG.warn((Object)"Exception occurred during event notification. This exception will be ignored.", (Throwable)e);
        }
        if (this.synchronizations != null && !this.synchronizations.isEmpty()) {
            for (Synchronization synchronization : this.synchronizations) {
                try {
                    if (failed) {
                        synchronization.onFailure(exchange);
                        continue;
                    }
                    synchronization.onComplete(exchange);
                }
                catch (Exception e) {
                    LOG.warn((Object)"Exception occurred during onCompletion. This exception will be ignored.", (Throwable)e);
                }
            }
        }
        if (exchange.getContext() != null) {
            exchange.getContext().getInflightRepository().remove(exchange);
        }
    }

    public String getId() {
        if (this.id == null) {
            this.id = UuidGenerator.get().generateUuid();
        }
        return this.id;
    }

    public Message getOriginalInMessage() {
        return this.originalInMessage;
    }

    public TracedRouteNodes getTracedRouteNodes() {
        return this.tracedRouteNodes;
    }
}

