/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.converter.jaxp;

import org.apache.camel.Converter;
import org.w3c.dom.Attr;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.w3c.dom.Text;

@Converter
public final class DomConverter {
    private DomConverter() {
    }

    @Converter
    public static String toString(NodeList nodeList) {
        StringBuffer buffer = new StringBuffer();
        DomConverter.append(buffer, nodeList);
        return buffer.toString();
    }

    @Converter
    public static Integer toInteger(NodeList nodeList) {
        StringBuffer buffer = new StringBuffer();
        DomConverter.append(buffer, nodeList);
        String s = buffer.toString();
        return Integer.valueOf(s);
    }

    @Converter
    public static Long toLong(NodeList nodeList) {
        StringBuffer buffer = new StringBuffer();
        DomConverter.append(buffer, nodeList);
        String s = buffer.toString();
        return Long.valueOf(s);
    }

    private static void append(StringBuffer buffer, NodeList nodeList) {
        int size = nodeList.getLength();
        for (int i = 0; i < size; ++i) {
            DomConverter.append(buffer, nodeList.item(i));
        }
    }

    private static void append(StringBuffer buffer, Node node) {
        if (node instanceof Text) {
            Text text = (Text)node;
            buffer.append(text.getTextContent());
        } else if (node instanceof Attr) {
            Attr attribute = (Attr)node;
            buffer.append(attribute.getTextContent());
        } else if (node instanceof Element) {
            Element element = (Element)node;
            DomConverter.append(buffer, element.getChildNodes());
        }
    }
}

