/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.builder;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.apache.camel.CamelContext;
import org.apache.camel.Endpoint;
import org.apache.camel.Expression;
import org.apache.camel.LoggingLevel;
import org.apache.camel.NoSuchEndpointException;
import org.apache.camel.builder.Builder;
import org.apache.camel.builder.DeadLetterChannelBuilder;
import org.apache.camel.builder.DefaultErrorHandlerBuilder;
import org.apache.camel.builder.ErrorHandlerBuilder;
import org.apache.camel.builder.LoggingErrorHandlerBuilder;
import org.apache.camel.builder.NoErrorHandlerBuilder;
import org.apache.camel.builder.ValueBuilder;
import org.apache.camel.util.ObjectHelper;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class BuilderSupport {
    private CamelContext context;
    private ErrorHandlerBuilder errorHandlerBuilder;

    protected BuilderSupport(CamelContext context) {
        this.context = context;
    }

    public ValueBuilder header(String name) {
        return Builder.header(name);
    }

    public ValueBuilder property(String name) {
        return Builder.property(name);
    }

    public ValueBuilder body() {
        return Builder.body();
    }

    public <T> ValueBuilder body(Class<T> type) {
        return Builder.bodyAs(type);
    }

    public ValueBuilder outBody() {
        return Builder.outBody();
    }

    public <T> ValueBuilder outBody(Class<T> type) {
        return Builder.outBodyAs(type);
    }

    public ValueBuilder faultBody() {
        return Builder.faultBody();
    }

    public <T> ValueBuilder faultBodyAs(Class<T> type) {
        return Builder.faultBodyAs(type);
    }

    public ValueBuilder systemProperty(String name) {
        return Builder.systemProperty(name);
    }

    public ValueBuilder systemProperty(String name, String defaultValue) {
        return Builder.systemProperty(name, defaultValue);
    }

    public ValueBuilder constant(Object value) {
        return Builder.constant(value);
    }

    public ValueBuilder bean(String beanRef) {
        return Builder.bean(beanRef, null);
    }

    public ValueBuilder bean(String beanRef, String method) {
        return Builder.bean(beanRef, method);
    }

    public ValueBuilder bean(Class<?> beanType) {
        return Builder.bean(beanType, null);
    }

    public ValueBuilder bean(Class<?> beanType, String method) {
        return Builder.bean(beanType, method);
    }

    public ValueBuilder sendTo(String uri) {
        return Builder.sendTo(uri);
    }

    public ValueBuilder regexReplaceAll(Expression content, String regex, String replacement) {
        return Builder.regexReplaceAll(content, regex, replacement);
    }

    public ValueBuilder regexReplaceAll(Expression content, String regex, Expression replacement) {
        return Builder.regexReplaceAll(content, regex, replacement);
    }

    public ValueBuilder exceptionMessage() {
        return Builder.exceptionMessage();
    }

    public Endpoint endpoint(String uri) throws NoSuchEndpointException {
        ObjectHelper.notNull(uri, "uri");
        Endpoint endpoint = this.getContext().getEndpoint(uri);
        if (endpoint == null) {
            throw new NoSuchEndpointException(uri);
        }
        return endpoint;
    }

    public <T extends Endpoint> T endpoint(String uri, Class<T> type) throws NoSuchEndpointException {
        ObjectHelper.notNull(uri, "uri");
        T endpoint = this.getContext().getEndpoint(uri, type);
        if (endpoint == null) {
            throw new NoSuchEndpointException(uri);
        }
        return endpoint;
    }

    public List<Endpoint> endpoints(String ... uris) throws NoSuchEndpointException {
        ArrayList<Endpoint> endpoints = new ArrayList<Endpoint>();
        for (String uri : uris) {
            endpoints.add(this.endpoint(uri));
        }
        return endpoints;
    }

    public List<Endpoint> endpoints(Endpoint ... endpoints) {
        ArrayList<Endpoint> answer = new ArrayList<Endpoint>();
        answer.addAll(Arrays.asList(endpoints));
        return answer;
    }

    public DefaultErrorHandlerBuilder defaultErrorHandler() {
        return new DefaultErrorHandlerBuilder();
    }

    public NoErrorHandlerBuilder noErrorHandler() {
        return new NoErrorHandlerBuilder();
    }

    public LoggingErrorHandlerBuilder loggingErrorHandler() {
        return new LoggingErrorHandlerBuilder();
    }

    public LoggingErrorHandlerBuilder loggingErrorHandler(String log) {
        return this.loggingErrorHandler(LogFactory.getLog((String)log));
    }

    public LoggingErrorHandlerBuilder loggingErrorHandler(Log log) {
        return new LoggingErrorHandlerBuilder(log);
    }

    public LoggingErrorHandlerBuilder loggingErrorHandler(Log log, LoggingLevel level) {
        return new LoggingErrorHandlerBuilder(log, level);
    }

    public DeadLetterChannelBuilder deadLetterChannel(String deadLetterUri) {
        return this.deadLetterChannel(this.endpoint(deadLetterUri));
    }

    public DeadLetterChannelBuilder deadLetterChannel(Endpoint deadLetterEndpoint) {
        return new DeadLetterChannelBuilder(deadLetterEndpoint);
    }

    public CamelContext getContext() {
        return this.context;
    }

    public void setContext(CamelContext context) {
        this.context = context;
    }

    public ErrorHandlerBuilder getErrorHandlerBuilder() {
        if (this.errorHandlerBuilder == null) {
            this.errorHandlerBuilder = this.createErrorHandlerBuilder();
        }
        return this.errorHandlerBuilder;
    }

    protected ErrorHandlerBuilder createErrorHandlerBuilder() {
        return new DefaultErrorHandlerBuilder();
    }

    public void setErrorHandlerBuilder(ErrorHandlerBuilder errorHandlerBuilder) {
        this.errorHandlerBuilder = errorHandlerBuilder;
    }
}

