/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.processor;

import java.util.concurrent.TimeUnit;
import org.apache.camel.AsyncCallback;
import org.apache.camel.Exchange;
import org.apache.camel.Processor;
import org.apache.camel.processor.DelegateAsyncProcessor;
import org.apache.camel.processor.StopProcessor;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class SamplingThrottler
extends DelegateAsyncProcessor {
    protected final transient Log log = LogFactory.getLog(this.getClass());
    private long samplePeriod;
    private long periodInNanos;
    private TimeUnit units;
    private long timeOfLastExchange;
    private StopProcessor stopper = new StopProcessor();
    private Object calculationLock = new Object();
    private SampleStats sampled = new SampleStats();

    public SamplingThrottler(Processor processor, long samplePeriod, TimeUnit units) {
        super(processor);
        if (samplePeriod <= 0L) {
            throw new IllegalArgumentException("A positive value is required for the sampling period");
        }
        if (units == null) {
            throw new IllegalArgumentException("A invalid null value was supplied for the units of the sampling period");
        }
        this.samplePeriod = samplePeriod;
        this.units = units;
        this.periodInNanos = units.toNanos(samplePeriod);
    }

    public String toString() {
        return "SamplingThrottler[1 exchange per: " + this.samplePeriod + " " + this.units.toString().toLowerCase() + " -> " + this.getProcessor() + "]";
    }

    public String getTraceLabel() {
        return "samplingThrottler[1 exchange per: " + this.samplePeriod + " " + this.units.toString().toLowerCase() + "]";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean process(Exchange exchange, AsyncCallback callback) {
        boolean doSend = false;
        Object object = this.calculationLock;
        synchronized (object) {
            long now = System.nanoTime();
            if (now >= this.timeOfLastExchange + this.periodInNanos) {
                doSend = true;
                if (this.log.isTraceEnabled()) {
                    this.log.trace((Object)this.sampled.sample());
                }
                this.timeOfLastExchange = now;
            } else if (this.log.isTraceEnabled()) {
                this.log.trace((Object)this.sampled.drop());
            }
        }
        if (doSend) {
            return super.process(exchange, callback);
        }
        try {
            this.stopper.process(exchange);
        }
        catch (Exception e) {
            exchange.setException(e);
        }
        callback.done(true);
        return true;
    }

    private static class SampleStats {
        private long droppedThisPeriod;
        private long totalDropped;
        private long totalSampled;
        private long totalThisPeriod;

        private SampleStats() {
        }

        String drop() {
            ++this.droppedThisPeriod;
            ++this.totalThisPeriod;
            ++this.totalDropped;
            return this.getDroppedLog();
        }

        String sample() {
            this.totalThisPeriod = 1L;
            ++this.totalSampled;
            this.droppedThisPeriod = 0L;
            return this.getSampledLog();
        }

        String getSampledLog() {
            return String.format("Sampled %d of %d total exchanges", this.totalSampled, this.totalSampled + this.totalDropped);
        }

        String getDroppedLog() {
            return String.format("Dropped %d of %d exchanges in this period, totalling %d dropped of %d exchanges overall.", this.droppedThisPeriod, this.totalThisPeriod, this.totalDropped, this.totalSampled + this.totalDropped);
        }
    }
}

