/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.processor;

import java.util.Comparator;
import java.util.List;
import java.util.Set;
import java.util.TreeSet;
import org.apache.camel.CamelContext;
import org.apache.camel.Exchange;
import org.apache.camel.Expression;
import org.apache.camel.Processor;
import org.apache.camel.processor.BatchProcessor;
import org.apache.camel.processor.Traceable;
import org.apache.camel.util.ExpressionComparator;
import org.apache.camel.util.ExpressionListComparator;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Resequencer
extends BatchProcessor
implements Traceable {
    public Resequencer(CamelContext camelContext, Processor processor, Expression expression) {
        this(camelContext, processor, Resequencer.createSet(expression, false, false));
    }

    public Resequencer(CamelContext camelContext, Processor processor, List<Expression> expressions, boolean allowDuplicates, boolean reverse) {
        this(camelContext, processor, Resequencer.createSet(expressions, allowDuplicates, reverse));
    }

    public Resequencer(CamelContext camelContext, Processor processor, Set<Exchange> collection) {
        super(camelContext, processor, collection);
    }

    @Override
    public String toString() {
        return "Resequencer[to: " + this.getProcessor() + "]";
    }

    @Override
    public String getTraceLabel() {
        return "resequencer";
    }

    protected static Set<Exchange> createSet(Expression expression, boolean allowDuplicates, boolean reverse) {
        return Resequencer.createSet(new ExpressionComparator(expression), allowDuplicates, reverse);
    }

    protected static Set<Exchange> createSet(List<Expression> expressions, boolean allowDuplicates, boolean reverse) {
        if (expressions.size() == 1) {
            return Resequencer.createSet(expressions.get(0), allowDuplicates, reverse);
        }
        return Resequencer.createSet(new ExpressionListComparator(expressions), allowDuplicates, reverse);
    }

    protected static Set<Exchange> createSet(final Comparator<? super Exchange> comparator, boolean allowDuplicates, boolean reverse) {
        Comparator<Exchange> answer = comparator;
        if (reverse) {
            answer = new Comparator<Exchange>(){

                @Override
                public int compare(Exchange o1, Exchange o2) {
                    int answer = comparator.compare(o1, o2);
                    return answer * -1;
                }
            };
        }
        final Comparator<Exchange> forAllowDuplicates = answer;
        if (allowDuplicates) {
            answer = new Comparator<Exchange>(){

                @Override
                public int compare(Exchange o1, Exchange o2) {
                    int answer = forAllowDuplicates.compare(o1, o2);
                    if (answer == 0) {
                        return 1;
                    }
                    return answer;
                }
            };
        }
        return new TreeSet<Exchange>(answer);
    }
}

