﻿namespace SimpleSend
{
    using System;
    using Amqp;

    class SimpleSend
    {
        static void Main(string[] args)
        {
            // uncomment the following to write frame traces
            // Trace.TraceLevel = TraceLevel.Frame;
            // Trace.TraceListener = (l, f, a) => Console.WriteLine(DateTime.Now.ToString("[hh:mm:ss.fff]") + " " + string.Format(f, a));

            string    url = (args.Length > 0) ? args[0] :
                "amqp://guest:guest@127.0.0.1:5672";
            string target = (args.Length > 1) ? args[1] : "examples";
            int     count = (args.Length > 2) ? Convert.ToInt32(args[2]) : 10;

            Address      peerAddr = new Address(url);
            Connection connection = new Connection(peerAddr);
            Session       session = new Session(connection);
            SenderLink     sender = new SenderLink(session, "send-1", target);

            for (int i = 0; i < count; i++)
            {
                Message msg = new Message("simple " + i);
                sender.Send(msg);
                Console.WriteLine("Sent: " + msg.Body.ToString());
            }

            sender.Close();
            session.Close();
            connection.Close();
        }
    }
}
