<!-- vim: set syn=markdown : -->
<!--
    Licensed to the Apache Software Foundation (ASF) under one or more
    contributor license agreements.  See the NOTICE file distributed with
    this work for additional information regarding copyright ownership.
    The ASF licenses this file to You under the Apache License, Version 2.0
    (the "License"); you may not use this file except in compliance with
    the License.  You may obtain a copy of the License at

         http://www.apache.org/licenses/LICENSE-2.0

    Unless required by applicable law or agreed to in writing, software
    distributed under the License is distributed on an "AS IS" BASIS,
    WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
    See the License for the specific language governing permissions and
    limitations under the License.
-->

# Log4j 2 Javadoc API Documentation and TLD Documentation

## Javadoc API Documentation

The table below contains links to the Javadoc API Documentation for the components you are most likely to use
directly in code. You can also use the menu links on the left.

Component | Description
--------- | -----------
[Log4j 2 API](log4j-api/apidocs/index.html) | The interface that applications should use and code against.
[Implementation](log4j-core/apidocs/index.html) | The standard implementation, also called the Log4j 2 Core, that contains Appenders, Filters, and more.
[Log4j IO Streams](log4j-iostreams/apidocs/index.html) | Extra classes for dealing with older APIs that expect classes from `java.io` for logging.
[JSP Tag Library](log4j-taglib/apidocs/index.html) | The tag library that enables Java-free logging in JavaServer Pages™ using Log4j 2.
[JSP Tag Library (TLD Doc)](log4j-taglib/tlddoc/index.html) | The special Javadoc-like Tag Library Documentation for the Log4j 2 JSP Tag Library.

The table below contains links to the Javadoc API Documentation for all the other Log4j 2 components, which you
likely will not use directly in code but instead will only configure or include in your dependencies.

Component | Description
--------- | -----------
[Commons Logging Bridge](log4j-jcl/apidocs/index.html) | A bridge that permits applications written against the Apache Commons Logging API to log using Log4j 2.
[SLF4J Binding](log4j-slf4j-impl/apidocs/index.html) | A bridge that permits applications written against the SLF4J API to log using Log4j 2.
[Java Util Logging Adapter](log4j-jul/apidocs/index.html) | A bridge that permits applications written against the `java.util.logging` API to log using Log4j 2.
[Log4j 1.2 API Bridge](log4j-1.2-api/apidocs/index.html) | A bridge that permits applications written against the Log4j 1.2.x API to log using Log4j 2.
[Log4j 2 to SLF4J Adapter](log4j-to-slf4j/apidocs/index.html) | An adapter that permits applications written against the Log4j 2 API to log using SLF4J.
[Apache Flume Appender](log4j-flume-ng/apidocs/index.html) | An Appender that allows applications to send logging events to Apache Flume Agents.
[Log4j JMX GUI](log4j-jmx-gui/apidocs/index.html) | A Java Swing-based client for remotely viewing the status logger and editing the Log4j configuration.
[Log4j JPA](log4j-jpa/apidocs/index.html) | Apache Log4j Java Persistence API Appender.
[Log4j Web Application Support](log4j-web/apidocs/index.html) | Additional classes that enable multiple configurations within a Servlet Container.
[Log4j CouchDB Support](log4j-couchdb/apidocs/index.html) | Additional Appender for CouchDB.
[Log4j JDBC DBCP 2](log4j-jdbc-dbcp2/apidocs/index.html) | Connection source for the JDBC Appender using Apache Commons DBCP2.
[Log4j Liquibase Binding](log4j-liquibase/apidocs/index.html) | The Apache Log4j Liquibase binding to Log4j 2 Core.
[Log4j MongoDB 2 Support](log4j-mongodb2/apidocs/index.html) | Additional Appender for MongoDB using the version 2 driver.
[Log4j MongoDB 3 Support](log4j-mongodb3/apidocs/index.html) | Additional Appender for MongoDB using the version 3 driver.
[Log4j Cassandra Support](log4j-cassandra/apidocs/index.html) | Additional Appender for Cassandra.
