#!/usr/bin/python

import os
import sys
import subprocess
import glob

def run(cmd):
    print '$', ' '.join(cmd)
    proc = subprocess.Popen(cmd, stdin=file('/dev/null'),
                            stdout=subprocess.PIPE, stderr=subprocess.STDOUT)
    stdout, dummy = proc.communicate()
    print stdout
    if proc.wait():
        print 'Error running "%s", returncode was %s, output was: %s' % \
            (' '.join(cmd), proc.returncode, stdout)
        sys.exit(1)
    return stdout

if not len(sys.argv) == 2:
    print 'usage: %s /path/to/srpm' % sys.argv[0]
    sys.exit(1)

srpmpath = sys.argv[1]

run(['7z', 'x', srpmpath])
cpios = glob.glob('*.cpio')
if not cpios:
    print 'Could not find extracted .cpio'
    sys.exit(1)

run(['7z', 'x', cpios[0]])

specs = glob.glob('*.spec')
if not specs:
    print 'Could not find extracted .spec'
    sys.exit(1)
elif len(specs) > 1:
    print 'Multiple .spec files found'
    sys.exit(1)

name = None
version = None
release = None
source = None
defines = {}
patches = {}

with file(specs[0]) as spec:
    for line in spec:
        tokens = line.split()
        if not tokens:
            continue
        if tokens[0] in ['Name:', 'Version:', 'Release:']:
            subst = '%{' + tokens[0][:-1].lower() + '}'
            if subst not in defines:
                defines[subst] = tokens[1]
        elif tokens[0] in ['%global', '%define'] and len(tokens) > 2:
            subst = '%{' + tokens[1] + '}'
            if subst not in defines:
                defines[subst] = ' '.join(tokens[2:])
        elif tokens[0] in ['Source:', 'Source0:']:
            source = tokens[1].split('/')[-1]
        elif tokens[0] == 'Patch:':
            patches['%patch0'] = tokens[1]
        elif tokens[0].startswith('Patch'):
            patches['%' + tokens[0].split(':')[0].lower()] = tokens[1]

if not source:
    print 'Could not find source'
    sys.exit(1)
for key, value in defines.items():
    source = source.replace(key, value)

if '.tar' or '.tgz' in source:
    run(['tar', 'xf', source])
elif source.endswith('.zip'):
    run(['unzip', source])
else:
    print 'Unknown format:', source
    sys.exit(1)

sourcedir = None
for path in os.listdir('.'):
    if os.path.isdir(path):
        sourcedir = os.path.join(os.getcwd(), path)
        break

with file(specs[0]) as spec:
    for line in spec:
        tokens = line.split()
        if not tokens:
            continue
        if tokens[0].startswith('%patch'):
            patchfile = patches.get(tokens[0])
            if not patchfile:
                print 'Could not find', tokens[0]
                sys.exit(1)
            plev = None
            for token in tokens:
                if token.startswith('-p'):
                    plev = token
                    break
            cmd = ['patch', '-d', sourcedir, '-i', os.path.join(os.getcwd(), patchfile)]
            if plev:
                cmd.append(plev)
            run(cmd)

print 'Source tree:', sourcedir
