/*
 * Copyright 2014 JBoss Inc
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package org.artificer.server.core.api;

import org.artificer.common.ontology.ArtificerOntology;

import java.util.List;

/**
 * @author Brett Meyer.
 */
public interface OntologyService extends AbstractService {

    public ArtificerOntology create(ArtificerOntology ontology) throws Exception;

    public void update(String uuid, ArtificerOntology ontology) throws Exception;

    public ArtificerOntology get(String uuid) throws Exception;

    public List<ArtificerOntology> get() throws Exception;

    public void delete(String uuid) throws Exception;
}
