/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.errai;

import java.lang.instrument.Instrumentation;
import java.util.HashMap;
import java.util.Map;
import java.util.regex.Pattern;
import org.jboss.errai.BoringClassGenerator;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ClientLocalClassHidingAgent {
    private static final String DEFAULT_CLASS_NAME_PATTERN = ".*/client/local/.*";

    private static final Map<String, String> parseOptionsWithDefaults(String options) {
        HashMap<String, String> map = new HashMap<String, String>();
        if (options == null) {
            options = "";
        }
        map.put("debugAgent", Boolean.FALSE.toString());
        map.put("classPattern", DEFAULT_CLASS_NAME_PATTERN);
        for (String keyval : options.split(",")) {
            String val;
            String key;
            int equalsIdx = keyval.indexOf("=");
            if (equalsIdx >= 0) {
                key = keyval.substring(0, equalsIdx);
                val = keyval.substring(equalsIdx + 1);
            } else {
                key = keyval;
                val = null;
            }
            map.put(key, val);
        }
        return map;
    }

    public static void premain(String agentArgs, Instrumentation inst) {
        Map<String, String> options = ClientLocalClassHidingAgent.parseOptionsWithDefaults(agentArgs);
        boolean debug = Boolean.parseBoolean(options.get("debugAgent"));
        Pattern hideClassesPattern = Pattern.compile(options.get("classPattern"));
        inst.addTransformer(new BoringClassGenerator(hideClassesPattern, debug));
    }
}

