/*
 * Decompiled with CFR 0.152.
 */
package org.overlord.sramp.demos.archivepkg;

import java.io.InputStream;
import java.util.Map;
import org.jboss.resteasy.plugins.providers.atom.Entry;
import org.jboss.resteasy.plugins.providers.atom.Feed;
import org.overlord.sramp.atom.archive.SrampArchive;
import org.overlord.sramp.client.SrampAtomApiClient;
import org.s_ramp.xmlns._2010.s_ramp.BaseArtifactType;
import org.s_ramp.xmlns._2010.s_ramp.WsdlDocument;
import org.s_ramp.xmlns._2010.s_ramp.XsdDocument;

public class ArchivePackageDemo {
    private static final String DEFAULT_ENDPOINT = "http://localhost:8080/s-ramp-atom/s-ramp";

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void main(String[] args) throws Exception {
        System.out.println("\n*** Running S-RAMP Archive Package Demo ***\n");
        String endpoint = System.getProperty("sramp.endpoint");
        if (endpoint == null || endpoint.trim().length() == 0) {
            endpoint = DEFAULT_ENDPOINT;
        }
        System.out.println("S-RAMP Endpoint: " + endpoint);
        SrampAtomApiClient client = new SrampAtomApiClient(endpoint);
        System.out.println("Creating the S-RAMP package...");
        SrampArchive archive = new SrampArchive();
        try {
            InputStream contentStream = ArchivePackageDemo.class.getResourceAsStream("wss-wssecurity-utility-1.0.xsd");
            XsdDocument metaData = new XsdDocument();
            metaData.setName("wss-wssecurity-utility-1.0.xsd");
            metaData.setDescription("WS-Security: utility.xsd");
            metaData.setVersion("1.0");
            System.out.print("\tAdding " + metaData.getName() + " to the archive...");
            archive.addEntry("ws-security/schemas/wss-wssecurity-utility-1.0.xsd", (BaseArtifactType)metaData, contentStream);
            contentStream.close();
            System.out.println("added.");
            contentStream = ArchivePackageDemo.class.getResourceAsStream("wss-wssecurity-secext-1.0.xsd");
            metaData = new XsdDocument();
            metaData.setName("wss-wssecurity-secext-1.0.xsd");
            metaData.setDescription("WS-Security: secext.xsd");
            metaData.setVersion("1.0");
            System.out.print("\tAdding " + metaData.getName() + " to the archive...");
            archive.addEntry("ws-security/schemas/wss-wssecurity-secext-1.0.xsd", (BaseArtifactType)metaData, contentStream);
            contentStream.close();
            System.out.println("added.");
            contentStream = ArchivePackageDemo.class.getResourceAsStream("wstx-wsba-1.1-schema-200701.xsd");
            metaData = new XsdDocument();
            metaData.setName("wstx-wsba-1.1-schema-200701.xsd");
            metaData.setDescription("WS-Transaction: ws-tx-schema.xsd");
            metaData.setVersion("1.1");
            System.out.print("\tAdding " + metaData.getName() + " to the archive...");
            archive.addEntry("ws-tx/schemas/wstx-wsba-1.1-schema-200701.xsd", (BaseArtifactType)metaData, contentStream);
            contentStream.close();
            System.out.println("added.");
            contentStream = ArchivePackageDemo.class.getResourceAsStream("wstx-wsba-1.1-wsdl-200702.wsdl");
            metaData = new WsdlDocument();
            metaData.setName("wstx-wsba-1.1-wsdl-200702.wsdl");
            metaData.setDescription("WS-Transaction: ws-tx-wsdl.wsdl");
            metaData.setVersion("1.1");
            System.out.print("\tAdding " + metaData.getName() + " to the archive...");
            archive.addEntry("ws-tx/wsdl/wstx-wsba-1.1-wsdl-200702.wsdl", (BaseArtifactType)metaData, contentStream);
            contentStream.close();
            System.out.println("added.");
            System.out.print("Uploading the S-RAMP package...");
            Map batchResponse = client.uploadBatch(archive);
            System.out.println("uploaded:");
            for (Map.Entry entry : batchResponse.entrySet()) {
                String path = (String)entry.getKey();
                Object resp = entry.getValue();
                if (!(resp instanceof BaseArtifactType)) continue;
                BaseArtifactType arty = (BaseArtifactType)resp;
                System.out.println("\t" + path + " (" + arty.getUuid() + ")");
            }
        }
        finally {
            SrampArchive.closeQuietly((SrampArchive)archive);
        }
        System.out.print("Querying the S-RAMP repository for Schemas...");
        Feed feed = client.query("/s-ramp/xsd/XsdDocument");
        System.out.println("success: " + feed.getEntries().size() + " Schemas found:");
        for (Entry entry : feed.getEntries()) {
            System.out.println("\t * " + entry.getTitle() + " (" + entry.getId() + ")");
        }
        System.out.println("\n*** Demo Completed Successfully ***\n\n");
        Thread.sleep(3000L);
    }
}

