/* Copyright (C) 1991,92,93,94,95,96,97,98,2002,03,04,05
	Free Software Foundation, Inc.
   This file is part of the GNU C Library.

   The GNU C Library is free software; you can redistribute it and/or
   modify it under the terms of the GNU Lesser General Public
   License as published by the Free Software Foundation; either
   version 2.1 of the License, or (at your option) any later version.

   The GNU C Library is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
   Lesser General Public License for more details.

   You should have received a copy of the GNU Lesser General Public
   License along with the GNU C Library; if not, write to the Free
   Software Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA
   02111-1307 USA.  */

#include <sysdep.h>
#include <tls.h>

.globl syscall_error

#if defined(PIC)
	/* Put this at the end of libc's text segment so that all of
	   the direct branches from the syscalls are forward, and 
	   thus predicted not taken.  */
	.section .text.last, "ax", @progbits
#else
	.text
#endif

#undef syscall_error
#ifdef NO_UNDERSCORES
__syscall_error:
#else
syscall_error:
#endif

#if defined(_LIBC_REENTRANT) && ! USE___THREAD
	addi	sp, #-24, sp
	movsg	lr, gr5
	sti.p	fp, @(sp, 8)
	addi	sp, #8, fp
	mov	gr8, gr18
	sti	gr5, @(fp, 8)
	call	C_SYMBOL_NAME(__errno_location)
	st.p	gr18, @(gr8, gr0)
	setlos	#-1, gr8
	ld	@(sp, gr0), gr18
	ldi	@(fp, 8), gr5
	ld	@(fp, gr0), fp
	jmpl.p	@(gr5, gr0)
	addi	sp, #24, sp
#else

# ifndef NOT_IN_libc
#  define SYSCALL_ERROR_ERRNO C_SYMBOL_NAME(__libc_errno)
# else
#  define SYSCALL_ERROR_ERRNO C_SYMBOL_NAME(errno)
# endif

	.globl SYSCALL_ERROR_ERRNO
# if USE___THREAD
	ldi	@(gr15, #gottlsoff12(SYSCALL_ERROR_ERRNO)), gr5
	st.p	gr8, @(gr29, gr5)
# else
	sethi.p	#gothi(SYSCALL_ERROR_ERRNO), gr4
	setlo	#gotlo(SYSCALL_ERROR_ERRNO), gr4
	ld	@(gr4, gr15), gr5
	st.p	gr8, @(gr5, gr0)
# endif
	setlos	#-1, gr8
	ret
#endif

#undef	__syscall_error
END (__syscall_error)
