/*	Copyright (C) 1995, 1996 Free Software Foundation, Inc.
 * 
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2, or (at your option)
 * any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with this software; see the file COPYING.  If not, write to
 * the Free Software Foundation, 675 Mass Ave, Cambridge, MA 02139, USA.
 *
 * As a special exception, the Free Software Foundation gives permission
 * for additional uses of the text contained in its release of GUILE.
 *
 * The exception is that, if you link the GUILE library with other files
 * to produce an executable, this does not by itself cause the
 * resulting executable to be covered by the GNU General Public License.
 * Your use of that executable is in no way restricted on account of
 * linking the GUILE library code into it.
 *
 * This exception does not however invalidate any other reasons why
 * the executable file might be covered by the GNU General Public License.
 *
 * This exception applies only to the code released by the
 * Free Software Foundation under the name GUILE.  If you copy
 * code from other Free Software Foundation releases into a copy of
 * GUILE, as the General Public License permits, the exception does
 * not apply to the code that you add in this way.  To avoid misleading
 * anyone as to the status of such modified files, you must delete
 * this exception notice from them.
 *
 * If you write modifications of your own for GUILE, it is your choice
 * whether to permit this exception to apply to your modifications.
 * If you do not wish that, delete this exception notice.  
 */


#include <stdio.h>

#include <gscm.h>
#include <_scm.h>

#include "threads.h"



#ifdef USE_THREADS

#ifdef USE_MIT_PTHREADS
#include "mit-pthreads.c"
#endif

#ifdef USE_COOP_THREADS
#include "coop-threads.c"
#endif

/* Define thread PLUGIN interface. */

PROC(s_yield, "yield", 0, 0, 0, gscm_threads_yield);
PROC(s_with_new_thread, "with-new-thread", 2, 0, 0, gscm_threads_with_new_thread);
PROC(s_join_thread, "join-thread", 1, 0, 0, gscm_threads_join_thread);
PROC(s_make_mutex, "make-mutex", 0, 0, 0, gscm_threads_make_mutex);
PROC(s_lock_mutex, "lock-mutex", 1, 0, 0, gscm_threads_lock_mutex);
PROC(s_unlock_mutex, "unlock-mutex", 1, 0, 0, gscm_threads_unlock_mutex);
PROC(s_make_condition_variable, "make-condition-variable", 0, 0, 0, gscm_threads_make_condition_variable);
PROC(s_lock_condition_variable, "wait-condition-variable", 2, 0, 0, gscm_threads_condition_variable_wait);
PROC(s_unlock_condition_variable, "signal-condition-variable", 1, 0, 0, gscm_threads_condition_variable_signal);

#ifdef __STDC__
void
gscm_threads_init_all ()
#else
void
gscm_threads_init_all ()
#endif
{
  /* Add "threads" to the *features* list */
  scm_add_feature ("threads");

  /* Define the new type: thread */
  scm_thread_type.name = "thread";
  scm_thread_type.equal = gscm_threads_thread_equal;
  scm_thread_type.print = NULL;
  scm_thread_type.die = gscm_threads_thread_die;

  /* Define the new type: mutex */
  scm_mutex_type.name = "mutex";
  scm_mutex_type.equal = NULL;
  scm_mutex_type.print = NULL;
  scm_mutex_type.die = gscm_threads_mutex_die;
  
  /* Define the new type: mutex */
  scm_condition_variable_type.name = "condition-variable";
  scm_condition_variable_type.equal = NULL;
  scm_condition_variable_type.print = NULL;
  scm_condition_variable_type.die = gscm_threads_condition_variable_die;
  
  /* Include function registration code */
#include "threads.x"

  /* Initialize implementation specific details of the threads support */
  gscm_threads_init();
}

#else

#include "no-threads.c"

#endif


