#!/packages/bin/guile -
; -*-scheme-*-

;; examples of processing matrices with guile

;; include the Tk toolkit stuff so we can do a color
;; representation of the matrix on a canvas.
(require 'Gwish)
(use-library tcl)
(use-interface tcl)
(use-interface tclhack)

(define sample-m
  (list
   (list 7 2 1 3 2 8 5 3 6 2 8 5 3 6 2 8 5 3 6 2 8 5 3 6 2 8 5 3 6)
   (list 4 1 1 1 3 8 9 8 1 2 8 5 3 6 2 8 5 3 6 2 8 5 3 6 2 8 5 3 6)
   (list 4 2 1 1 4 2 1 1 4 2 1 1 4 2 1 1 4 2 1 1 4 2 1 1 3 8 9 8 1)
   (list 4 3 1 1 3 8 4 2 1 1 4 2 1 1 4 2 1 1 4 2 1 1 4 2 1 1 9 8 1)
   (list 4 2 1 1 4 4 4 2 1 1 1 4 2 1 1 1 4 2 1 1 3 4 2 1 1 8 9 8 1)
   (list 4 6 1 1 3 8 9 8 1 4 2 1 1 4 2 1 1 4 2 1 1 4 2 4 2 1 1 1 1)
   (list 4 2 1 1 4 2 1 1 4 2 1 1 4 2 1 1 4 2 1 1 4 2 1 1 3 8 9 8 1)
   (list 4 3 1 1 3 8 4 2 1 1 4 2 1 1 4 2 1 1 4 2 1 1 4 2 1 1 9 8 1)
   (list 4 2 1 1 4 4 4 2 1 1 1 4 2 1 1 1 4 2 1 1 3 4 2 1 1 8 9 8 1)
   (list 4 6 1 1 3 8 9 8 1 4 2 1 1 4 2 1 1 4 2 1 1 4 2 4 2 1 1 1 1)
   (list 4 2 1 1 4 2 1 1 4 2 1 1 4 2 1 1 4 2 1 1 4 2 1 1 3 8 9 8 1)
   (list 4 3 1 1 3 8 4 2 1 1 4 2 1 1 4 2 1 1 4 2 1 1 4 2 1 1 9 8 1)
   (list 4 2 1 1 4 4 4 2 1 1 1 4 2 1 1 1 4 2 1 1 3 4 2 1 1 8 9 8 1)
   (list 4 6 1 1 3 8 9 8 1 4 2 1 1 4 2 1 1 4 2 1 1 4 2 4 2 1 1 1 1)
   (list 4 2 1 1 4 2 1 1 4 2 1 1 4 2 1 1 4 2 1 1 4 2 1 1 3 8 9 8 1)
   (list 4 3 1 1 3 8 4 2 1 1 4 2 1 1 4 2 1 1 4 2 1 1 4 2 1 1 9 8 1)
   (list 4 2 1 1 4 4 4 2 1 1 1 4 2 1 1 1 4 2 1 1 3 4 2 1 1 8 9 8 1)
   (list 4 6 1 1 3 8 9 8 1 4 2 1 1 4 2 1 1 4 2 1 1 4 2 4 2 1 1 1 1)
   (list 4 2 1 1 4 2 1 1 4 2 1 1 4 2 1 1 4 2 1 1 4 2 1 1 3 8 9 8 1)
   (list 4 3 1 1 3 8 4 2 1 1 4 2 1 1 4 2 1 1 4 2 1 1 4 2 1 1 9 8 1)
   (list 4 2 1 1 4 4 4 2 1 1 1 4 2 1 1 1 4 2 1 1 3 4 2 1 1 8 9 8 1)
   (list 4 6 1 1 3 8 9 8 1 4 2 1 1 4 2 1 1 4 2 1 1 4 2 4 2 1 1 1 1)
   (list 4 2 1 1 4 2 1 1 4 2 1 1 4 2 1 1 4 2 1 1 4 2 1 1 3 8 9 8 1)
   (list 0 3 1 1 3 8 4 2 1 1 4 2 1 1 4 2 1 1 4 2 1 1 4 2 1 1 9 8 1)
   (list 1 2 1 1 4 4 4 2 1 1 1 4 2 1 1 1 4 2 1 1 3 4 2 1 1 8 9 8 1)
   (list 2 6 1 1 3 8 9 8 1 4 2 1 1 4 2 1 1 4 2 1 1 4 2 4 2 1 1 1 1)
   (list 3 5 4 8 1 8 2 4 2 1 1 4 2 1 1 4 2 4 2 1 4 2 1 1 1 1 1 2 4)))

(define color-list '("black" "purple" "blue" "lightblue" "orange" "yellow"
			     "white" "red" "green"))
;; this returns the n-th element in a list (wrapping if the list is short)
;; we use it to find entries in the color table.
(define (nth-wrap n list size)
  (if (= (modulo n size) 0)
    (car list)
    (nth-wrap (- n 1) (cdr list) size)))

;; returns the color corresponding to a given integer
(define (find-color n)
  (nth-wrap n color-list (length color-list)))

;; applies the function func to the matrix m element-by-element;
;; returns a matrix with the result.
(define (process-matrix m func)
  (map (lambda (l)
	 (map func l))
       m))

;; proc is a procedure to represent the single element,
;; row-proc is a procedure that is invoked after each row.
;; For example, proc could be (lambda (x) (begin (display x) (display " ")))
;; and row-proc could be (lambda (l) (display "\n"))
(define (represent-matrix m proc row-proc)
  (for-each (lambda (l)
	      (begin
		(for-each proc l)
		(row-proc l)))
	    m))

;; draw-cell is a helper function if you want to draw a cell in a
;; Tk window.  It has a minimal object-oriented-ness using closures
;; to remember the coordinates of the current matrix element (since
;; it is not called with the (i, j) coordinates).
;; The title is placed at the bottom; a "quit" button is placed at the
;; top; sizex and sizey are the dimensions of the matrix that will
;; be represented; square-size is the size of each matrix square.
;;(define (prepare-canvas title sizex sizey square-size)

(define title "matrix representation")
(define sizex (length (car m)))
(define sizey (length m))
(define square-size 10)


(define quit-callback
  (lambda ()
    (display "quitting now\n")
    (destroy ".")))

(define (MAKE-CELL the-x the-y the-color)
  (define (get-x) the-x)
  (define (get-y) the-y)

  (define (set-x! new-x)
    (set! the-x new-x)
    the-x)
  (define (set-y! new-y)
    (set! the-y new-y)
    the-y)
  (define (set-color! new-color)
    (set! the-color new-color)
    the-color)
  (define (next!)
    (set! the-x (+ the-x 1))
    (if (>= the-x sizex)
	(begin
	  (set! the-x 0)
	  (set! the-y (+ the-y 1))))
	(if (>= the-y sizey)
	    (begin
	      (display "CELL next!: value of y is too big; not changing it\n")
	      (set! the-y (- the-y 1))))
	(cons the-x the-y))
  (define (draw)
    (let* ((x0 (* the-x square-size))
	   (y0 (* the-y square-size))
	   (x1 (+ x0 square-size))
	   (y1 (+ y0 square-size)))
      (.matrix-canvas 'create 'rectangle x0 y0 x1 y1 :fill the-color)
      ))

  ;; self is the dispatch procedure
  (define (self message)
    (case message
      ((x)            get-x)
      ((y)            get-y)
      ((set-x!)       set-x!)
      ((set-y!)       set-y!)
      ((set-color!)   set-color!)
      ((next!)        next!)
      ((draw)          draw)
      (else (error "CELL: Unknown message -> " message))))
  ;; and now return the dispatch procedure
  self
  )

;; draw-matrix uses process-matrix and the cell object to represent
;; the matrix in a canvas widget.
(define (draw-matrix m)
  (let ((c (MAKE-CELL 0 0 (find-color (car (car m))))))
    (process-matrix
     m
     (lambda (x)
       (begin
	 ((c 'set-color!) (find-color x))
	 ((c 'draw))
	 ((c 'next!)))))))


(frame '.button-bar :relief 'raised :bd 2)
(pack '.button-bar :side 'top)

(button '.button-bar.quit :text "quit"
	:command (tcl-lambda () (quit-callback)))
(pack '.button-bar.quit)

(canvas '.matrix-canvas :width (* square-size sizex)
	:height (* square-size sizey))
;;    (.matrix-canvas 'create 'rectangle 0 0 100 100
;;		    :outline "white" :fill "white")
(pack '.matrix-canvas :expand 'yes :fill 'both)

(label '.description-lab :text title)
(pack '.description-lab)

(define current-x 0)
(define current-y 0)

(define (draw-matrix-element val)
  (begin
    (.matrix-canvas 'create 'rectangle
		    (* current-x sizex) (* current-y sizey)
		    (+ (* current-x sizex) square-size)
		    (+ (* current-y sizey) square-size)
		    :fill 'black)
    (set! current-x (+ current-x 1))
   )
  )

(define (draw-matrix-new-row)
  (begin
    (set! current-x 0)
    (set! current-y (+ current-y 1))))


;;(tk-main-loop)
;;(quit)
