/* Target definitions for Matsushita AM33-2 processor running Linux.
   Copyright 2002
   Free Software Foundation, Inc.

   This file is part of GDB.

   This program is free software; you can redistribute it and/or modify
   it under the terms of the GNU General Public License as published by
   the Free Software Foundation; either version 2 of the License, or
   (at your option) any later version.

   This program is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
   GNU General Public License for more details.

   You should have received a copy of the GNU General Public License
   along with this program; if not, write to the Free Software
   Foundation, Inc., 59 Temple Place - Suite 330,
   Boston, MA 02111-1307, USA.  */

/* The mn10300 target is fully multi-arched and, therefore, does not have
   a "tm" file. The mn10300 target does not support Linux shared libraries.
   At this time shared library support and full multi-arch support are
   mutually exclusive.

   The AM33-2 target does support Linux shared libraries and, therefore, must
   be only partially multi-arched. This allows the specification of this "tm"
   file from which the generic tm-linux.h is included (which, in turn,
   includes the required solib.h).

   Notice that gdb/configure.tgt sets the following:

   target_cpu == mn10300:      target_cpu == am33_2.0*-*-linux*:
     gdb_target_cpu=mn10300      gdb_target_cpu=mn10300
     gdb_target=mn10300          gdb_target=linux
   gdb_target == mn10300:      gdb_target == linux:
     gdb_multi_arch=yes          gdb_multi_arch=<undefined>

This causes the mn10300 target to look in gdb/config/mn10300 for mn10300.mt
and specifies that this target is fully multi-arched. And it causes the AM33-2
target to look in that same directory for linux.mt. Since gdb_multi_arch is
not defined for this target, linux.mt can specify the TM_FILE symbol pointing
to gdb/config/mn10300/tm-linux.h (this file). */

/* Pull in generic linux definitions.  */
#include "tm-linux.h"

/* Set the multi-arch level to "partial". */
#define GDB_MULTI_ARCH 1
