;; GCC machine description for Matsushita MN10300
;; Copyright (C) 1996, 1997, 1998, 1999, 2000, 2001, 2002, 2003, 2004, 2006
;; Free Software Foundation, Inc.
;; Contributed by Jeff Law (law@cygnus.com).

;; This file is part of GCC.

;; GCC is free software; you can redistribute it and/or modify
;; it under the terms of the GNU General Public License as published by
;; the Free Software Foundation; either version 2, or (at your option)
;; any later version.

;; GCC is distributed in the hope that it will be useful,
;; but WITHOUT ANY WARRANTY; without even the implied warranty of
;; MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
;; GNU General Public License for more details.

;; You should have received a copy of the GNU General Public License
;; along with GCC; see the file COPYING.  If not, write to
;; the Free Software Foundation, 59 Temple Place - Suite 330,
;; Boston, MA 02111-1307, USA.

;; The original PO technology requires these to be ordered by speed,
;; so that assigner will pick the fastest.

;; See file "rtl.def" for documentation on define_insn, match_*, et. al.

(define_constants [
  (PIC_REG	6)
  (SP_REG	9)
  (TLS_REG	12)
  (CC_REG       50)

  (UNSPEC_INT_LABEL	0)
  (UNSPEC_PIC		1)
  (UNSPEC_GOT		2)
  (UNSPEC_GOTOFF	3)
  (UNSPEC_PLT		4)
  (UNSPEC_A0D0		5)
  (UNSPEC_BLOCKAGE      6)
  
  ;; These put the corresponding @op suffix on TLS variables.
  (UNSPEC_TLSGD		100)
  (UNSPEC_TLSLDM	101)
  (UNSPEC_DTPOFF	102)
  (UNSPEC_GOTNTPOFF	103)
  (UNSPEC_INDNTPOFF	104)
  (UNSPEC_TPOFF		105)

  ;; These are used to differentiate tls-specific insns.
  (UNSPEC_TLS_GD	110)
  (UNSPEC_TLS_LD_BASE	111)

  ;; These are used to encode LIW patterns.
  (UNSPEC_LIW_1		112)
  (UNSPEC_LIW_2		113)
  (UNSPEC_LCC		114)
  (UNSPEC_SETLB		115)

  (UNSPEC_CACHE_FLUSH	116)
])

;; Processor type.  This attribute must exactly match the processor_type
;; enumeration in mn10300.h.
(define_attr "cpu" "mn10300,am33,am34"
  (const (symbol_ref "mn10300_tune_cpu")))


;; Bundling of smaller insns into a long instruction word (LIW)
(define_automaton "liw_bundling")
(automata_option "ndfa")

(define_cpu_unit "liw_op1_u,liw_op2_u" "liw_bundling")

(define_attr "liw" "op1,op2,both,either"
  (const_string "both"))
;; Note: this list must match the one for 'W' just before print_operand()
(define_attr "liw_op" "add,cmp,sub,mov,and,or,xor,dmach,swhw,sat16,asr,lsr,asl,none,max"
  (const_string "none"))

(define_insn_reservation "liw_op1" 1
  (and (ior (eq_attr "cpu" "am33")
	    (eq_attr "cpu" "am34"))
       (eq_attr "liw" "op1"))
  "liw_op1_u");
(define_insn_reservation "liw_op2" 1
  (and (ior (eq_attr "cpu" "am33")
	    (eq_attr "cpu" "am34"))
       (eq_attr "liw" "op2"))
  "liw_op2_u");
(define_insn_reservation "liw_both" 1
  (and (ior (eq_attr "cpu" "am33")
	    (eq_attr "cpu" "am34"))
       (eq_attr "liw" "both"))
  "liw_op1_u + liw_op2_u");
(define_insn_reservation "liw_either" 1
  (and (ior (eq_attr "cpu" "am33")
	    (eq_attr "cpu" "am34"))
       (eq_attr "liw" "either"))
  "liw_op1_u | liw_op2_u");


;; Pipeline description.

;; The AM33 only has a single pipeline.  It has five stages (fetch,
;; decode, execute, memory access, writeback) each of which normally
;; takes a single CPU clock cycle.

;; The timings attribute consists of two numbers, the first is the
;; throughput, which is the number of cycles the instruction takes
;; to execute and generate a result.  The second is the latency
;; which is the effective number of cycles the instruction takes to
;; execute if its result is used by the following instruction.  The
;; latency is always greater than or equal to the throughput.
;; These values were taken from the Appendix of the "MN103E Series
;; Instruction Manual" and the timings for the AM34.

;; Note - it would be nice to use strings rather than integers for
;; the possible values of this attribute, so that we can have the
;; gcc build mechanism check for values that are not supported by
;; the reservations below.  But this will not work because the code
;; in mn10300_adjust_sched_cost() needs integers not strings.

(define_attr "timings" "" (const_int 11))

(define_automaton "pipelining")
(define_cpu_unit "throughput" "pipelining")

(define_insn_reservation "throughput__1_latency__1"  1 (eq_attr "timings" "11") "throughput")
(define_insn_reservation "throughput__1_latency__2"  2 (eq_attr "timings" "12") "throughput,nothing")
(define_insn_reservation "throughput__1_latency__3"  3 (eq_attr "timings" "13") "throughput,nothing*2")
(define_insn_reservation "throughput__1_latency__4"  4 (eq_attr "timings" "14") "throughput,nothing*3")
(define_insn_reservation "throughput__2_latency__2"  2 (eq_attr "timings" "22") "throughput*2")
(define_insn_reservation "throughput__2_latency__3"  3 (eq_attr "timings" "23") "throughput*2,nothing")
(define_insn_reservation "throughput__2_latency__4"  4 (eq_attr "timings" "24") "throughput*2,nothing*2")
(define_insn_reservation "throughput__2_latency__5"  5 (eq_attr "timings" "25") "throughput*2,nothing*3")
(define_insn_reservation "throughput__3_latency__3"  3 (eq_attr "timings" "33") "throughput*3")
(define_insn_reservation "throughput__3_latency__7"  7 (eq_attr "timings" "37") "throughput*3,nothing*4")
(define_insn_reservation "throughput__4_latency__4"  4 (eq_attr "timings" "44") "throughput*4")
(define_insn_reservation "throughput__4_latency__7"  7 (eq_attr "timings" "47") "throughput*4,nothing*3")
(define_insn_reservation "throughput__4_latency__8"  8 (eq_attr "timings" "48") "throughput*4,nothing*4")
(define_insn_reservation "throughput__5_latency__5"  5 (eq_attr "timings" "55") "throughput*5")
(define_insn_reservation "throughput__6_latency__6"  6 (eq_attr "timings" "66") "throughput*6")
(define_insn_reservation "throughput__7_latency__7"  7 (eq_attr "timings" "77") "throughput*7")
(define_insn_reservation "throughput__7_latency__8"  8 (eq_attr "timings" "78") "throughput*7,nothing")
(define_insn_reservation "throughput__8_latency__8"  8 (eq_attr "timings" "88") "throughput*8")
(define_insn_reservation "throughput__9_latency__9"  9 (eq_attr "timings" "99") "throughput*9")
(define_insn_reservation "throughput__8_latency_14" 14 (eq_attr "timings" "814") "throughput*8,nothing*6")
(define_insn_reservation "throughput__9_latency_10" 10 (eq_attr "timings" "910") "throughput*9,nothing")
(define_insn_reservation "throughput_10_latency_10" 10 (eq_attr "timings" "1010") "throughput*10")
(define_insn_reservation "throughput_12_latency_16" 16 (eq_attr "timings" "1216") "throughput*12,nothing*4")
(define_insn_reservation "throughput_13_latency_13" 13 (eq_attr "timings" "1313") "throughput*13")
(define_insn_reservation "throughput_14_latency_14" 14 (eq_attr "timings" "1414") "throughput*14")
(define_insn_reservation "throughput_13_latency_17" 17 (eq_attr "timings" "1317") "throughput*13,nothing*4")
(define_insn_reservation "throughput_23_latency_27" 27 (eq_attr "timings" "2327") "throughput*23,nothing*4")
(define_insn_reservation "throughput_25_latency_31" 31 (eq_attr "timings" "2531") "throughput*25,nothing*6")
(define_insn_reservation "throughput_38_latency_39" 39 (eq_attr "timings" "3839") "throughput*38,nothing")
(define_insn_reservation "throughput_39_latency_40" 40 (eq_attr "timings" "3940") "throughput*39,nothing")
(define_insn_reservation "throughput_40_latency_40" 40 (eq_attr "timings" "4040") "throughput*40")
(define_insn_reservation "throughput_41_latency_42" 42 (eq_attr "timings" "4142") "throughput*41,nothing")
(define_insn_reservation "throughput_43_latency_44" 44 (eq_attr "timings" "4344") "throughput*43,nothing")
(define_insn_reservation "throughput_45_latency_46" 46 (eq_attr "timings" "4546") "throughput*45,nothing")
(define_insn_reservation "throughput_47_latency_53" 53 (eq_attr "timings" "4753") "throughput*47,nothing*6")

;; Note - the conflict between memory load/store instructions
;; and floating point instructions described in section 1-7-4
;; of Chapter 3 of the MN103E Series Instruction Manual is
;; handled by the mn10300_adjust_sched_cost function.

;; ----------------------------------------------------------------------
;; MOVE INSTRUCTIONS
;; ----------------------------------------------------------------------

;; movqi

(define_expand "movqi"
  [(set (match_operand:QI 0 "general_operand" "")
	(match_operand:QI 1 "general_operand" ""))]
  ""
  "
  {
    /* One of the ops has to be in a register.  */
    if (!register_operand (operand0, QImode)
        && !register_operand (operand1, QImode))
      operands[1] = copy_to_mode_reg (QImode, operand1);
  }"
)

(define_insn "*am33_movqi"
  [(set (match_operand:QI 0 "nonimmediate_operand" "=d*x*a*f,d*x*a,d*x*a,m,*f,d*x*a")
	(match_operand:QI 1 "general_operand"      "0,d*xai,m,d*xa,d*xa*f,*f"))]
  "TARGET_AM33
   && (register_operand (operands[0], QImode)
       || register_operand (operands[1], QImode))"
  "*
  {
  switch (which_alternative)
    {
    case 0:
      return \"nop\";
    case 1:
      if (GET_CODE (operands[1]) == CONST_DOUBLE)
	{
	  rtx xoperands[2];
	  xoperands[0] = operands[0];
	  xoperands[1] = GEN_INT (CONST_DOUBLE_LOW (operands[1]));
	  output_asm_insn (\"mov %1, %0\", xoperands);
	  return \"\";
	}

      if (REGNO_REG_CLASS (true_regnum (operands[0])) == EXTENDED_REGS
	  && GET_CODE (operands[1]) == CONST_INT)
	{
	  HOST_WIDE_INT val = INTVAL (operands[1]);

	  if (((val & 0x80) && ! (val & 0xffffff00))
	      || ((val & 0x800000) && ! (val & 0xff000000)))
	    return \"movu %1, %0\";
	}
      return \"mov %1, %0\";
    case 2:
    case 3:
      return \"movbu %1, %0\";
    case 4:
    case 5:
      return \"fmov %1, %0\";
    default:
      abort ();
    }
  }"
  [(set_attr_alternative "timings"
			 [(const_int 11)
			  (if_then_else (eq_attr "cpu" "am34") (const_int 11) (const_int 22))
			  (if_then_else (eq_attr "cpu" "am34") (const_int 13) (const_int 24))
			  (if_then_else (eq_attr "cpu" "am34") (const_int 13) (const_int 24))
			  (if_then_else (eq_attr "cpu" "am34") (const_int 47) (const_int 25))
			  (if_then_else (eq_attr "cpu" "am34") (const_int 47) (const_int 25))
			 ])
  ]
)

(define_insn "*mn10300_movqi"
  [(set (match_operand:QI 0 "nonimmediate_operand" "=d*a,d*a,d,m")
	(match_operand:QI 1 "general_operand"      "0,dai,m,d"))]
  "register_operand (operands[0], QImode)
   || register_operand (operands[1], QImode)"
  "*
  {
  switch (which_alternative)
    {
    case 0:
      return \"nop\";
    case 1:
      if (GET_CODE (operands[1]) == CONST_DOUBLE)
	{
	  rtx xoperands[2];
	  xoperands[0] = operands[0];
	  xoperands[1] = GEN_INT (CONST_DOUBLE_LOW (operands[1]));
	  output_asm_insn (\"mov %1, %0\", xoperands);
	  return \"\";
	}

      return \"mov %1, %0\";
    case 2:
    case 3:
      return \"movbu %1, %0\";
    default:
      abort ();
    }
  }"
  [(set_attr_alternative "timings"
			 [(const_int 11)
			  (if_then_else (eq_attr "cpu" "am34") (const_int 11) (const_int 22))
			  (if_then_else (eq_attr "cpu" "am34") (const_int 13) (const_int 24))
			  (if_then_else (eq_attr "cpu" "am34") (const_int 13) (const_int 24))
			 ])
  ]
)

;; movhi

(define_expand "movhi"
  [(set (match_operand:HI 0 "general_operand" "")
	(match_operand:HI 1 "general_operand" ""))]
  ""
  "
  {
    /* One of the ops has to be in a register.  */
    if (!register_operand (operand1, HImode)
        && !register_operand (operand0, HImode))
      operands[1] = copy_to_mode_reg (HImode, operand1);
  }"
)

(define_insn "*am33_movhi"
  [(set (match_operand:HI 0 "nonimmediate_operand" "=d*x*a*f,d*x*a,d*x*a,m,*f,d*x*a")
	(match_operand:HI 1 "general_operand"      "0,d*x*ai,m,d*x*a,d*x*a*f,*f"))]
  "TARGET_AM33
   && (register_operand (operands[0], HImode)
       || register_operand (operands[1], HImode))"
  "*
  {
  switch (which_alternative)
    {
    case 0:
      return \"nop\";
    case 1:
      if (GET_CODE (operands[1]) == CONST_DOUBLE)
	{
	  rtx xoperands[2];
	  xoperands[0] = operands[0];
	  xoperands[1] = GEN_INT (CONST_DOUBLE_LOW (operands[1]));
	  output_asm_insn (\"mov %1, %0\", xoperands);
	  return \"\";
	}

      if (REGNO_REG_CLASS (true_regnum (operands[0])) == EXTENDED_REGS
	  && GET_CODE (operands[1]) == CONST_INT)
	{
	  HOST_WIDE_INT val = INTVAL (operands[1]);

	  if (((val & 0x80) && ! (val & 0xffffff00))
	      || ((val & 0x800000) && ! (val & 0xff000000)))
	    return \"movu %1, %0\";
	}
      return \"mov %1, %0\";
    case 2:
    case 3:
      return \"movhu %1, %0\";
    case 4:
    case 5:
      return \"fmov %1, %0\";
    default:
      abort ();
    }
  }"
  [(set_attr_alternative "timings"
			 [(const_int 11)
			  (if_then_else (eq_attr "cpu" "am34") (const_int 11) (const_int 22))
			  (if_then_else (eq_attr "cpu" "am34") (const_int 13) (const_int 24))
			  (if_then_else (eq_attr "cpu" "am34") (const_int 13) (const_int 24))
			  (if_then_else (eq_attr "cpu" "am34") (const_int 47) (const_int 25))
			  (if_then_else (eq_attr "cpu" "am34") (const_int 47) (const_int 25))
			 ])
  ]
)

(define_insn "*mn10300_movhi"
  [(set (match_operand:HI 0 "nonimmediate_operand" "=d*a,d*a,d,m")
	(match_operand:HI 1 "general_operand"      "0,dai,m,d"))]
  "register_operand (operands[0], HImode)
   || register_operand (operands[1], HImode)"
  "*
  {
  switch (which_alternative)
    {
    case 0:
      return \"nop\";
    case 1:
      if (GET_CODE (operands[1]) == CONST_DOUBLE)
	{
	  rtx xoperands[2];
	  xoperands[0] = operands[0];
	  xoperands[1] = GEN_INT (CONST_DOUBLE_LOW (operands[1]));
	  output_asm_insn (\"mov %1, %0\", xoperands);
	  return \"\";
	}
      return \"mov %1, %0\";
    case 2:
    case 3:
      return \"movhu %1, %0\";
    default:
      abort ();
    }
  }"
  [(set_attr_alternative "timings"
			 [(const_int 11)
			  (if_then_else (eq_attr "cpu" "am34") (const_int 11) (const_int 22))
			  (if_then_else (eq_attr "cpu" "am34") (const_int 13) (const_int 24))
			  (if_then_else (eq_attr "cpu" "am34") (const_int 13) (const_int 24))
			 ])
  ]
)

;; movsi and helpers

;; We use this to handle addition of two values when one operand is the
;; stack pointer and the other is a memory reference of some kind.  Reload
;; does not handle them correctly without this expander.
(define_expand "reload_insi"
  [(set (match_operand:SI     0 "register_operand" "=a")
	(match_operand:SI     1 "impossible_plus_operand" ""))
   (clobber (match_operand:SI 2 "register_operand" "=&r"))]
  ""
  "
  {
  if (XEXP (operands[1], 0) == stack_pointer_rtx)
    {
      if (GET_CODE (XEXP (operands[1], 1)) == SUBREG
	  && (GET_MODE_SIZE (GET_MODE (XEXP (operands[1], 1)))
	      > GET_MODE_SIZE (GET_MODE (SUBREG_REG (XEXP (operands[1], 1))))))
	emit_move_insn (operands[2],
			gen_rtx_ZERO_EXTEND
			(GET_MODE (XEXP (operands[1], 1)),
			 SUBREG_REG (XEXP (operands[1], 1))));
      else
	emit_move_insn (operands[2], XEXP (operands[1], 1));
      emit_move_insn (operands[0], XEXP (operands[1], 0));
    }
  else
    {
      if (GET_CODE (XEXP (operands[1], 0)) == SUBREG
	  && (GET_MODE_SIZE (GET_MODE (XEXP (operands[1], 0)))
	      > GET_MODE_SIZE (GET_MODE (SUBREG_REG (XEXP (operands[1], 0))))))
	emit_move_insn (operands[2],
			gen_rtx_ZERO_EXTEND
			(GET_MODE (XEXP (operands[1], 0)),
			 SUBREG_REG (XEXP (operands[1], 0))));
      else
	emit_move_insn (operands[2], XEXP (operands[1], 0));
      emit_move_insn (operands[0], XEXP (operands[1], 1));
    }
  emit_insn (gen_addsi3 (operands[0], operands[0], operands[2]));
  DONE;
  }"
)

(define_insn "pop_pic_reg"
  [(set (reg:SI PIC_REG)
	(mem:SI (post_inc:SI (reg:SI SP_REG))))
  ]
  "reload_completed"
  "movm (sp),[a2]"
  [(set (attr "timings") (if_then_else (eq_attr "cpu" "am34") (const_int 44) (const_int 33)))]
)

(define_expand "movsi"
  [(set (match_operand:SI 0 "general_operand" "")
	(match_operand:SI 1 "general_operand" ""))]
  ""
  "
  {
  int model;

  model = tls_symbolic_operand (operands[1], Pmode);
  if (model)
    {
      operands[1] = legitimize_tls_address (operands[1]);
      operands[1] = force_operand (operands[1], operands[0]);
      if (operands[1] == operands[0])
        DONE;
    }
  /* One of the ops has to be in a register.  */
  if (!register_operand (operand1, SImode)
      && !register_operand (operand0, SImode))
    operands[1] = copy_to_mode_reg (SImode, operand1);
  if (flag_pic)
    {
      rtx temp;

      if (SYMBOLIC_CONST_P (operands[1]))
	{
	  if (GET_CODE (operands[0]) == MEM)
	    operands[1] = force_reg (Pmode, operands[1]);
	  else
	    {
	      temp = no_new_pseudos ? operands[0] : gen_reg_rtx (Pmode);
	      operands[1] = legitimize_pic_address (operands[1], temp);
	    }
	}
      else if (GET_CODE (operands[1]) == CONST
	       && GET_CODE (XEXP (operands[1], 0)) == PLUS
	       && SYMBOLIC_CONST_P (XEXP (XEXP (operands[1], 0), 0)))
	{
	  temp = no_new_pseudos ? operands[0] : gen_reg_rtx (Pmode);
	  temp = legitimize_pic_address (XEXP (XEXP (operands[1], 0), 0),
					 temp);
	  operands[1] = expand_binop (SImode, add_optab, temp,
				      XEXP (XEXP (operands[1], 0), 1),
				      no_new_pseudos ? temp
				      : gen_reg_rtx (Pmode),
				      0, OPTAB_LIB_WIDEN);
	}
    }
  }"
)

(define_insn "movsi_internal"
  [(set (match_operand:SI 0 "nonimmediate_operand"
				"=dx,ax,a, dax,daxm, dx,dx,ax,ax, axR,!*y, *f,*f,dxaQ")
	(match_operand:SI 1 "nontls_general_operand"
				"0,0,I, daxO,dax, dixm,aixm,dixm,aixm, !*y,axR, 0,dxaQi*f,*f"))
  ]
  "register_operand (operands[0], SImode)
   || register_operand (operands[1], SImode)"
  "*
  {
  switch (which_alternative)
    {
    case 0:
    case 1:
      return \"nop\";
    case 2:
    case 3:
    case 4:
    case 5:
    case 6:
    case 7:
    case 8:
    case 9:
    case 10:
      if (GET_CODE (operands[1]) == CONST_DOUBLE)
	{
	  rtx xoperands[2];

          xoperands[0] = operands[0];
	  xoperands[1] = GEN_INT (CONST_DOUBLE_LOW (operands[1]));
	  output_asm_insn (\"mov %1, %0\", xoperands);
	  return \"\";
	}

      if (REGNO_REG_CLASS (true_regnum (operands[0])) == EXTENDED_REGS
	  && GET_CODE (operands[1]) == CONST_INT)
	{
	  HOST_WIDE_INT val = INTVAL (operands[1]);

	  if (((val & 0x80) && ! (val & 0xffffff00))
	      || ((val & 0x800000) && ! (val & 0xff000000)))
	    return \"movu %1, %0\";
	}
      return \"mov %1, %0\";
    case 11:
      return \"nop\";
    case 12:
    case 13:
      return \"fmov %1, %0\";
    default:
      abort ();
    }
  }"
  [(set_attr "liw" "either,either,either, either,*, *,*,*,*, *,*, *,*,*")
   (set_attr "liw_op" "mov")
   (set_attr_alternative "timings"
			 [(const_int 11)
			  (const_int 11)
			  (if_then_else (eq_attr "cpu" "am34") (const_int 13) (const_int 24))
			  (if_then_else (eq_attr "cpu" "am34") (const_int 13) (const_int 24))
			  (if_then_else (eq_attr "cpu" "am34") (const_int 13) (const_int 24))
			  (if_then_else (eq_attr "cpu" "am34") (const_int 13) (const_int 24))
			  (if_then_else (eq_attr "cpu" "am34") (const_int 13) (const_int 24))
			  (if_then_else (eq_attr "cpu" "am34") (const_int 13) (const_int 24))
			  (if_then_else (eq_attr "cpu" "am34") (const_int 13) (const_int 24))
			  (if_then_else (eq_attr "cpu" "am34") (const_int 13) (const_int 24))
			  (if_then_else (eq_attr "cpu" "am34") (const_int 13) (const_int 24))
			  (const_int 11)
			  (if_then_else (eq_attr "cpu" "am34") (const_int 47) (const_int 25))
			  (if_then_else (eq_attr "cpu" "am34") (const_int 47) (const_int 25))
			 ])
  ]
)

(define_expand "movsf"
  [(set (match_operand:SF 0 "general_operand" "")
	(match_operand:SF 1 "general_operand" ""))]
  ""
  "
  {
    /* One of the ops has to be in a register.  */
    if (!register_operand (operand1, SFmode)
        && !register_operand (operand0, SFmode))
      operands[1] = copy_to_mode_reg (SFmode, operand1);
  }"
)

(define_insn ""
  [(set (match_operand:SF 0 "nonimmediate_operand" "=f,dx,dx,a,f,dxaQ,daxm,dax")
	(match_operand:SF 1 "general_operand"      "0,0,0,G,fdxaQF,f,dax,daxFm"))
  ]
  "register_operand (operands[0], SFmode)
   || register_operand (operands[1], SFmode)"
  "*
  {
  switch (which_alternative)
    {
    case 0:
    case 1:
    case 2:
      return \"nop\";
    /* case 3: below.  */
    case 4:
    case 5:
      return \"fmov %1, %0\";
    case 3:
    case 6:
    case 7:
      if (REGNO_REG_CLASS (true_regnum (operands[0])) == EXTENDED_REGS
	  && GET_CODE (operands[1]) == CONST_INT)
	{
	  HOST_WIDE_INT val = INTVAL (operands[1]);

	  if (((val & 0x80) && ! (val & 0xffffff00))
	      || ((val & 0x800000) && ! (val & 0xff000000)))
	    return \"movu %1, %0\";
	}
      return \"mov %1, %0\";
    default:
      abort ();
    }
  }"
  [(set_attr_alternative "timings"
			 [(const_int 11)
			  (const_int 11)
			  (const_int 11)
			  (if_then_else (eq_attr "cpu" "am34") (const_int 13) (const_int 24))
			  (if_then_else (eq_attr "cpu" "am34") (const_int 47) (const_int 25))
			  (if_then_else (eq_attr "cpu" "am34") (const_int 47) (const_int 25))
			  (if_then_else (eq_attr "cpu" "am34") (const_int 13) (const_int 24))
			  (if_then_else (eq_attr "cpu" "am34") (const_int 13) (const_int 24))
			 ])
  ]
)

(define_expand "movdi"
  [(set (match_operand:DI 0 "general_operand" "")
	(match_operand:DI 1 "general_operand" ""))]
  ""
  "
  {
    /* One of the ops has to be in a register.  */
    if (!register_operand (operand1, DImode)
        && !register_operand (operand0, DImode))
      operands[1] = copy_to_mode_reg (DImode, operand1);
  }"
)

(define_insn ""
  [(set (match_operand:DI 0 "nonimmediate_operand"
				"=dx,ax,dx,a,dxm,dxm,axm,axm,dx,dx,ax,ax,*f,*f,*f,dxa,*f,Q")
	(match_operand:DI 1 "general_operand"
				"0,0,I,I,dx,ax,dx,ax,dxim,axim,dxim,axim,0,*f,dxai,*f,Q,*f"))
  ]
  "register_operand (operands[0], DImode)
   || register_operand (operands[1], DImode)"
  "*
  {
    long val[2];
    REAL_VALUE_TYPE rv;

    switch (which_alternative)
    {
      case 0:
      case 1:
	return \"nop\";

      case 2:
	return \"mov 0, %L0\;mov 0, %H0\";

      case 3:
	if (rtx_equal_p (operands[0], operands[1]))
	  return \"sub %L1, %L0\;mov %L0, %H0\";
	else
	  return \"mov %1, %L0\;mov %L0, %H0\";
      case 4:
      case 5:
      case 6:
      case 7:
      case 8:
      case 9:
      case 10:
      case 11:
	if (GET_CODE (operands[1]) == CONST_INT)
	  {
	    rtx low, high;
	    split_double (operands[1], &low, &high);
	    val[0] = INTVAL (low);
	    val[1] = INTVAL (high);
	  }
	if (GET_CODE (operands[1]) == CONST_DOUBLE)
	  {
	    if (GET_MODE (operands[1]) == DFmode)
	      {
		REAL_VALUE_FROM_CONST_DOUBLE (rv, operands[1]);
		REAL_VALUE_TO_TARGET_DOUBLE (rv, val);
	      }
	    else if (GET_MODE (operands[1]) == VOIDmode
		     || GET_MODE (operands[1]) == DImode)
	      {
		val[0] = CONST_DOUBLE_LOW (operands[1]);
		val[1] = CONST_DOUBLE_HIGH (operands[1]);
	      }
	  }

	if (GET_CODE (operands[1]) == MEM
	    && reg_overlap_mentioned_p (operands[0], XEXP (operands[1], 0)))
	  {
	    rtx temp = operands[0];

	    while (GET_CODE (temp) == SUBREG)
	      temp = SUBREG_REG (temp);

	    if (GET_CODE (temp) != REG)
	      abort ();

	    if (reg_overlap_mentioned_p (gen_rtx_REG (SImode, REGNO (temp)),
					 XEXP (operands[1], 0)))
	      return \"mov %H1, %H0\;mov %L1, %L0\";
	    else
	      return \"mov %L1, %L0\;mov %H1, %H0\";
	  }
	else if (GET_CODE (operands[1]) == MEM
		 && CONSTANT_ADDRESS_P (XEXP (operands[1], 0))
		 && REGNO_REG_CLASS (REGNO (operands[0])) == ADDRESS_REGS)
	  {
	    rtx xoperands[2];

	    xoperands[0] = operands[0];
	    xoperands[1] = XEXP (operands[1], 0);

	    output_asm_insn (\"mov %1, %L0\;mov (4, %L0), %H0\;mov (%L0), %L0\",
			     xoperands);
	    return \"\";
	  }
	else
	  {
	    if ((GET_CODE (operands[1]) == CONST_INT
		 || GET_CODE (operands[1]) == CONST_DOUBLE)
		&& val[0] == 0)
	      {
		if (REGNO_REG_CLASS (REGNO (operands[0])) == DATA_REGS)
		  output_asm_insn (\"clr %L0\", operands);
		else
		  output_asm_insn (\"mov %L1, %L0\", operands);
	      }
	    else if ((GET_CODE (operands[1]) == CONST_INT
		      || GET_CODE (operands[1]) == CONST_DOUBLE)
		     && (REGNO_REG_CLASS (true_regnum (operands[0]))
			 == EXTENDED_REGS)
		     && (((val[0] & 0x80) && ! (val[0] & 0xffffff00))
			 || ((val[0] & 0x800000) && ! (val[0] & 0xff000000))))
	      output_asm_insn (\"movu %L1, %L0\", operands);
	    else
	      output_asm_insn (\"mov %L1, %L0\", operands);

	    if ((GET_CODE (operands[1]) == CONST_INT
		 || GET_CODE (operands[1]) == CONST_DOUBLE)
		&& val[1] == 0)
	      {
		if (REGNO_REG_CLASS (REGNO (operands[0])) == DATA_REGS)
		  output_asm_insn (\"clr %H0\", operands);
		else
		  output_asm_insn (\"mov %H1, %H0\", operands);
	      }
	    else if ((GET_CODE (operands[1]) == CONST_INT
		      || GET_CODE (operands[1]) == CONST_DOUBLE)
		     && val[0] == val[1])
	      output_asm_insn (\"mov %L0, %H0\", operands);
	    else if ((GET_CODE (operands[1]) == CONST_INT
		      || GET_CODE (operands[1]) == CONST_DOUBLE)
		     && (REGNO_REG_CLASS (true_regnum (operands[0]))
			 == EXTENDED_REGS)
		     && (((val[1] & 0x80) && ! (val[1] & 0xffffff00))
			 || ((val[1] & 0x800000) && ! (val[1] & 0xff000000))))
	      output_asm_insn (\"movu %H1, %H0\", operands);
	    else
	      output_asm_insn (\"mov %H1, %H0\", operands);
	    return \"\";
	  }
      case 12:
        return \"nop\";
      case 13:
      case 14:
      case 15:
        return \"fmov %L1, %L0\;fmov %H1, %H0\";
      case 16:
	if (GET_CODE (operands[1]) == MEM
	    && GET_CODE (XEXP (operands[1], 0)) == CONST_INT
	    && (INTVAL (XEXP (operands[1], 0)) & 7) == 0)
	  return \"fmov %D1, %D0\";
	else
          return \"fmov %L1, %L0\;fmov %H1, %H0\";
      case 17:
	if (GET_CODE (operands[0]) == MEM
	    && GET_CODE (XEXP (operands[0], 0)) == CONST_INT
	    && (INTVAL (XEXP (operands[0], 0)) & 7) == 0)
	  return \"fmov %D1, %D0\";
	else
          return \"fmov %L1, %L0\;fmov %H1, %H0\";
    default:
      abort ();
    }
  }"
  ;; Timings of "37", "48" and "814" are approximations of worst case sceanarios.
  [(set_attr_alternative "timings"
			 [(const_int 11)
			  (const_int 11)
			  (const_int 22)
			  (const_int 22)
			  (const_int 37)
			  (const_int 37)
			  (const_int 37)
			  (const_int 37)
			  (const_int 37)
			  (const_int 37)
			  (const_int 37)
			  (const_int 37)
			  (const_int 11)
			  (if_then_else (eq_attr "cpu" "am34") (const_int 814) (const_int 48))
			  (if_then_else (eq_attr "cpu" "am34") (const_int 814) (const_int 48))
			  (if_then_else (eq_attr "cpu" "am34") (const_int 814) (const_int 48))
			  (if_then_else (eq_attr "cpu" "am34") (const_int 814) (const_int 48))
			  (if_then_else (eq_attr "cpu" "am34") (const_int 814) (const_int 48))
			 ])
  ]
)

(define_expand "movdf"
  [(set (match_operand:DF 0 "general_operand" "")
	(match_operand:DF 1 "general_operand" ""))]
  ""
  "
  {
    /* One of the ops has to be in a register.  */
    if (!register_operand (operand1, DFmode)
        && !register_operand (operand0, DFmode))
      operands[1] = copy_to_mode_reg (DFmode, operand1);
  }"
)

(define_insn "*movdf_insn"
  [(set (match_operand:DF 0 "nonimmediate_operand"
				"=f,dx,ax,dx,f,f,dxa,f,Q,a,dxm,dxm,axm,axm,dx,dx,ax,ax")
	(match_operand:DF 1 "general_operand"
				"0,0,0,G,f,dxaF,f,Q,f,G,dx,ax,dx,ax,dxFm,axFm,dxFm,axFm"))
  ]
  "register_operand (operands[0], DFmode)
   || register_operand (operands[1], DFmode)"
  "*
  {
    long val[2];
    REAL_VALUE_TYPE rv;

    switch (which_alternative)
    {
      case 0:
      case 1:
      case 2:
	return \"nop\";

      case 3:
	return \"mov 0, %L0\;mov 0, %H0\";

      case 4:
      case 5:
      case 6:
        return \"fmov %L1, %L0\;fmov %H1, %H0\";

      case 7:
	if (GET_CODE (operands[1]) == MEM
	    && GET_CODE (XEXP (operands[1], 0)) == CONST_INT
	    && (INTVAL (XEXP (operands[1], 0)) & 7) == 0)
	  return \"fmov %D1, %D0\";
	else
          return \"fmov %L1, %L0\;fmov %H1, %H0\";

      case 8:
	if (GET_CODE (operands[0]) == MEM
	    && GET_CODE (XEXP (operands[0], 0)) == CONST_INT
	    && (INTVAL (XEXP (operands[0], 0)) & 7) == 0)
	  return \"fmov %D1, %D0\";
	else
          return \"fmov %L1, %L0\;fmov %H1, %H0\";

      case 9:
	 if (rtx_equal_p (operands[0], operands[1]))
	   return \"sub %L1, %L0\;mov %L0, %H0\";
	 else
	   return \"mov %1, %L0\;mov %L0, %H0\";
      case 10:
      case 11:
      case 12:
      case 13:
      case 14:
      case 15:
      case 16:
      case 17:
	if (GET_CODE (operands[1]) == CONST_INT)
	  {
	    rtx low, high;
	    split_double (operands[1], &low, &high);
	    val[0] = INTVAL (low);
	    val[1] = INTVAL (high);
	  }
	if (GET_CODE (operands[1]) == CONST_DOUBLE)
	  {
	    if (GET_MODE (operands[1]) == DFmode)
	      {
		REAL_VALUE_FROM_CONST_DOUBLE (rv, operands[1]);
		REAL_VALUE_TO_TARGET_DOUBLE (rv, val);
	      }
	    else if (GET_MODE (operands[1]) == VOIDmode
		     || GET_MODE (operands[1]) == DImode)
	      {
		val[0] = CONST_DOUBLE_LOW (operands[1]);
		val[1] = CONST_DOUBLE_HIGH (operands[1]);
	      }
	  }

	if (GET_CODE (operands[1]) == MEM
	    && reg_overlap_mentioned_p (operands[0], XEXP (operands[1], 0)))
	  {
	    rtx temp = operands[0];

	    while (GET_CODE (temp) == SUBREG)
	      temp = SUBREG_REG (temp);

	    if (GET_CODE (temp) != REG)
	      abort ();

	    if (reg_overlap_mentioned_p (gen_rtx_REG (SImode, REGNO (temp)),
					 XEXP (operands[1], 0)))
	      return \"mov %H1, %H0\;mov %L1, %L0\";
	    else
	      return \"mov %L1, %L0\;mov %H1, %H0\";
	  }
	else if (GET_CODE (operands[1]) == MEM
		 && CONSTANT_ADDRESS_P (XEXP (operands[1], 0))
		 && REGNO_REG_CLASS (REGNO (operands[0])) == ADDRESS_REGS)
	  {
	    rtx xoperands[2];

	    xoperands[0] = operands[0];
	    xoperands[1] = XEXP (operands[1], 0);

	    output_asm_insn (\"mov %1, %L0\;mov (4, %L0), %H0\;mov (%L0), %L0\",
			     xoperands);
	    return \"\";
	  }
	else
	  {
	    if ((GET_CODE (operands[1]) == CONST_INT
		 || GET_CODE (operands[1]) == CONST_DOUBLE)
		&& val[0] == 0)
	      {
		if (REGNO_REG_CLASS (REGNO (operands[0])) == DATA_REGS)
		  output_asm_insn (\"clr %L0\", operands);
		else
		  output_asm_insn (\"mov %L1, %L0\", operands);
	      }
	    else if ((GET_CODE (operands[1]) == CONST_INT
		      || GET_CODE (operands[1]) == CONST_DOUBLE)
		     && (REGNO_REG_CLASS (true_regnum (operands[0]))
			 == EXTENDED_REGS)
		     && (((val[0] & 0x80) && ! (val[0] & 0xffffff00))
			 || ((val[0] & 0x800000) && ! (val[0] & 0xff000000))))
	      output_asm_insn (\"movu %L1, %L0\", operands);
	    else
	      output_asm_insn (\"mov %L1, %L0\", operands);

	    if ((GET_CODE (operands[1]) == CONST_INT
		 || GET_CODE (operands[1]) == CONST_DOUBLE)
		&& val[1] == 0)
	      {
		if (REGNO_REG_CLASS (REGNO (operands[0])) == DATA_REGS)
		  output_asm_insn (\"clr %H0\", operands);
		else
		  output_asm_insn (\"mov %H1, %H0\", operands);
	      }
	    else if ((GET_CODE (operands[1]) == CONST_INT
		      || GET_CODE (operands[1]) == CONST_DOUBLE)
		     && val[0] == val[1])
	      output_asm_insn (\"mov %L0, %H0\", operands);
	    else if ((GET_CODE (operands[1]) == CONST_INT
		      || GET_CODE (operands[1]) == CONST_DOUBLE)
		     && (REGNO_REG_CLASS (true_regnum (operands[0]))
			 == EXTENDED_REGS)
		     && (((val[1] & 0x80) && ! (val[1] & 0xffffff00))
			 || ((val[1] & 0x800000) && ! (val[1] & 0xff000000))))
	      output_asm_insn (\"movu %H1, %H0\", operands);
	    else
	      output_asm_insn (\"mov %H1, %H0\", operands);
	    return \"\";
	  }
    default:
      abort ();
    }
  }"
  ;; Timings of "37", "48" and "814" are approximations of worst case sceanarios.
  [(set_attr_alternative "timings"
			 [(const_int 11)
			  (const_int 11)
			  (const_int 11)
			  (const_int 22)
			  (if_then_else (eq_attr "cpu" "am34") (const_int 814) (const_int 48))
			  (if_then_else (eq_attr "cpu" "am34") (const_int 814) (const_int 48))
			  (if_then_else (eq_attr "cpu" "am34") (const_int 814) (const_int 48))
			  (if_then_else (eq_attr "cpu" "am34") (const_int 814) (const_int 48))
			  (if_then_else (eq_attr "cpu" "am34") (const_int 814) (const_int 48))
			  (const_int 22)
			  (const_int 37)
			  (const_int 37)
			  (const_int 37)
			  (const_int 37)
			  (const_int 37)
			  (const_int 37)
			  (const_int 37)
			  (const_int 37)
			 ])
  ]
)

;; ----------------------------------------------------------------------
;; COMPARE INSTRUCTIONS
;; ----------------------------------------------------------------------

(define_expand "cmpsi"
  [(set (reg:CC CC_REG)
	(compare:CC (match_operand:SI 0 "register_operand"  "")
		    (match_operand:SI 1 "nonmemory_operand" "")))
  ]
  ""
  "
    mn10300_compare_op0 = operands[0];
    mn10300_compare_op1 = operands[1];
    DONE;
  "
)

;; The first alternative is to cope with situations where gcc generates a
;; bogus compare between a register and itself, which is illegal (MN10300)
;; or sub-optimal (AM33).  This can happen with badly written source code,
;; eg compile/920928-3.c compiled at -O1 or when gcc fails to remove a
;; redundant compare, eg execute/20010116-1.c at -O3.
(define_insn "*cmpsi_insn"
  [(set (reg:CC CC_REG)
	(compare:CC (match_operand:SI 0 "register_operand"  "dax,dax")
		    (match_operand:SI 1 "nonmemory_operand" "!0,daxi")))
  ]
  "TARGET_AM33"
  "@
  btst 0, %0
  cmp %1, %0"
  [
   (set_attr "liw" "either")
   (set_attr "liw_op" "cmp")
   (set_attr_alternative "timings"
			 [(const_int 11)
			  (if_then_else (eq_attr "cpu" "am34") (const_int 11) (const_int 22))
			 ])
  ]
)

(define_insn "*cmpsi_insn_mn10300"
  [(set (reg:CC CC_REG)
	(compare:CC (match_operand:SI 0 "register_operand"  "dx,dx")
		    (match_operand:SI 1 "nonmemory_operand" "!0,dxi")))
  ]
  "! TARGET_AM33"
  "@
  btst 0, %0
  cmp %1, %0"
)

(define_expand "cmpsf"
  [(set (reg:CC_FLOAT CC_REG)
	(compare:CC_FLOAT (match_operand:SF 0 "register_operand"  "")
			  (match_operand:SF 1 "nonmemory_operand" "")))
  ]
  "TARGET_AM33_2"
  "
    mn10300_compare_op0 = operands[0];
    mn10300_compare_op1 = operands[1];
    DONE;
  "
)

(define_insn "*am33_cmpsf"
  [(set (reg:CC_FLOAT CC_REG)
	(compare:CC_FLOAT (match_operand:SF 0 "register_operand"  "f,f")
			  (match_operand:SF 1 "nonmemory_operand" "f,F")))]
  "TARGET_AM33_2"
  "fcmp %1, %0"
  [(set (attr "timings") (if_then_else (eq_attr "cpu" "am34") (const_int 17) (const_int 25)))]
)

;; ----------------------------------------------------------------------
;; ADD INSTRUCTIONS
;; ----------------------------------------------------------------------

(define_expand "addsi3"
  [(parallel [(set (match_operand:SI          0 "register_operand" "")
		   (plus:SI (match_operand:SI 1 "register_operand" "")
			    (match_operand:SI 2 "nonmemory_operand" "")))
	      (clobber (reg:CC CC_REG))
	     ])
  ]
  ""
  "
  /* This code attempts to work around a problem with reload.  Reload must be able
     to generate ADDSI3 instructions of its own when it is reloading a POST_INC
     memory address.  But, reload assumes that these ADDSI3 insns have no side
     effects and so it does not look to see if, for example, the first instruction
     scheduler pass has already moved a COMPARE insn to before the POST_INC that
     is being reloaded.  */
  if (TARGET_AM33
      && (reload_in_progress || reload_completed)
      && GET_CODE (operands[0]) == REG
      && GET_CODE (operands[1]) == REG
      && true_regnum (operands[0]) == true_regnum (operands[1])
      && (REGNO_REG_CLASS (true_regnum (operands[0])) == ADDRESS_REGS
          || REGNO_REG_CLASS (true_regnum (operands[0])) == A0_REGS)
      && (GET_CODE (operands[2]) == CONST_INT
          && CONST_OK_FOR_P (INTVAL (operands[2]))))
    {
      emit_insn (gen_addsi3_without_clobber (operands[0], operands[1], operands[2]));
      DONE;
    }
    /* We must also handle reload generating REG+REG.  */
  else if (TARGET_AM33
      && (reload_in_progress || reload_completed)
      && GET_CODE (operands[0]) == REG
      && GET_CODE (operands[1]) == REG
      && true_regnum (operands[0]) == true_regnum (operands[1])
      && GET_CODE (operands[2]) == REG)
    {
      emit_insn (gen_addsi3_without_clobber (operands[0], operands[1], operands[2]));
      DONE;
    }
  else if (0 && (reload_in_progress || reload_completed))
    {
      fprintf (stderr, \"WARNING: dangerous reload of ADDSI3:\");
      debug_rtx (operands[0]);
      debug_rtx (operands[1]);
      debug_rtx (operands[2]);
    }
  "
)

(define_insn "*am33_addsi3"
  [(set (match_operand:SI          0 "register_operand" "=dx,a,x,a,dax,dax,!*y,!dax")
	(plus:SI (match_operand:SI 1 "register_operand" "%0,0,0,0,0,0,0,dax")
		 (match_operand:SI 2 "nontls_nonmemory_operand" "J,J,L,L,daxO,i,i,dax")))
   (clobber (reg:CC CC_REG))
  ]
  "TARGET_AM33"
  "*
  {
  switch (which_alternative)
    {
    case 0:
    case 1:
      return \"inc %0\";
    case 2:
    case 3:
      return \"inc4 %0\";
    case 4:
    case 5:
    case 6:
      return \"add %2, %0\";
    case 7:
      {
	enum reg_class src1_class, src2_class, dst_class;

	src1_class = REGNO_REG_CLASS (true_regnum (operands[1]));
	src2_class = REGNO_REG_CLASS (true_regnum (operands[2]));
	dst_class = REGNO_REG_CLASS (true_regnum (operands[0]));

	/* I'm not sure if this can happen or not.  Might as well be prepared
	  and generate the best possible code if it does happen.  */
	if (true_regnum (operands[0]) == true_regnum (operands[1]))
	  return \"add %2, %0\";
	if (true_regnum (operands[0]) == true_regnum (operands[2]))
	  return \"add %1, %0\";

	/* Catch cases where no extended register was used.  These should be
	   handled just like the mn10300.  */
	if (src1_class != EXTENDED_REGS
	    && src2_class != EXTENDED_REGS
	    && dst_class != EXTENDED_REGS)
	  {
	    /* We have to copy one of the sources into the destination, then
	       add the other source to the destination.

	       Carefully select which source to copy to the destination; a naive
	       implementation will waste a byte when the source classes are
	       different and the destination is an address register.  Selecting
	       the lowest cost register copy will optimize this sequence.  */
	    if (REGNO_REG_CLASS (true_regnum (operands[1]))
		== REGNO_REG_CLASS (true_regnum (operands[0])))
	      return \"mov %1, %0\;add %2, %0\";
	    return \"mov %2, %0\;add %1, %0\";
	  }

	/* At least one register is an extended register.  */

	/* The three operand add instruction on the am33 is a win iff the
	   output register is an extended register, or if both source
	   registers are extended registers.  */
	if (dst_class == EXTENDED_REGS
	    || src1_class == src2_class)
	  return \"add %2, %1, %0\";

      /* It is better to copy one of the sources to the destination, then
	 perform a 2 address add.  The destination in this case must be
	 an address or data register and one of the sources must be an
	 extended register and the remaining source must not be an extended
	 register.

	 The best code for this case is to copy the extended reg to the
	 destination, then emit a two address add.  */
      if (src1_class == EXTENDED_REGS)
	return \"mov %1, %0\;add %2, %0\";
      return \"mov %2, %0\;add %1, %0\";
      }
    default:
      abort ();
    }
  }"
  [(set_attr "liw" "either,either,*,*,either,*,*,*")
   (set_attr "liw_op" "add")
   (set_attr "timings" "11,11,11,11,11,11,11,22")
  ]
)

(define_insn "*mn10300_addsi3"
  [(set (match_operand:SI          0 "register_operand" "=dx,a,a,dax,!*y,!dax")
	(plus:SI (match_operand:SI 1 "register_operand" "%0,0,0,0,0,dax")
		 (match_operand:SI 2 "nonmemory_operand" "J,J,L,daxi,i,dax")))
   (clobber (reg:CC CC_REG))
  ]
  ""
  "*
  {
  switch (which_alternative)
    {
    case 0:
    case 1:
      return \"inc %0\";
    case 2:
      return \"inc4 %0\";
    case 3:
    case 4:
      return \"add %2, %0\";
    case 5:
      /* I'm not sure if this can happen or not.  Might as well be prepared
	 and generate the best possible code if it does happen.  */
      if (true_regnum (operands[0]) == true_regnum (operands[1]))
	return \"add %2, %0\";
      if (true_regnum (operands[0]) == true_regnum (operands[2]))
	return \"add %1, %0\";

      /* We have to copy one of the sources into the destination, then add
	 the other source to the destination.

	 Carefully select which source to copy to the destination; a naive
	 implementation will waste a byte when the source classes are different
	 and the destination is an address register.  Selecting the lowest
	 cost register copy will optimize this sequence.  */
      if (REGNO_REG_CLASS (true_regnum (operands[1]))
	  == REGNO_REG_CLASS (true_regnum (operands[0])))
	return \"mov %1, %0\;add %2, %0\";
      return   \"mov %2, %0\;add %1, %0\";
    default:
      abort ();
    }
  }"
  [(set_attr "timings" "11,11,11,11,11,22")]
)

;; FIXME: We may need to support a larger integer range than -8..7
;; We could use "sub -8, %0, 0, d0" to add 8.
(define_insn "addsi3_without_clobber"
  [(set (match_operand:SI          0 "register_operand" "=a,a,a,dax")
	(plus:SI (match_operand:SI 1 "register_operand" "%0,0,0,0")
		 (match_operand:SI 2 "nonmemory_operand" "J,L,P,r")))
  ]
  "TARGET_AM33 && (reload_in_progress || reload_completed)"
  "*
  {
    switch (which_alternative)
      {
      case 0: return \"inc %0\";
      case 1: return \"inc4 %0\";
      case 2: return \"add_add %2, %0, 0, d0\";
      case 3:
        /* Check for the case where the destination register is d0
	   because 'add_add xxx, d0, xxx, d0' is an undefined instruction.  */
        if (true_regnum (operands[0]) == 0)
          return \"add_add %2, %0, 0, d1\";
        return \"add_add %2, %0, 0, d0\";
      default:
	abort ();
      }
  }"
  ;; [(set_attr "timings" "11")]
)

;; ----------------------------------------------------------------------
;; SUBTRACT INSTRUCTIONS
;; ----------------------------------------------------------------------

(define_expand "subsi3"
  [(parallel [(set (match_operand:SI           0 "register_operand" "")
		   (minus:SI (match_operand:SI 1 "register_operand" "")
			     (match_operand:SI 2 "nonmemory_operand" "")))
	      (clobber (reg:CC CC_REG))
	     ])
  ]
  ""
  ""
)

(define_insn "*am33_subsi3"
  [(set (match_operand:SI           0 "register_operand" "=dax,dax,!dax")
	(minus:SI (match_operand:SI 1 "register_operand" "0,0,dax")
		  (match_operand:SI 2 "nonmemory_operand" "daxO,i,dax")))
   (clobber (reg:CC CC_REG))
  ]
  "TARGET_AM33"
  "*
  {
  if (true_regnum (operands[0]) == true_regnum (operands[1]))
    return \"sub %2, %0\";
  else
    {
      enum reg_class src1_class, src2_class, dst_class;

      src1_class = REGNO_REG_CLASS (true_regnum (operands[1]));
      src2_class = REGNO_REG_CLASS (true_regnum (operands[2]));
      dst_class = REGNO_REG_CLASS (true_regnum (operands[0]));

      /* If no extended registers are used, then the best way to handle
	 this is to copy the first source operand into the destination
	 and emit a two address subtraction.  */
      if (src1_class != EXTENDED_REGS
	  && src2_class != EXTENDED_REGS
	  && dst_class != EXTENDED_REGS
	  && true_regnum (operands[0]) != true_regnum (operands[2]))
	return \"mov %1, %0\;sub %2, %0\";
      return \"sub %2, %1, %0\";
    }
  }"
  [(set_attr "liw" "either,*,*")
   (set_attr "liw_op" "sub")
   (set_attr "timings" "11,22,22")
  ]
)

(define_insn "*mn10300_subsi3"
  [(set (match_operand:SI           0 "register_operand" "=dax")
	(minus:SI (match_operand:SI 1 "register_operand" "0")
		  (match_operand:SI 2 "nonmemory_operand" "daxi")))
   (clobber (reg:CC CC_REG))
  ]
  ""
  "sub %2, %0"
  [(set (attr "timings") (if_then_else (eq_attr "cpu" "am34") (const_int 11) (const_int 22)))]
)

(define_expand "negsi2"
  [(set (match_operand:SI         0 "register_operand" "")
        (neg:SI (match_operand:SI 1 "register_operand" "")))]
  ""
  "
  {
    rtx target = gen_reg_rtx (SImode);

    emit_move_insn (target, GEN_INT (0));
    emit_insn (gen_subsi3 (target, target, operands[1]));
    emit_move_insn (operands[0], target);
    DONE;
  }"
)

;; ----------------------------------------------------------------------
;; MULTIPLY INSTRUCTIONS
;; ----------------------------------------------------------------------

(define_expand "mulsidi3"
  [(parallel [(set (match_operand:DI                          0 "register_operand" "=dax")
		   (mult:DI (sign_extend:DI (match_operand:SI 1 "register_operand" "dax"))
			    (sign_extend:DI (match_operand:SI 2 "register_operand" "dax"))))
	      (clobber (reg:CC CC_REG))
	     ])
  ]
  "TARGET_AM33"
  ""
)

(define_insn "*mulsidi3_insn"
  [(set (match_operand:DI                          0 "register_operand" "=dax")
        (mult:DI (sign_extend:DI (match_operand:SI 1 "register_operand" "dax"))
                 (sign_extend:DI (match_operand:SI 2 "register_operand" "dax"))))
   (clobber (reg:CC CC_REG))
  ]
  "TARGET_AM33"
  "mul %1, %2, %H0, %L0"
  [(set (attr "timings") (if_then_else (eq_attr "cpu" "am34") (const_int 24) (const_int 23)))]
)

(define_expand "umulsidi3"
  [(parallel [(set (match_operand:DI                          0 "register_operand" "=dax")
		   (mult:DI (zero_extend:DI (match_operand:SI 1 "register_operand" "dax"))
			    (zero_extend:DI (match_operand:SI 2 "register_operand" "dax"))))
	      (clobber (reg:CC CC_REG))
	     ])
  ]
  "TARGET_AM33"
  ""
)

(define_insn "*umulsidi3_insn"
  [(set (match_operand:DI                          0 "register_operand" "=dax")
        (mult:DI (zero_extend:DI (match_operand:SI 1 "register_operand" "dax"))
                 (zero_extend:DI (match_operand:SI 2 "register_operand" "dax"))))
   (clobber (reg:CC CC_REG))
  ]
  "TARGET_AM33"
  "mulu %1, %2, %H0, %L0"
  [(set (attr "timings") (if_then_else (eq_attr "cpu" "am34") (const_int 24) (const_int 23)))]
)

(define_expand "mulsi3"
  [(parallel [(set (match_operand:SI          0 "register_operand" "")
		   (mult:SI (match_operand:SI 1 "register_operand" "")
			    (match_operand:SI 2 "register_operand" "")))
	      (clobber (reg:CC CC_REG))
	     ])
  ]
  ""
  ""
)

(define_insn "*am33_mulsi3"
  [(set (match_operand:SI          0 "register_operand" "=dx,!dax")
	(mult:SI (match_operand:SI 1 "register_operand" "%0,0")
		 (match_operand:SI 2 "nonmemory_operand" "dx,daxi")))
   (clobber (reg:CC CC_REG))
  ]
  "TARGET_AM33"
  "*
  {
    if (TARGET_MULT_BUG)
      return \"nop\;nop\;mul %2, %0\";
    else
      return \"mul %2, %0\";
  }"
  [(set (attr "timings") (if_then_else (eq_attr "cpu" "am34") (const_int 24) (const_int 23)))]
)

(define_insn "*mn10300_mulsi3"
  [(set (match_operand:SI          0 "register_operand" "=dx")
	(mult:SI (match_operand:SI 1 "register_operand" "%0")
		 (match_operand:SI 2 "register_operand" "dx")))
   (clobber (reg:CC CC_REG))
  ]
  ""
  "*
  {
    if (TARGET_MULT_BUG)
      return \"nop\;nop\;mul %2, %0\";
    else
      return \"mul %2, %0\";
  }"
  [(set (attr "timings") (if_then_else (eq_attr "cpu" "am34") (const_int 24) (const_int 23)))]
)

(define_expand "udivmodsi4"
  [(parallel [(set (match_operand:SI 0 "nonimmediate_operand" "=dx")
		   (udiv:SI (match_operand:SI 1 "general_operand" "0")
			    (match_operand:SI 2 "general_operand" "dx")))
	      (set (match_operand:SI 3 "nonimmediate_operand" "=&d")
		   (umod:SI (match_dup 1) (match_dup 2)))
	      (clobber (reg:CC CC_REG))
	     ])
  ]
  ""
  ""
)

(define_insn "*udivmodsi4_insn"
  [(set (match_operand:SI 0 "nonimmediate_operand" "=dx")
	(udiv:SI (match_operand:SI 1 "general_operand" "0")
		 (match_operand:SI 2 "general_operand" "dx")))
   (set (match_operand:SI 3 "nonimmediate_operand" "=&d")
	(umod:SI (match_dup 1) (match_dup 2)))
   (clobber (reg:CC CC_REG))
  ]
  ""
  "*
  {
    output_asm_insn (\"sub %3, %3\;mov %3, mdr\", operands);

    if (find_reg_note (insn, REG_UNUSED, operands[3]))
      return \"divu %2, %0\";
    else
      return \"divu %2, %0\;mov mdr, %3\";
  }"
  ;; Timings:  AM33   AM34
  ;;  SUB       1/1    1/1
  ;;  MOV       1/1    1/1
  ;;  DIVU     38/39  42/43
  ;;  MOV       1/1    1/1
  ;;  --------------------
  ;;  total    41/42  45/46  (worst case sceanario)
  [(set (attr "timings") (if_then_else (eq_attr "cpu" "am34") (const_int 4546) (const_int 4142)))]
)

(define_expand "divmodsi4"
  [(parallel [(set (match_operand:SI 0 "nonimmediate_operand" "=dx")
		   (div:SI (match_operand:SI 1 "general_operand" "0")
			   (match_operand:SI 2 "general_operand" "dx")))
	      (set (match_operand:SI 3 "nonimmediate_operand" "=d")
		   (mod:SI (match_dup 1) (match_dup 2)))
	      (clobber (reg:CC CC_REG))
	     ])
  ]
  ""
  ""
)

(define_insn "*divmodsi4_insn"
  [(set (match_operand:SI 0 "nonimmediate_operand" "=dx")
	(div:SI (match_operand:SI 1 "general_operand" "0")
		 (match_operand:SI 2 "general_operand" "dx")))
   (set (match_operand:SI 3 "nonimmediate_operand" "=d")
	(mod:SI (match_dup 1) (match_dup 2)))
   (clobber (reg:CC CC_REG))
  ]
  ""
  "*
  {
    if (find_reg_note (insn, REG_UNUSED, operands[3]))
      return \"ext %0\;div %2, %0\";
    else
      return \"ext %0\;div %2, %0\;mov mdr, %3\";
  }"
  ;; Timings:  AM33   AM34
  ;;  EXT       1/1    1/1
  ;;  DIV      38/39  42/43
  ;;  --------------------
  ;;  total    39/40  43/44  (worst case sceanario)
  [(set (attr "timings") (if_then_else (eq_attr "cpu" "am34") (const_int 4344) (const_int 3940)))]
)

;; ----------------------------------------------------------------------
;; AND INSTRUCTIONS
;; ----------------------------------------------------------------------

(define_expand "andsi3"
  [(parallel [(set (match_operand:SI 0 "register_operand" "")
		   (and:SI (match_operand:SI 1 "register_operand" "")
			   (match_operand:SI 2 "nonmemory_operand" "")))
	      (clobber (reg:CC CC_REG))
	     ])
  ]
  ""
  ""
)

(define_insn "*am33_andsi3"
  [(set (match_operand:SI         0 "register_operand" "=dx,dx,dx,!dax,!dax,!dax")
	(and:SI (match_operand:SI 1 "register_operand" "%0,0,0,0,dax,0")
		(match_operand:SI 2 "nonmemory_operand" "N,dx,i,dax,dax,daxi")))
   (clobber (reg:CC CC_REG))
  ]
  "TARGET_AM33"
  "*
  {
  if (GET_CODE (operands[2]) == CONST_INT && INTVAL (operands[2]) == 0xff)
    return \"extbu %0\";
  if (GET_CODE (operands[2]) == CONST_INT && INTVAL (operands[2]) == 0xffff)
    return \"exthu %0\";
  if (GET_CODE (operands[2]) == CONST_INT && INTVAL (operands[2]) == 0x7fffffff)
    return \"add %0, %0\;lsr 1, %0\";
  if (GET_CODE (operands[2]) == CONST_INT && INTVAL (operands[2]) == 0x3fffffff)
    return \"asl2 %0\;lsr 2, %0\";
  if (GET_CODE (operands[2]) == CONST_INT && INTVAL (operands[2]) == 0x1fffffff)
    return \"add %0, %0\;asl2 %0\;lsr 3, %0\";
  if (GET_CODE (operands[2]) == CONST_INT && INTVAL (operands[2]) == 0x0fffffff)
    return \"asl2 %0\;asl2 %0\;lsr 4, %0\";
  if (GET_CODE (operands[2]) == CONST_INT && INTVAL (operands[2]) == 0xfffffffe)
    return \"lsr 1, %0\;add %0, %0\";
  if (GET_CODE (operands[2]) == CONST_INT && INTVAL (operands[2]) == 0xfffffffc)
    return \"lsr 2, %0\;asl2 %0\";
  if (GET_CODE (operands[2]) == CONST_INT && INTVAL (operands[2]) == 0xfffffff8)
    return \"lsr 3, %0\;add %0, %0\;asl2 %0\";
  if (GET_CODE (operands[2]) == CONST_INT && INTVAL (operands[2]) == 0xfffffff0)
    return \"lsr 4, %0\;asl2 %0\;asl2 %0\";
  if (REG_P (operands[2]) && REG_P (operands[1])
      && true_regnum (operands[0]) != true_regnum (operands[1])
      && true_regnum (operands[0]) != true_regnum (operands[2])
      && REGNO_REG_CLASS (true_regnum (operands[0])) == DATA_REGS
      && REGNO_REG_CLASS (true_regnum (operands[1])) == DATA_REGS
      && REGNO_REG_CLASS (true_regnum (operands[2])) == DATA_REGS)
    return \"mov %1, %0\;and %2, %0\";
  if (REG_P (operands[2]) && REG_P (operands[1])
      && true_regnum (operands[0]) != true_regnum (operands[1])
      && true_regnum (operands[0]) != true_regnum (operands[2]))
    return \"and %1, %2, %0\";
  if (REG_P (operands[2]) && REG_P (operands[0])
      && true_regnum (operands[2]) == true_regnum (operands[0]))
    return \"and %1, %0\";
  if (REG_P (operands[1]) && REG_P (operands[0])
      && true_regnum (operands[1]) == true_regnum (operands[0]))
    return \"and %2, %0\";
  abort ();
  }"
  [(set_attr "liw" "*,op1,*,op1,*,*")
   (set_attr "liw_op" "and")
   (set_attr "timings" "33")
  ]
)

(define_insn "*mn10300_andsi3"
  [(set (match_operand:SI         0 "register_operand" "=dx,dx,!a")
	(and:SI (match_operand:SI 1 "register_operand" "%0,0,0")
		(match_operand:SI 2 "nonmemory_operand" "N,dxi,i")))
   (clobber (reg:CC CC_REG))
  ]
  ""
  "*
  {
   if (which_alternative == 2)
    return \"add -4, sp; mov d0, (sp); mov %1, d0; and %2, d0; mov d0, %0; mov (sp), d0; add 4, sp\";
  if (GET_CODE (operands[2]) == CONST_INT && INTVAL (operands[2]) == 0xff)
    return \"extbu %0\";
  if (GET_CODE (operands[2]) == CONST_INT && INTVAL (operands[2]) == 0xffff)
    return \"exthu %0\";
  if (GET_CODE (operands[2]) == CONST_INT && INTVAL (operands[2]) == 0x7fffffff)
    return \"add %0, %0\;lsr 1, %0\";
  if (GET_CODE (operands[2]) == CONST_INT && INTVAL (operands[2]) == 0x3fffffff)
    return \"asl2 %0\;lsr 2, %0\";
  if (GET_CODE (operands[2]) == CONST_INT && INTVAL (operands[2]) == 0x1fffffff)
    return \"add %0, %0\;asl2 %0\;lsr 3, %0\";
  if (GET_CODE (operands[2]) == CONST_INT && INTVAL (operands[2]) == 0x0fffffff)
    return \"asl2 %0\;asl2 %0\;lsr 4, %0\";
  if (GET_CODE (operands[2]) == CONST_INT && INTVAL (operands[2]) == 0xfffffffe)
    return \"lsr 1, %0\;add %0, %0\";
  if (GET_CODE (operands[2]) == CONST_INT && INTVAL (operands[2]) == 0xfffffffc)
    return \"lsr 2, %0\;asl2 %0\";
  if (GET_CODE (operands[2]) == CONST_INT && INTVAL (operands[2]) == 0xfffffff8)
    return \"lsr 3, %0\;add %0, %0\;asl2 %0\";
  if (GET_CODE (operands[2]) == CONST_INT && INTVAL (operands[2]) == 0xfffffff0)
    return \"lsr 4, %0\;asl2 %0\;asl2 %0\";
  return \"and %2, %0\";
  }"
  [(set_attr_alternative "timings"
			 [(const_int 33)
			  (const_int 33)
			  ;; For timing computation see mn10300_xorsi3 below
			  (if_then_else (eq_attr "cpu" "am34") (const_int 78) (const_int 910))
			 ])
  ]
)

;; ----------------------------------------------------------------------
;; OR INSTRUCTIONS
;; ----------------------------------------------------------------------

(define_expand "iorsi3"
  [(parallel [(set (match_operand:SI         0 "register_operand" "")
		   (ior:SI (match_operand:SI 1 "register_operand" "")
			   (match_operand:SI 2 "nonmemory_operand" "")))
	      (clobber (reg:CC CC_REG))
	     ])
  ]
  ""
  ""
)

(define_insn "*am33_iorsi3"
  [(set (match_operand:SI         0 "register_operand" "=dx,dx,!dax,!dax,!dax")
	(ior:SI (match_operand:SI 1 "register_operand" "%0,0,0,dax,0")
		(match_operand:SI 2 "nonmemory_operand" "dxO,i,dax,dax,daxi")))
   (clobber (reg:CC CC_REG))
  ]
  "TARGET_AM33"
  "*
  {
  if (REG_P (operands[2]) && REG_P (operands[1])
      && true_regnum (operands[0]) != true_regnum (operands[1])
      && true_regnum (operands[0]) != true_regnum (operands[2])
      && REGNO_REG_CLASS (true_regnum (operands[0])) == DATA_REGS
      && REGNO_REG_CLASS (true_regnum (operands[1])) == DATA_REGS
      && REGNO_REG_CLASS (true_regnum (operands[2])) == DATA_REGS)
    return \"mov %1, %0\;or %2, %0\";
  if (REG_P (operands[2]) && REG_P (operands[1])
      && true_regnum (operands[0]) != true_regnum (operands[1])
      && true_regnum (operands[0]) != true_regnum (operands[2]))
    return \"or %1, %2, %0\";
  if (REG_P (operands[2]) && REG_P (operands[0])
      && true_regnum (operands[2]) == true_regnum (operands[0]))
    return \"or %1, %0\";
  if (REG_P (operands[1]) && REG_P (operands[0])
      && true_regnum (operands[1]) == true_regnum (operands[0]))
    return \"or %2, %0\";
  abort ();
  }"
  [(set_attr "liw" "op1,*,op1,*,*")
   (set_attr "liw_op" "or")
   (set_attr "timings" "22")
  ]
)

(define_insn "*mn10300_iorsi3"
  [(set (match_operand:SI         0 "register_operand" "=dx,!a")
	(ior:SI (match_operand:SI 1 "register_operand" "%0,0")
		(match_operand:SI 2 "nonmemory_operand" "dxi,i")))
   (clobber (reg:CC CC_REG))
  ]
  ""
  "@
  or %2, %0
  add -4, sp; mov d0, (sp); mov %1, d0; or %2, d0; mov d0, %0; mov (sp), d0; add 4, sp"
  ;; Timings: AM33  AM34
  ;; ADD       1/1   1/1
  ;; MOV       1/1   1/1
  ;; MOV       1/1   1/1
  ;; OR        2/2   1/1
  ;; MOV       2/2   1/1
  ;; MOV       1/3   1/3
  ;; ADD       1/1   1/1
  ;; -------------------
  ;; total     9/10  7/8
  [(set_attr_alternative "timings"
			 [(const_int 11)
			  (if_then_else (eq_attr "cpu" "am34") (const_int 78) (const_int 910))
			 ])
  ]
)

;; ----------------------------------------------------------------------
;; XOR INSTRUCTIONS
;; ----------------------------------------------------------------------

(define_expand "xorsi3"
  [(parallel [(set (match_operand:SI         0 "register_operand" "")
		   (xor:SI (match_operand:SI 1 "register_operand" "")
			   (match_operand:SI 2 "nonmemory_operand" "")))
	      (clobber (reg:CC CC_REG))
	     ])
  ]
  ""
  ""
)

(define_insn "*am33_xorsi3"
  [(set (match_operand:SI         0 "register_operand" "=dx,dx,!dax,!dax,!dax")
	(xor:SI (match_operand:SI 1 "register_operand" "%0,0,0,dax,0")
		(match_operand:SI 2 "nonmemory_operand" "dxO,i,dax,dax,daxi")))
   (clobber (reg:CC CC_REG))
  ]
  "TARGET_AM33"
  "*
  {
  if (REG_P (operands[2]) && REG_P (operands[1])
      && true_regnum (operands[0]) != true_regnum (operands[1])
      && true_regnum (operands[0]) != true_regnum (operands[2])
      && REGNO_REG_CLASS (true_regnum (operands[0])) == DATA_REGS
      && REGNO_REG_CLASS (true_regnum (operands[1])) == DATA_REGS
      && REGNO_REG_CLASS (true_regnum (operands[2])) == DATA_REGS)
    return \"mov %1, %0\;xor %2, %0\";
  if (REG_P (operands[2]) && REG_P (operands[1])
      && true_regnum (operands[0]) != true_regnum (operands[1])
      && true_regnum (operands[0]) != true_regnum (operands[2]))
    return \"xor %1, %2, %0\";
  if (REG_P (operands[2]) && REG_P (operands[0])
      && true_regnum (operands[2]) == true_regnum (operands[0]))
    return \"xor %1, %0\";
  if (REG_P (operands[1]) && REG_P (operands[0])
      && true_regnum (operands[1]) == true_regnum (operands[0]))
    return \"xor %2, %0\";
  abort ();
  }"
  [(set_attr "liw" "op1,*,op1,*,*")
   (set_attr "liw_op" "xor")
   (set_attr "timings" "22")
  ]
)

(define_insn "*mn10300_xorsi3"
  [(set (match_operand:SI         0 "register_operand" "=dx,!a")
	(xor:SI (match_operand:SI 1 "register_operand" "%0,0")
		(match_operand:SI 2 "nonmemory_operand" "dxi,i")))
   (clobber (reg:CC CC_REG))
  ]
  ""
  "@
  xor %2, %0
  add -4, sp; mov d0, (sp); mov %1, d0; xor %2, d0; mov d0, %0; mov (sp), d0; add 4, sp"
  ;; Timings: AM33  AM34
  ;; ADD       1/1   1/1
  ;; MOV       1/1   1/1
  ;; MOV       1/1   1/1
  ;; XOR       2/2   1/1
  ;; MOV       2/2   1/1
  ;; MOV       1/3   1/3
  ;; ADD       1/1   1/1
  ;; -------------------
  ;; total     9/10  7/8
  [(set_attr_alternative "timings"
			 [(const_int 11)
			  (if_then_else (eq_attr "cpu" "am34") (const_int 78) (const_int 910))
			 ])
  ]
)

;; ----------------------------------------------------------------------
;; NOT INSTRUCTIONS
;; ----------------------------------------------------------------------

(define_expand "one_cmplsi2"
  [(parallel [(set (match_operand:SI         0 "register_operand" "")
		   (not:SI (match_operand:SI 1 "register_operand" "")))
	      (clobber (reg:CC CC_REG))
	     ])
  ]
  ""
  ""
)

(define_insn "*am33_cmplsi2"
  [(set (match_operand:SI         0 "register_operand" "=dx,!dax")
	(not:SI (match_operand:SI 1 "register_operand" "0,0")))
   (clobber (reg:CC CC_REG))
  ]
  "TARGET_AM33"
  "not %0"
  ;; [(set_attr "timings" "11")]
)

(define_insn "*mn10300_cmplsi2"
  [(set (match_operand:SI         0 "register_operand" "=dx")
	(not:SI (match_operand:SI 1 "register_operand" "0")))
   (clobber (reg:CC CC_REG))
  ]
  ""
  "not %0"
  ;; [(set_attr "timings" "11")]
)

;; -----------------------------------------------------------------
;; BIT FIELDS
;; -----------------------------------------------------------------


;; These set/clear memory in byte sized chunks.
;;
;; They are no smaller/faster than loading the value into a register
;; and storing the register, but they don't need a scratch register
;; which may allow for better code generation.
(define_insn ""
  [(set (match_operand:QI 0 "nonimmediate_operand" "=R,d") (const_int 0))
   (clobber (reg:CC CC_REG))
  ]
  "GET_CODE (operands[0]) != MEM || ! MEM_VOLATILE_P (operands[0])"
  "@
  bclr 255, %A0
  clr %0"
  [(set_attr_alternative "timings"
			 [(if_then_else (eq_attr "cpu" "am34") (const_int 66) (const_int 77))
			  (const_int 11)
			 ])
  ]
)

(define_insn ""
  [(set (match_operand:QI 0 "nonimmediate_operand" "=R,d") (const_int -1))
   (clobber (reg:CC CC_REG))
  ]
  "GET_CODE (operands[0]) != MEM || ! MEM_VOLATILE_P (operands[0])"
  "@
  bset 255, %A0
  mov -1, %0"
  [(set_attr_alternative "timings"
			 [(if_then_else (eq_attr "cpu" "am34") (const_int 66) (const_int 77))
			  (const_int 11)
			 ])
  ]
)

(define_insn ""
  [(set (match_operand:QI 0 "nonimmediate_operand" "+R,d")
	(subreg:QI
	  (and:SI (subreg:SI (match_dup 0) 0)
		  (match_operand:SI 1 "const_int_operand" "i,i")) 0))
   (clobber (reg:CC CC_REG))
  ]
  ""
  "@
  bclr %N1, %A0
  and %1, %0"
  [(set_attr_alternative "timings"
			 [(if_then_else (eq_attr "cpu" "am34") (const_int 66) (const_int 77))
			  (const_int 11)
			 ])
  ]
)

(define_insn ""
  [(set (match_operand:QI 0 "memory_operand" "=R,T")
	(and:QI
	 (match_dup 0)
	 (not:QI (match_operand:QI 1 "nonmemory_operand" "i,d"))))
   (clobber (reg:CC CC_REG))
  ]
  ""
  "@
  bclr %U1, %A0
  bclr %1, %0"
  [(set_attr_alternative "timings"
			 [(if_then_else (eq_attr "cpu" "am34") (const_int 66) (const_int 77))
			  (const_int 66)
			 ])
  ]
)

(define_insn ""
  [(set (match_operand:QI 0 "nonimmediate_operand" "+R,d")
	(subreg:QI
	  (ior:SI (subreg:SI (match_dup 0) 0)
		  (match_operand:SI 1 "const_int_operand" "i,i")) 0))
   (clobber (reg:CC CC_REG))
  ]
  ""
  "@
  bset %U1, %A0
  or %1, %0"
  [(set_attr_alternative "timings"
			 [(if_then_else (eq_attr "cpu" "am34") (const_int 66) (const_int 77))
			  (const_int 11)
			 ])
  ]
)

(define_expand "iorqi3"
  [(parallel [(set (match_operand:QI         0 "nonimmediate_operand" "")
		   (ior:QI (match_operand:QI 1 "nonimmediate_operand" "")
			   (match_operand:QI 2 "nonmemory_operand" "")))
	      (clobber (reg:CC CC_REG))
	     ])
  ]
  ""
  ""
)

(define_insn "*am33_iorqi3"
  [(set (match_operand:QI         0 "nonimmediate_operand" "=R,T,r")
	(ior:QI (match_operand:QI 1 "nonimmediate_operand" "%0,0,0")
		;; This constraint should really be nonmemory_operand,
		;; but making it general_operand, along with the
		;; condition that not both input operands are MEMs, it
		;; here helps combine do a better job.
		(match_operand:QI 2 "general_operand" "i,d,ir")))
   (clobber (reg:CC CC_REG))
  ]
  "TARGET_AM33 &&
   (GET_CODE (operands[2]) != MEM || GET_CODE (operands[1]) != MEM)"
  "@
  bset %U2, %A0
  bset %2, %0
  or %2, %0"
  [(set_attr_alternative "timings"
			 [(if_then_else (eq_attr "cpu" "am34") (const_int 66) (const_int 77))
			  (const_int 66)
			  (const_int 11)
			 ])
  ]
)

(define_insn "*mn10300_iorqi3"
  [(set (match_operand:QI         0 "nonimmediate_operand" "=R,T,d")
	(ior:QI (match_operand:QI 1 "nonimmediate_operand" "%0,0,0")
		;; This constraint should really be nonmemory_operand,
		;; but making it general_operand, along with the
		;; condition that not both input operands are MEMs, it
		;; here helps combine do a better job.
		(match_operand:QI 2 "general_operand" "i,d,id")))
   (clobber (reg:CC CC_REG))
  ]
  "GET_CODE (operands[2]) != MEM || GET_CODE (operands[1]) != MEM"
  "@
  bset %U2, %A0
  bset %2, %0
  or %2, %0"
  [(set_attr_alternative "timings"
			 [(if_then_else (eq_attr "cpu" "am34") (const_int 66) (const_int 77))
			  (const_int 66)
			  (const_int 11)
			 ])
  ]
)

(define_insn "*test_int_bitfield"
  [(set (reg:CC CC_REG)
	(compare (zero_extract:SI (match_operand:SI 0 "register_operand" "dx")
				  (match_operand    1 "const_int_operand" "")
				  (match_operand    2 "const_int_operand" ""))
		 (const_int 0)))
  ]
  ""
  "*
  {
    int len = INTVAL (operands[1]);
    int bit = INTVAL (operands[2]);
    int mask = 0;
    rtx xoperands[2];

    while (len > 0)
      {
        mask |= (1 << bit);
        bit ++;
        len --;
      }

    xoperands[0] = operands[0];
    xoperands[1] = GEN_INT (trunc_int_for_mode (mask, SImode));
    output_asm_insn (\"btst %1, %0\", xoperands);
    return \"\";
  }"
  ;; [(set_attr "timings" "11")]
)

(define_insn "*test_byte_bitfield"
  [(set (reg:CC CC_REG)
	(compare (zero_extract:SI (match_operand:QI 0 "general_operand" "R,dx")
				  (match_operand    1 "const_int_operand" "")
				  (match_operand    2 "const_int_operand" ""))
		 (const_int 0)))
  ]
  "mask_ok_for_mem_btst (INTVAL (operands[1]), INTVAL (operands[2]))"
  "*
  {
    int len = INTVAL (operands[1]);
    int bit = INTVAL (operands[2]);
    int mask = 0;
    rtx xoperands[2];

    while (len > 0)
      {
        mask |= (1 << bit);
        bit ++;
        len --;
      }

    /* If the source operand is not a reg (i.e. it is memory), then extract the
       bits from mask that we actually want to test.  Note that the mask will
       never cross a byte boundary.  */
    if (!REG_P (operands[0]))
      {
        if (mask & 0xff)
	  mask = mask & 0xff;
        else if (mask & 0xff00)
	  mask = (mask >> 8) & 0xff;
        else if (mask & 0xff0000)
	  mask = (mask >> 16) & 0xff;
        else if (mask & 0xff000000)
	  mask = (mask >> 24) & 0xff;
      }

    xoperands[0] = operands[0];
    xoperands[1] = GEN_INT (trunc_int_for_mode (mask, SImode));
    if (GET_CODE (operands[0]) == REG)
      output_asm_insn (\"btst %1, %0\", xoperands);
    else
      output_asm_insn (\"btst %U1, %A0\", xoperands);
    return \"\";
  }"
  [(set_attr_alternative "timings"
			 [(if_then_else (eq_attr "cpu" "am34") (const_int 44) (const_int 55))
			  (if_then_else (eq_attr "cpu" "am34") (const_int 11) (const_int 22))
			 ])
  ]
)

(define_insn "*bit_test"
  [(set (reg:CC CC_REG)
	(compare (and:SI (match_operand:SI 0 "register_operand" "dx")
			 (match_operand:SI 1 "const_int_operand" ""))
		 (const_int 0)))
  ]
  ""
  "btst %1, %0"
  [(set (attr "timings") (if_then_else (eq_attr "cpu" "am34") (const_int 11) (const_int 22)))]
)

(define_insn "*subreg_bit_test"
  [(set (reg:CC CC_REG)
	(compare (and:SI (subreg:SI (match_operand:QI 0 "general_operand" "R,dx") 0)
			 (match_operand:SI            1 "const_8bit_operand" ""))
		 (const_int 0)))
  ]
  ""
  "@
  btst %U1, %A0
  btst %1, %0"
  [(set_attr_alternative "timings"
			 [(if_then_else (eq_attr "cpu" "am34") (const_int 44) (const_int 55))
			  (if_then_else (eq_attr "cpu" "am34") (const_int 11) (const_int 22))
			 ])
  ]
)

;; ----------------------------------------------------------------------
;; JUMP INSTRUCTIONS
;; ----------------------------------------------------------------------

;; Conditional jump instructions

(define_expand "ble"
  [(set (pc)
	(if_then_else (le (match_dup 1) (const_int 0))
		      (label_ref (match_operand 0 "" ""))
		      (pc)))]
  ""
  "operands[1] = mn10300_gen_compare_reg (LE, mn10300_compare_op0, mn10300_compare_op1);"
)

(define_expand "bleu"
  [(set (pc)
	(if_then_else (leu (match_dup 1) (const_int 0))
		      (label_ref (match_operand 0 "" ""))
		      (pc)))]
  ""
  "operands[1] = mn10300_gen_compare_reg (LEU, mn10300_compare_op0, mn10300_compare_op1);"
)

(define_expand "bge"
  [(set (pc)
	(if_then_else (ge (match_dup 1) (const_int 0))
		      (label_ref (match_operand 0 "" ""))
		      (pc)))]
  ""
  "operands[1] = mn10300_gen_compare_reg (GE, mn10300_compare_op0, mn10300_compare_op1);"
)

(define_expand "bgeu"
  [(set (pc)
	(if_then_else (geu (match_dup 1) (const_int 0))
		      (label_ref (match_operand 0 "" ""))
		      (pc)))]
  ""
  "operands[1] = mn10300_gen_compare_reg (GEU, mn10300_compare_op0, mn10300_compare_op1);"
)

(define_expand "blt"
  [(set (pc)
	(if_then_else (lt (match_dup 1) (const_int 0))
		      (label_ref (match_operand 0 "" ""))
		      (pc)))]
  ""
  "operands[1] = mn10300_gen_compare_reg (LT, mn10300_compare_op0, mn10300_compare_op1);"
)

(define_expand "bltu"
  [(set (pc)
	(if_then_else (ltu (match_dup 1) (const_int 0))
		      (label_ref (match_operand 0 "" ""))
		      (pc)))]
  ""
  "operands[1] = mn10300_gen_compare_reg (LTU, mn10300_compare_op0, mn10300_compare_op1);"
)

(define_expand "bgt"
  [(set (pc)
	(if_then_else (gt (match_dup 1) (const_int 0))
		      (label_ref (match_operand 0 "" ""))
		      (pc)))]
  ""
  "operands[1] = mn10300_gen_compare_reg (GT, mn10300_compare_op0, mn10300_compare_op1);"
)

(define_expand "bgtu"
  [(set (pc)
	(if_then_else (gtu (match_dup 1) (const_int 0))
		      (label_ref (match_operand 0 "" ""))
		      (pc)))]
  ""
  "operands[1] = mn10300_gen_compare_reg (GTU, mn10300_compare_op0, mn10300_compare_op1);"
)

(define_expand "beq"
  [(set (pc)
	(if_then_else (eq (match_dup 1) (const_int 0))
		      (label_ref (match_operand 0 "" ""))
		      (pc)))]
  ""
  "operands[1] = mn10300_gen_compare_reg (EQ, mn10300_compare_op0, mn10300_compare_op1);"
)

(define_expand "bne"
  [(set (pc)
	(if_then_else (ne (match_dup 1) (const_int 0))
		      (label_ref (match_operand 0 "" ""))
		      (pc)))]
  ""
  "operands[1] = mn10300_gen_compare_reg (NE, mn10300_compare_op0, mn10300_compare_op1);"
)

(define_insn "integer_conditional_branch"
  [(set (pc)
	(if_then_else (match_operator 1 "comparison_operator" [(reg:CC CC_REG) (const_int 0)])
		      (label_ref (match_operand 0 "" ""))
		      (pc)))]
  ""
  "b%b1 %0"
  [(set (attr "timings") (if_then_else (eq_attr "cpu" "am34") (const_int 11) (const_int 33)))]
)

(define_insn "reversed_integer_conditional_branch"
  [(set (pc)
	(if_then_else (match_operator 1 "comparison_operator" [(reg:CC CC_REG) (const_int 0)])
		      (pc)
		      (label_ref (match_operand 0 "" ""))))]
  ""
  "b%B1 %0"
  [(set (attr "timings") (if_then_else (eq_attr "cpu" "am34") (const_int 11) (const_int 33)))]
)

(define_insn "float_conditional_branch"
  [(set (pc)
	(if_then_else (match_operator 1 "comparison_operator" [(reg:CC_FLOAT CC_REG) (const_int 0)])
		      (label_ref (match_operand 0 "" ""))
		      (pc)))]
  "TARGET_AM33_2"
  "fb%b1 %0"
  [(set (attr "timings") (if_then_else (eq_attr "cpu" "am34") (const_int 44) (const_int 33)))]
)

(define_insn "reversed_float_conditional_branch"
  [(set (pc)
	(if_then_else (match_operator 1 "comparison_operator" [(reg:CC_FLOAT CC_REG) (const_int 0)])
		      (pc)
		      (label_ref (match_operand 0 "" ""))))]
  "TARGET_AM33_2"
  "fb%B1 %0"
  [(set (attr "timings") (if_then_else (eq_attr "cpu" "am34") (const_int 44) (const_int 33)))]
)

(define_insn "loop_integer_conditional_branch"
  [(set (pc)
	(if_then_else (match_operator 1 "comparison_operator" [(reg:CC CC_REG) (const_int 0)])
		      (label_ref (match_operand 0 "" ""))
		      (pc)))
   (unspec [(const_int 0)] UNSPEC_LCC)
  ]
  ""
  "l%b1 # %0"
  ;; [(set_attr "timings" "11")]
)

(define_insn "loop_reversed_integer_conditional_branch"
  [(set (pc)
	(if_then_else (match_operator 1 "comparison_operator" [(reg:CC CC_REG) (const_int 0)])
		      (pc)
		      (label_ref (match_operand 0 "" ""))))
   (unspec [(const_int 0)] UNSPEC_LCC)
  ]
  ""
  "l%B1 # %0"
  ;; [(set_attr "timings" "11")]
)

(define_insn "loop_float_conditional_branch"
  [(set (pc)
	(if_then_else (match_operator 1 "comparison_operator" [(reg:CC_FLOAT CC_REG) (const_int 0)])
		      (label_ref (match_operand 0 "" ""))
		      (pc)))
   (unspec [(const_int 0)] UNSPEC_LCC)
  ]
  ""
  "fl%b1 # %0"
  [(set (attr "timings") (if_then_else (eq_attr "cpu" "am34") (const_int 44) (const_int 11)))]
)

(define_insn "loop_reversed_float_conditional_branch"
  [(set (pc)
	(if_then_else (match_operator 1 "comparison_operator" [(reg:CC_FLOAT CC_REG) (const_int 0)])
		      (pc)
		      (label_ref (match_operand 0 "" ""))))
   (unspec [(const_int 0)] UNSPEC_LCC)
  ]
  ""
  "fl%B1 # %0"
  [(set (attr "timings") (if_then_else (eq_attr "cpu" "am34") (const_int 44) (const_int 11)))]
)

(define_insn "setlb"
  [(unspec [(const_int 0)] UNSPEC_SETLB)]
  ""
  "setlb"
  ;; [(set_attr "timings" "11")]
)

(define_expand "lcc"
  [(parallel [(match_operand 0 "" "")
	      (unspec [(const_int 0)] UNSPEC_LCC)
	     ])
  ]
  ""
  ""
)

;; Unconditional and other jump instructions.

(define_insn "jump"
  [(set (pc)
	(label_ref (match_operand 0 "" "")))]
  ""
  "jmp %l0"
  [(set (attr "timings") (if_then_else (eq_attr "cpu" "am34") (const_int 11) (const_int 44)))]
)

(define_insn "indirect_jump"
  [(set (pc) (match_operand:SI 0 "register_operand" "a"))]
  ""
  "jmp (%0)"
  [(set (attr "timings") (if_then_else (eq_attr "cpu" "am34") (const_int 11) (const_int 33)))]
)

(define_expand "builtin_setjmp_receiver"
  [(match_operand 0 "" "")]
  "flag_pic"
  "
  {
    if (flag_pic)
      emit_insn (gen_GOTaddr2picreg ());

    DONE;
  }"
)

(define_expand "casesi"
  [(match_operand:SI 0 "register_operand" "")
   (match_operand:SI 1 "immediate_operand" "")
   (match_operand:SI 2 "immediate_operand" "")
   (match_operand 3 "" "") (match_operand 4 "" "")]
  ""
  "
  {
  rtx table = gen_reg_rtx (SImode);
  rtx index = gen_reg_rtx (SImode);
  rtx addr = gen_reg_rtx (Pmode);

  emit_move_insn (table, gen_rtx_LABEL_REF (VOIDmode, operands[3]));
  emit_insn (gen_addsi3 (index, operands[0], GEN_INT (- INTVAL (operands[1]))));
  emit_insn (gen_cmpsi (index, operands[2]));
  emit_jump_insn (gen_bgtu (operands[4]));
  emit_insn (gen_ashlsi3 (index, index, GEN_INT (2)));
  emit_move_insn (addr, gen_rtx_MEM (SImode,
				     gen_rtx_PLUS (SImode, table, index)));
  if (flag_pic)
    emit_insn (gen_addsi3 (addr, addr, table));

  emit_jump_insn (gen_tablejump (addr, operands[3]));
  DONE;
  }"
)

(define_insn "tablejump"
  [(set (pc) (match_operand:SI 0 "register_operand" "a"))
   (use (label_ref (match_operand 1 "" "")))]
  ""
  "jmp (%0)"
  [(set (attr "timings") (if_then_else (eq_attr "cpu" "am34") (const_int 11) (const_int 33)))]
)

;; Call subroutine with no return value.

(define_expand "call"
  [(call (match_operand:QI 0 "general_operand" "")
	 (match_operand:SI 1 "general_operand" ""))]
  ""
  "
  {
  if (flag_pic && GET_CODE (XEXP (operands[0], 0)) == SYMBOL_REF)
    {
      if (MN10300_GLOBAL_P (XEXP (operands[0], 0)))
	{
	  /* The PLT code won't run on AM30, but then, there's no
	     shared library support for AM30 either, so we just assume
	     the linker is going to adjust all @PLT relocs to the
	     actual symbols.  */
	  emit_insn (gen_rtx_USE (VOIDmode, pic_offset_table_rtx));
	  XEXP (operands[0], 0) = gen_sym2PLT (XEXP (operands[0], 0));
	}
      else
	XEXP (operands[0], 0) = gen_sym2PIC (XEXP (operands[0], 0));
    }
  if (! call_address_operand (XEXP (operands[0], 0), VOIDmode))
    XEXP (operands[0], 0) = force_reg (SImode, XEXP (operands[0], 0));
  emit_call_insn (gen_call_internal (XEXP (operands[0], 0), operands[1]));
  DONE;
  }"
)

(define_insn "call_internal"
  [(call (mem:QI (match_operand:SI 0 "call_address_operand" "a,S"))
	 (match_operand:SI         1 "general_operand"      "g,g"))]
  ""
  "*
  {
    if (REG_P (operands[0]))
      return \"calls %C0\";
    else
      return \"call %C0,[],0\";
  }"
  [(set_attr_alternative "timings"
			 [(if_then_else (eq_attr "cpu" "am34") (const_int 33) (const_int 44))
			  (if_then_else (eq_attr "cpu" "am34") (const_int 55) (const_int 33))
			 ])
  ]
)

;; Call subroutine, returning value in operand 0
;; (which must be a hard register).

(define_expand "call_value"
  [(set (match_operand 0 "" "")
	(call (match_operand:QI 1 "general_operand" "")
	      (match_operand:SI 2 "general_operand" "")))]
  ""
  "
  {
  if (flag_pic && GET_CODE (XEXP (operands[1], 0)) == SYMBOL_REF)
    {
      if (MN10300_GLOBAL_P (XEXP (operands[1], 0)))
	{
	  /* The PLT code won't run on AM30, but then, there's no
	     shared library support for AM30 either, so we just assume
	     the linker is going to adjust all @PLT relocs to the
	     actual symbols.  */
	  emit_insn (gen_rtx_USE (VOIDmode, pic_offset_table_rtx));
	  XEXP (operands[1], 0) = gen_sym2PLT (XEXP (operands[1], 0));
	}
      else
	XEXP (operands[1], 0) = gen_sym2PIC (XEXP (operands[1], 0));
    }
  if (! call_address_operand (XEXP (operands[1], 0), VOIDmode))
    XEXP (operands[1], 0) = force_reg (SImode, XEXP (operands[1], 0));
  emit_call_insn (gen_call_value_internal (operands[0],
					   XEXP (operands[1], 0),
					   operands[2]));
  DONE;
  }"
)

(define_insn "call_value_internal"
  [(set (match_operand                  0 "register_operand"     "=dax,dax")
	(call (mem:QI (match_operand:SI 1 "call_address_operand" "a,S"))
	      (match_operand:SI         2 "general_operand"      "g,g")))]
  ""
  "*
  {
    if (REG_P (operands[1]))
      return \"calls %C1\";
    else
      return \"call %C1,[],0\";
  }"
  [(set_attr_alternative "timings"
			 [(if_then_else (eq_attr "cpu" "am34") (const_int 33) (const_int 44))
			  (if_then_else (eq_attr "cpu" "am34") (const_int 55) (const_int 33))
			 ])
  ]
)

(define_expand "untyped_call"
  [(parallel [(call (match_operand 0 "" "")
                    (const_int 0))
              (match_operand 1 "" "")
              (match_operand 2 "" "")])]
  ""
  "
  {
    int i;

    emit_call_insn (gen_call (operands[0], const0_rtx));

    for (i = 0; i < XVECLEN (operands[2], 0); i++)
      {
        rtx set = XVECEXP (operands[2], 0, i);
        emit_move_insn (SET_DEST (set), SET_SRC (set));
      }
    DONE;
  }"
)

(define_insn "nop"
  [(const_int 0)]
  ""
  "nop"
  ;; [(set_attr "timings" "11")]
)

;; ----------------------------------------------------------------------
;; EXTEND INSTRUCTIONS
;; ----------------------------------------------------------------------

(define_expand "zero_extendqisi2"
  [(set (match_operand:SI 0 "general_operand" "")
	(zero_extend:SI
	 (match_operand:QI 1 "general_operand" "")))]
  ""
  ""
)

(define_insn ""
  [(set (match_operand:SI 0 "nonimmediate_operand" "=dx,dx,dx,!dax,!dax,!dax")
	(zero_extend:SI
	 (match_operand:QI 1 "general_operand" "0,dax,m,0,dax,m")))]
  "TARGET_AM33"
  "@
  extbu %0
  mov %1, %0\;extbu %0
  movbu %1, %0
  extbu %0
  mov %1, %0\;extbu %0
  movbu %1, %0"
  [(set_attr_alternative "timings"
			 [(const_int 11)
			  (const_int 22)
			  (if_then_else (eq_attr "cpu" "am34") (const_int 13) (const_int 24))
			  (const_int 11)
			  (const_int 22)
			  (if_then_else (eq_attr "cpu" "am34") (const_int 13) (const_int 24))
			 ])
  ]
)

(define_insn ""
  [(set (match_operand:SI 0 "nonimmediate_operand" "=dx,dx,dx")
	(zero_extend:SI
	 (match_operand:QI 1 "general_operand" "0,d,m")))]
  ""
  "@
  extbu %0
  mov %1, %0\;extbu %0
  movbu %1, %0"
  [(set_attr_alternative "timings"
			 [(const_int 11)
			  (const_int 22)
			  (if_then_else (eq_attr "cpu" "am34") (const_int 13) (const_int 24))
			 ])
  ]
)

(define_expand "zero_extendhisi2"
  [(set (match_operand:SI 0 "general_operand" "")
	(zero_extend:SI
	 (match_operand:HI 1 "general_operand" "")))]
  ""
  ""
)

(define_insn ""
  [(set (match_operand:SI 0 "nonimmediate_operand" "=dx,dx,dx,!dax,!dax,!dax")
	(zero_extend:SI
	 (match_operand:HI 1 "general_operand" "0,dax,m,0,dax,m")))]
  "TARGET_AM33"
  "@
  exthu %0
  mov %1, %0\;exthu %0
  movhu %1, %0
  exthu %0
  mov %1, %0\;exthu %0
  movhu %1, %0"
  [(set_attr_alternative "timings"
			 [(const_int 11)
			  (const_int 22)
			  (if_then_else (eq_attr "cpu" "am34") (const_int 13) (const_int 24))
			  (const_int 11)
			  (const_int 22)
			  (if_then_else (eq_attr "cpu" "am34") (const_int 13) (const_int 24))
			 ])
  ]
)

(define_insn ""
  [(set (match_operand:SI 0 "nonimmediate_operand" "=dx,dx,dx")
	(zero_extend:SI
	 (match_operand:HI 1 "general_operand" "0,dx,m")))]
  ""
  "@
  exthu %0
  mov   %1, %0\; exthu %0
  movhu %1, %0"
  [(set_attr_alternative "timings"
			 [(const_int 11)
			  (const_int 22)
			  (if_then_else (eq_attr "cpu" "am34") (const_int 13) (const_int 24))
			 ])
  ]
)

;;- sign extension instructions

(define_expand "extendqisi2"
  [(set (match_operand:SI 0 "general_operand" "")
	(sign_extend:SI
	 (match_operand:QI 1 "general_operand" "")))]
  ""
  ""
)

(define_insn ""
  [(set (match_operand:SI 0 "nonimmediate_operand" "=dx,dx,!dax,!dax")
	(sign_extend:SI
	 (match_operand:QI 1 "general_operand" "0,dx,0,dax")))]
  "TARGET_AM33"
  "@
  extb %0
  mov %1, %0\;extb %0
  extb %0
  mov %1, %0\;extb %0"
  [(set_attr "timings" "11,22,11,22")]
)

(define_insn ""
  [(set (match_operand:SI 0 "nonimmediate_operand" "=dx,dx")
	(sign_extend:SI
	 (match_operand:QI 1 "general_operand" "0,dx")))]
  ""
  "@
  extb %0
  mov %1, %0\;extb %0"
  [(set_attr "timings" "11,22")]
)

(define_expand "extendhisi2"
  [(set (match_operand:SI 0 "general_operand" "")
	(sign_extend:SI
	 (match_operand:HI 1 "general_operand" "")))]
  ""
  ""
)

(define_insn ""
  [(set (match_operand:SI 0 "nonimmediate_operand" "=dx,dx,!dax,!dax")
	(sign_extend:SI
	 (match_operand:HI 1 "general_operand" "0,dax,0,dax")))]
  "TARGET_AM33"
  "@
  exth %0
  mov %1, %0\;exth %0
  exth %0
  mov %1, %0\;exth %0"
  [(set_attr "timings" "11,22,11,22")]
)

(define_insn ""
  [(set (match_operand:SI 0 "nonimmediate_operand" "=dx,dx")
	(sign_extend:SI
	 (match_operand:HI 1 "general_operand" "0,dx")))]
  ""
  "@
  exth %0
  mov %1, %0\;exth %0"
  [(set_attr "timings" "11,22")]
)

;; ----------------------------------------------------------------------
;; SHIFTS
;; ----------------------------------------------------------------------

(define_expand "ashlsi3"
  [(parallel [(set (match_operand:SI 0 "register_operand" "")
		   (ashift:SI
		    (match_operand:SI 1 "register_operand" "")
		    (match_operand:QI 2 "nonmemory_operand" "")))
	      (clobber (reg:CC CC_REG))
	     ])
  ]
  ""
  ""
)

(define_insn "*am33_ashlsi3"
  [(set (match_operand:SI 0 "register_operand" "=dax,dx,dx,!dax,!dax")
	(ashift:SI
	 (match_operand:SI 1 "register_operand" "0,0,0,0,dax")
	 (match_operand:QI 2 "nonmemory_operand" "J,dxO,i,dax,dax")))
   (clobber (reg:CC CC_REG))
  ]
  "TARGET_AM33"
  "*
  {
  if (GET_CODE (operands[2]) == CONST_INT && INTVAL (operands[2]) == 1)
    return \"add %0, %0\";

  if (GET_CODE (operands[2]) == CONST_INT && INTVAL (operands[2]) == 2)
    return \"asl2 %0\";

  if (GET_CODE (operands[2]) == CONST_INT && INTVAL (operands[2]) == 3
      && REGNO_REG_CLASS (true_regnum (operands[0])) == DATA_REGS)
    return \"asl2 %0\;add %0, %0\";

  if (GET_CODE (operands[2]) == CONST_INT && INTVAL (operands[2]) == 4
      && REGNO_REG_CLASS (true_regnum (operands[0])) == DATA_REGS)
    return \"asl2 %0\;asl2 %0\";

  if (true_regnum (operands[1]) == true_regnum (operands[0]))
    return \"asl %S2, %0\";

  if (REGNO_REG_CLASS (true_regnum (operands[0])) == DATA_REGS
      && REGNO_REG_CLASS (true_regnum (operands[1])) == DATA_REGS
      && true_regnum (operands[0]) != true_regnum (operands[2]))
    return \"mov %1, %0\;asl %S2, %0\";
  return \"asl %2, %1, %0\";
  }"
  [(set_attr "liw" "*,op2,*,op2,*")
   (set_attr "liw_op" "asl")
   (set_attr "timings" "22")
  ]
)

(define_insn "*mn10300_ashlsi3"
  [(set (match_operand:SI 0 "register_operand" "=dax,dx,dx,dx,dx")
	(ashift:SI
	 (match_operand:SI 1 "register_operand" "0,0,0,0,0")
	 (match_operand:QI 2 "nonmemory_operand" "J,K,M,L,dxi")))
   (clobber (reg:CC CC_REG))
  ]
  ""
  "@
  add %0, %0
  asl2 %0
  asl2 %0\;add %0, %0
  asl2 %0\;asl2 %0
  asl %S2, %0"
  [(set_attr "timings" "11,11,22,22,11")]
)

(define_expand "lshrsi3"
  [(parallel [(set (match_operand:SI 0 "register_operand" "")
		   (lshiftrt:SI
		    (match_operand:SI 1 "register_operand" "")
		    (match_operand:QI 2 "nonmemory_operand" "")))
	      (clobber (reg:CC CC_REG))
	     ])
  ]
  ""
  ""
)

(define_insn "*am33_lshrsi3"
  [(set (match_operand:SI 0 "register_operand" "=dx,dx,!dax,!dax")
	(lshiftrt:SI
	 (match_operand:SI 1 "register_operand" "0,0,0,dax")
	 (match_operand:QI 2 "nonmemory_operand" "dxO,i,dax,dax")))
   (clobber (reg:CC CC_REG))
  ]
  "TARGET_AM33"
  "*
  {
  if (true_regnum (operands[1]) == true_regnum (operands[0]))
    return \"lsr %S2, %0\";

  if (REGNO_REG_CLASS (true_regnum (operands[0])) == DATA_REGS
      && REGNO_REG_CLASS (true_regnum (operands[1])) == DATA_REGS
      && true_regnum (operands[0]) != true_regnum (operands[2]))
    return \"mov %1, %0\;lsr %S2, %0\";
  return \"lsr %2, %1, %0\";
  }"
  [(set_attr "liw" "op2,*,op2,*")
   (set_attr "liw_op" "lsr")
   (set_attr "timings" "22")
  ]
)

(define_insn "*mn10300_lshrsi3"
  [(set (match_operand:SI 0 "register_operand" "=dx")
	(lshiftrt:SI
	 (match_operand:SI 1 "register_operand" "0")
	 (match_operand:QI 2 "nonmemory_operand" "dxi")))
   (clobber (reg:CC CC_REG))
  ]
  ""
  "lsr %S2, %0"
  [(set (attr "timings") (if_then_else (eq_attr "cpu" "am34") (const_int 11) (const_int 22)))]
)

(define_expand "ashrsi3"
  [(parallel [(set (match_operand:SI 0 "register_operand" "")
		   (ashiftrt:SI
		    (match_operand:SI 1 "register_operand" "")
		    (match_operand:QI 2 "nonmemory_operand" "")))
	      (clobber (reg:CC CC_REG))
	     ])
  ]
  ""
  ""
)

(define_insn "*am33_ashrisi3"
  [(set (match_operand:SI 0 "register_operand" "=dx,dx,!dax,!dax")
	(ashiftrt:SI
	 (match_operand:SI 1 "register_operand" "0,0,0,dax")
	 (match_operand:QI 2 "nonmemory_operand" "dxO,i,dax,dax")))
   (clobber (reg:CC CC_REG))
  ]
  "TARGET_AM33"
  "*
  {
    if (true_regnum (operands[1]) == true_regnum (operands[0]))
      return \"asr %S2, %0\";

    if (REGNO_REG_CLASS (true_regnum (operands[0])) == DATA_REGS
        && REGNO_REG_CLASS (true_regnum (operands[1])) == DATA_REGS
        && true_regnum (operands[0]) != true_regnum (operands[2]))
      return \"mov %1, %0\;asr %S2, %0\";
    return \"asr %2, %1, %0\";
  }"
  [(set_attr "liw" "op2,*,op2,*")
   (set_attr "liw_op" "asr")
   (set_attr "timings" "22")
  ]
)

(define_insn "*mn10300_ashrsi3"
  [(set (match_operand:SI 0 "register_operand" "=dx")
	(ashiftrt:SI
	 (match_operand:SI 1 "register_operand" "0")
	 (match_operand:QI 2 "nonmemory_operand" "dxi")))
   (clobber (reg:CC CC_REG))
  ]
  ""
  "asr %S2, %0"
  [(set (attr "timings") (if_then_else (eq_attr "cpu" "am34") (const_int 11) (const_int 22)))]
)

;; ----------------------------------------------------------------------
;; FP INSTRUCTIONS
;; ----------------------------------------------------------------------
;;
;; The mn103 series does not have floating point instructions, but since
;; FP values are held in integer regs, we can clear the high bit easily
;; which gives us an efficient inline floating point absolute value.
;;
;; Similarly for negation of a FP value.
;;

(define_expand "absdf2"
  [(set (match_operand:DF         0 "register_operand" "")
        (abs:DF (match_operand:DF 1 "register_operand" "")))]
  ""
  "
  {
  rtx target, result, insns;

  start_sequence ();
  target = operand_subword (operands[0], 1, 1, DFmode);
  result = expand_binop (SImode, and_optab,
			 operand_subword_force (operands[1], 1, DFmode),
			 GEN_INT (0x7fffffff), target, 0, OPTAB_WIDEN);

  if (result == 0)
    abort ();

  if (result != target)
    emit_move_insn (result, target);

  emit_move_insn (operand_subword (operands[0], 0, 1, DFmode),
		  operand_subword_force (operands[1], 0, DFmode));

  insns = get_insns ();
  end_sequence ();

  emit_no_conflict_block (insns, operands[0], operands[1], 0, 0);
  DONE;
  }"
)

(define_expand "abssf2"
  [(set (match_operand:SF 0 "register_operand" "")
        (abs:SF (match_operand:SF 1 "register_operand" "")))]
  ""
  "
  {
  rtx result;
  rtx target;

  if (TARGET_AM33_2)
    {
      emit_insn (gen_abssf2_am33_2 (operands[0], operands[1]));
      DONE;
    }

  target = operand_subword_force (operands[0], 0, SFmode);
  result = expand_binop (SImode, and_optab,
			 operand_subword_force (operands[1], 0, SFmode),
			 GEN_INT (0x7fffffff), target, 0, OPTAB_WIDEN);
  if (result == 0)
    abort ();

  if (result != target)
    emit_move_insn (result, target);

  /* Make a place for REG_EQUAL.  */
  emit_move_insn (operands[0], operands[0]);
  DONE;
  }"
)

(define_insn "abssf2_am33_2"
  [(set (match_operand:SF         0 "register_operand" "=f,f")
	(abs:SF (match_operand:SF 1 "register_operand" "0,?f")))]
  "TARGET_AM33_2"
  "@
   fabs %0
   fabs %1, %0"
  [(set (attr "timings") (if_then_else (eq_attr "cpu" "am34") (const_int 17) (const_int 14)))]
)

(define_expand "negdf2"
  [(set (match_operand:DF         0 "register_operand" "")
        (neg:DF (match_operand:DF 1 "register_operand" "")))]
  ""
  "
  {
  rtx target, result, insns;

  start_sequence ();
  target = operand_subword (operands[0], 1, 1, DFmode);
  result = expand_binop (SImode, xor_optab,
			 operand_subword_force (operands[1], 1, DFmode),
			 GEN_INT (trunc_int_for_mode (0x80000000, SImode)),
			 target, 0, OPTAB_WIDEN);

  if (result == 0)
    abort ();

  if (result != target)
    emit_move_insn (result, target);

  emit_move_insn (operand_subword (operands[0], 0, 1, DFmode),
		  operand_subword_force (operands[1], 0, DFmode));

  insns = get_insns ();
  end_sequence ();

  emit_no_conflict_block (insns, operands[0], operands[1], 0, 0);
  DONE;
  }"
)

(define_expand "negsf2"
  [(set (match_operand:SF         0 "register_operand" "")
        (neg:SF (match_operand:SF 1 "register_operand" "")))]
  ""
  "
  {
  rtx result;
  rtx target;

  if (TARGET_AM33_2)
    {
      emit_insn (gen_negsf2_am33_2 (operands[0], operands[1]));
      DONE;
    }

  target = operand_subword_force (operands[0], 0, SFmode);
  result = expand_binop (SImode, xor_optab,
			 operand_subword_force (operands[1], 0, SFmode),
			 GEN_INT (trunc_int_for_mode (0x80000000, SImode)),
			 target, 0, OPTAB_WIDEN);
  if (result == 0)
    abort ();

  if (result != target)
    emit_move_insn (result, target);

  /* Make a place for REG_EQUAL.  */
  emit_move_insn (operands[0], operands[0]);
  DONE;
  }"
)

(define_insn "negsf2_am33_2"
  [(set (match_operand:SF         0 "register_operand" "=f,f")
	(neg:SF (match_operand:SF 1 "register_operand" "0,?f")))]
  "TARGET_AM33_2"
  "@
   fneg %0
   fneg %1, %0"
  [(set (attr "timings") (if_then_else (eq_attr "cpu" "am34") (const_int 17) (const_int 14)))]
)

(define_expand "sqrtsf2"
  [(parallel [(set (match_operand:SF          0 "register_operand" "")
		   (sqrt:SF (match_operand:SF 1 "register_operand" "")))
	      (clobber (reg:CC_FLOAT CC_REG))
	     ])
  ]
  "TARGET_AM33_2 && flag_unsafe_math_optimizations"
  "
  {
    rtx scratch = gen_reg_rtx (SFmode);

    emit_insn (gen_rsqrtsf2 (scratch, operands[1], CONST1_RTX (SFmode)));
    emit_insn (gen_divsf3 (operands[0], force_reg (SFmode, CONST1_RTX (SFmode)),
 			   scratch));
    DONE;
  }"
)

(define_insn "rsqrtsf2"
  [(set (match_operand:SF                  0 "register_operand" "=f,f")
	(div:SF (match_operand:SF          2 "const_1f_operand" "F,F")
		(sqrt:SF (match_operand:SF 1 "register_operand" "0,?f"))))
   (clobber (reg:CC_FLOAT CC_REG))
  ]
  "TARGET_AM33_2"
  "@
   frsqrt %0
   frsqrt %1, %0"
  [(set (attr "timings") (if_then_else (eq_attr "cpu" "am34") (const_int 4753) (const_int 2327)))]
)

(define_insn "addsf3"
  [(set (match_operand:SF          0 "register_operand" "=f,f")
	(plus:SF (match_operand:SF 1 "register_operand" "%0,f")
		 (match_operand:SF 2 "general_operand"  "f,?fF")))
   (clobber (reg:CC_FLOAT CC_REG))
  ]
  "TARGET_AM33_2"
  "@
   fadd %2, %0
   fadd %2, %1, %0"
  [(set_attr_alternative "timings"
			 [(if_then_else (eq_attr "cpu" "am34") (const_int 17) (const_int 14))
			  (if_then_else (eq_attr "cpu" "am34") (const_int 17) (const_int 25))
			 ])
  ]
)

(define_insn "subsf3"
  [(set (match_operand:SF           0 "register_operand" "=f,f")
	(minus:SF (match_operand:SF 1 "register_operand" "0,f")
		  (match_operand:SF 2 "general_operand"  "f,?fF")))
   (clobber (reg:CC_FLOAT CC_REG))
  ]
  "TARGET_AM33_2"
  "@
   fsub %2, %0
   fsub %2, %1, %0"
  [(set_attr_alternative "timings"
			 [(if_then_else (eq_attr "cpu" "am34") (const_int 17) (const_int 14))
			  (if_then_else (eq_attr "cpu" "am34") (const_int 17) (const_int 25))
			 ])
  ]
)

(define_insn "mulsf3"
  [(set (match_operand:SF          0 "register_operand" "=f,f")
	(mult:SF (match_operand:SF 1 "register_operand" "%0,f")
		 (match_operand:SF 2 "general_operand"  "f,?fF")))
   (clobber (reg:CC_FLOAT CC_REG))
  ]
  "TARGET_AM33_2"
  "@
   fmul %2, %0
   fmul %2, %1, %0"
  [(set_attr_alternative "timings"
			 [(if_then_else (eq_attr "cpu" "am34") (const_int 17) (const_int 14))
			  (if_then_else (eq_attr "cpu" "am34") (const_int 17) (const_int 25))
			 ])
  ]
)

(define_insn "divsf3"
  [(set (match_operand:SF         0 "register_operand" "=f,f")
	(div:SF (match_operand:SF 1 "register_operand" "0,f")
		(match_operand:SF 2 "general_operand"  "f,?fF")))
   (clobber (reg:CC_FLOAT CC_REG))
  ]
  "TARGET_AM33_2"
  "@
   fdiv %2, %0
   fdiv %2, %1, %0"
  [(set_attr_alternative "timings"
			 [(if_then_else (eq_attr "cpu" "am34") (const_int 2531) (const_int 1216))
			  (if_then_else (eq_attr "cpu" "am34") (const_int 2531) (const_int 1317))
			 ])
  ]
)

(define_insn "fmaddsf4"
  [(set (match_operand:SF                   0 "register_operand" "=A")
	(plus:SF (mult:SF (match_operand:SF 1 "register_operand" "%f")
			  (match_operand:SF 2 "register_operand" "f"))
		 (match_operand:SF          3 "register_operand" "f")))
   (clobber (reg:CC_FLOAT CC_REG))
  ]
  "TARGET_AM33_2"
  "fmadd %1, %2, %3, %0"
  [(set (attr "timings") (if_then_else (eq_attr "cpu" "am34") (const_int 17) (const_int 24)))]
)

(define_insn "fmsubsf4"
  [(set (match_operand:SF                    0 "register_operand" "=A")
	(minus:SF (mult:SF (match_operand:SF 1 "register_operand" "%f")
			   (match_operand:SF 2 "register_operand" "f"))
		  (match_operand:SF          3 "register_operand" "f")))
   (clobber (reg:CC_FLOAT CC_REG))
  ]
  "TARGET_AM33_2"
  "fmsub %1, %2, %3, %0"
  [(set (attr "timings") (if_then_else (eq_attr "cpu" "am34") (const_int 17) (const_int 24)))]
)

(define_insn "fnmaddsf4"
  [(set (match_operand:SF                    0 "register_operand" "=A")
	(minus:SF (match_operand:SF          3 "register_operand" "f")
		  (mult:SF (match_operand:SF 1 "register_operand" "%f")
			   (match_operand:SF 2 "register_operand" "f"))))
   (clobber (reg:CC_FLOAT CC_REG))
  ]
  "TARGET_AM33_2"
  "fnmadd %1, %2, %3, %0"
  [(set (attr "timings") (if_then_else (eq_attr "cpu" "am34") (const_int 17) (const_int 24)))]
)

(define_insn "fnmsubsf4"
  [(set (match_operand:SF                            0 "register_operand" "=A")
	(minus:SF (neg:SF (mult:SF (match_operand:SF 1 "register_operand" "%f")
				   (match_operand:SF 2 "register_operand" "f")))
		  (match_operand:SF                  3 "register_operand" "f")))
   (clobber (reg:CC_FLOAT CC_REG))
  ]
  "TARGET_AM33_2"
  "fnmsub %1, %2, %3, %0"
  [(set (attr "timings") (if_then_else (eq_attr "cpu" "am34") (const_int 17) (const_int 24)))]
)

;; ----------------------------------------------------------------------
;; PROLOGUE/EPILOGUE
;; ----------------------------------------------------------------------

(define_expand "prologue"
  [(const_int 0)]
  ""
  "expand_prologue (); DONE;"
)

(define_expand "epilogue"
  [(return)]
  ""
  "expand_epilogue (); DONE;"
)

(define_insn "return_internal"
  [(const_int 2)
   (return)]
  ""
  "rets"
  [(set_attr "timings" "66")]
)

;; This insn restores the callee saved registers and does a return, it
;; can also deallocate stack space.
(define_insn "return_internal_regs"
  [(const_int 0)
   (match_operand:SI 0  "const_int_operand" "i")
   (return)]
  ""
  "*
  {
    fputs (\"\\tret \", asm_out_file);
    mn10300_print_reg_list (asm_out_file, mn10300_get_live_callee_saved_regs ());
    fprintf (asm_out_file, \", %d\\n\", (int) INTVAL (operands[0]));
    return \"\";
  }"
  ;; Assumes that there will be no more than 8 regs to pop
  [(set (attr "timings") (if_then_else (eq_attr "cpu" "am34") (const_int 1414) (const_int 1313)))]
)

;; This instruction matches one generated by mn10300_gen_multiple_store()
(define_insn "store_movm"
  [(match_parallel 0 "store_multiple_operation"
    [(set (reg:SI SP_REG) (plus:SI (reg:SI SP_REG) (match_operand 1 "" "")))])]
  ""
  "*
  {
    fputs (\"\\tmovm \", asm_out_file);
    mn10300_print_reg_list (asm_out_file,
                            store_multiple_operation (operands[0], VOIDmode));
    fprintf (asm_out_file, \",(sp)\\n\");
    return \"\";
  }"
  ;; Assume that no more than 8 registers will be pushed.
  [(set (attr "timings") (if_then_else (eq_attr "cpu" "am34") (const_int 99) (const_int 88)))]
)

(define_insn "return"
  [(return)]
  "can_use_return_insn ()"
  "*
  {
    rtx next = next_active_insn (insn);

    if (next
        && GET_CODE (next) == JUMP_INSN
        && GET_CODE (PATTERN (next)) == RETURN)
      return \"\";
    else
      return \"rets\";
  }"
  [(set_attr "timings" "66")]
)

(define_insn "epilogue_copy_a0d0"
  [(unspec_volatile [(const_int 0)] UNSPEC_A0D0)]
  ""
  "mov a0, d0 # -mreturn-pointer-on-d0"
  ;; [(set_attr "timings" "11")]
)

;; Try to combine consecutive updates of the stack pointer
;; (or any other register for that matter).
(define_peephole
  [(parallel [(set (match_operand:SI 0 "register_operand" "=dxay")
		   (plus:SI (match_dup 0)
			    (match_operand 1 "const_int_operand" "")))
	      (clobber (reg:CC CC_REG))
	     ])
   (parallel [(set (match_dup 0)
		   (plus:SI (match_dup 0)
			    (match_operand 2 "const_int_operand" "")))
	      (clobber (reg:CC CC_REG))
	     ])
  ]
  ""
  "*
  {
    operands[1] = GEN_INT (INTVAL (operands[2]) + INTVAL (operands[1]));
    return \"add %1, %0\";
  }"
  ;; [(set_attr "timings" "11")]
)

(define_expand "int_label"
  [(unspec [(match_operand:SI 0 "" "")] UNSPEC_INT_LABEL)]
  ""
  ""
)

(define_expand "GOTaddr2picreg"
  [(match_dup 0)]
  "" "
  {
    /* It would be nice to be able to have int_label keep track of the
       counter and all, but if we add C code to it, we'll get an insn
       back, and we just want the pattern.  */
    operands[0] = gen_int_label (GEN_INT (mn10300_unspec_int_label_counter++));
    if (TARGET_AM33)
      emit_insn (gen_am33_loadPC (operands[0]));
    else
      emit_insn (gen_mn10300_loadPC (operands[0]));
    emit_insn (gen_add_GOT_to_pic_reg (operands[0]));
    DONE;
  }"
)

(define_insn "am33_loadPC"
  [(parallel
    [(set (reg:SI PIC_REG) (pc))
     (use (match_operand 0 "" ""))])]
  "TARGET_AM33"
  "%0:\;mov pc, a2"
  ;; [(set_attr "timings" "11")]
)

(define_insn "am33_loadPC_anyreg"
  [(parallel
    [(set (match_operand 0 "register_operand" "=a") (pc))
     (use (match_operand 1 "" ""))])]
  "TARGET_AM33"
  "%1:\;mov pc, %0"
  ;; [(set_attr "timings" "11")]
)

(define_insn_and_split "mn10300_loadPC"
  [(parallel
    [(set (reg:SI PIC_REG) (pc))
     (use (match_operand 0 "" ""))])]
  "! TARGET_AM33"
  "#"
  "reload_completed"
  [(match_operand 0 "" "")]
  "
  {
    if (TARGET_AM33)
      emit_insn (gen_am33_loadPC (operands[0]));
    else 
      {
        rtx sp_reg = gen_rtx_REG (SImode, SP_REG);
        int need_stack_space = (get_frame_size () == 0
			        && current_function_outgoing_args_size == 0);

        if (need_stack_space)
          emit_insn (gen_addsi3 (sp_reg, sp_reg, GEN_INT (-4)));

        emit_insn (gen_call_next_insn (operands[0]));

        if (need_stack_space)
          emit_insn (gen_pop_pic_reg ());
        else
          emit_move_insn (pic_offset_table_rtx, gen_rtx_MEM (SImode, sp_reg));
      }
    DONE;
  }"
)

;; Used for non-pic code; will store in any register.
(define_expand "am33_set_got"
  [(match_operand:SI 0 "" "")
   (match_dup 1)
  ]
  "TARGET_AM33"
  "
  {
    rtx tmp = gen_reg_rtx (SImode);

    operands[1] = gen_int_label (GEN_INT (mn10300_unspec_int_label_counter++));
    emit_insn (gen_am33_loadPC_anyreg (tmp, operands[1]));
    emit_insn (gen_add_GOT_to_any_reg (operands[0], tmp, operands[1]));
    DONE;
  }"
)

(define_insn "call_next_insn"
  [(parallel
    [(set (mem:SI (reg:SI SP_REG)) (pc))
     (use (match_operand 0 "" ""))
    ])
  ]
  "!TARGET_AM33 && reload_completed"
  "calls %0\; %0:"
  [(set_attr "timings" "44")]
)

(define_expand "add_GOT_to_pic_reg"
  [(parallel [(set (reg:SI PIC_REG)
		   (plus:SI
		    (reg:SI PIC_REG)
		    (const
		     (unspec [(minus:SI
			       (match_dup 1)
			       (const (minus:SI
				       (const (match_operand:SI 0 "" ""))
				       (pc))))
			      ] UNSPEC_PIC))))
	      (clobber (reg:CC CC_REG))
	      ])
  ]
  ""
  "operands[1] = gen_rtx_SYMBOL_REF (VOIDmode, GOT_SYMBOL_NAME);"
)

(define_expand "add_GOT_to_any_reg"
  [(parallel [(set (match_operand:SI 0 "" "=r")
		   (plus:SI
		    (match_operand:SI 1 "" "0")
		    (const
		     (unspec [(minus:SI
			       (match_dup 3)
			       (const (minus:SI
				       (const (match_operand:SI 2 "" ""))
				       (pc))))
			      ] UNSPEC_PIC))))
	      (clobber (reg:CC CC_REG))
	     ])
  ]
  ""
  "operands[3] = gen_rtx_SYMBOL_REF (VOIDmode, GOT_SYMBOL_NAME);"
)

(define_expand "symGOT2reg"
  [(match_operand:SI 0 "" "")
   (match_operand:SI 1 "" "")
  ]
  ""
  "
  {
    rtx insn = emit_insn (gen_symGOT2reg_i (operands[0], operands[1]));

    RTX_UNCHANGING_P (SET_SRC (PATTERN (insn))) = 1;

    REG_NOTES (insn) = gen_rtx_EXPR_LIST (REG_EQUAL, operands[1],
					  REG_NOTES (insn));
    DONE;
  }"
)

(define_expand "symGOT2reg_i"
  [(set (match_operand:SI 0 "" "")
	(mem:SI (plus:SI (reg:SI PIC_REG)
			 (const (unspec [(match_operand:SI 1 "" "")]
					UNSPEC_GOT)))))
  ]
  ""
  ""
)

(define_expand "symGOTOFF2reg"
  [(match_operand:SI 0 "" "") (match_operand:SI 1 "" "")]
  ""
  "
  {
    rtx insn = emit_insn (gen_symGOTOFF2reg_i (operands[0], operands[1]));

    REG_NOTES (insn) = gen_rtx_EXPR_LIST (REG_EQUAL, operands[1],
					  REG_NOTES (insn));
    DONE;
  }"
)

(define_expand "symGOTOFF2reg_i"
  [(set (match_operand:SI 0 "" "")
	(const (unspec [(match_operand:SI 1 "" "")] UNSPEC_GOTOFF)))
   (parallel [(set (match_dup 0)
		   (plus:SI (match_dup 0)
			    (reg:SI PIC_REG)))
	      (clobber (reg:CC CC_REG))
	     ])
  ]
  ""
  ""
)

(define_expand "sym2PIC"
  [(unspec [(match_operand:SI 0 "" "")] UNSPEC_PIC)]
  ""
  ""
)

(define_expand "sym2PLT"
  [(unspec [(match_operand:SI 0 "" "")] UNSPEC_PLT)]
  ""
  ""
)

; We clobber d0 instead of passing it as a parameter so that gcc will
; know that it doesn't have to set a value in it.  We use constraints
; to specify it as reload avoids regs that are mentioned explicitly.
; Whoever emits this is responsible for moving the result out of a0
; into a pseudo, else reload complains sometimes.  We use PIC_REG so
; that gcc won't delete the prologue insns that set it.  We don't
; split the insns because relaxation requires this specific insn
; sequence.

(define_insn "tls_global_dynamic_i"
  [(parallel
    [(set (match_operand:SI         0 "register_operand" "=C")
	  (call (unspec:SI
		 [(match_operand:SI 1 "tls_symbolic_operand" "")
		  (match_operand:SI 2 "register_operand" "a")
		  (match_operand    4 "register_operand" "")]
		 UNSPEC_TLS_GD)
		(const_int 0)))
     (clobber (match_operand        3 "register_operand" "=B"))])
   ]
  ""
  {
    if (flag_pic)
      return "mov %1@tlsgd, %3\;add %2, %3\;call __tls_get_addr@PLT,[],0";
    return   "mov %1@tlsgd, %3\;add %2, %3\;call __tls_get_addr,[],0";
  }
  ;; Timings: AM33  AM34
  ;; MOV        4     3    (latency invoked because ADD uses %3)
  ;; ADD        1     1
  ;; CALL       3     5
  ;; -------------------
  ;; total      8     9
  [(set (attr "timings") (if_then_else (eq_attr "cpu" "am34") (const_int 99) (const_int 88)))]
)

(define_expand "tls_global_dynamic"
  [(parallel
    [(set (match_operand:SI 0 "register_operand" "")
	  (call (unspec:SI
		 [(match_operand:SI 1 "tls_symbolic_operand" "")
		  (match_operand:SI 2 "register_operand" "")
		  (match_dup 4)]
		 UNSPEC_TLS_GD)
		(const_int 0)))
     (clobber (match_dup 3))])
   ]
  ""
  {
    operands[3] = gen_reg_rtx (SImode);
    operands[4] = mn10300_tls_get_addr ();
  }
)

(define_insn "tls_local_dynamic_base_i"
  [(parallel
    [(set (match_operand:SI 0 "register_operand" "=C")
	  (call (unspec:SI
		 [(match_operand:SI 1 "tls_symbolic_operand" "")
		  (match_operand:SI 2 "register_operand" "a")
		  (match_operand 4 "register_operand" "")]
		 UNSPEC_TLS_LD_BASE)
		(const_int 0)))
     (clobber (match_operand 3 "register_operand" "=B"))])
   ]
  ""
  {
    if (flag_pic)
      return "mov %&@tlsldm, %3\;add %2, %3\;call __tls_get_addr@PLT,[],0";
    return   "mov %&@tlsldm, %3\;add %2, %3\;call __tls_get_addr,[],0";
  }
  ;; Timings: AM33  AM34
  ;; MOV        4     3    (latency invoked because ADD uses %3)
  ;; ADD        1     1
  ;; CALL       3     5
  ;; -------------------
  ;; total      8     9
  [(set (attr "timings") (if_then_else (eq_attr "cpu" "am34") (const_int 99) (const_int 88)))]
)

(define_expand "tls_local_dynamic_base"
  [(parallel
    [(set (match_operand:SI 0 "register_operand" "")
	  (call (unspec:SI
		 [(match_operand:SI 1 "tls_symbolic_operand" "")
		  (match_operand:SI 2 "register_operand" "")
		  (match_dup 4)]
		 UNSPEC_TLS_LD_BASE)
		(const_int 0)))
     (clobber (match_dup 3))])
   ]
  ""
  {
    operands[3] = gen_reg_rtx (SImode);
    operands[4] = mn10300_tls_get_addr ();
  }
)

(define_expand "tls_initial_exec"
  [(match_operand:SI 0 "" "")
   (match_operand:SI 1 "" "")]
  ""
  "
  {
    rtx insn;

    if (flag_pic)
      insn = emit_insn (gen_tls_initial_exec_1 (operands[0], operands[1]));
    else
      insn = emit_insn (gen_tls_initial_exec_2 (operands[0], operands[1]));

    RTX_UNCHANGING_P (SET_SRC (PATTERN (insn))) = 1;

    DONE;
  }"
)

(define_expand "tls_initial_exec_1"
  [(set (match_operand:SI 0 "" "")
	(mem:SI (plus:SI (reg:SI PIC_REG)
			 (const (unspec [(match_operand:SI 1 "" "")]
					UNSPEC_GOTNTPOFF)))))
  ]
  ""
  ""
)

(define_expand "tls_initial_exec_2"
  [(set (match_operand:SI 0 "" "")
	(mem:SI (const (unspec [(match_operand:SI 1 "" "")]
				UNSPEC_INDNTPOFF))))
  ]
  ""
  ""
)

(define_insn "liw_1"
  [(unspec [(match_operand 0 "" "")
	    (match_operand 1 "" "")
	    (match_operand 2 "" "")
	    (match_operand 3 "" "")
	    (match_operand 4 "" "")
	    ] UNSPEC_LIW_1)]
  ""
  "%W0 %2, %1, %4, %3"
  [(set (attr "timings") (if_then_else (eq_attr "cpu" "am34") (const_int 13) (const_int 12)))]
)

(define_insn "liw_lcc"
  [(unspec [(match_operand 0 "" "")
	    (match_operand 1 "" "")
	    (match_operand 2 "" "")
	    ] UNSPEC_LIW_2)]
  ""
  "mov_l%b2 %Q1, %0"
  [(set_attr "timings" "13")]
)

;; cache flush syscall for dcache->icache flushing after setting up
;; the trampoline code.  The operands are: syscall number (289) in d0,
;; start address in a0, and end address in d1.

(define_insn "cache_flush"
  [(parallel
    [(unspec_volatile [(match_operand:SI 0 "" "B")
	      (match_operand:SI 1 "" "C")
	      (match_operand:SI 2 "" "D")]
	     UNSPEC_CACHE_FLUSH)
    (clobber (reg:CC CC_REG))])]
  ""
  "syscall 0 # call=%0, start=%1, end=%2"
  )

;; UNSPEC_VOLATILE is considered to use and clobber all hard registers and
;; all of memory.  This blocks insns from being moved across this point.

(define_insn "blockage"
  [(unspec_volatile [(const_int 0)] UNSPEC_BLOCKAGE)]
  ""
  ""
)

