'\"
'\" Copyright (c) 1993-1998  Lucent Technologies, Inc.
'\"
'\" See the file "license.terms" for information on usage and redistribution
'\" of this file, and for a DISCLAIMER OF ALL WARRANTIES.
'\"
'\" RCS: $Id: Archetype.n,v 1.2 2003/02/16 06:18:15 hunt Exp $
'\"
.so man.macros
.TH Archetype n 3.0 itk "[incr\ Tk]"
.BS
'\" Note:  do not modify the .SH NAME line immediately below!
.SH NAME
Archetype \- base class for all [incr\ Tk] mega-widgets
.SH "INHERITANCE"
none
.ta 4c 8c 12c
.SH "WIDGET-SPECIFIC OPTIONS"
.LP
.nf
Name:	\fBclientData\fR
Class:	\fBClientData\fR
Command-Line Switch:	\fB-clientdata\fR
.fi
.IP
This does not affect the widget operation in any way.  It is
simply a hook that clients can use to store a bit of data with
each widget.  This can come in handy when using widgets to
build applications.
.BE

.SH DESCRIPTION
.PP
The \fBArchetype\fR class is the basis for all \fB[incr\ Tk]\fR
mega-widgets.  It keeps track of component widgets and provides
methods like "configure" and "cget" that are used to access
the composite configuration options.  Each component widget
must be registered with the \fBArchetype\fR base class using
the "\fBitk_component add\fR" method.  When the component
is registered, its configuration options are integrated into
the composite option list.  Configuring a composite option
like "-background" causes all of the internal components
to change their background color.
.PP
It is not used as a widget by itself, but is used as a base
class for more specialized widgets.  The \fBWidget\fR base class
inherits from \fBArchetype\fR, and adds a Tk frame which acts as
the "hull" for the mega-widget.  The \fBToplevel\fR base class
inherits from \fBArchetype\fR, but adds a Tk toplevel which acts
as the "hull".
.PP
\fIEach derived class must invoke the \fBitk_initialize\fP method
within its constructor\fR, so that all options are properly
integrated and initialized in the composite list.


.SH "PUBLIC METHODS"
.PP
The following methods are provided to support the public
interface of the mega-widget.
.TP
\fIpathName \fBcget\fR \fIoption\fR
Returns the current value of the configuration option given
by \fIoption\fR.
.sp
In this case, \fIoption\fR refers to a composite configuration
option for the mega-widget.  Individual components integrate
their own configuration options onto the composite list when
they are registered by the "\fBitk_component add\fR" method.
.TP
\fIpathName\fR \fBcomponent\fR ?\fIname\fR? ?\fIcommand arg arg ...\fR?
Used to query or access component widgets within a mega-widget.
With no arguments, this returns a list of symbolic names for
component widgets that are accessible in the current scope.
The symbolic name for a component is established when it is
registered by the "\fBitk_component add\fR" method.  Note that
component widgets obey any public/protected/private access
restriction that is in force when the component is created.
.sp
If a symbolic \fIname\fR is specified, this method returns the
window path name for that component.
.sp
Otherwise, the \fIcommand\fR and any remaining \fIarg\fR arguments
are invoked as a method on the component with the symbolic
name \fIname\fR.  This provides a well-defined way of accessing
internal components without relying on specific window path
names, which are really details of the implementation.
.TP
\fIpathName\fR \fBconfigure\fR ?\fIoption\fR? ?\fIvalue option value ...\fR?
Query or modify the configuration options of the widget.
If no \fIoption\fR is specified, returns a list describing all of
the available options for \fIpathName\fR (see \fBTk_ConfigureInfo\fR for
information on the format of this list).  If \fIoption\fR is specified
with no \fIvalue\fR, then the command returns a list describing the
one named option (this list will be identical to the corresponding
sublist of the value returned if no \fIoption\fR is specified).  If
one or more \fIoption\-value\fR pairs are specified, then the command
modifies the given widget option(s) to have the given value(s);  in
this case the command returns an empty string.
.sp
In this case, the \fIoptions\fR refer to composite configuration
options for the mega-widget.  Individual components integrate their
own configuration options onto the composite list when they are
registered by the "\fBitk_component add\fR" method.

.SH "PROTECTED METHODS"
.PP
The following methods are used in derived classes as part of
the implementation for a mega-widget.
.TP
\fBitk_component add\fR ?\fB-protected\fR? ?\fB-private\fR? ?\fB--\fR? \fIname createCmds\fR ?\fIoptionCmds\fR?
Creates a component widget by executing the \fIcreateCmds\fR
argument and registers the new component with the symbolic
name \fIname\fR.  The \fB-protected\fR and \fB-private\fR options
can be used to keep the component hidden from the outside world.
These options have a similar effect on component visibility as
they have on class members.
.sp
The \fIcreateCmds\fR code can contain any
number of commands, but it must return the window path name
for the new component widget.
.sp
The \fIoptionCmds\fR script contains commands that describe
how the configuration options for the new component should
be integrated into the composite list for the mega-widget.
It can contain any of the following commands:
.RS
.TP
\fBignore \fIoption\fR ?\fIoption option ...\fR?
Removes one or more configuration \fIoptions\fR from the
composite list.  All options are ignored by default,
so the \fBignore\fR command is only used to negate the
effect of a previous \fBkeep\fR or \fBrename\fR command.
This is useful, for example, when the some of the options
added by the \fBusual\fR command should not apply to
a particular component, and need to be ignored.
.TP
\fBkeep \fIoption\fR ?\fIoption option ...\fR?
Integrates one or more configuration \fIoptions\fR into the
composite list, keeping the name the same.  Whenever the
mega-widget option is configured, the new value is also
applied to the current component.  Options like "-background"
and "-cursor" are commonly found on the \fBkeep\fR list.
.TP
\fBrename \fIoption switchName resourceName resourceClass\fR
Integrates the configuration \fIoption\fR into the composite
list with a different name.  The option will be called
\fIswitchName\fR on the composite list.  It will also be
modified by setting values for \fIresourceName\fR and \fIresourceClass\fR
in the X11 resource database.  The "-highlightbackground"
option is commonly renamed to "-background", so that when
the mega-widget background changes, the background of the
focus ring will change as well.
.TP
\fBusual ?\fItag\fR?
Finds the usual option-handling commands for the specified
\fItag\fR name and executes them.  If the \fItag\fR is
not specified, then the widget class name is used as the
\fItag\fR name.  The "usual" option-handling commands
are registered via the \fBusual\fR command.
.RE
.sp
If the \fIoptionCmds\fR script is not specified, the usual
option-handling commands associated with the class of the
component widget are used by default.

.TP
\fBitk_component delete\fR \fIname\fR ?\fIname name ...\fR?
Removes the component widget with the symbolic name \fIname\fR
from the mega-widget.  The component widget will still exist,
but it will no longer be accessible as a component of the
mega-widget.  Also, any options associated with the component
are removed from the composite option list.
.sp
Note that you can destroy a component using the \fBdestroy\fR
command, just as you would destroy any Tk widget.  Components
automatically detach themselves from their mega-widget parent
when destroyed, so "\fBitk_component delete\fR" is rarely used.

.TP
\fBitk_initialize ?\fIoption value option value...\fR?
\fIThis method must be invoked within the constructor for
each class in a mega-widget hierarchy.\fR  It makes sure
that all options are properly integrated into the composite
option list, and synchronizes all components to the initial
option values.  It is usually invoked near the bottom of
the constructor, after all component widgets have been
added.
.sp
If any \fIoption\fR/\fIvalue\fR pairs are specified, they
override settings determined from the X11 resource database.
The arguments to the constructor are usually passed along
to this method as follows:
.CS
class MyWidget {
    inherit Widget

    constructor {args} {
        .
        .
        .
        eval itk_initialize $args
    }
}
.CE

.TP
\fBitk_option add\fR \fIoptName\fR ?\fIoptName optName ...\fR?
Adds one or more options to the composite option list for
a mega-widget.  Here, \fIoptName\fR can have one of the
following forms:
.RS
.TP
\fIcomponent\fR.\fIoption\fR
Accesses an \fIoption\fR belonging to a component with the
symbolic name \fIcomponent\fR.  The \fIoption\fR name is
specified without a leading "\fB-\fR" sign.
.TP
\fIclassName\fR::\fIoption\fR
Accesses an \fIoption\fR defined by the "\fBitk_option define\fR"
command in class \fIclassName\fR.  The \fIoption\fR name is
specified without a leading "\fB-\fR" sign.
.RE
.PP
Options are normally integrated into the composite option list
when a component widget is first created.  This method can be
used to add options at a later time.  For example, the \fBWidget\fR
and \fBToplevel\fR base classes keep only the bare minimum options
for their "hull" component:  -background and -cursor.  A derived
class can override this decision, and add options that control
the border of the "hull" component as well:
.CS
class MyWidget {
    inherit Widget

    constructor {args} {
        itk_option add hull.borderwidth hull.relief

        itk_component add label {
            label $itk_interior.l1 -text "Hello World!"
        }
        pack $itk_component(label)

        eval itk_initialize $args
    }
}
.CE

.TP
\fBitk_option define\fR \fIswitchName resourceName resourceClass init\fR ?\fIconfig\fR?
This command is used at the level of the class definition to
define a synthetic mega-widget option.  Within the \fBconfigure\fR
and \fBcget\fR methods, this option is referenced by \fIswitchName\fR,
which must start with a "\fB-\fR" sign.  It can also be
modified by setting values for \fIresourceName\fR and \fIresourceClass\fR
in the X11 resource database.  The \fIinit\fR value string is used
as a last resort to initialize the option if no other value can
be used from an existing option, or queried from the X11 resource
database.  If any \fIconfig\fR code is specified, it is executed
whenever the option is modified via the \fBconfigure\fR method.
The \fIconfig\fR code can also be specified outside of the class
definition via the \fBconfigbody\fR command.
.sp
In the following example, a synthetic "-background" option is
added to the class, so that whenever the background changes, the
new value is reported to standard output.  Note that this synthetic
option is integrated with the rest of the "-background" options
that have been kept from component widgets:
.CS
class MyWidget {
    inherit Widget
    constructor {args} {
        itk_component add label {
            label $itk_interior.l1 -text "Hello World!"
        }
        pack $itk_component(label)

        eval itk_initialize $args
    }
    itk_option define -background background Background #d9d9d9 {
        puts "new background: $itk_option(-background)"
    }
}
.CE

.TP
\fBitk_option remove\fR \fIoptName\fR ?\fIoptName optName ...\fR?
Removes one or more options from the composite option list for
a mega-widget.  Here, \fIoptName\fR can have one of the forms
described above for the "\fBitk_option add\fR" command.
.sp
Options are normally integrated into the composite option list
when a component widget is first created.  This method can be
used to remove options at a later time.  For example, a derived
class can override an option defined in a base class by removing
and redefining the option:
.CS
class Base {
    inherit Widget
    constructor {args} {
        eval itk_initialize $args
    }

    itk_option define -foo foo Foo "" {
        puts "Base: $itk_option(-foo)"
    }
}

class Derived {
    inherit Base

    constructor {args} {
        itk_option remove Base::foo
        eval itk_initialize $args
    }
    itk_option define -foo foo Foo "" {
        puts "Derived: $itk_option(-foo)"
    }
}
.CE
Without the "\fBitk_option remove\fR" command, the code fragments
for both of the "-foo" options would be executed each time the
composite "-foo" option is configured.  In the example above,
the \fCBase::foo\fR option is suppressed in all Derived class
widgets, so only the \fCDerived::foo\fR option remains.

.SH "PROTECTED VARIABLES"
Derived classes can find useful information in the following
protected variables.
.TP
itk_component(\fIname\fR)
The "itk_component" array returns the real window path name
for a component widget with the symbolic name \fIname\fR.
The same information can be queried using the \fBcomponent\fR
method, but accessing this array is faster and more convenient.
.TP
itk_interior
This variable contains the name of the window that acts as
a parent for internal components.  It is initialized to the
name of the "hull" component provided by the \fBWidget\fR
and \fBToplevel\fR classes.  Derived classes can override
the initial setting to point to another interior window
to be used for further-derived classes.
.TP
itk_option(\fIoption\fR)
The "itk_option" array returns the current option value
for the composite widget option named \fIoption\fR.  Here,
the \fIoption\fR name should include a leading "\fB-\fR" sign.
The same information can be queried using the \fBcget\fR
method, but accessing this array is faster and more convenient.

.SH KEYWORDS
itk, Widget, Toplevel, mega-widget
