; $Id: diners.scm,v 1.1.1.1 2003/02/18 20:59:36 green Exp $

; { dg-output "\[01234567]+" }

;; Solution to the classic dining philosophers problem.
;;
;; A mutex is used to synchronize access to the shared "fork"
;; resources. When a Philosopher is able to grab two forks,
;; (s)he can procees with eating. Eating is represented by 
;; displaying the Philosopher's id to the default output port.

(define (dining-philosophers diners)
  (let ((fork-mutex (make-mutex))
	(forks (make-vector diners #t)))

    (define (pick-up n)
      (if (not (with-mutex fork-mutex
		  (if (and (vector-ref forks n)
			   (vector-ref forks (modulo (+ n 1) diners)))
		      (begin
			(vector-set! forks n #f)
			(vector-set! forks (modulo (+ n 1) diners) #f)
			#t)
		      #f)))
	  (pick-up n)))

    (define (put-down n)
      (with-mutex fork-mutex
	(vector-set! forks n #t)
	(vector-set! forks (modulo (+ n 1) diners) #t)))

    (define (eat n)
      (display n)
      (force-output))

    (define (dine n)
      (pick-up n)
      (eat n)
      (put-down n)
      (dine n))

    (define (make-philosopher n)
      (if (> n 0)
	  (begin
	    (make-thread dine (- n 1))
	    (make-philosopher (- n 1)))))
    
    (make-philosopher diners)))

(dining-philosophers 8)

(sleep 5)

