;;; Extended characters conversion tests
;;;
;;; files:
;;;
;;;  chars.CHARSET		characters of CHARSET represented by
;;;				internal code number.
;;;
;;;  mbs.CHARSET.ENCODING	characters of CHARSET represented in
;;;				multi-byte form encoded by ENCODING.

(define (string->byte-list str coding)
  (let ((l #f))
    (call-with-input-string (code-convert-string str #t coding)
      (lambda (p)
	(regular-port! p)
	(do ((c (read-char p)))
	    ((eof-object? c))
	  (set! l (append l (list (char->integer c))))
	  (set! c (read-char p)))))
    l))

(define (byte-list->string bytes coding)
  (let ((l #f))
    (do ((c 0))
	((null? bytes))
      (set! c (car bytes))
      (set! l (append l (list (integer->char c))))
      (set! bytes (cdr bytes)))
    (code-convert-string (list->string l) coding #t)))

(define (encode-chars charfile mbfile coding)
  (let ((code (symbol->string coding))
	(stdout (current-output-port))
	(count 0))
    (set! code (substring code 1 (- (string-length code) 1)))
    (call-with-input-file charfile
      (lambda (ip)
	(call-with-output-file (string-append "tmp." code)
	  (lambda (op)
	    (set-port-coding! op coding)
	    (do ((c (read ip)))
		((eof-object? c))
	      (write (string->byte-list (string c) coding) op)
	      (display "	; " op)
	      (display c op)
	      (newline op)
	      (set! count (+ count 1))
	      (display count stdout)
	      (display "\n" stdout)
	      (set! c (read ip)))))))
    (if (= (system (string-append "diff tmp." code " " mbfile " > /dev/null"))
	   0)
	'passed
	'failed)))

(define (decode-mbs charfile mbfile coding)
  (let ((code (symbol->string coding)))
    (set! code (substring code 1 (- (string-length code) 1)))
    (call-with-input-file mbfile
      (lambda (ip)
	(set-port-coding! ip coding)
	(call-with-output-file (string-append "tmp." code)
	  (lambda (op)
	    (regular-port! op)
	    (do ((l (read ip)))
		((eof-object? l))
	      (write (string-ref (byte-list->string l coding) 0) op)
	      (newline op)
	      (set! l (read ip)))))))
    (if (= (system (string-append "diff tmp." code " " charfile "> /dev/null"))
	   0)
	'passed
	'failed)))


;;; Extended characters encoding tests.

;;(encode-chars CHARFILE MBFILE CODING)
;;
;;  encode characters in CHARFILE with encoding specified by CODING.
;;  compare results with MBFILE.

;(encode-chars "chars.jis0208" "mbs.jis0208.internal" *internal*)
;(encode-chars "chars.jis0208" "mbs.jis0208.junet" *junet*)
;(encode-chars "chars.jis0208" "mbs.jis0208.euc-japan" *euc-japan*)
;(encode-chars "chars.jis0208" "mbs.jis0208.sjis" *sjis*)
;(encode-chars "chars.jis0208" "mbs.jis0208.utf-8" *utf-8*) 

;(encode-chars "chars.jis0201" "mbs.jis0201.internal" *internal*)
;(encode-chars "chars.jis0201" "mbs.jis0201.junet" *junet*)
;(encode-chars "chars.jis0201" "mbs.jis0201.euc-japan" *euc-japan*)
;(encode-chars "chars.jis0201" "mbs.jis0201.sjis" *sjis*)
;(encode-chars "chars.jis0201" "mbs.jis0201.utf-8" *utf-8*)

;(encode-chars "chars.iso8859-1" "mbs.iso8859-1.internal" *internal*)
;(encode-chars "chars.iso8859-1" "mbs.iso8859-1.ctext" *ctext*)
;(encode-chars "chars.iso8859-1" "mbs.iso8859-1.utf-8" *utf-8*)


;;(decode-mbs MBFILE CHARFILE CODING)
;;
;;  decode lists of bytes encoded by CODING in MBFILE.
;;  compare results with CHARFILE.

;(decode-mbs "chars.jis0208" "mbs.jis0208.internal" *internal*)
;(decode-mbs "chars.jis0208" "mbs.jis0208.junet" *junet*)
;(decode-mbs "chars.jis0208" "mbs.jis0208.euc-japan" *euc-japan*)
;(decode-mbs "chars.jis0208" "mbs.jis0208.sjis" *sjis*)
;(decode-mbs "chars.jis0208" "mbs.jis0208.utf-8" *utf-8*) ==> failed

;(decode-mbs "chars.jis0201" "mbs.jis0201.internal" *internal*)
;(decode-mbs "chars.jis0201" "mbs.jis0201.junet" *junet*)
;(decode-mbs "chars.jis0201" "mbs.jis0201.euc-japan" *euc-japan*)
;(decode-mbs "chars.jis0201" "mbs.jis0201.sjis" *sjis*)
;(decode-mbs "chars.jis0201" "mbs.jis0201.utf-8" *utf-8*)

;(decode-mbs "chars.iso8859-1" "mbs.iso8859-1.internal" *internal*)
;(decode-mbs "chars.iso8859-1" "mbs.iso8859-1.ctext" *ctext*)
;(decode-mbs "chars.iso8859-1" "mbs.iso8859-1.utf-8" *utf-8*)
