#!/packages/bin/guile -
; -*-scheme-*-

;; examples of processing matrices with guile; includes a matrix
;; rendering example that uses Tk widgets and scheme closers.

;; include the Tk toolkit stuff so we can do a color
;; representation of the matrix on a canvas.
(require 'Gwish)
(use-library tcl)
(use-interface tcl)
(use-interface tclhack)

(define sample-m
  (list
   (list 7 2 1 3 2 8 5 3 6 2 8 5 3 6 2 8 5 3 6 2 8 5 3 6 2 8 5 3 6)
   (list 4 1 1 1 3 8 9 8 1 2 8 5 3 6 2 8 5 3 6 2 8 5 3 6 2 8 5 3 6)
   (list 4 2 1 1 4 2 1 1 4 2 1 1 4 2 1 1 4 2 1 1 4 2 1 1 3 8 9 8 1)
   (list 4 3 1 1 3 8 4 2 1 1 4 2 1 1 4 2 1 1 4 2 1 1 4 2 1 1 9 8 1)
   (list 4 2 1 1 4 4 4 2 1 1 1 4 2 1 1 1 4 2 1 1 3 4 2 1 1 8 9 8 1)
   (list 4 6 1 1 3 8 9 8 1 4 2 1 1 4 2 1 1 4 2 1 1 4 2 4 2 1 1 1 1)
   (list 4 2 1 1 4 2 1 1 4 2 1 1 4 2 1 1 4 2 1 1 4 2 1 1 3 8 9 8 1)
   (list 4 3 1 1 3 8 4 2 1 1 4 2 1 1 4 2 1 1 4 2 1 1 4 2 1 1 9 8 1)
   (list 4 2 1 1 4 4 4 2 1 1 1 4 2 1 1 1 4 2 1 1 3 4 2 1 1 8 9 8 1)
   (list 4 6 1 1 3 8 9 8 1 4 2 1 1 4 2 1 1 4 2 1 1 4 2 4 2 1 1 1 1)
   (list 4 2 1 1 4 2 1 1 4 2 1 1 4 2 1 1 4 2 1 1 4 2 1 1 3 8 9 8 1)
   (list 4 3 1 1 3 8 4 2 1 1 4 2 1 1 4 2 1 1 4 2 1 1 4 2 1 1 9 8 1)
   (list 4 2 1 1 4 4 4 2 1 1 1 4 2 1 1 1 4 2 1 1 3 4 2 1 1 8 9 8 1)
   (list 4 6 1 1 3 8 9 8 1 4 2 1 1 4 2 1 1 4 2 1 1 4 2 4 2 1 1 1 1)
   (list 4 2 1 1 4 2 1 1 4 2 1 1 4 2 1 1 4 2 1 1 4 2 1 1 3 8 9 8 1)
   (list 4 3 1 1 3 8 4 2 1 1 4 2 1 1 4 2 1 1 4 2 1 1 4 2 1 1 9 8 1)
   (list 4 2 1 1 4 4 4 2 1 1 1 4 2 1 1 1 4 2 1 1 3 4 2 1 1 8 9 8 1)
   (list 4 6 1 1 3 8 9 8 1 4 2 1 1 4 2 1 1 4 2 1 1 4 2 4 2 1 1 1 1)
   (list 4 2 1 1 4 2 1 1 4 2 1 1 4 2 1 1 4 2 1 1 4 2 1 1 3 8 9 8 1)
   (list 4 3 1 1 3 8 4 2 1 1 4 2 1 1 4 2 1 1 4 2 1 1 4 2 1 1 9 8 1)
   (list 4 2 1 1 4 4 4 2 1 1 1 4 2 1 1 1 4 2 1 1 3 4 2 1 1 8 9 8 1)
   (list 4 6 1 1 3 8 9 8 1 4 2 1 1 4 2 1 1 4 2 1 1 4 2 4 2 1 1 1 1)
   (list 4 2 1 1 4 2 1 1 4 2 1 1 4 2 1 1 4 2 1 1 4 2 1 1 3 8 9 8 1)
   (list 0 3 1 1 3 8 4 2 1 1 4 2 1 1 4 2 1 1 4 2 1 1 4 2 1 1 9 8 1)
   (list 1 2 1 1 4 4 4 2 1 1 1 4 2 1 1 1 4 2 1 1 3 4 2 1 1 8 9 8 1)
   (list 2 6 1 1 3 8 9 8 1 4 2 1 1 4 2 1 1 4 2 1 1 4 2 4 2 1 1 1 1)
   (list 3 5 4 8 1 8 2 4 2 1 1 4 2 1 1 4 2 4 2 1 4 2 1 1 1 1 1 2 4)))

(define color-list '("black" "purple" "blue" "lightblue" "orange" "yellow"
			     "white" "red" "green"))
;; this returns the n-th element in a list (wrapping if the list is short)
;; we use it to find entries in the color table.
(define (nth-wrap n list size)
  (if (= (modulo n size) 0)
    (car list)
    (nth-wrap (- n 1) (cdr list) size)))

;; returns the color corresponding to a given integer
(define (find-color n)
  (nth-wrap n color-list (length color-list)))

;; applies the function func to the matrix m element-by-element;
;; returns a matrix with the result.
(define (process-matrix m func)
  (map (lambda (l)
	 (map func l))
       m))

;; represent-matrix applies a prcedure to each element, and also
;; applies a procedure after each row has been displayed.
;; `proc' is a procedure to represent the single element,
;; `row-proc' is a procedure that is invoked after each row.
;; For example, proc could be (lambda (x) (begin (display x) (display " ")))
;; and row-proc could be (lambda (l) (display "\n"))
(define (represent-matrix m proc row-proc)
  (for-each (lambda (l)
	      (begin
		(for-each proc l)
		(row-proc l)))
	    m))
