#include <stdio.h>
#include <math.h>

#include <gscm.h>

#include "c_builtins.h"

/* this is a factorial routine in C, made to be callable by scheme */
SCM c_factorial(SCM s_n)
{
  int i;
  unsigned long result = 1, n;

  n = gscm_2_ulong(s_n);

  GSCM_DEFER_INTS;
  for (i = 1; i <= n; ++i) {
    result = result*i;
  }
  GSCM_ALLOW_INTS;
  return gscm_ulong(result);
}

/* a sin routine in C, callable from scheme.  it is named c_sin()
 * to distinguish it from the default scheme sin function
 */
SCM c_sin(SCM s_x)
{
  double x = gscm_2_double(s_x);

  return gscm_double(sin(x));
}

/* play around with vectors in guile: this routine creates a
 * vector of the given length, initializes it all to zero except
 * element 2 which is set to 1.9.
 */
SCM vector_test(SCM s_length)
{
  SCM xvec;
  unsigned long c_length;

  c_length = gscm_2_ulong(s_length);
  printf("requested length for vector: %ld\n", c_length);

  /* create a vector */
  xvec = gscm_vector(c_length, gscm_double(0.0));
  /* set the second element in it */
  gscm_vset(xvec, 2, gscm_double(1.9));

  return xvec;
}
