;;;; 	copyright (C) 1995 Free Software Foundation, Inc.
;;;; 
;;;; This program is free software; you can redistribute it and/or modify
;;;; it under the terms of the GNU General Public License as published by
;;;; the Free Software Foundation; either version 2, or (at your option)
;;;; any later version.
;;;; 
;;;; This program is distributed in the hope that it will be useful,
;;;; but WITHOUT ANY WARRANTY; without even the implied warranty of
;;;; MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
;;;; GNU General Public License for more details.
;;;; 
;;;; You should have received a copy of the GNU General Public License
;;;; along with this software; see the file COPYING.  If not, write to
;;;; the Free Software Foundation, 675 Mass Ave, Cambridge, MA 02139, USA.
;;;; 


;;; ----------------------------------------------------------------
;;; libguile.scm -- Basic guile interfaces
;;; 21 Dec 1994, Miles Bader <miles@eskimo.com>
;;; ----------------------------------------------------------------
;;;
(in-package guile)
(export-library guile (guile))
(in-module guile)

(define guile-interface (resolve-interface 'guile (current-package)))
(module-binder-set! guile-interface root-module-thunk)

(define-syntax-macro (module:defined? name)
  (module-bound? (current-module) name))

(define auto-loaded '())

(define (try-auto-load f)
  (or (member f auto-loaded)
      (save-module-excursion
       (lambda ()
	 (and (not (file-is-directory? f)) (%try-load f))))))

(define pending '())

(define (auto-loader dir table)
      (lambda (module name define?)
	(and-map 
	 (lambda (bind)
	   (or (not (eq? (car bind) name))
	       (member name pending)
	       (dynamic-wind
		(lambda () (set! pending (cons name pending)))
		(lambda ()
		  (try-auto-load (string-append dir "/" (cdr bind))))
		(lambda () (set! pending (delq! name pending))))))
	 table)
	(and (symbol-bound? (module-obarray module) name)
	     (symbol-binding (module-obarray module) name))))
