'\"
'\" Copyright (c) 1995 DSC Technologies Corporation
'\"
'\" See the file "license.terms" for information on usage and redistribution
'\" of this file, and for a DISCLAIMER OF ALL WARRANTIES.
'\"
'\" @(#) entryfield.n 1.21 94/12/17 16:04:44
'\" 
'\" The definitions below are for supplemental macros used in Tcl/Tk
'\" manual entries.
'\"
'\" .HS name section [date [version]]
'\"	Replacement for .TH in other man pages.  See below for valid
'\"	section names.
'\"
'\" .AP type name in/out [indent]
'\"	Start paragraph describing an argument to a library procedure.
'\"	type is type of argument (int, etc.), in/out is either "in", "out",
'\"	or "in/out" to describe whether procedure reads or modifies arg,
'\"	and indent is equivalent to second arg of .IP (shouldn't ever be
'\"	needed;  use .AS below instead)
'\"
'\" .AS [type [name]]
'\"	Give maximum sizes of arguments for setting tab stops.  Type and
'\"	name are examples of largest possible arguments that will be passed
'\"	to .AP later.  If args are omitted, default tab stops are used.
'\"
'\" .BS
'\"	Start box enclosure.  From here until next .BE, everything will be
'\"	enclosed in one large box.
'\"
'\" .BE
'\"	End of box enclosure.
'\"
'\" .VS
'\"	Begin vertical sidebar, for use in marking newly-changed parts
'\"	of man pages.
'\"
'\" .VE
'\"	End of vertical sidebar.
'\"
'\" .DS
'\"	Begin an indented unfilled display.
'\"
'\" .DE
'\"	End of indented unfilled display.
'\"
'\" @(#) man.macros 1.1 94/08/09 13:07:19
.\"
'\"	# Heading for Tcl/Tk man pages
.de HS
.ds ^3 \\0
.if !"\\$3"" .ds ^3 \\$3
.if '\\$2'cmds'      .TH "\\$1" 1 "\\*(^3" "\\$4" "\\$5"
.if '\\$2'lib'       .TH "\\$1" 3 "\\*(^3" "\\$4" "\\$5"
.if '\\$2'ncmds'     .TH "\\$1" n "\\*(^3" "\\$4" "\\$5"
.if '\\$2'tcl'       .TH "\\$1" n "\\*(^3"  Tcl   "Tcl Built-In Commands"
.if '\\$2'tk'        .TH "\\$1" n "\\*(^3"  Tk    "Tk Commands"
.if '\\$2'tclc'      .TH "\\$1" 3 "\\*(^3"  Tcl   "Tcl Library Procedures"
.if '\\$2'tkc'       .TH "\\$1" 3 "\\*(^3"  Tk    "Tk Library Procedures"
.if '\\$2'tclcmds'   .TH "\\$1" 1 "\\*(^3"  Tk    "Tcl Applications"
.if '\\$2'tkcmds'    .TH "\\$1" 1 "\\*(^3"  Tk    "Tk Applications"
.if '\\$2'iwid'      .TH "\\$1" 1 "\\*(^3"  Tk    "[incr Widgets]"
.if t .wh -1.3i ^B
.nr ^l \\n(.l
.ad b
..
'\"	# Start an argument description
.de AP
.ie !"\\$4"" .TP \\$4
.el \{\
.   ie !"\\$2"" .TP \\n()Cu
.   el          .TP 15
.\}
.ie !"\\$3"" \{\
.ta \\n()Au \\n()Bu
\&\\$1	\\fI\\$2\\fP	(\\$3)
.\".b
.\}
.el \{\
.br
.ie !"\\$2"" \{\
\&\\$1	\\fI\\$2\\fP
.\}
.el \{\
\&\\fI\\$1\\fP
.\}
.\}
..
'\"	# define tabbing values for .AP
.de AS
.nr )A 10n
.if !"\\$1"" .nr )A \\w'\\$1'u+3n
.nr )B \\n()Au+15n
.\"
.if !"\\$2"" .nr )B \\w'\\$2'u+\\n()Au+3n
.nr )C \\n()Bu+\\w'(in/out)'u+2n
..
'\"	# BS - start boxed text
'\"	# ^y = starting y location
'\"	# ^b = 1
.de BS
.br
.mk ^y
.nr ^b 1u
.if n .nf
.if n .ti 0
.if n \l'\\n(.lu\(ul'
.if n .fi
..
'\"	# BE - end boxed text (draw box now)
.de BE
.nf
.ti 0
.mk ^t
.ie n \l'\\n(^lu\(ul'
.el \{\
.\"	Draw four-sided box normally, but don't draw top of
.\"	box if the box started on an earlier page.
.ie !\\n(^b-1 \{\
\h'-1.5n'\L'|\\n(^yu-1v'\l'\\n(^lu+3n\(ul'\L'\\n(^tu+1v-\\n(^yu'\l'|0u-1.5n\(ul'
.\}
.el \}\
\h'-1.5n'\L'|\\n(^yu-1v'\h'\\n(^lu+3n'\L'\\n(^tu+1v-\\n(^yu'\l'|0u-1.5n\(ul'
.\}
.\}
.fi
.br
.nr ^b 0
..
'\"	# VS - start vertical sidebar
'\"	# ^Y = starting y location
'\"	# ^v = 1 (for troff;  for nroff this doesn't matter)
.de VS
.mk ^Y
.ie n 'mc \s12\(br\s0
.el .nr ^v 1u
..
'\"	# VE - end of vertical sidebar
.de VE
.ie n 'mc
.el \{\
.ev 2
.nf
.ti 0
.mk ^t
\h'|\\n(^lu+3n'\L'|\\n(^Yu-1v\(bv'\v'\\n(^tu+1v-\\n(^Yu'\h'-|\\n(^lu+3n'
.sp -1
.fi
.ev
.\}
.nr ^v 0
..
'\"	# Special macro to handle page bottom:  finish off current
'\"	# box/sidebar if in box/sidebar mode, then invoked standard
'\"	# page bottom macro.
.de ^B
.ev 2
'ti 0
'nf
.mk ^t
.if \\n(^b \{\
.\"	Draw three-sided box if this is the box's first page,
.\"	draw two sides but no top otherwise.
.ie !\\n(^b-1 \h'-1.5n'\L'|\\n(^yu-1v'\l'\\n(^lu+3n\(ul'\L'\\n(^tu+1v-\\n(^yu'\h'|0u'\c
.el \h'-1.5n'\L'|\\n(^yu-1v'\h'\\n(^lu+3n'\L'\\n(^tu+1v-\\n(^yu'\h'|0u'\c
.\}
.if \\n(^v \{\
.nr ^x \\n(^tu+1v-\\n(^Yu
\kx\h'-\\nxu'\h'|\\n(^lu+3n'\ky\L'-\\n(^xu'\v'\\n(^xu'\h'|0u'\c
.\}
.bp
'fi
.ev
.if \\n(^b \{\
.mk ^y
.nr ^b 2
.\}
.if \\n(^v \{\
.mk ^Y
.\}
..
'\"	# DS - begin display
.de DS
.RS
.nf
.sp
..
'\"	# DE - end display
.de DE
.fi
.RE
.sp
..
.HS iwidgets::entryfield iwid
.BS
'\" Note:  do not modify the .SH NAME line immediately below!
.SH NAME
iwidgets::entryfield \- Create and manipulate a entry field widget
.SH SYNOPSIS
\fBiwidgets::entryfield\fI \fIpathName \fR?\fIoptions\fR?
.SH "INHERITANCE"
itk::Widget <- iwidgets::LabeledWidget <- iwidgets::Entryfield
.SH "STANDARD OPTIONS"
.LP
.nf
.ta 4c 8c 12c
\fB
background         borderWidth     cursor              exportSelection
foreground         highlightColor  highlightThickness  insertBackground
insertBorderWidth  insertOffTime   insertOnTime        insertWidth
justify            relief          selectBackground    selectBorderWidth
selectForeground   textVariable    width\fR
.fi
.LP
See the "options" manual entry for details on the standard options.
.SH "ASSOCIATED OPTIONS"
.LP
.nf
.ta 4c 8c 12c
\fBshow\fR	\fBstate\fR
.fi
.LP
See the "entry" manual entry for details on the associated options.
.SH "INHERITED OPTIONS"
.LP
.nf
.ta 4c 8c 12c
\fBdisabledForeground\fR	\fBlabelBitmap\fR	\fBlabelFont\fR	\fBlabelImage\fR
\fBlabelMargin\fR	\fBlabelPos\fR	\fBlabelText\fR	\fBlabelVariable\fR
\fBstate\fR	\fBsticky\fR
.fi
.LP
See the "labeledwidget" class manual entry for details on the 
inherited options.
.SH "WIDGET-SPECIFIC OPTIONS"
.LP
.nf
Name:	\fBchildSitePos\fR
Class:	\fBPosition\fR
Command-Line Switch:	\fB-childsitepos\fR
.fi
.IP
Specifies the position of the child site in the entry field: \fBn\fR, 
\fBs\fR, \fBe\fR, or \fBw\fR.  The default is e.
.LP
.nf
Name:	\fBcommand\fR
Class:	\fBCommand\fR
Command-Line Switch:	\fB-command\fR
.fi
.IP
Specifies a Tcl command to be executed upon detection of a Return key 
press event.
.LP
.nf
Name:	\fBfixed\fR
Class:	\fBFixed\fR
Command-Line Switch:	\fB-fixed\fR
.fi
.IP
Restrict entry to the specified number of chars.  A value of 0, which is the
default, denotes no limit.  The value is the maximum number of chars the 
user may type into the field, regardles of field width.  For example,
if the field width is set to 20 and the fixed value is 10, the user will 
only be able to type 10 characters into the field which is 20 characters long.
.LP
.nf
Name:	\fBfocusCommand\fR
Class:	\fBCommand\fR
Command-Line Switch:	\fB-focuscommand\fR
.fi
.IP
Specifies a Tcl command to be executed upon reception of focus.
.LP
.nf
Name:	\fBinvalid\fR
Class:	\fBCommand\fR
Command-Line Switch:	\fB-invalid\fR
.fi
.IP
Specifies a Tcl command to be executed upon determination of invalid input.
The default is bell.
.LP
.nf
Name:	\fBtextBackground\fR
Class:	\fBBackground\fR
Command-Line Switch:	\fB-textbackground\fR
.fi
.IP
Background color for inside textual portion of the entry field.  The value
may be given in any of the forms acceptable to \fBTk_GetColor\fR.
.LP
.nf
Name:	\fBtextFont\fR
Class:	\fBFont\fR
Command-Line Switch:	\fB-textfont\fR
.fi
.IP
Name of font to use for display of text in entryfield.  The value
may be given in any of the forms acceptable to \fBTk_GetFont\fR.
.LP
.nf
Name:	\fBpasting\fR
Class:	\fBBehavior\fR
Command-Line Switch:	\fB-pasting\fR
.fi
.IP
Option to enable/disable pasting into the entry component of the
entryfield.  Valid values are 0 (disabled) or 1 (enabled).
Defaults to 1.
.LP
.nf
Name:	\fBvalidate\fR
Class:	\fBCommand\fR
Command-Line Switch:	\fB-validate\fR
.fi
.IP
The validate option allows specification of a validation mechanism.  Standard
character validation such as \fBnumeric\fR, \fBalphabetic\fR, \fBinteger\fR,
\fBhexidecimal\fR, \fBreal\fR, and \fBalphanumeric\fR can be handled through 
the use of keywords.  Should more
extensive validation be necessary, the value may contain the name of
a command script.  The script should return a boolean value.  True for 
valid, false for invalid.  If false is returned, then the procedure 
associated with the invalid option will be invoked.
If the validation script contains
any \fB%\fR characters, then the script will not be
executed directly.  Instead, a new script will be
generated by replacing each \fB%\fR, and the character following
it, with information from the entryfield.  The replacement
depends on the character following the \fB%\fR, as defined in the
list below.
.TP
\fB%c\fR
Replaced with the current input character.
.TP
\fB%P\fR
Replaced with the contents of the entryfield modified to include the latest
keystoke.  This is equivalent to peeking at the future contents, enabling
rejection prior to the update.
.TP
\fB%S\fR
Replaced with the current contents of the entryfield prior to the latest
keystroke being added.
.TP
\fB%W\fR
Replaced with the entryfield widget pathname.
.LP
.BE

.SH DESCRIPTION
.PP
The \fBiwidgets::entryfield\fR command creates an enhanced text entry widget with an
optional associated label.  Addtional options support validation and 
establishing a upper limit on the number of characters which may be
entered in the field.
.DE

.SH "METHODS"
.PP
The \fBiwidgets::entryfield\fR command creates a new Tcl command whose
name is \fIpathName\fR.  This
command may be used to invoke various
operations on the widget.  It has the following general form:
.DS C
\fIpathName option \fR?\fIarg arg ...\fR?
.DE
\fIOption\fR and the \fIarg\fRs
determine the exact behavior of the command.  The following
commands are possible for entryfield widgets:
.SH "ASSOCIATED METHODS"
.LP
.nf
.ta 4c 8c 12c
\fBdelete\fR	\fBget\fR	\fBicursor\fR	\fBindex\fR	
\fBinsert\fR	\fBscan\fR	\fBselection\fR	\fBxview\fR	
.fi
.LP
See the "entry" manual entry for details on the associated methods.
.SH "WIDGET-SPECIFIC METHODS"
.TP
\fIpathName \fBcget\fR \fIoption\fR
Returns the current value of the configuration option given
by \fIoption\fR.
\fIOption\fR may have any of the values accepted by the \fBiwidgets::entryfield\fR
command.
.TP
\fIpathName \fBchildsite\fR
Returns the path name of the child site.
.TP
\fIpathName \fBclear\fR
Clear entry widget
.TP
\fIpathName\fR \fBconfigure\fR ?\fIoption\fR? ?\fIvalue option value ...\fR?
Query or modify the configuration options of the widget.
If no \fIoption\fR is specified, returns a list describing all of
the available options for \fIpathName\fR (see \fBTk_ConfigureInfo\fR for
information on the format of this list).  If \fIoption\fR is specified
with no \fIvalue\fR, then the command returns a list describing the
one named option (this list will be identical to the corresponding
sublist of the value returned if no \fIoption\fR is specified).  If
one or more \fIoption\-value\fR pairs are specified, then the command
modifies the given widget option(s) to have the given value(s);  in
this case the command returns an empty string.
\fIOption\fR may have any of the values accepted by the \fBiwidgets::entryfield\fR
command.

.SH "COMPONENTS"
.LP
.nf
Name:	\fBefchildsite\fR
Class:	\fBframe\fR
.fi
.IP
The efchildsite component is the user child site for the entry field.  See 
the "frame" widget manual entry for details on the efchildsite component item.
.LP
.nf
Name:	\fBentry\fR
Class:	\fBentry\fR
.fi
.IP
The entry component provides the entry field for user text input and display.
See the "entry" widget manual entry for details on the entry component item.
.fi

.SH EXAMPLE
.DS
 package require Iwidgets 4.0
 option add *textBackground white
 
 proc returnCmd {} {
     puts stdout "Return Pressed"
 }
 
 proc invalidCmd {} {
     puts stdout "Alphabetic contents invalid"
 }
 
 iwidgets::entryfield .ef -command returnCmd
 
 iwidgets::entryfield .fef -labeltext "Fixed:" -fixed 10 -width 12
 
 iwidgets::entryfield .nef -labeltext "Numeric:" -validate numeric -width 12
 
 iwidgets::entryfield .aef -labeltext "Alphabetic:" \\
    -validate alphabetic -width 12 -invalid invalidCmd
 
 iwidgets::entryfield .pef -labeltext "Password:" \\
    -show \267 -width 12 -command returnCmd
 
 iwidgets::Labeledwidget::alignlabels .ef .fef .nef .aef .pef

 pack .ef -fill x -expand yes -padx 10 -pady 5
 pack .fef -fill x -expand yes -padx 10 -pady 5
 pack .nef -fill x -expand yes -padx 10 -pady 5
 pack .aef -fill x -expand yes -padx 10 -pady 5
 pack .pef -fill x -expand yes -padx 10 -pady 5
.DE
.SH AUTHOR
Sue Yockey
.DE
Mark L. Ulferts
.LP
.SH KEYWORDS
entryfield, widget
