#=====================================================================
# SQL-Ledger, Accounting
# Copyright (c) 2001
#
#  Author: Dieter Simader
#   Email: dsimader@sql-ledger.org
#     Web: http://www.sql-ledger.org
#
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License as published by
# the Free Software Foundation; either version 2 of the License, or
# (at your option) any later version.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
#======================================================================
#
# Inventory Control module
#
#======================================================================


use SL::IC;

require "$form->{path}/io.pl";
$form->{rowcount}=40;

1;
# end of main



sub add {

  $form->{title} = $locale->text('Add ' . ucfirst $form->{item});

  $form->{callback} = "$form->{script}?action=add&item=$form->{item}&path=$form->{path}&login=$form->{login}&sessionid=$form->{sessionid}";

 # $form->{unit} = ($form->{item} eq 'service') ? $locale->text('hr') : $locale->text('ea');

  &link_part;
  $form->{nextfocus}="partnumber";
  &display_form;
  
}


sub search {

  $form->{title} = $locale->text('Inventory Reports');
  
  $form->header;
  
  print qq|
  <script>
<!--

function stb(){
       parent.document.title ="$form->{title}";
}


// -->
</script>

<body bgcolor=ffffff  onLoad=stb()>

<form method=post action=$form->{script} name=myform>

<table border=1>
<tr><th class=listtop bgcolor=000000><font color=ffffff>$form->{title}</font></th></tr>

<tr valign=top>
<td>
<table>

<tr>
  <td colspan=4>
<input onkeydown='setnextfocus(this)' onfocus='setfocus(this);' name=searchitems class=radio type=radio value=parts checked >&nbsp;|.$locale->text('Parts').qq|
    <input onkeydown='setnextfocus(this)' onfocus='setfocus(this);' name=searchitems class=radio type=radio value=assemblies>&nbsp;|.$locale->text('Assemblies').qq|
    <input onkeydown='setnextfocus(this)' onfocus='setfocus(this);' name=searchitems class=radio type=radio value=services>&nbsp;|.$locale->text('Services').qq|
    <input onkeydown='setnextfocus(this)' onfocus='setfocus(this);' name=searchitems class=radio type=radio value=combo>&nbsp;|.$locale->text('Combo').qq|
<!--
    <input onkeydown='setnextfocus(this)' onfocus='setfocus(this);' name=searchitems class=radio type=radio value="bom">&nbsp;BOM
-->
  </td>
</tr>


<tr>

  <th align=right>|.$locale->text('Number').qq|</th>
  <td colspan=3><input onkeydown='setnextfocus(this)' onfocus='setfocus(this);' name=partnumber size=20></td>

</tr>

<tr>

  <th align=right>|.$locale->text('Description').qq|</th>
  <td colspan=3><input onkeydown='setnextfocus(this)' onfocus='setfocus(this);' name=description size=35></td>

</tr>

<tr>

  <th align=right>|.$locale->text('Make').qq|</th>
  <td><input onkeydown='setnextfocus(this)' onfocus='setfocus(this);' name=make size=20></td>
  
  <th align=right>|.$locale->text('Model').qq|</th>
  <td><input onkeydown='setnextfocus(this)' onfocus='setfocus(this);' name=model size=20></td>

</tr>


  
  |;
  
  #  <input onkeydown='setnextfocus(this)' onfocus='setfocus(this);' name=searchitems class=radio type=radio value=all >&nbsp;|.$locale->text('All').qq|
print qq|
<tr>
  <td colspan=4>
    <input onkeydown='setnextfocus(this)' onfocus='setfocus(this);' name=onhand class=checkbox type=checkbox value=1>&nbsp;|.$locale->text('On Hand').qq|
    <input onkeydown='setnextfocus(this)' onfocus='setfocus(this);' name=short class=checkbox type=checkbox value=1>&nbsp;|.$locale->text('Short').qq|
    <input onkeydown='setnextfocus(this)' onfocus='setfocus(this);' name=obsolete class=checkbox type=checkbox value=1>&nbsp;|.$locale->text('Obsolete').qq|
    <input onkeydown='setnextfocus(this)' onfocus='setfocus(this);' name=not_obsolete class=checkbox type=checkbox value=1>&nbsp;|.$locale->text('Not Obsolete').qq|
    <input onkeydown='setnextfocus(this)' onfocus='setfocus(this);' name=qtygt class=checkbox type=checkbox value=1>&nbsp;|.$locale->text('Qty > 0').qq|
    <input onkeydown='setnextfocus(this)' onfocus='setfocus(this);' name=qtylt class=checkbox type=checkbox value=1>&nbsp;|.$locale->text('Qty <= 0').qq|
    <input onkeydown='setnextfocus(this)' onfocus='setfocus(this);' name=orphaned class=checkbox type=checkbox value=1>&nbsp;|.$locale->text('Orphaned').qq|
  </td>
</tr>


<tr>
  <td colspan=4>
    <input onkeydown='setnextfocus(this)' onfocus='setfocus(this);' name=bought class=checkbox type=checkbox value=1>&nbsp;|.$locale->text('Bought').qq|
    <input onkeydown='setnextfocus(this)' onfocus='setfocus(this);' name=sold class=checkbox type=checkbox value=1>&nbsp;|.$locale->text('Sold').qq|
    <input onkeydown='setnextfocus(this)' onfocus='setfocus(this);' name=adjust class=checkbox type=checkbox value=1>&nbsp;|.$locale->text('Adjust').qq|
    <input onkeydown='setnextfocus(this)' onfocus='setfocus(this);' name=creditnote class=checkbox type=checkbox value=1>&nbsp;|.$locale->text('Credit Note').qq|
    <input onkeydown='setnextfocus(this)' onfocus='setfocus(this);' name=debitnote class=checkbox type=checkbox value=1>&nbsp;|.$locale->text('Debit Note').qq|
    <input onkeydown='setnextfocus(this)' onfocus='setfocus(this);' name=orders class=checkbox type=checkbox value=1>&nbsp;|.$locale->text('Orders').qq|
    <input onkeydown='setnextfocus(this)' onfocus='setfocus(this);' name=otype size=10 value='$form->{otype}' title='Enter the Order Type Separate by semicolon ex. SO;PO;DO'>
    <br><br><b>|.$locale->text('From').qq| </b>
    <input onkeydown='setnextfocus(this)' onfocus='setfocus(this);' name=transdatefrom size=11 title=($myconfig{dateformat}) >
      <link rel="stylesheet" media="screen" href="javascript/dynCalendar.css" />
<script language="javascript" type="text/javascript" src="javascript/browserSniffer.js"></script>
<script language="javascript" type="text/javascript" src="javascript/dynCalendar.js"></script>
 
   <script language="JavaScript" type="text/javascript">
    <!--
        /**
        * Example callback function
        */
        function calendar1Callback(date, month, year)
        {
            document.forms['myform'].transdatefrom.value = formatDate(new Date(getDateFromFormat(year + '-' + month + '-' + date,'yyyy-M-d')),'$myconfig{dateformat}');
        }

        calendar1 = new dynCalendar('calendar1', 'calendar1Callback', 'javascript/images/');
    //-->
    </script>
    <b>&nbsp;|.$locale->text('To').qq|</b>
    <input onkeydown='setnextfocus(this)' onfocus='setfocus(this);' name=transdateto size=11 title=($myconfig{dateformat}) >
        <script language="JavaScript" type="text/javascript">
    <!--
        /**
        * Example callback function
        */
        function calendar1Callback2(date, month, year)
        {
            document.forms['myform'].transdateto.value = formatDate(new Date(getDateFromFormat(year + '-' + month + '-' + date,'yyyy-M-d')),'$myconfig{dateformat}');
        }

        calendar2 = new dynCalendar('calendar2', 'calendar1Callback2', 'javascript/images/');
    //-->
    </script>
   
  </td>
</tr>

<tr>
  <th align=right>|.$locale->text('Include in Report').qq|</th>
  <td colspan=3>
    <input onkeydown='setnextfocus(this)' onfocus='setfocus(this);' name=l_sr class=checkbox type=checkbox value=Y $form->{l_sr}>&nbsp;|.$locale->text('SR').qq|
    <input onkeydown='setnextfocus(this)' onfocus='setfocus(this);' name=l_partnumber class=checkbox type=checkbox value=Y $form->{l_partnumber}>&nbsp;|.$locale->text('Number').qq|
    <input onkeydown='setnextfocus(this)' onfocus='setfocus(this);' name=l_description class=checkbox type=checkbox value=Y $form->{l_description}>&nbsp;|.$locale->text('Description').qq|
    <input onkeydown='setnextfocus(this)' onfocus='setfocus(this);' name=l_bin class=checkbox type=checkbox value=Y $form->{l_bin}>&nbsp;|.$locale->text('Bin').qq|
    <input onkeydown='setnextfocus(this)' onfocus='setfocus(this);' name=l_onhand class=checkbox type=checkbox value=Y $form->{l_onhand}>&nbsp;|.$locale->text('Qty').qq|
    <input onkeydown='setnextfocus(this)' onfocus='setfocus(this);' name=l_rop class=checkbox type=checkbox value=Y $form->{l_rop}>&nbsp;|.$locale->text('ROP').qq|<br>
    <input onkeydown='setnextfocus(this)' onfocus='setfocus(this);' name=l_unit class=checkbox type=checkbox value=Y $form->{l_unit}>&nbsp;|.$locale->text('Unit of measure').qq|
    <input onkeydown='setnextfocus(this)' onfocus='setfocus(this);' name=l_listprice class=checkbox type=checkbox value=Y $form->{l_listprice}>&nbsp;|.$locale->text('List Price').qq|
    <input onkeydown='setnextfocus(this)' onfocus='setfocus(this);' name=l_sellprice class=checkbox type=checkbox value=Y $form->{l_sellprice}>&nbsp;|.$locale->text('Sell Price').qq|
    <input onkeydown='setnextfocus(this)' onfocus='setfocus(this);' name=l_lastcost class=checkbox type=checkbox value=Y $form->{l_lastcost}>&nbsp;|.$locale->text('Last Cost').qq|<br>
    <input onkeydown='setnextfocus(this)' onfocus='setfocus(this);' name=l_priceupdate class=checkbox type=checkbox value=Y $form->{l_priceupdate}>&nbsp;|.$locale->text('Price Updated').qq|
    <input onkeydown='setnextfocus(this)' onfocus='setfocus(this);' name=l_weight class=checkbox type=checkbox value=Y $form->{l_weight}>&nbsp;|.$locale->text('Weight').qq|
    <input onkeydown='setnextfocus(this)' onfocus='setfocus(this);' name=l_linetotal class=checkbox type=checkbox value=Y $form->{l_linetotal}>&nbsp;|.$locale->text('Line Sales Total').qq|
    <input onkeydown='setnextfocus(this)' onfocus='setfocus(this);' name=l_linetotal2 class=checkbox type=checkbox value=Y $form->{l_linetotal2}>&nbsp;|.$locale->text('Line Cost Total').qq|
    <input onkeydown='setnextfocus(this)' onfocus='setfocus(this);' name=l_subtotal class=checkbox type=checkbox value=Y $form->{l_subtotal}>&nbsp;|.$locale->text('Sub Total').qq|
    <input onkeydown='setnextfocus(this)' onfocus='setfocus(this);' name=l_gtotal class=checkbox type=checkbox value=Y $form->{l_gtotal}>&nbsp;|.$locale->text('Grand Total').qq|
  </td>
</tr>

</table>
</td>

</tr>
</table>

<input type=hidden name=readonly value=$form->{readonly}>
<input type=hidden name=rowcount value=$form->{rowcount}>
<input type=hidden name=path value=$form->{path}>
<input type=hidden name=login value=$form->{login}>
<input type=hidden name=sessionid value=$form->{sessionid}>
<input type=hidden name=nextfocus value=$form->{nextfocus}>
<input type=hidden name=sort value=$form->{sort}>

<br>
<input class=submit type=submit name=action value="|.$locale->text('Report').qq|">
<input class=submit type=submit name=action value="|.$locale->text('Print').qq|">
</form>

<p>
|.$locale->text('To display all items, leave fields blank')

.qq|

</body>
</html>
|;

}


sub search_short {

  $form->{title} = $locale->text('Inventory Reports');
  
  $form->header;
  
  print qq|
  <script>
<!--

function stb(){
   parent.document.title ="$form->{title}";
}


// -->
</script>

<body bgcolor=ffffff  onLoad=stb()>

<form method=post action=$form->{script} name=myform>

<table border=1>
<tr><th class=listtop bgcolor=000000><font color=ffffff>$form->{title}</font></th></tr>

<tr valign=top>
<td>
<table>

<tr>
  <td colspan=4>
<input onkeydown='setnextfocus(this)' onfocus='setfocus(this);' name=searchitems class=radio type=radio value=parts checked >&nbsp;|.$locale->text('Parts').qq|
    <input onkeydown='setnextfocus(this)' onfocus='setfocus(this);' name=searchitems class=radio type=radio value=assemblies>&nbsp;|.$locale->text('Assemblies').qq|
    <input onkeydown='setnextfocus(this)' onfocus='setfocus(this);' name=searchitems class=radio type=radio value=services>&nbsp;|.$locale->text('Services').qq|
    <input onkeydown='setnextfocus(this)' onfocus='setfocus(this);' name=searchitems class=radio type=radio value=combo>&nbsp;|.$locale->text('Combo').qq|
<!--
    <input onkeydown='setnextfocus(this)' onfocus='setfocus(this);' name=searchitems class=radio type=radio value="bom">&nbsp;BOM
-->
  </td>
</tr>


<tr>

  <th align=right>|.$locale->text('Number').qq|</th>
  <td colspan=3><input onkeydown='setnextfocus(this)' onfocus='setfocus(this);' name=partnumber size=20></td>

</tr>

<tr>

  <th align=right>|.$locale->text('Description').qq|</th>
  <td colspan=3><input onkeydown='setnextfocus(this)' onfocus='setfocus(this);' name=description size=35></td>

</tr>

<tr>

  <th align=right>|.$locale->text('Make').qq|</th>
  <td><input onkeydown='setnextfocus(this)' onfocus='setfocus(this);' name=make size=20></td>
  
  <th align=right>|.$locale->text('Model').qq|</th>
  <td><input onkeydown='setnextfocus(this)' onfocus='setfocus(this);' name=model size=20></td>

</tr>


  
  |;
  
  #  <input onkeydown='setnextfocus(this)' onfocus='setfocus(this);' name=searchitems class=radio type=radio value=all >&nbsp;|.$locale->text('All').qq|
print qq|
<tr>
  <td colspan=4>
    <input onkeydown='setnextfocus(this)' onfocus='setfocus(this);' name=onhand class=checkbox type=checkbox value=1>&nbsp;|.$locale->text('On Hand').qq|
    <input onkeydown='setnextfocus(this)' onfocus='setfocus(this);' name=short class=checkbox type=checkbox value=1>&nbsp;|.$locale->text('Short').qq|
    <input onkeydown='setnextfocus(this)' onfocus='setfocus(this);' name=obsolete class=checkbox type=checkbox value=1>&nbsp;|.$locale->text('Obsolete').qq|
    <input onkeydown='setnextfocus(this)' onfocus='setfocus(this);' name=not_obsolete class=checkbox type=checkbox value=1>&nbsp;|.$locale->text('Not Obsolete').qq|
    <input onkeydown='setnextfocus(this)' onfocus='setfocus(this);' name=qtygt class=checkbox type=checkbox value=1>&nbsp;|.$locale->text('Qty > 0').qq|
    <input onkeydown='setnextfocus(this)' onfocus='setfocus(this);' name=qtylt class=checkbox type=checkbox value=1>&nbsp;|.$locale->text('Qty <= 0').qq|
    <input onkeydown='setnextfocus(this)' onfocus='setfocus(this);' name=orphaned class=checkbox type=checkbox value=1>&nbsp;|.$locale->text('Orphaned').qq|
  </td>
</tr>
|;

print qq|    <input onkeydown='setnextfocus(this)' onfocus='setfocus(this);' name=l_sr class=checkbox type=hidden value=Y $form->{l_sr}>&nbsp;|if $form->{l_sr};
print qq|    <input onkeydown='setnextfocus(this)' onfocus='setfocus(this);' name=l_partnumber class=checkbox type=hidden value=Y $form->{l_partnumber}>&nbsp;|if $form->{l_partnumber};
print qq|    <input onkeydown='setnextfocus(this)' onfocus='setfocus(this);' name=l_description class=checkbox type=hidden value=Y $form->{l_description}>&nbsp;|if $form->{l_description};
 print qq|   <input onkeydown='setnextfocus(this)' onfocus='setfocus(this);' name=l_bin class=checkbox type=hidden value=Y $form->{l_bin}>&nbsp;|if $form->{l_bin};
print qq|    <input onkeydown='setnextfocus(this)' onfocus='setfocus(this);' name=l_onhand class=checkbox type=hidden value=Y $form->{l_onhand}>&nbsp;| if $form->{l_onhand};
print qq|    <input onkeydown='setnextfocus(this)' onfocus='setfocus(this);' name=l_rop class=checkbox type=hidden value=Y $form->{l_rop}>&nbsp;| if $form->{l_rop};
print qq|    <input onkeydown='setnextfocus(this)' onfocus='setfocus(this);' name=l_unit class=checkbox type=hidden value=Y $form->{l_unit}>&nbsp;| if $form->{l_unit};
print qq|    <input onkeydown='setnextfocus(this)' onfocus='setfocus(this);' name=l_listprice class=checkbox type=hidden value=Y $form->{l_listprice}>&nbsp;| if $form->{l_listprice};
print qq|    <input onkeydown='setnextfocus(this)' onfocus='setfocus(this);' name=l_sellprice class=checkbox type=hidden value=Y $form->{l_sellprice}>&nbsp;|if $form->{l_sellprice};
print qq|    <input onkeydown='setnextfocus(this)' onfocus='setfocus(this);' name=l_lastcost class=checkbox type=hidden value=Y $form->{l_lastcost}>&nbsp;|if $form->{l_lastcost};
print qq|    <input onkeydown='setnextfocus(this)' onfocus='setfocus(this);' name=l_priceupdate class=checkbox type=hidden value=Y $form->{l_priceupdate}>&nbsp;|if $form->{l_priceupdate};
print qq|    <input onkeydown='setnextfocus(this)' onfocus='setfocus(this);' name=l_weight class=checkbox type=hidden value=Y $form->{l_weight}>&nbsp;|if $form->{l_weight};
print qq|    <input onkeydown='setnextfocus(this)' onfocus='setfocus(this);' name=l_linetotal class=checkbox type=hidden value=Y $form->{l_linetotal}>&nbsp;|if $form->{l_linetotal};
print qq|    <input onkeydown='setnextfocus(this)' onfocus='setfocus(this);' name=l_linetotal2 class=checkbox type=hidden value=Y $form->{l_linetotal2}>&nbsp;|if $form->{l_linetotal2};
print qq|    <input onkeydown='setnextfocus(this)' onfocus='setfocus(this);' name=l_subtotal class=checkbox type=hidden value=Y $form->{l_subtotal}>&nbsp;|if $form->{l_subtotal};
print qq|    <input onkeydown='setnextfocus(this)' onfocus='setfocus(this);' name=l_gtotal class=checkbox type=hidden value=Y $form->{l_gtotal}>&nbsp;|if $form->{l_gtotal};

print qq|
</table>
</td>

</tr>
</table>

<input type=hidden name=readonly value=$form->{readonly}>
<input type=hidden name=rowcount value=$form->{rowcount}>
<input type=hidden name=path value=$form->{path}>
<input type=hidden name=login value=$form->{login}>
<input type=hidden name=sessionid value=$form->{sessionid}>
<input type=hidden name=nextfocus value=$form->{nextfocus}>
<input type=hidden name=sort value=$form->{sort}>

<br>
<input class=submit type=submit name=action value="|.$locale->text('Report').qq|">
<input class=submit type=submit name=action value="|.$locale->text('Print').qq|">
<input class=submit type=submit name=action value="|.$locale->text('More').qq|">
</form>

<p>
|.$locale->text('To display all items, leave fields blank')

.qq|

</body>
</html>
|;

}

sub more{
   @columns = qw( partnumber description invnumber transdate number name bin lastcost listprice sellprice onhand   rop unit  linetotal  linetotal2 priceupdate weight );
   map { $form->{"l_$_"} = "checked" if $form->{"l_$_"} eq "Y" } @columns;

 &search;
}

sub report{
 &generate_report;

}

sub print{
 &generate_report_print;

}


sub generate_report_print {
 $form->{print}="true";
 &generate_report1;
}

sub generate_report {
	&generate_report1;
}


sub sortheading {
 	print qq|<tr>
	<td $listprint colspan=$colspan><br><b>$column_title{"$form->{sort}"} :</b>$ref->{"$form->{sort}"}
|;
if($form->{sort} eq "number"){
 	  print qq|
	  	&nbsp;&nbsp;&nbsp;&nbsp;<b>$column_title{"name"} :</b>$ref->{name}|;
  }
 	print qq|
	</td>
	</tr>
|;

	
}


sub generate_report1 {
  map { $form->{$_} = $myconfig{$_} } (qw(company address businessnumber nativecurr fy));
 if(!$form->{print}){
    $listheading="class=listheading";
    $listheadingcolor="color=ffffff";
    $listtop="class=listtop";
    $listrow="class=listrow";
    $listtotal="class=listtotal";
    $listsubtotal="class=listsubtotal";
    $lastline=$locale->text('Click on "Number" to edit');
     $mouseaction[0]=" onmouseover=\"this.className = 'listover';\" onmouseout=\"this.className = 'listrow0';\"";
    $mouseaction[1]=" onmouseover=\"this.className = 'listover';\" onmouseout=\"this.className = 'listrow1';\"";
     }else{
    $line = "<hr size=2 noshade>";
    $fontsize="size=-1";
   $listprint="class=print";
   $listheading="class=print";
    $listtop="class=print";
    $listrow="class=print";
    $listsubtotal="class=print";
 }

  # setup $form->{sort}
  unless ($form->{sort}) {
    if ($form->{description} && !($form->{partnumber})) {
      $form->{sort} = "description";
    } else {
      $form->{sort} = "partnumber";
    }
  }
  
  $callback = "$form->{script}?action=generate_report&path=$form->{path}&login=$form->{login}&sessionid=$form->{sessionid}&showreport=true&searchitems=$form->{searchitems}&print=$form->{print}&rowcount=$form->{rowcount}&readonly=$form->{readonly}";

  IC->all_parts(\%myconfig, \%$form);


  if ($form->{searchitems} eq 'all') {
    $option = $locale->text('All')." : ";
  } else {
    $option = ucfirst $form->{searchitems};
    $option = $locale->text($option)." : ";
  }


  if ($form->{obsolete}) {
    $callback .= "&obsolete=$form->{obsolete}";
    $option .= $locale->text('Obsolete')." : ";
  }
  if ($form->{not_obsolete}) {
    $callback .= "&not_obsolete=$form->{not_obsolete}";
    $option .= $locale->text('NOT Obsolete')." : ";
  }
  if ($form->{qtygt}) {
    $callback .= "&qtygt=$form->{qtygt}";
    $option .= $locale->text('Quantity > 0')." : ";
  }
  if ($form->{qtylt}) {
    $callback .= "&qtylt=$form->{qtylt}";
    $option .= $locale->text('Quantity <= 0')." : ";
  }
  if ($form->{orphaned}) {
    $callback .= "&orphaned=$form->{orphaned}";
    $option .= $locale->text('Orphaned')." : ";
  }
  if ($form->{bought}) {
    $callback .= "&bought=$form->{bought}";
    $option .= $locale->text('Bought')." : ";
  }
  if ($form->{sold}) {
    $callback .= "&sold=$form->{sold}";
    $option .= $locale->text('Sold')." : ";
  }
  if ($form->{adjust}) {
    $callback .= "&adjust=$form->{adjust}";
    $option .= $locale->text('Adjust')." : ";
  }
  if ($form->{creditnote}) {
    $callback .= "&creditnote=$form->{creditnote}";
    $option .= $locale->text('Credit Note')." : ";
  }
  if ($form->{debitnote}) {
    $callback .= "&debitnote=$form->{debitnote}";
    $option .= $locale->text('Debit Note')." : ";
  }
  if ($form->{orders}) {
    $callback .= "&orders=$form->{orders}";
    $option .= $locale->text('Orders')." : ";
	  if ($form->{otype}) {
	    $callback .= "&otype=$form->{otype}";
	    $option .= $form->{otype}." : ";
	    
	  }
    
  }
  if ($form->{bought} || $form->{sold} || $form->{adjust}|| $form->{creditnote}|| $form->{orders}) {
    if ($form->{transdatefrom}) {
      $callback .= "&transdatefrom=$form->{transdatefrom}";
      $option .= "\n<br>".$locale->text('From')."&nbsp;".$locale->date(\%myconfig, $form->{transdatefrom}, 1);
    }
    if ($form->{transdateto}) {
      $callback .= "&transdateto=$form->{transdateto}";
      $option .= "\n<br>".$locale->text('To')."&nbsp;".$locale->date(\%myconfig, $form->{transdateto}, 1);
    }
  }

  $option .= "<br>";
    if ($form->{vendorno} && $form->{vendorno} ne 'All Vendor') {
    $callback .= "&vendorno=".$form->escape($form->{vendorno});
    $option .= $locale->text('Vendor')." : $form->{vendorno}<Br>";
  }elsif ($form->{customerno}&& $form->{customerno} ne 'All Customer') {
    $callback .= "&customerno=".$form->escape($form->{customerno});
    $option .= $locale->text('Customer')." : $form->{customerno}<br>";
  }
  if ($form->{partnumber}) {
    $callback .= "&partnumber=".$form->escape($form->{partnumber})."";
    $option .= $locale->text('Number').qq| : $form->{partnumber}<br>|;
  }
  if ($form->{description}) {
    $callback .= "&description=".$form->escape($form->{description})."";
    $option .= $locale->text('Description').qq| : $form->{description}<br>|;
  }
  if ($form->{make}) {
    $callback .= "&make=$form->{make}";
    $option .= $locale->text('Make').qq| : $form->{make}<br>|;
  }
  if ($form->{model}) {
    $callback .= "&model=$form->{model}";
    $option .= $locale->text('Model').qq| : $form->{model}<br>|;
  }

  if ($form->{searchitems} eq 'onhand' || $form->{searchitems} eq 'short') {
    # turn on onhand
    $form->{l_onhand} = "Y";
  }
  
  @columns = $form->sort_columns(qw( partnumber description invnumber transdate number name bin lastcost listprice sellprice onhand   rop unit  linetotal  linetotal2 priceupdate weight ));

  if ($form->{searchitems} eq 'services') {
    # remove bin, weight and rop from list
    map { $form->{"l_$_"} = "" } qw(bin weight rop);

    # qty is irrelevant unless bought or sold
    unless ($form->{bought} || $form->{sold}) {
      $form->{l_onhand} = "";
      $form->{l_linetotal} = "";
    }
  }

  if ($form->{bought} || $form->{sold} || $form->{adjust} || $form->{creditnote} || $form->{debitnote}|| $form->{orders}) {
    # add invnumber
    $form->{l_invnumber} = "Y" unless ($form->{l_invnumber});
    $form->{l_transdate} = "Y" unless ($form->{l_transdate});
    $form->{l_number} = "Y" unless ($form->{l_number});
    $form->{l_name} = "Y" unless ($form->{l_name});
  $form->{boughtandsold} = 1;
    # change quantity field to Bought and Sold
    $form->{l_bought} = $form->{l_sold} = $form->{l_balance}="Y";
    @columns = $form->sort_columns(qw(partnumber description invnumber transdate number name bin bought sold balance rop unit listprice sellprice linetotal  lastcost linetotal2 priceupdate weight ));
  }
#  if ($form->{bought} && $form->{sold}) {
  #  $form->{boughtandsold} = 1;
    # change quantity field to Bought and Sold
#    $form->{l_bought} = $form->{l_sold} = $form->{l_balance}="Y";
#    @columns = $form->sort_columns(qw(partnumber description bin bought sold balance rop unit listprice sellprice linetotal lastcost priceupdate weight invnumber transdate number name));
#  }
#  if ($form->{adjust} && $form->{sold}) {
#    $form->{boughtandsold} = 1;
#    # change quantity field to Bought and Sold
#    $form->{l_bought} = $form->{l_sold} = $form->{l_balance}="Y";
#    @columns = $form->sort_columns(qw(partnumber description bin bought sold balance rop unit listprice sellprice linetotal lastcost priceupdate weight invnumber transdate number name));
#  }
#    if ($form->{bought} && $form->{adjust}) {
#    $form->{boughtandsold} = 1;
#    # change quantity field to Bought and Sold
#    $form->{l_bought} = $form->{l_sold} = $form->{l_balance}="Y";
 #   @columns = $form->sort_columns(qw(partnumber description bin bought sold balance rop unit listprice sellprice linetotal lastcost priceupdate weight invnumber transdate number name));
#  }
  $form->{l_lastcost} = "" if ($form->{searchitems} eq 'assemblies');
  
  foreach $item (@columns) {
    if ($form->{"l_$item"} eq "Y") {
      push @column_index, $item;

      # add column to callback
      $callback .= "&l_$item=Y";
    }
  }
  if ($form->{"l_gtotal"} eq "Y") {
 
      # add column to callback
      $callback .= "&l_gtotal=Y";
    }
  if ($form->{"l_subtotal"} eq "Y") {
 
      # add column to callback
      $callback .= "&l_subtotal=Y";
        @column_index = grep !/$form->{sort}/, @column_index;
  
    if($form->{sort} eq "number"){
  @column_index = grep !/name/, @column_index;	  
  }
  
    }
    $column_title{sr} =  $locale->text('SR');
    $column_title{partnumber} =  $locale->text('Number');
    $column_title{description} =  $locale->text('Description');
    $column_title{bin} =  $locale->text('Bin');
    $column_title{priceupdate} =  $locale->text('Price Updated');
    $column_title{onhand} =  $locale->text('Qty');
    $column_title{bought} =  $locale->text('In');
    $column_title{sold} =  $locale->text('Out');
    $column_title{balance} =  $locale->text('Balance');
    $column_title{unit} =  $locale->text('Unit');
    $column_title{listprice} =  $locale->text('List Price');
    $column_title{lastcost} =  $locale->text('Last Cost');
    $column_title{rop} =  $locale->text('ROP');
    $column_title{weight} =  $locale->text('Weight');
    $column_title{invnumber} =  $locale->text('Ref. Number');
    $column_title{number} =  $locale->text('Acc No');
    $column_title{name} =  $locale->text('Name');
    $column_title{sellprice} =  $locale->text('Unit Price');
    $column_title{transdate} =  $locale->text('Date');
    $column_title{linetotal} =  $locale->text('Total Sales');
    $column_title{linetotal2} =  $locale->text('Total Cost');
    
  $column_header{sr} = qq|<th $listprint>|.$$column_title{sr}.qq|$line</th>|;
  $column_header{partnumber} = qq|<th $listprint><a $listheading href=$callback&sort=partnumber>|.$column_title{partnumber}.qq|$line</a></th>|;
  $column_header{description} = qq|<th $listprint><a $listheading href=$callback&sort=description>|.$column_title{description}.qq|$line</a></th>|;
  $column_header{bin} = qq|<th $listprint><a $listheading href=$callback&sort=bin>|.$column_title{bin}.qq|$line</a></th>|;
  $column_header{priceupdate} = qq|<th $listprint><a $listheading href=$callback&sort=priceupdate>|.$column_title{priceupdate}.qq|$line</a></th>|;
  $column_header{onhand} = qq|<th $listprint>|.$$column_title{onhand}.qq|$line</th>|;
  $column_header{bought} = qq|<th $listprint>|.$column_title{bought}.qq|$line</th>|;
  $column_header{sold} = qq|<th $listprint>|.$column_title{sold}.qq|$line</th>|;
  $column_header{balance} = qq|<th $listprint>|.$column_title{balance}.qq|$line</th>|;
  $column_header{unit} = qq|<th $listprint>|.$column_title{unit}.qq|$line</th>|;
  $column_header{listprice} = qq|<th $listprint>|.$column_title{listprice}.qq|$line</th>|;
  $column_header{lastcost} = qq|<th $listprint>|.$column_title{lastcost}.qq|$line</th>|;
  $column_header{rop} = qq|<th $listprint>|.$$column_title{rop}.qq|$line</th>|;
  $column_header{weight} = qq|<th $listprint>|.$column_title{weight}.qq|$line</th>|;
  $column_header{invnumber} = qq|<th $listprint><a $listheading href=$callback&sort=invnumber>|.$column_title{invnumber}.qq|$line</a></th>|;
  $column_header{number} = qq|<th $listprint><a $listheading href=$callback&sort=number>|.$column_title{number}.qq|$line</a></th>|;
  $column_header{name} = qq|<th $listprint><a $listheading href=$callback&sort=name>|.$column_title{name}.qq|$line</a></th>|;
  $column_header{sellprice} = qq|<th $listprint>|.$column_title{sellprice}.qq|$line</th>|;
  $column_header{transdate} = qq|<th $listprint><a $listheading href=$callback&sort=transdate>|.$column_title{transdate}.qq|$line</a></th>|;
  $column_header{linetotal} = qq|<th $listprint>|.$column_title{linetotal}.qq|$line</th>|;
    $column_header{linetotal2} = qq|<th $listprint>|.$column_title{linetotal2}.qq|$line</th>|;
  
    if ($form->{"l_sr"} eq "Y") {
      unshift (@column_index, "sr") ;

      # add column to callback
      $callback .= "&l_sr=Y";
    }
   

      
  $form->{title} = $locale->text('Inventory');
  
  $form->header;
  $colspan = $#column_index + 1;

  print qq|
<body bgcolor=ffffff>

<p  $listprint>F/Y : $form->{fy}</p>
<H1  $listprint  align=center >$form->{company}<br>$form->{title}</h1>

<table $listprint border=0 width=100%>

<tr><td $listprint colspan=$colspan>$option</td></tr>

  <tr $listheading >
|;

  map { print "\n$column_header{$_}" } @column_index;
  
  print qq|
  </tr>
  |;

  if (@{ $form->{parts} }) {
    $sameitem = $form->{parts}->[0]->{$form->{sort}};
  }
	
  
  # add order to callback and escape
  $callback = $form->escape($callback . "&sort=$form->{sort}");


  foreach $ref (@{ $form->{parts} }) {
	  if(!$stopprintheading){
		  if ($form->{l_subtotal} eq 'Y') {
				 &sortheading;
		  }
		$stopprintheading="true";
	  }

	  
	  if ($form->{l_subtotal} eq 'Y') {
      if ($sameitem ne $ref->{$form->{sort}}) {
	&ic_subtotal;
	 &sortheading;

      }
    }

    if ($ref->{onhand} < 0) {
	    $boughttotal+=$ref->{onhand};
	    $boughtsubtotal+=$ref->{onhand};
	    $balance +=$ref->{onhand};
      $column_data{onhand} = "<td  $listprint align=right>".$form->format_amount(\%myconfig, $ref->{onhand}, 0, "&nbsp;")."</td>";
      $column_data{bought} = "<td $listprint align=right>".$form->format_amount(\%myconfig, $ref->{onhand} * -1, 0, "&nbsp;")."</td>";
      $column_data{sold} = "<td $listprint>&nbsp;</td>";
      $column_data{balance} = "<td $listprint align=right>".$form->format_amount(\%myconfig, $balance *-1, 0, "&nbsp;")."</td>";

      if ($ref->{module} eq 'is') {
	$column_data{sold} = $column_data{onhand};
	$column_data{bought} = "<td $listprint>&nbsp;</td>";
      }
    } else {
	    $soldtotal+=$ref->{onhand};
	    $soldsubtotal+=$ref->{onhand};
	    $balance +=$ref->{onhand};
      $column_data{sold} = $column_data{onhand} = "<td $listprint align=right>".$form->format_amount(\%myconfig, $ref->{onhand}, 0, "&nbsp;")."</td>";
      $column_data{bought} = "<td $listprint>&nbsp;</td>";
      $column_data{balance} = "<td $listprint align=right>".$form->format_amount(\%myconfig, $balance*-1, 0, "&nbsp;")."</td>";

      if ($ref->{module} eq 'ir') {
	$column_data{sold} = "<td $listprint>&nbsp;</td>";
	$column_data{bought} = "<td $listprint align=right>".$form->format_amount(\%myconfig, $ref->{onhand} * -1, 1, "&nbsp;")."</td>";
      }
    }

    $ref->{onhand} *= -1 if $form->{boughtandsold};
    
    $column_data{sellprice} = "<td $listprint align=right>".$form->format_amount(\%myconfig, $ref->{sellprice}, 2, "&nbsp;") . "</td>";
    $column_data{listprice} = "<td $listprint align=right>".$form->format_amount(\%myconfig, $ref->{listprice}, 2, "&nbsp;") . "</td>";
    $column_data{lastcost} = "<td $listprint align=right>".$form->format_amount(\%myconfig, $ref->{lastcost}, 2, "&nbsp;") . "</td>";
    $column_data{linetotal} = "<td $listprint align=right>".$form->format_amount(\%myconfig, $ref->{onhand} * $ref->{sellprice}, 2, "&nbsp;")."</td>";
    $total += $ref->{onhand} * $ref->{sellprice};
    $column_data{linetotal2} = "<td $listprint align=right>".$form->format_amount(\%myconfig, $ref->{onhand} * $ref->{lastcost}, 2, "&nbsp;")."</td>";
    $total2 += $ref->{onhand} * $ref->{lastcost};
 #   $gtotal = $gtotal+ $total;
    
    
    $column_data{sr} = "<td $listprint>".++$j."&nbsp;</td>";
   $column_data{rop} = "<td $listprint align=right>".$form->format_amount(\%myconfig, $ref->{rop}, -1, "&nbsp;")."</td>";
    $column_data{weight} = "<td $listprint align=right>".$form->format_amount(\%myconfig, $ref->{weight}, -1, "&nbsp;")."</td>";
    $column_data{unit} = "<td $listprint>$ref->{unit}&nbsp;</td>";
    $column_data{bin} = "<td $listprint>$ref->{bin}&nbsp;</td>";
    $column_data{priceupdate} = "<td $listprint>$ref->{priceupdate}&nbsp;</td>";
    $column_data{partnumber} = "<td $listprint><a  $listprint href=$form->{script}?action=edit&id=$ref->{id}&path=$form->{path}&login=$form->{login}&showreport=true&sessionid=$form->{sessionid}&callback=$callback&readonly=$form->{readonly}&transdateto=$form->{transdateto}&transdatefrom=$form->{transdatefrom}>$ref->{partnumber}&nbsp;</a></td>";
    $column_data{description} = "<td $listprint>$ref->{description}</td>";
    $type="invoice";
    if($ref->{module} eq "adjust"){
	$type="purchase_order";    
    }
       if($ref->{module} eq "creditnote"){
	$type="sales_order";    
    }      
        if($ref->{module} eq "debitnote"){
		   $ref->{module}="creditnote";
	$type="purchase_order";    
    }      
       if($ref->{module} eq "oev"){
		   $ref->{module}="oe";
	$ref->{vc}="vendor";    
    }      
        if($ref->{module} eq "oec"){
		   $ref->{module}="oe";
	$ref->{vc}="customer";    
    }      

    $column_data{invnumber} = "<td $listprint><a  $listprint href=$ref->{module}.pl?action=edit&type=$type&id=$ref->{trans_id}&vc=$ref->{vc}&path=$form->{path}&login=$form->{login}&sessionid=$form->{sessionid}&callback=$callback>$ref->{invnumber}</a></td>";
    $column_data{number} = "<td $listprint>$ref->{number}</td>";
    $column_data{name} = "<td $listprint>$ref->{name}</td>";
    $column_data{transdate} = "<td $listprint>$ref->{transdate}</td>";
    
    $i++; $i %= 2;$r++;
    print "<tr $listrow$i $mouseaction[$i] >";

    map { print "\n$column_data{$_}" } @column_index;

    print qq|
    </tr>
|;


    #pagebreak printing
if($form->{rowcount} && $form->{print} && $form->{rowcount} <= $r){
$pagenum++;
    print "<tr $listrow$i $mouseaction[$i]  >";
if($form->{l_sr}){
	print "<td $listprint >$line&nbsp;</td>";
}
	
#	  map { $column_data{$_} = "<td $listprint >&nbsp;</td>" } @column_index;
 #    map { print "\n$column_data{$_}" } @column_index;

     print qq|
     </tr>
</table>

 <p style="page-break-before: always">F/Y : $form->{fy}</p>
<H1  $listprint align=center >$form->{company}<br>$form->{title}</h1>
<table  $listprint border=0 width=100%>

<tr $listheading >|;
if($form->{l_sr}){
	print "<th $listprint ><font $listheadingcolor>".$locale->text('SR')."$line</font></th>";
}
map { print "\n$column_header{$_}" } @column_index;

print qq|
</tr><tr>
|;
if($form->{l_sr}){
	print "<td $listprint >&nbsp;</td>";
}

 #	  map { $column_data{$_} = "<td $listprint >&nbsp;</td>" } @column_index;
 #   map { print "\n$column_data{$_}" } @column_index;
print qq|
</tr>
|;
$r=0;

}

  }
    if ($form->{l_subtotal} eq 'Y') {
    &ic_subtotal;
  }
  if ($form->{"l_linetotal"} && !$form->{boughtandsold}) {
    map { $column_data{$_} = "<td $listprint>&nbsp;</td>" } @column_index;
    $column_data{linetotal} = "<th  $listprint align=right>$line".$form->format_amount(\%myconfig, $total, 2, "&nbsp;")."$line</th>";
   $column_data{linetotal2} = "<th  $listprint align=right>$line".$form->format_amount(\%myconfig, $total2, 2, "&nbsp;")."$line</th>";

    print "<tr $listtotal>";

    map { print "\n$column_data{$_}" } @column_index;

    print qq|</tr>|;
  }
  
  if($form->{"l_gtotal"}){
    print "<tr $listtotal>";
    map { $column_data{$_} = "<td $listprint>&nbsp;</td>" } @column_index;
    $column_data{bought} = "<th  $listprint align=right>$line".$form->format_amount(\%myconfig, ($boughttotal*-1), 2, "&nbsp;")."$line</th>";
    $column_data{sold} = "<th  $listprint align=right>$line".$form->format_amount(\%myconfig, $soldtotal, 2, "&nbsp;")."$line</th>";
   $column_data{linetotal} = "<th  $listprint align=right>$line".$form->format_amount(\%myconfig, $total, 2, "&nbsp;")."$line</th>";
   $column_data{linetotal2} = "<th  $listprint align=right>$line".$form->format_amount(\%myconfig, $total2, 2, "&nbsp;")."$line</th>";
   map { print "\n$column_data{$_}" } @column_index;
    print qq|</tr>|;
	  
  }

  print qq|
</table>

<p>|.$lastline

.qq|

</body>
</html>
|;

}

sub ic_subtotal {

  map { $column_data{$_} = "<th>&nbsp;</th>" } @column_index;

   $column_data{bought} = "<th  $listprint align=right>$line".$form->format_amount(\%myconfig, ($boughtsubtotal*-1), 2, "&nbsp;")."</th>";
 $column_data{sold} = "<th  $listprint align=right>$line".$form->format_amount(\%myconfig, $soldsubtotal, 2, "&nbsp;")."</th>";

  $boughtsubtotal = 0;
  $soldsubtotal = 0;

  $sameitem = $ref->{$form->{sort}};

  print "<tr $listsubtotal >";
   if($form->{l_sr}){

    	print "<td  $listprint >&nbsp;</td>";
    }
  map { print "\n$column_data{$_}" } @column_index;

print "
</tr>";
}

sub edit {


  IC->get_part(\%myconfig, \%$form);

  $form->{title} = $locale->text('Edit '.ucfirst $form->{item});
  &link_part;
  $form->{nextfocus}="partnumber";

  &display_form;
  
}



sub link_part {

  IC->create_links("IC", \%myconfig, \%$form);

  # parts and assemblies have the same links
  $item = $form->{item};
  if ($form->{item} eq 'assembly' || $form->{item} eq 'combo') {
    $item = 'part';
  }
  
  # build the popup menus
  $form->{taxaccounts} = "";
  foreach $key (keys %{ $form->{IC_links} }) {
    foreach $ref (@{ $form->{IC_links}{$key} }) {
      # if this is a tax field
      if ($key =~ /IC_tax/) {
	if ($key =~ /$item/) {
	  $form->{taxaccounts} .= "$ref->{accno} ";
	  $form->{"IC_tax_$ref->{accno}_description"} = "$ref->{accno}--$ref->{description}";
	  
	  if ($form->{id}) {
	    if ($form->{amount}{$ref->{accno}}) {
	      $form->{"IC_tax_$ref->{accno}"} = "checked";
	    }
	  } else {
	    $form->{"IC_tax_$ref->{accno}"} = "checked";
	  }
	}
      } else {
	$form->{"select$key"} .= "<option>$ref->{accno}--$ref->{description}\n";
	if ($form->{amount}{$ref->{accno}}) {
	  $form->{$key} = "$ref->{accno}--$ref->{description}";
	}
	
      }
    }
  }
  chop $form->{taxaccounts};

  if (($form->{item} eq "part") || ($form->{item} eq "assembly" || $form->{item} eq 'combo')) {
    $form->{selectIC_income} = $form->{selectIC_sale};
    $form->{selectIC_expense} = $form->{selectIC_cogs};
    $form->{IC_income} = $form->{IC_sale};
    $form->{IC_expense} = $form->{IC_cogs};
  }
  
  delete $form->{IC_links};
  delete $form->{amount};

}


sub form_header {
 $form->{taxincluded}= "checked" if $form->{taxincluded};
  $form->{"taxaccounts"} = $form->unescape($form->{"taxaccounts"});

  ($dec) = ($form->{sellprice} =~ /\.(\d+)/);
  $dec = length $dec;
  my $decimalplaces = ($dec > 2) ? $dec : 2;

  $form->{listprice} = $form->format_amount(\%myconfig, $form->{listprice}, $decimalplaces);
  $form->{sellprice} = $form->format_amount(\%myconfig, $form->{sellprice}, $decimalplaces);
$form->{avgcost} = $form->format_amount(\%myconfig, $form->{avgcost}, $decimalplaces);

  ($dec) = ($form->{lastcost} =~ /\.(\d+)/);
  $dec = length $dec;
  my $decimalplaces = ($dec > 2) ? $dec : 2;

  $form->{lastcost} = $form->format_amount(\%myconfig, $form->{lastcost}, $decimalplaces);

  foreach $item (qw(partnumber description unit notes)) {
    $form->{$item} =~ s/"/&quot;/g;
  }

  if (($rows = $form->numtextrows($form->{notes}, 40)) < 2) {
    $rows = 2;
  }
  $notes = qq|<textarea name=notes rows=$rows cols=40 wrap=soft>$form->{notes}</textarea>|;

  if (($rows = $form->numtextrows($form->{description}, 40)) > 1) {
    $description = qq|<textarea name="description" rows=$rows cols=40 wrap=soft>$form->{description}</textarea>|;
  } else {
    $description = qq|<input onkeydown='setnextfocus(this)' onfocus='setfocus(this);' name=description size=40 value="$form->{description}">|;
  }
  
  foreach $item (split / /, $form->{taxaccounts}) {
    $form->{"IC_tax_$item"} = ($form->{"IC_tax_$item"}) ? "checked" : "";
  }

  # set option
  foreach $item (qw(IC IC_income IC_expense)) {
    $form->{"$item"} = $form->unescape($form->{"$item"});
  $form->{"select$item"} = $form->unescape($form->{"select$item"});
   $form->{"select$item"} =~ s/ selected//;
    $form->{"select$item"} =~ s/option>\Q$form->{$item}\E/option selected>$form->{$item}/;
  }

  # tax fields
  foreach $item (split / /, $form->{taxaccounts}) {
     $form->{"IC_tax_${item}_description"} = $form->unescape($form->{"IC_tax_${item}_description"});
   $tax .= qq|<input  onkeydown='setnextfocus(this)' onfocus='setfocus(this);' class=checkbox type=checkbox name="IC_tax_$item" value=1 $form->{"IC_tax_$item"}>&nbsp;<b>$form->{"IC_tax_${item}_description"}</b>
               <br><input type=hidden name=IC_tax_${item}_description value="$form->{"IC_tax_${item}_description"}">
|;
  }

  $form->{obsolete} = ($form->{obsolete}) ? "checked" : "";
  

  if ($form->{item} eq "part") {

    $linkaccounts = qq|
<table>
  <tr>

  <th align=right>|.$locale->text('Inventory').qq|</th>
  <td><select  onkeypress="selectKeyPress();" onkeydown="setsubmit(this);selectKeyDown();" onblur="clr();" onfocus="clr();"  name=IC>$form->{selectIC}</select></td>

<input onkeydown='setnextfocus(this)' onfocus='setfocus(this);' name=selectIC type=hidden value="$form->{selectIC}">

  </tr>

  <tr>

  <th align=right>|.$locale->text('Sales').qq|</th>
  <td><select  onkeypress="selectKeyPress();" onkeydown="setsubmit(this);selectKeyDown();" onblur="clr();" onfocus="clr();"  name=IC_income>$form->{selectIC_income}</select></td>

<input onkeydown='setnextfocus(this)' onfocus='setfocus(this);' name=selectIC_income type=hidden value="$form->{selectIC_income}">

  </tr>

  <tr>

  <th align=right>|.$locale->text('COGS').qq|</th>
  <td><select  onkeypress="selectKeyPress();" onkeydown="setsubmit(this);selectKeyDown();" onblur="clr();" onfocus="clr();"  name=IC_expense>$form->{selectIC_expense}</select></td>

<input onkeydown='setnextfocus(this)' onfocus='setfocus(this);' name=selectIC_expense type=hidden value="$form->{selectIC_expense}">

  </tr>|;
  
  if ($tax) {
    $linkaccounts .= qq|<tr>
      <th align=right>|.$locale->text('Tax').qq|</th>
      <td>$tax</td>
      </tr>
        <tr> 
  	<td colspan=2><input onkeydown='setnextfocus(this)' onfocus='setfocus(this);' name=taxincluded type=checkbox class=checkbox value=1 $form->{taxincluded}>&nbsp;<b>|.$locale->text('Tax Included').qq|</b></td>
   </tr>
   |;
  }

  $linkaccounts .= qq|
  </table>
|;


    $weight = qq|<tr>
	      <td>
                 <b>|.$locale->text('Weight').qq|</b>&nbsp;<input onkeydown='setnextfocus(this)' onfocus='setfocus(this);' name=weight size=5 value=|.$form->format_amount(\%myconfig, $form->{weight}).qq|>&nbsp;<b>$form->{weightunit}</b></td>

	      <td>
                 <b>|.$locale->text('On Hand').qq|</b>&nbsp;->&nbsp;|.$form->format_amount(\%myconfig, $form->{onhand}).qq|</td>
  <input type=hidden name=weightunit value=$form->{weightunit}>
</tr>|;
    
    }


  if ($form->{item} eq "assembly" || $form->{item} eq "combo") {
    
    $linkaccounts = qq|
<table>
  <tr>

  <th align=right>|.$locale->text('Sales').qq|</th>
  <td><select  onkeypress="selectKeyPress();" onkeydown="setsubmit(this);selectKeyDown();" onblur="clr();" onfocus="clr();"  name=IC_income>$form->{selectIC_income}</select></td>

<input onkeydown='setnextfocus(this)' onfocus='setfocus(this);' name=selectIC_income type=hidden value="$form->{selectIC_income}">

  </tr>|;
  
  if ($tax) {
    $linkaccounts .= qq|<tr>
      <th align=right>|.$locale->text('Tax').qq|</th>
      <td>$tax</td>
      </tr>
           <tr> 
  	<td colspan=2><input onkeydown='setnextfocus(this)' onfocus='setfocus(this);' name=taxincluded type=checkbox class=checkbox value=1 $form->{taxincluded}>&nbsp;<b>|.$locale->text('Tax Included').qq|</b></td>
   </tr>
   
      |;
  }

  $linkaccounts .= qq|

  </table>
|;


    $weight = qq|<tr>
	      <td><b>|.$locale->text('Weight').qq|</b>&nbsp;|.$form->format_amount(\%myconfig, $form->{weight}).qq|&nbsp;<b>$form->{weightunit}</b></td>
		 
	      <td><b>|.$locale->text('On Hand').qq|</b>&nbsp;|.$form->format_amount(\%myconfig, $form->{onhand}).qq|</td>
	      </tr>
 
<input type=hidden name=weight value=$form->{weight}>
<input type=hidden name=weightunit value=$form->{weightunit}>
|;
	      $weight = "" if $form->{item} eq "combo"; 

  }

 
  if ($form->{item} eq "service") {
    
    $linkaccounts = qq|
<table>
  <tr>

  <th align=right>|.$locale->text('Income').qq|</th>
  <td><select  onkeypress="selectKeyPress();" onkeydown="setsubmit(this);selectKeyDown();" onblur="clr();" onfocus="clr();"  name=IC_income>$form->{selectIC_income}</select></td>

<input onkeydown='setnextfocus(this)' onfocus='setfocus(this);' name=selectIC_income type=hidden value="$form->{selectIC_income}">

  </tr>

  <tr>

  <th align=right>|.$locale->text('Expense').qq|</th>
  <td><select  onkeypress="selectKeyPress();" onkeydown="setsubmit(this);selectKeyDown();" onblur="clr();" onfocus="clr();"  name=IC_expense>$form->{selectIC_expense}</select></td>

<input onkeydown='setnextfocus(this)' onfocus='setfocus(this);' name=selectIC_expense type=hidden value="$form->{selectIC_expense}">

  </tr>|;
  
  if ($tax) {
    $linkaccounts .= qq|<tr>
      <th align=left>|.$locale->text('Tax').qq|<br></th>
      <td>$tax</td>
      </tr>
              <tr> 
  	<td colspan=2><input onkeydown='setnextfocus(this)' onfocus='setfocus(this);' name=taxincluded type=checkbox class=checkbox value=1 $form->{taxincluded}>&nbsp;<b>|.$locale->text('Tax Included').qq|</b></td>
   </tr>

      |;
  }

  $linkaccounts .= qq|
	    
  </table>
|;

  }


  unless ($form->{item} eq 'service') {
    $rop = qq|<b>|.$locale->text('ROP').qq|</b>&nbsp;<input onkeydown='setnextfocus(this)' onfocus='setfocus(this);' name=rop size=5 value=|.$form->format_amount(\%myconfig, $form->{rop}).qq|>

    <br>
	  <b>|.$locale->text('Bin').qq|</b>&nbsp;<input onkeydown='setnextfocus(this)' onfocus='setfocus(this);' name=bin size=10 value=$form->{bin}>|;
	  
  }

  if ($form->{id}) {
    $rop .= qq|<br>
	    <input onkeydown='setnextfocus(this)' onfocus='setfocus(this);' name=obsolete type=checkbox class=checkbox value=1 $form->{obsolete}>&nbsp;<b>|.$locale->text('Obsolete').qq|</b>|;
  }

	
# type=submit $locale->text('Add Part')
# type=submit $locale->text('Add Service')
# type=submit $locale->text('Add Assembly')

# type=submit $locale->text('Edit Part')
# type=submit $locale->text('Edit Service')
# type=submit $locale->text('Edit Assembly')
      $form->{title} = $form->unescape($form->{title});


  $form->header;

  print qq|
  <script>
<!--

function stb(){
        document.myform.$form->{nextfocus}.focus();parent.document.title ="$form->{title}";
}


// -->
</script>

<body bgcolor=ffffff  onLoad=stb()>
<form method=post action=$form->{script} name=myform>

<input onkeydown='setnextfocus(this)' onfocus='setfocus(this);' name=id type=hidden value=$form->{id}>
<input onkeydown='setnextfocus(this)' onfocus='setfocus(this);' name=part_id type=hidden value=$form->{id}>
<input onkeydown='setnextfocus(this)' onfocus='setfocus(this);' name=item type=hidden value=$form->{item}>
<input onkeydown='setnextfocus(this)' onfocus='setfocus(this);' name=title type=hidden value="$form->{title}">

<input onkeydown='setnextfocus(this)' onfocus='setfocus(this);' name=makemodel type=hidden value="$form->{makemodel}">
<input onkeydown='setnextfocus(this)' onfocus='setfocus(this);' name=alternate type=hidden value="$form->{alternate}">
<input onkeydown='setnextfocus(this)' onfocus='setfocus(this);' name=onhand type=hidden value=$form->{onhand}>

<input onkeydown='setnextfocus(this)' onfocus='setfocus(this);' name=taxaccounts type=hidden value="$form->{taxaccounts}">
<input type=hidden name=keys >
<input onkeydown='setnextfocus(this)' onfocus='setfocus(this);' name=rowcount type=hidden value=$form->{rowcount}>
<input type=hidden name=nextfocus value=$form->{nextfocus}>
<input type=hidden name=showreport value=$form->{showreport}>
<input type=hidden name=action value='Update Form'>


<table border=1>
<tr><th class=listtop bgcolor=000000><font color=ffffff>$form->{title}</font></th></tr>

<tr valign=top>
<td>
<table callspacing=0 cellpadding=0>

<tr valign=top>

  <td><b>|.$locale->text('Number').qq|</b>
  <br><input onkeydown='setnextfocus(this)' onfocus='setfocus(this);' name=partnumber size=20 value="$form->{partnumber}"></td>
  <td><b>|.$locale->text('Description').qq|</b>
  <br>$description
  </td>

</tr>

$weight

<tr>

  <td>
         
	 <b>|.$locale->text('Unit of measure').qq|</b>&nbsp;<input onkeydown='setnextfocus(this)' onfocus='setfocus(this);' name=unit size=5 maxsize=5 value="$form->{unit}">
	 
     </td>
     
  <td>
         
	 <b>|.$locale->text('Price Updated').qq|</b>&nbsp;<b>($myconfig{dateformat})</b>&nbsp;<input onkeydown='setnextfocus(this)' onfocus='setfocus(this);' name=priceupdate size=11 value=$form->{priceupdate}>
	 
  </td>

</tr>

<tr>
  <td colspan=2>

      <b>|.$locale->text('List Price').qq|</b>&nbsp;<input onkeydown='setnextfocus(this)' onfocus='setfocus(this);' name=listprice size=9 value=$form->{listprice}>&nbsp;<b>|.$locale->text('Sell Price').qq|</b>&nbsp;<input onkeydown='setnextfocus(this)' onfocus='setfocus(this);' name=sellprice size=9 value=$form->{sellprice}>&nbsp;&nbsp;&nbsp;&nbsp;<b>|.$locale->text('Last Cost').qq|</b>&nbsp;->&nbsp;$form->{lastcost}</td>
    </tr>

<tr valign=top>

  <td>$rop</td>
  <td><b>|.$locale->text('Notes').qq|</b>
  <br>$notes
  </td>

</tr>

<tr>
  <td colspan=2>
  <table><tr>

  <th align=right>|.$locale->text('Link Accounts').qq|</th>
  <td>$linkaccounts</td>

  </table></td>
</tr>
|;

}


sub form_footer {

# type=submit $locale->text('Delete Part')
# type=submit $locale->text('Delete Service')
# type=submit $locale->text('Delete Assembly')
# type=submit $locale->text('Save Part')
# type=submit $locale->text('Save Service')
# type=submit $locale->text('Save Assembly')
  $form->all_vc(\%myconfig, "customer");

  $selectionc = "<option selected>" . $locale->text('All Customers') . "\n";

  foreach $ref (@{ $form->{all_customer} }) {
    $selectionc .= "<option value='$ref->{customernumber}::$ref->{name}--$ref->{id}'>$ref->{customernumber}--$ref->{name}\n";
  }

  $form->all_vc(\%myconfig, "vendor");

  $selectionv = "<option selected>" . $locale->text('All Vendor') . "\n";

  foreach $ref (@{ $form->{all_vendor} }) {
    $selectionv .= "<option value='$ref->{vendornumber}::$ref->{name}--$ref->{id}'>$ref->{vendornumber}--$ref->{name}\n";
  }
  

  if ($form->{item} eq "assembly") {

    print qq|
<tr>
<th  align=right>|.$locale->text('Total Price').qq|</th>
<th align=right>|.$form->format_amount(\%myconfig, $form->{assemblytotal}, 2).qq|</th></tr>


</table>
</td>
</tr>

  <input type=hidden name=assembly_rows value=$form->{assembly_rows}>
|;
  }

   if ($form->{item} eq "combo") {

    print qq|
<tr>
<th colspan=3 align=right>|.$locale->text('Total').qq|</th>
<th align=right>|.$form->format_amount(\%myconfig, $form->{combototal}, 2).qq|</th></tr>

</table>
</td>
</tr>

  <input type=hidden name=combo_rows value=$form->{combo_rows}>
|;
  }

  
  print qq|

<input type=hidden name=path value=$form->{path}>
<input type=hidden name=login value=$form->{login}>
<input type=hidden name=sessionid value=$form->{sessionid}>

<input type=hidden name=callback value="$form->{callback}">
<input type=hidden name=previous_form value="$form->{previous_form}">

|;

if($form->{id}){
@column_bal = qw (transdate qty sellprice);
  $colspan = $#column_bal + 1;
IC->retrieve_allocated(\%myconfig, \%$form);
	print qq|
			<table border=0 width=100%>
			<tr>
				<td class=listtop colspan=$colspan align=center> Quantity Balance </td>
			</tr>

	|;
	
				   $column_data{transdate} = "<td   class=listheading align=right>". $locale->text('Date')."</td>";
				   $column_data{qty} = "<td   class=listheading align=right>". $locale->text('Quantity')."</td>";
					$column_data{sellprice} = "<td   class=listheading align=right>". $locale->text('Cost')."</td>";
					$i++;
					
      print "<tr $listrow$i $mouseaction[$i] >";
	  map { print "\n$column_data{$_}" } @column_bal;

    print qq|
</tr>
|;


	    foreach $ref (@{ $form->{all_allocated} } ) {
		$totalcost+=$ref->{qty}* $ref->{sellprice};
		$totalqty+=$ref->{qty};
				   $column_data{transdate} = "<td   $listprint align=right>". $ref->{transdate}."</td>";
				   $column_data{qty} = "<td   $listprint align=right>". $ref->{qty}."</td>";
					$column_data{sellprice} = "<td   $listprint align=right>". $form->format_amount(\%myconfig,$ref->{sellprice},2)."</td>";
					$i++;$i%=2;
					
      print "<tr class=listrow$i $mouseaction[$i] >";
	  map { print "\n$column_data{$_}" } @column_bal;

    print qq|
</tr>
|;
			}
}
$sellprice = $totalcost/$totalqty if $totalqty !=0;
				   $column_data{transdate} = "<td   $listprint align=right></td>";
				   $column_data{qty} = "<td   $listprint align=right>". $locale->text('Average Cost')."</td>";
					$column_data{sellprice} = "<td   $listprint align=right>". $form->format_amount(\%myconfig,$sellprice,2)."</td>";
      print "<tr class=listtotal $mouseaction[$i] >";
	  map { print "\n$column_data{$_}" } @column_bal;

    print qq|
</tr>
|;


print qq|

</table>
</td>

</tr>
</table>
<br>


<br>
|;
$to_item="";
$to_item = "<input class=submit type=submit name=action value=\"".$locale->text('To Assembly')."\">" if $form->{item} eq "part";
$to_item = "<input class=submit type=submit name=action value=\"".$locale->text('To Part')."\">" if $form->{item} eq "assembly";
$to_item="" if !$form->{id};
#$form->dberror($form->{readonly});
if(!$form->{readonly}){
    print qq|
    <input class=submit type=submit name=action value="|.$locale->text('Update Form').qq|">
    $to_item
|;

  unless ($form->{item} eq "service") {
    print qq|
<input type=hidden name=makemodel_rows value=$form->{makemodel_rows}>
|;
  }
  
  print qq|
<input class=submit type=submit name=action value="|.$locale->text('Save ' . ucfirst $form->{item}).qq|">
|;


  if ($form->{id}) {
    print qq|
    <input class=submit type=submit name=action value="|.$locale->text('Delete '. ucfirst $form->{item}).qq|">
|;
  }

}
 
if($form->{showreport}){
print qq|
<br><br>
<table border=1  cellspacing=0 >

<tr>
<td>

<table border=0  cellspacing=0 >

<tr>
<td colspan=2 align=center class=listtop>
|.$locale->text('History').qq|
</td>  
</tr>


<tr >
<td colspan=2>
    <input onkeydown='setnextfocus(this)' onfocus='setfocus(this);' name=bought class=checkbox type=checkbox value=1 checked>&nbsp;|.$locale->text('Bought').qq|
    <input onkeydown='setnextfocus(this)' onfocus='setfocus(this);' name=sold class=checkbox type=checkbox value=1 checked>&nbsp;|.$locale->text('Sold').qq|
    <input onkeydown='setnextfocus(this)' onfocus='setfocus(this);' name=adjust class=checkbox type=checkbox value=1 checked>&nbsp;|.$locale->text('Adjust').qq|
    <input onkeydown='setnextfocus(this)' onfocus='setfocus(this);' name=creditnote class=checkbox type=checkbox value=1 checked>&nbsp;|.$locale->text('Credit Note').qq|
    <input onkeydown='setnextfocus(this)' onfocus='setfocus(this);' name=debitnote class=checkbox type=checkbox value=1 checked>&nbsp;|.$locale->text('Debit Note').qq|
        <input onkeydown='setnextfocus(this)' onfocus='setfocus(this);' name=orders class=checkbox type=checkbox value=1>&nbsp;|.$locale->text('Orders').qq|
    <input onkeydown='setnextfocus(this)' onfocus='setfocus(this);' name=otype size=10 value='$form->{otype}'>
    <b>&nbsp;&nbsp;&nbsp;<br><b>|.$locale->text('From').qq| ($myconfig{dateformat}) </b>
    <input onkeydown='setnextfocus(this)' onfocus='setfocus(this);' name=transdatefrom size=11 value='$form->{transdatefrom}'>
  <link rel="stylesheet" media="screen" href="javascript/dynCalendar.css" />
<script language="javascript" type="text/javascript" src="javascript/browserSniffer.js"></script>
<script language="javascript" type="text/javascript" src="javascript/dynCalendar.js"></script>
 
   <script language="JavaScript" type="text/javascript">
    <!--
        /**
        * Example callback function
        */
        function calendar1Callback(date, month, year)
        {
            document.forms['myform'].transdatefrom.value = formatDate(new Date(getDateFromFormat(year + '-' + month + '-' + date,'yyyy-M-d')),'$myconfig{dateformat}');
        }

        calendar1 = new dynCalendar('calendar1', 'calendar1Callback', 'javascript/images/');
    //-->
    </script>
    <b>&nbsp;|.$locale->text('To').qq|</b>
    <input onkeydown='setnextfocus(this)' onfocus='setfocus(this);' name=transdateto size=11 value='$form->{transdateto}'>
        <script language="JavaScript" type="text/javascript">
    <!--
        /**
        * Example callback function
        */
        function calendar1Callback2(date, month, year)
        {
            document.forms['myform'].transdateto.value = formatDate(new Date(getDateFromFormat(year + '-' + month + '-' + date,'yyyy-M-d')),'$myconfig{dateformat}');
        }

        calendar2 = new dynCalendar('calendar2', 'calendar1Callback2', 'javascript/images/');
    //-->
    </script>
   
    <input onkeydown='setnextfocus(this)' onfocus='setfocus(this);' name=l_linetotal type=hidden value=Y>
    <input onkeydown='setnextfocus(this)' onfocus='setfocus(this);' name=l_onhand type=hidden value=Y>
    <input onkeydown='setnextfocus(this)' onfocus='setfocus(this);' name=l_unit type=hidden value=Y>
    <input onkeydown='setnextfocus(this)' onfocus='setfocus(this);' name=l_sellprice type=hidden value=Y>
    <input onkeydown='setnextfocus(this)' onfocus='setfocus(this);' name=l_lastcost type=hidden value=Y>
    <input onkeydown='setnextfocus(this)' onfocus='setfocus(this);' name=l_gtotal type=hidden value=Y>
    <input onkeydown='setnextfocus(this)' onfocus='setfocus(this);' name=sort type=hidden value=transdate>
 
</td>

</tr>
<tr>
<th>
|.$locale->text('Customer').qq|
</th>
<td >

<select  onkeypress="selectKeyPress();" onkeydown="setsubmit(this);selectKeyDown();" onblur="clr();" onfocus="clr();"  name=customerno>$selectionc</select>

</td>
</tr>

<tr>
<th>
|.$locale->text('Vendor').qq|
</th>
<td >

<select  onkeypress="selectKeyPress();" onkeydown="setsubmit(this);selectKeyDown();" onblur="clr();" onfocus="clr();"  name=vendorno>$selectionv</select>

</td>
</tr>

<tr>
<td colspan=2>
    <input class=submit type=submit name=action value="|.$locale->text('Generate Report').qq|">
    <input class=submit type=submit name=action value="|.$locale->text('Customer Listing').qq|">
    <input class=submit type=submit name=action value="|.$locale->text('Vendor Listing').qq|">

</td>
</tr>
</table>
</td>
</tr>
</table>
|;
}

print qq|
  
  
  </form>
</body>
</html>
|;

}

sub to_assembly{
	$form->{item}="assembly";
  $form->{title} = $locale->text('Edit ' . ucfirst $form->{item});
	&display_form;
	
}

sub to_part{
	$form->{item}="part";
  $form->{title} = $locale->text('Edit ' . ucfirst $form->{item});
 &link_part;
	&display_form;
	
}

sub customer_listing {
	$form->{callback}="report.pl?action=sales_invoice&login=$form->{login}&path=$form->{path}&sessionid=$form->{sessionid}&readonly=$form->{readonly}&parts_id=$form->{id}&l_invnumber=Y&l_transdate=Y&l_qty=Y&l_price=Y&l_subtotal=Y&l_subtotal1=Y&l_partnumber=Y&l_description=Y&l_customer=Y&l_accno=Y&datefrom=$form->{transdatefrom}&dateto=$form->{transdateto}&sort=accno&customerno=$form->{customerno}";
  $form->redirect;

}
sub vendor_listing {
	$form->{callback}="report.pl?action=vendor_invoice&login=$form->{login}&path=$form->{path}&sessionid=$form->{sessionid}&readonly=$form->{readonly}&parts_id=$form->{id}&l_invnumber=Y&l_transdate=Y&l_qty=Y&l_price=Y&l_subtotal=Y&l_subtotal1=Y&l_partnumber=Y&l_description=Y&l_customer=Y&datefrom=$form->{transdatefrom}&dateto=$form->{transdateto}&l_accno=Y&sort=accno&vendorno=$form->{vendorno}";
  $form->redirect;

}
sub makemodel_row {
  my $i = shift;

  $form->{"make_$i"} =~ s/"/&quot;/g;
  $form->{"model_$i"} =~ s/"/&quot;/g;

  if ($i == 1) {
    print qq|
    <tr>
    <td><b>|.$locale->text('Make').qq|</b>
    <br><input onkeydown='setnextfocus(this)' onfocus='setfocus(this);' name="make_$i" size=20 value="$form->{"make_$i"}"></td>
    <td><b>|.$locale->text('Model').qq|</b>
    <br><input onkeydown='setnextfocus(this)' onfocus='setfocus(this);' name="model_$i" size=40 value="$form->{"model_$i"}"></td>

    </tr>
    |;
  } else {
    print qq|
    <tr>
    <td><input onkeydown='setnextfocus(this)' onfocus='setfocus(this);' name="make_$i" size=20 value="$form->{"make_$i"}"></td>
    <td><input onkeydown='setnextfocus(this)' onfocus='setfocus(this);' name="model_$i" size=40 value="$form->{"model_$i"}"></td>
    </tr>
    |;
  }
}


sub assembly_row {
  my $i = shift;

  $form->{"partnumber_$i"} =~ s/"/&quot;/g;

  @column_index = qw(qty partnumber description total onhand weight);
 
 

  if ($i == 1) {

    if ($form->{previous_form}) {
      $nochange = 1;
    } else {
      # change callback
      $form->{old_callback} = $form->{callback};
      $callback = $form->{callback};
      $form->{callback} = "$form->{script}?action=display_form";

      # delete action
      delete $form->{action};

      $previous_form = "";
      # save form variables in a previous_form variable
      foreach $key (sort keys %$form) {
	# escape ampersands
	$form->{$key} =~ s/&/%26/g;
	$previous_form .= qq|$key=$form->{$key}&|;
      }
      chop $previous_form;
      $previous_form = $form->escape($form->escape($previous_form));
      $form->{callback} = $callback;
    }
    
    $form->{assemblytotal} = 0;
    $form->{weight} = 0;
    
    $column_header{qty} = qq|<th>|.$locale->text('Qty').qq|</th>|;
    $column_header{partnumber} = qq|<th>|.$locale->text('Number').qq|</th>|;
    $column_header{description} = qq|<th>|.$locale->text('Description').qq|</th>|;
    $column_header{total} = qq|<th>|.$locale->text('Amount').qq|</th>|;
    $column_header{onhand} = qq|<th>|.$locale->text('Onhand').qq|</th>|;
    $column_header{weight} = qq|<th>|.$locale->text('Weight').qq|</th>|;
    
    print qq|
<tr class=listheading bgcolor=336666><th colspan=2><font color=ffffff>|.$locale->text('Individual Items').qq|</font></th></tr>

<tr><td colspan=2>
<table>
  <tr>|;

  map { print "\n$column_header{$_}" } @column_index;
  
  print qq|
  </tr>
|;
  }
 $form->{"partnumber_$i"} = $form->unescape($form->{"partnumber_$i"});
 $form->{"description_$i"} = $form->unescape($form->{"description_$i"});

  $linetotal = $form->round_amount($form->{"sellprice_$i"} * $form->{"qty_$i"}, 2);
  $form->{assemblytotal} += $linetotal;
 # $form->{weighttotal} += $form->{"weight_$i"};
   
  $form->{"qty_$i"} = $form->format_amount(\%myconfig, $form->{"qty_$i"});

  $linetotal = $form->format_amount(\%myconfig, $linetotal, 2);

  if (($form->{assembly_rows} >= 1) && ($form->{assembly_rows} == $i)) {

    if ($nochange) {
      map { $column_data{$_} = qq|<td></td>| } qw(qty partnumber description);
    } else {
      
      $column_data{qty} = qq|<td><input onkeydown='setnextfocus(this)' onfocus='setfocus(this);' name="qty_$i" size=5 value="$form->{"qty_$i"}"></td>|;
 	    $column_data{onhand} = qq|<td><input type=hidden  name="onhand_$i" size=5 value="$form->{"onhand_$i"}">$form->{"onhand_$i"}</td>|;
 	    $column_data{weight} = qq|<td><input type=hidden  name="weight_$i" size=5 value="$form->{"weight_$i"}">$form->{"weight_$i"}</td>|;
      $column_data{partnumber} = qq|<td><input onkeydown='setnextfocus(this)' onfocus='setfocus(this);' name="partnumber_$i" size=15 value="$form->{"partnumber_$i"}"></td>|;
      $column_data{description} = qq|<td><input onkeydown='setnextfocus(this)' onfocus='setfocus(this);' name="description_$i" size=30 value="$form->{"description_$i"}"></td>|;
    }

  } else {
    
    if ($form->{previous_form}) {
      $column_data{partnumber} = qq|<td><input type=hidden name="partnumber_$i" value="$form->{"partnumber_$i"}">$form->{"partnumber_$i"}</td>|;
      $column_data{qty} = qq|<td align=right><input type=hidden name="qty_$i" value="$form->{"qty_$i"}">$form->{"qty_$i"}</td>|;
 	    $column_data{onhand} = qq|<td align=right><input type=hidden  name="onhand_$i" size=5 value="$form->{"onhand_$i"}">$form->{"onhand_$i"}</td>|;
 	    $column_data{weight} = qq|<td><input type=hidden  name="weight_$i" size=5 value="$form->{"weight_$i"}">$form->{"weight_$i"}</td>|;
    } else {
      $href = qq|$form->{script}?action=edit&id=$form->{"id_$i"}&path=$form->{path}&login=$form->{login}&sessionid=$form->{sessionid}&rowcount=$i&previous_form=$previous_form|;
      $column_data{partnumber} = qq|<td><input type=hidden name="partnumber_$i" value="$form->{"partnumber_$i"}"><a href=$href>$form->{"partnumber_$i"}</a></td>|;
      $column_data{qty} = qq|<td><input onkeydown='setnextfocus(this)' onfocus='setfocus(this);' name="qty_$i" size=5 value="$form->{"qty_$i"}"></td>|;
 	    $column_data{onhand} = qq|<td align=right><input type=hidden  name="onhand_$i" size=5 value="$form->{"onhand_$i"}">$form->{"onhand_$i"}</td>|;
 	    $column_data{weight} = qq|<td><input type=hidden  name="weight_$i" size=5 value="$form->{"weight_$i"}">$form->{"weight_$i"}</td>|;
    }

    $column_data{description} = qq|<td><input type=hidden name="description_$i" value="$form->{"description_$i"}">$form->{"description_$i"}</td>|;

  }
  
  $column_data{total} = qq|<td align=right>$linetotal</td>|;
  
  print qq|
<tr>|;

  map { print "\n$column_data{$_}" } @column_index;
  
  print qq|
</tr>
  <input type=hidden name="id_$i" value=$form->{"id_$i"}>
  <input type=hidden name="sellprice_$i" value=$form->{"sellprice_$i"}>
  <input type=hidden name="weight_$i" value=$form->{"weight_$i"}>
|;

 
}


sub combo_row {
  my $i = shift;

  $form->{"partnumber_$i"} =~ s/"/&quot;/g;

  @column_index = qw(partnumber description qty delete);
  
  if ($i == 1) {

    if ($form->{previous_form}) {
      $nochange = 1;
    } else {
      # change callback
      $form->{old_callback} = $form->{callback};
      $callback = $form->{callback};
      $form->{callback} = "$form->{script}?action=display_form";

      # delete action
      delete $form->{action};

      $previous_form = "";
      # save form variables in a previous_form variable
      foreach $key (sort keys %$form) {
	# escape ampersands
	$form->{$key} =~ s/&/%26/g;
	$previous_form .= qq|$key=$form->{$key}&|;
      }
      chop $previous_form;
      $previous_form = $form->escape($form->escape($previous_form));
      $form->{callback} = $callback;
    }
    
    $form->{combototal} = 0;
#    $form->{onhand} = 0;
   $form->{weight} = 0;
    
    
    $column_header{qty} = qq|<th>|.$locale->text('Qty').qq|</th>|;
    $column_header{partnumber} = qq|<th>|.$locale->text('Number').qq|</th>|;
    $column_header{description} = qq|<th>|.$locale->text('Description').qq|</th>|;
    $column_header{total} = qq|<th>|.$locale->text('Amount').qq|</th>|;
    $column_header{delete} = qq|<th>|.$locale->text('Delete').qq|</th>|;
    
    print qq|
<tr class=listheading bgcolor=336666><th colspan=2><font color=ffffff>|.$locale->text('Individual Items').qq|</font></th></tr>

<tr><td colspan=2>
<table>
  <tr>|;

  map { print "\n$column_header{$_}" } @column_index;
  
  print qq|
  </tr>
|;
  }
 $form->{"partnumber_$i"} = $form->unescape($form->{"partnumber_$i"});
 $form->{"description_$i"} = $form->unescape($form->{"description_$i"});

  $linetotal = $form->round_amount( $form->{"qty_$i"}, 2);
  $form->{combototal} += $linetotal;

  $form->{"qty_$i"} = $form->format_amount(\%myconfig, $form->{"qty_$i"});

  $linetotal = $form->format_amount(\%myconfig, $linetotal, 2);

  if (($form->{combo_rows} >= 1) && ($form->{combo_rows} == $i)) {

    if ($nochange) {
      map { $column_data{$_} = qq|<td></td>| } qw(qty partnumber description);
    } else {
      
	    $column_data{delete} = qq|<td align=center><input type=checkbox  name="delete_$i"  value="T"></td>|;
 	    $column_data{qty} = qq|<td><input type=hidden  name="qty_$i" size=5 value="$form->{"qty_$i"}">$form->{"qty_$i"}</td>|;
      $column_data{partnumber} = qq|<td><input onkeydown='setnextfocus(this)' onfocus='setfocus(this);' name="partnumber_$i" size=15 value="$form->{"partnumber_$i"}"></td>|;
      $column_data{description} = qq|<td><input onkeydown='setnextfocus(this)' onfocus='setfocus(this);' name="description_$i" size=30 value="$form->{"description_$i"}"></td>|;
    }

  } else {
    
    if ($form->{previous_form}) {
	    $column_data{delete} = qq|<td align=center><input type=checkbox  name="delete_$i"  value="T"></td>|;
      $column_data{partnumber} = qq|<td><input type=hidden name="partnumber_$i" value="$form->{"partnumber_$i"}">$form->{"partnumber_$i"}</td>|;
      $column_data{qty} = qq|<td><input type=hidden name="qty_$i" size=5 value="$form->{"qty_$i"}">$form->{"qty_$i"}</td>|;
    } else {
      $href = qq|$form->{script}?action=edit&id=$form->{"id_$i"}&path=$form->{path}&login=$form->{login}&sessionid=$form->{sessionid}&rowcount=$i&previous_form=$previous_form|;
      $column_data{partnumber} = qq|<td><input type=hidden name="partnumber_$i" value="$form->{"partnumber_$i"}"><a href=$href>$form->{"partnumber_$i"}</a></td>|;
      $column_data{qty} = qq|<td><input type=hidden name="qty_$i" size=5 value="$form->{"qty_$i"}">$form->{"qty_$i"}</td>|;
	    $column_data{delete} = qq|<td align=center><input type=checkbox  name="delete_$i"  value="T"></td>|;
    }

    $column_data{description} = qq|<td><input type=hidden name="description_$i" value="$form->{"description_$i"}">$form->{"description_$i"}</td>|;

  }
  
  $column_data{total} = qq|<td align=right>$linetotal</td>|;
  
  print qq|
<tr>|;

  map { print "\n$column_data{$_}" } @column_index;
  
  print qq|
</tr>
  <input type=hidden name="id_$i" value=$form->{"id_$i"}>
  <input type=hidden name="sellprice_$i" value=$form->{"sellprice_$i"}>
  <input type=hidden name="weight_$i" value=$form->{"weight_$i"}>
|;

 
}


sub update_form {


  if ($form->{item} eq "assembly") {

    $i = $form->{assembly_rows};
    
    # if last row is empty check the form otherwise retrieve item
    if (($form->{"partnumber_$i"} eq "") && ($form->{"description_$i"} eq "")) {
      
      &check_form;
      
    } else {

      IC->assembly_item(\%myconfig, \%$form);

      $rows = scalar @{ $form->{item_list} };
      
      if ($rows) {
	$form->{"qty_$i"} = 1 unless ($form->{"qty_$i"});
	
	if ($rows > 1) {
	  &select_item;
	  exit;
	} else {
	  map { $form->{item_list}[$i]{$_} =~ s/"/&quot;/g } qw(partnumber description);
	  map { $form->{"${_}_$i"} = $form->{item_list}[0]{$_} } keys %{ $form->{item_list}[0] };
	  $form->{assembly_rows}++;

	  &check_form;

	}

      } else {

        $form->{rowcount} = $i;
	$form->{assembly_rows}++;
	
	&new_item;

      }
    }
  }
  
    if ($form->{item} eq "combo") {

    $i = $form->{combo_rows};
    
    # if last row is empty check the form otherwise retrieve item
    if (($form->{"partnumber_$i"} eq "") && ($form->{"description_$i"} eq "")) {
      
      &check_form;
      
    } else {

      IC->assembly_item(\%myconfig, \%$form);

      $rows = scalar @{ $form->{item_list} };
      
      if ($rows) {
	      
       $form->{"qty_$i"} = $form->{item_list}[0]{"onhand"} unless ($form->{"qty_$i"});

	      
  #     $form->dberror($form->{item_list}[$i-1]{"onhand"}."  -   ".$form->{"qty_$i"});

	if ($rows > 1) {
	  &select_item;
	  exit;
	} else {
	  map { $form->{item_list}[$i]{$_} =~ s/"/&quot;/g } qw(partnumber description);
	  map { $form->{"${_}_$i"} = $form->{item_list}[0]{$_} } keys %{ $form->{item_list}[0] };
	  $form->{combo_rows}++;

	  &check_form;

	}

      } else {

        $form->{rowcount} = $i;
	$form->{combo_rows}++;
	
	&new_item;

      }
    }
  }
  
  if ($form->{item} eq "part") {
    &check_form;
  }

  if ($form->{item} eq 'service') {
    map { $form->{$_} = $form->parse_amount(\%myconfig, $form->{$_}) } qw(sellprice listprice);
    
    &form_header;
    &form_footer;
  }

}


sub save_part {
  &save;
}

sub save_service {
  &save;
}

sub save_assembly {
  &save;
}

sub save_combo {
  &save;
}


sub save {

  # check if there is a part number
  $form->isblank("partnumber", $locale->text(ucfirst $form->{item}." Number missing!"));

  if ($form->{obsolete}) {
    $form->error($locale->text("Inventory quantity must be zero before you can set this $form->{item} obsolete!")) if ($form->{onhand});
  }

# expand dynamic strings
# $locale->text('Inventory quantity must be zero before you can set this part obsolete!')
# $locale->text('Inventory quantity must be zero before you can set this assembly obsolete!')
# $locale->text('Part Number missing!')
# $locale->text('Service Number missing!')
# $locale->text('Assembly Number missing!')

  # save part
  $rc = IC->save(\%myconfig, \%$form);

  $parts_id = $form->{id};
  
  # load previous variables
  if ($form->{previous_form}) {
    # save the new form variables before splitting previous_form
    map { $newform{$_} = $form->{$_} } keys %$form;

    $previous_form = $form->unescape($form->{previous_form});
   # $previous_form = $form->unescape($form->{previous_form});
   # $previous_form =~ s/%26/&/g;                  # moved up here for 2.0
    #$previous_form =~ s/%3d/=/g;                  # moved up here for 2.0
     #  $form->dberror($previous_form);

    # don't trample on previous variables
    map { delete $form->{$_} } keys %newform;
  
    # now take it apart and restore original values
  #  foreach $item (split /&/, $previous_form) {
   #   $item = $form->unescape($item);             # added for Apache 2.0
   #   ($key, $value) = split /=/, $item, 2;
   #   $key = $form->unescape($key);               # added for Apache 2.0
   #   $value = $form->unescape($value);           # added for Apache 2.0
   #   $value =~ s/%26/&/g;
   #   $form->{$key} = $value;
   # }
   #$form->dberror($previous_form);
  #$form->dberror($previous_form);
   foreach $item (split /&/, $previous_form) {
      ($key, $value) = split /=/, $item, 2;
      $value =~ s/%26/&/g;
   #   $value = $form->escape($form->{$key}, 1);
      $form->{$key} = $value;
    }
  # $form->dberror($form->{item});


    if ($form->{item} eq 'assembly') {

      # undo number formatting
      map { $form->{$_} = $form->parse_amount(\%myconfig, $form->{$_}) } qw(weight listprice sellprice rop);

      $form->{assembly_rows}--;
      $i =   $form->{assembly_rows};
      $form->{"qty_$i"} = 1 unless ($form->{"qty_$i"});
#$form->dberror($query);
      $form->{sellprice} -= $form->{"sellprice_$i"} * $form->{"qty_$i"};
      $form->{weight} -= $form->{"weight_$i"} * $form->{"qty_$i"};
      
      # change/add values for assembly item
      map { $form->{"${_}_$i"} = $newform{$_} } qw(partnumber description bin unit weight listprice sellprice inventory_accno income_accno expense_accno);
      
      $form->{sellprice} += $form->{"sellprice_$i"} * $form->{"qty_$i"};
      $form->{weight} += $form->{"weight_$i"} * $form->{"qty_$i"};
 #        $form->dberror($i);
#

    }    elsif ($form->{item} eq 'combo') {

      # undo number formatting
      map { $form->{$_} = $form->parse_amount(\%myconfig, $form->{$_}) } qw(weight listprice sellprice rop);

      $form->{combo_rows}--;
    #  $i = $newform{rowcount};
          $i =   $form->{combo_rows};

      $form->{"qty_$i"} = 1 unless ($form->{"qty_$i"});

      $form->{sellprice} -= $form->{"sellprice_$i"} * $form->{"qty_$i"};
      $form->{weight} -= $form->{"weight_$i"} * $form->{"qty_$i"};
      
      # change/add values for assembly item
      map { $form->{"${_}_$i"} = $newform{$_} } qw(partnumber description bin unit weight listprice sellprice inventory_accno income_accno expense_accno);
      
      $form->{sellprice} += $form->{"sellprice_$i"} * $form->{"qty_$i"};
      $form->{weight} += $form->{"weight_$i"} * $form->{"qty_$i"};

    } else {
      # set values for last invoice/order item
      $i = $form->{rowcount};
      $form->{"qty_$i"} = 1 unless ($form->{"qty_$i"});

      map { $form->{"${_}_$i"} = $newform{$_} } qw(partnumber description bin unit listprice inventory_accno income_accno expense_accno sellprice);
      $form->{"sellprice_$i"} = $newform{lastcost} if ($form->{vendor_id});

      if ($form->{exchangerate} != 0) {
	$form->{"sellprice_$i"} /= $form->{exchangerate};
      }
      
      map { $form->{"taxaccounts_$i"} .= "$_ " if ($newform{"IC_tax_$_"}) } split / /, $newform{taxaccounts};
      chop $form->{"taxaccounts_$i"};
    }
    
    $form->{"id_$i"} = $parts_id;
    delete $form->{action};


    # restore original callback
  #  $callback = $form->{callback};
  #  $form->{callback} = $form->{old_callback};
  #  delete $form->{old_callback};
       $callback = $form->unescape($form->{callback});
    $form->{callback} = $form->unescape($form->{old_callback});
  # $form->{callback} = $form->unescape($form->{callback});
      delete $form->{old_callback};
 
    # put callback together
    foreach $key (sort keys %$form) {
      # do single escape for Apache 2.0
      $value = $form->escape($form->{$key}, 1);
      $callback .= qq|&$key=$value|;
   }
     $form->{callback} = $callback;
  }
  # $form->dberror( $form->{callback});

  # redirect
  $form->isposted($rc);

}


sub delete_part {

  $form->header;

  print qq|
<body bgcolor=ffffff>

<form method=post action=$form->{script}>
|;

  # delete action variable
  delete $form->{action};

  foreach $key (keys %$form) {
    $form->{$key} =~ s/"/&quot;/g;
    print qq|<input type=hidden name=$key value="$form->{$key}">\n|;
  }

  print qq|
<h2><font color=blue>|.$locale->text('Confirm!').qq|</font></h2>

<h4>|.$locale->text('Are you sure you want to delete Part ').qq| $form->{partnumber}</h4>
<p>
<input onkeydown='setnextfocus(this)' onfocus='setfocus(this);' name=action class=submit type=submit value="|.$locale->text('Yes Delete Part').qq|">
</form>
|;


}

sub yes_delete_part {

  if ($form->{previous_form}) {
    $form->error($locale->text("Cannot delete item which is part of an assembly!"));
  }
  if ($form->{onhand}) {
    $form->error($locale->text("Inventory quantity must be zero!"));
  }
  
  &delete_item;

}


sub delete_service {

  if ($form->{previous_form}) {
    $form->error($locale->text("Cannot delete item which is part of an assembly!"));
  }
  
  &delete_item;
  
}


sub delete_assembly {

  if ($form->{previous_form}) {
    $form->error($locale->text("Cannot delete item which is part of an assembly!"));
  }
  if ($form->{onhand}) {
    $form->error($locale->text("Inventory quantity must be zero!"));
  }
  
  &delete_item;

}


sub delete_combo {

  if ($form->{previous_form}) {
    $form->error($locale->text("Cannot delete item which is part of an assembly!"));
  }
  if ($form->{onhand}) {
    $form->error($locale->text("Inventory quantity must be zero!"));
  }
  
  &delete_item;

}
sub delete_item {

  $rc = IC->delete(\%myconfig, \%$form);
  
  if ($rc == 2) {
    $form->error($locale->text("Cannot delete item already invoiced!"));
  }
  
  if ($rc == 3) {
    $form->error($locale->text("Cannot delete item which is part of an assembly!"));
  }
  
  if ($rc == 4) {
    $form->error($locale->text("Cannot delete item on order!"));
  }
 
  # redirect
  $form->isdeleted($rc);

}



sub stock_assembly {

  $form->{title} = $locale->text('Stock Assembly');
  
  $form->header;
  
  print qq|
<body bgcolor=ffffff>

<form method=post action=$form->{script}>

<table border=1>
<tr><th class=listtop bgcolor=000000><font color=ffffff>$form->{title}</font></th></tr>

<tr valign=top>
<td>
<table>

<tr>

  <th align=right>|.$locale->text('Number').qq|</th>
  <td><input onkeydown='setnextfocus(this)' onfocus='setfocus(this);' name=partnumber size=20></td>

</tr>

<tr>

  <th align=right>|.$locale->text('Description').qq|</th>
  <td><input onkeydown='setnextfocus(this)' onfocus='setfocus(this);' name=description size=35></td>

</tr>

</table>
</td>

</tr>
</table>

<input type=hidden name=path value=$form->{path}>
<input type=hidden name=login value=$form->{login}>
<input type=hidden name=sessionid value=$form->{sessionid}>

<input type=hidden name=nextsub value=list_assemblies>

<br>
<input class=submit type=submit name=action value="|.$locale->text('Continue').qq|">
</form>

<p>
|.$locale->text('To display all items, leave fields blank')

.qq|

</body>
</html>
|;

}



sub list_assemblies {

  IC->retrieve_assemblies(\%myconfig, \%$form);
  

  $column_header{partnumber} = qq|<th><font color=ffffff>|.$locale->text('Number').qq|</th>|;
  $column_header{description} = qq|<th><font color=ffffff>|.$locale->text('Description').qq|</th>|;
  $column_header{bin} = qq|<th><font color=ffffff>|.$locale->text('Bin').qq|</th>|;
  $column_header{onhand} = qq|<th><font color=ffffff>|.$locale->text('Qty').qq|</th>|;
  $column_header{rop} = qq|<th><font color=ffffff>|.$locale->text('ROP').qq|</th>|;
  $column_header{stock} = qq|<th><font color=ffffff>|.$locale->text('Add').qq|</th>|;

  @column_index = (qw(partnumber description bin onhand rop stock));
  
  $form->{title} = $locale->text('Stock Assembly');

  $form->{callback} = "$form->{script}?action=stock_assembly&path=$form->{path}&login=$form->{login}&sessionid=$form->{sessionid}";
  
  $form->header;
  
  $colspan = $#column_index + 1;

  print qq|
<body bgcolor=ffffff>

<form method=post action=$form->{script}>

<table border=1>
<tr><th class=listtop bgcolor=000000 colspan=$colspan><font color=ffffff>$form->{title}</font></th></tr>

<tr class=listheading bgcolor=336666>|;

  map { print "\n$column_header{$_}" } @column_index;

  print qq|
  </tr>
|;

  $i = 1;
  foreach $ref (@{ $form->{assembly_items} }) {

    map { $ref->{$_} =~ s/"/&quot;/g } qw(partnumber description);
   
    # figure out how many to stock
    $form->{"qty_$i"} = $form->format_amount(\%myconfig, $ref->{rop} - $ref->{onhand});

    $column_data{partnumber} = qq|<td>$ref->{partnumber}</td>|;
    $column_data{description} = qq|<td>$ref->{description}&nbsp;</td>|;
    $column_data{bin} = qq|<td>$ref->{bin}&nbsp;</td>|;
    $column_data{onhand} = qq|<td align=right>|.$form->format_amount(\%myconfig, $ref->{onhand}, -1, "&nbsp;").qq|</td>|;
    $column_data{rop} = qq|<td align=right>|.$form->format_amount(\%myconfig, $ref->{rop}, -1, "&nbsp;").qq|</td>|;
    $column_data{stock} = qq|<td><input onkeydown='setnextfocus(this)' onfocus='setfocus(this);' name="qty_$i" size=6 value=$form->{"qty_$i"}></td>|;

    $j++; $j %= 2;
    print qq|<tr class=listrow$j><input onkeydown='setnextfocus(this)' onfocus='setfocus(this);' name="id_$i" type=hidden value=$ref->{id}>\n|;
    
    map { print "\n$column_data{$_}" } @column_index;
    
    print qq|


    </tr>
|;

    $i++;

  }
  
  $i--;
  print qq|
  
</table>
<input onkeydown='setnextfocus(this)' onfocus='setfocus(this);' name=rowcount type=hidden value="$i">

<input type=hidden name=path value=$form->{path}>
<input type=hidden name=login value=$form->{login}>
<input type=hidden name=sessionid value=$form->{sessionid}>

<input onkeydown='setnextfocus(this)' onfocus='setfocus(this);' name=callback type=hidden value="$form->{callback}">

<input type=hidden name=nextsub value=restock_assemblies>

<br>
<input class=submit type=submit name=action value="|.$locale->text('Continue').qq|">

</form>

</body>
</html>
|;
 
}


sub restock_assemblies {

  IC->restock_assemblies(\%myconfig, \%$form);

  $form->redirect;
  
}


