#=====================================================================
# SQL-Ledger Accounting
# Copyright (c) 2001
#
#  Author: Dieter Simader
#   Email: dsimader@sql-ledger.org
#     Web: http://www.sql-ledger.org
#
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License as published by
# the Free Software Foundation; either version 2 of the License, or
# (at your option) any later version.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See thsubsse
# GNU General Public License for more details.
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
#======================================================================
#
# Inventory invoicing module
#
#======================================================================


use SL::IS;
# use SL::Num2text;

$form->{print_invoice_mod}="print_invoice";
$form->{print_pl_mod}="print_packing_list";
	$form->{show_all_price}="true";

#$form->{must_select_item}="true";
#$form->{pagebreak}="true";
#$form->{save_before_click}="true";

require "$form->{path}/io.pl";
require "format/$form->{print_invoice_mod}.pl";
require "format/$form->{print_pl_mod}.pl";

$form->{printtitle}="I N V O I C E" if !$form->{printtitle};

1;
# end of main



sub add {
   #####australia modify
 if(!$form->{page} ||	!$form->{pagerows}){
	 $form->{pagerows}=5;
	$form->{page}=1;
 }
 
  $form->{title} = $locale->text('Add Customer Invoice') if !$form->{title};



  $form->{callback} = "$form->{script}?action=add&path=$form->{path}&login=$form->{login}&sessionid=$form->{sessionid}&subtype=$form->{subtype}&printtitle=".$form->escape($form->{printtitle})."&title=".$form->escape($form->{title});

  if($form->{invdate}){
 $lastbatch = $form->{batch};
 $lastdate = $form->{invdate};
 $accno2=$form->{accno2};
 $accno3=$form->{accno3};
 

 }


  &invoice_links;
if($lastdate){
 $form->{invdate}=$lastdate;
$form->{batch}=$lastbatch;
$form->{accno2}=$accno2;
$form->{accno3}=$accno3;
}
#  $form->dberror($form->{"taxincluded"});
 # lock the exchangerate field
  $form->{forex} = 1;
  $form->{"forex_1"} = 1;

  $i++;
	$j=0;
   while($form->{"partnumber_$i"}){
    # if last row empty, check the form otherwise retrieve new item
$form->{rowcount}=$i;
    IS->retrieve_item(\%myconfig, \%$form);
    $form->{i} = $i;

    $rows = scalar @{ $form->{item_list} };

    $form->{"discount_$i"}	= $form->format_amount(\%myconfig, $form->{discount} * 100);

    if ($rows) {
      $form->{"qty_$i"}		= ($form->{"qty_$i"} * 1) ? $form->{"qty_$i"} : 1;

     # if ($rows > 1) {
	#&select_item;
	#exit;
     # } else {

	map { $form->{item_list}[$i]{$_} =~ s/"/&quot;/g } qw(partnumber description unit);
	map { $form->{"${_}_$i"} = $form->{item_list}[$j]{$_} } keys %{ $form->{item_list}[$j] };
	if($j<=0){
	$j=$j+2;
	}else{
	$j++}
#if($i >2){
#$form->dberror($form->{item_list}[0]{"description"});}

	($dec) = ($form->{"sellprice_$i"} =~ /\.(\d+)/);
	$dec = length $dec;
	$decimalplaces = ($dec > 2) ? $dec : 2;

	# if there is an exchange rate adjust sellprice
	if (($form->{exchangerate} * 1) != 0) {
	  $form->{"sellprice_$i"} /= $form->{exchangerate};
	  $form->{"listprice_$i"} /= $form->{exchangerate};
	}

	map { $form->{"${_}_$i"} = $form->format_amount(\%myconfig, $form->{"${_}_$i"}, $decimalplaces) } qw(sellprice listprice);

	$form->{"qty_$i"} =  $form->format_amount(\%myconfig, $form->{"qty_$i"});


    #  }
  if(!$form->{"part_ordnumber_$i"}){
   if($form->{"partnumber_$i"}){
            $form->{"part_ordnumber_$i"} = $form->{"ordnumber"};
   }
  }
 }
   IS->get_poqty(\%myconfig, \%$form);
   $i++;

}
IS->last_invoice(\%myconfig, \%$form);
   $form->{invnumber}=$form->{lastinvnumber};
   $form->{invnumber}++;
   $form->{new_form}="true";
#form->{lastinvnumber}--;
if($form->{save_before_click}){
IS->post_invoice(\%myconfig, \%$form);
}
  &prepare_invoice;
 #&edit;
}


sub save{
	&post_invoice;	
}

sub delete{
	&delete_invoice;	
}

sub print{
	&print_invoice;	
}

sub update{
	&update_form;	
}



sub invoice_links {

  # create links
#  $myconfig->{customercode}= $form->{customercode};
 
 $form->create_links("AR", \%myconfig, "customer",$form->{group});
#$form->dberror($myconfig->{ccode}); 

  IS->retrieve_invoice(\%myconfig, \%$form);

  # currencies
  @curr = split /:/, $form->{currencies};
  chomp $curr[0];
  $form->{defaultcurrency} = $curr[0];

  map { $form->{selectcurrency} .= "<option value=\"$_\">$_" } @curr;
  
  $taxincluded= $form->{taxincluded};
  
  foreach $ref (@{ $form->{all_customer} }) {
    if ($ref->{id} == $form->{customer_id}) {
     $form->{customer} = "$ref->{name}--$ref->{id}";
 #australia
 $form->{AR1} = "$ref->{customernumber}--$ref->{name}";

      IS->get_customer(\%myconfig, \%$form) unless $form->{id};
    }
    $form->{selectcustomer} .= "<option>$ref->{name}--$ref->{id}";
#australia
$ref->{name} =~ s/'/&#39;/g;
 $ref->{customernumber} =~ s/'/&#39;/g;
     $form->{"selectAR1"} .= "<option value=\"$ref->{customernumber}--$ref->{name}\">$ref->{customernumber}--$ref->{name}";
#      $form->{"chartAR"} .="$ref->{accno}--$ref->{description}\n";
  }
  
  $form->{taxincluded}=$taxincluded if $taxincluded;

  # forex
  $form->{forex} = $form->{exchangerate};

  foreach $key (keys %{ $form->{AR_links} }) {
    
    foreach $ref (@{ $form->{AR_links}{$key} }) {
      $form->{"select$key"} .= "<option value='$ref->{accno}--$ref->{description}'>$ref->{accno}--$ref->{description}";
#australia
      $form->{"chart$key"} .="$ref->{accno}--$ref->{description}";
    }

    if ($key eq "AR_paid") {
      for $i (1 .. scalar @{ $form->{acc_trans}{$key} }) {
	$form->{"AR_paid_$i"} = "$form->{acc_trans}{$key}->[$i-1]->{accno}--$form->{acc_trans}{$key}->[$i-1]->{description}";
	# reverse paid
	$form->{"paid_$i"} = $form->{acc_trans}{$key}->[$i-1]->{amount} * -1;
	$form->{"datepaid_$i"} = $form->{acc_trans}{$key}->[$i-1]->{transdate};
	if ($form->{"exchangerate_$i"} = $form->{acc_trans}{$key}->[$i-1]->{exchangerate}) {
	  $form->{"forex_$i"} = 1;
	} else {
	  $form->{"exchangerate_$i"} = 1;
	}
	$form->{"source_$i"} = $form->{acc_trans}{$key}->[$i-1]->{source};
	$form->{paidaccounts} = $i;
      }
    } else {
      $form->{$key} = "$form->{acc_trans}{$key}->[0]->{accno}--$form->{acc_trans}{$key}->[0]->{description}";
    }
    
#### clear;
          for $i (1 .. scalar @{ $form->{acc_trans}{$key} }) {
		  pop  @{ $form->{acc_trans}{$key} };
	}

  }

  $form->{paidaccounts} = 1 unless (exists $form->{paidaccounts});

  $form->{locked} = ($form->datetonum($form->{invdate}, \%myconfig) <= $form->datetonum($form->{closedto}, \%myconfig));
  
}



sub prepare_invoice {

#  $form->{new_form} = !$form->{id} unless (exists $form->{new_form});

  $form->{format} = "html";
  $form->{media} = "screen";
  $form->{sendmode} = "attachment";
  $form->{copies} = 2;
  
  if ($form->{id}) {
    
    map { $form->{$_} =~ s/"/&quot;/g } qw(invnumber ordnumber shippingpoint notes);

    $form->{creditlimit} = $form->format_amount(\%myconfig, $form->{creditlimit}, 0);
    $form->{creditremaining} = $form->format_amount(\%myconfig, $form->{creditremaining}, 0);

    foreach $ref (@{ $form->{invoice_details} } ) {
      $i++;
      map { $form->{"${_}_$i"} = $ref->{$_} } keys %{ $ref };

      
      $form->{"discount_$i"} = $form->format_amount(\%myconfig, $form->{"discount_$i"} * 100);

      ($dec) = ($form->{"sellprice_$i"} =~ /\.(\d+)/);
      $dec = length $dec;
      $decimalplaces = ($dec > 2) ? $dec : 2;

      $form->{"sellprice_$i"} = $form->format_amount(\%myconfig, $form->{"sellprice_$i"}, $decimalplaces);
      $form->{"qty_$i"} = $form->format_amount(\%myconfig, $form->{"qty_$i"});
      
      map { $form->{"${_}_$i"} =~ s/"/&quot;/g } qw(partnumber description unit);
      $form->{rowcount} = $i;
    }
  }
#  if(!$form->{AR1}){

	#australia
	 $form->{selectAR}=$form->{selectAR1};
 #}
 &display_form;
}

sub prepare_invoice2 {

  $form->{new_form} = !$form->{id} unless (exists $form->{new_form});

  $form->{format} = "html";
  $form->{media} = "screen";
  $form->{sendmode} = "attachment";
  $form->{copies} = 2;

  if ($form->{id}) {
    
    map { $form->{$_} =~ s/"/&quot;/g } qw(invnumber ordnumber shippingpoint notes);

    $form->{creditlimit} = $form->format_amount(\%myconfig, $form->{creditlimit}, 0);
    $form->{creditremaining} = $form->format_amount(\%myconfig, $form->{creditremaining}, 0);

     	$i=0;
    foreach $ref (@{ $form->{invoice_details} } ) {
      $i++;
      map { $form->{"${_}_$i"} = $ref->{$_} } keys %{ $ref };



     $form->{"discount_$i"} = $form->format_amount(\%myconfig, $form->{"discount_$i"} * 100);

      ($dec) = ($form->{"sellprice_$i"} =~ /\.(\d+)/);
      $dec = length $dec;
      $decimalplaces = ($dec > 2) ? $dec : 2;



      
    #  $form->dberror($form->{"sellprice_$i"}*$form->{"qty_$i"}*(100-$form->{"discount_$i"}));
       if($form->{"discount_$i"}  ){
     $form->{"linetotal_$i"} = $form->{"sellprice_$i"}*$form->{"qty_$i"}*(100-$form->{"discount_$i"})/100;
     }else{
     $form->{"linetotal_$i"} =  $form->{"sellprice_$i"}*$form->{"qty_$i"};
     }
      $form->{"sellprice_$i"} = $form->format_amount(\%myconfig, $form->{"sellprice_$i"}, $decimalplaces);
      $form->{"qty_$i"} = $form->format_amount(\%myconfig, $form->{"qty_$i"});
      
      $form->{invsubtotal}  +=$form->{"linetotal_$i"};   
       
      map { $form->{"${_}_$i"} =~ s/"/&quot;/g } qw(partnumber description unit);
      $form->{rowcount} = $i;
      
      
        if (!$form->{taxincluded}) {
    
    foreach $item (split / /, $form->{"taxaccounts_$i"}) {
    #  if ($form->{"${item}_base"}) {
	    $form->{"${item}_base1"}= $form->{invsubtotal};
	    $form->{"${item}_rate1"}=$form->{"${item}_rate"};
	    $form->{"${item}_description1"}=$form->{"${item}_description"};
	$form->{"${item}_total1"} = $form->round_amount($form->{"${item}_base1"} * $form->{"${item}_rate1"}, 2);
	$form->{invtotal} += $form->{"${item}_total1"};
	$form->{"${item}_total1"} = $form->format_amount(\%myconfig, $form->{"${item}_total1"}, 2);
	
	#$form->dberror($form->{"${item}_base"});
    #  }
    }

    $form->{invsubtotal} = $form->format_amount(\%myconfig, $form->{invsubtotal}, 2);
 
  }
  
  
    }
    #########clear 
   for $j(1..$i) {
     pop  @{  $form->{invoice_details}};
 
    }
  }

  $form->{rowcount} ++;

###footnote
  $form->{invtotal} = $form->{invsubtotal};
  if (($rows = $form->numtextrows($form->{notes}, 50, 8)) < 2) {
    $rows = 2;
  }
  $notes = qq|<textarea name=notes rows=$rows cols=50 wrap=soft>$form->{notes}</textarea>|;
  

	   $whole=$form->format_amount(\%myconfig, $form->{invtotal}, 2);
  
  $whole =~ s/,//g;
  
    ($whole, $form->{decimal}) = split /\./, $whole;
  
  $check = new IS $myconfig{countrycode};
  $check->init;
  $form->{text_amount} = $check->num2text($whole);
 # $form->dberror($form->{text_amount});
 if(   $form->{decimal}>0){
	 $form->{text_amount} .= " And ". $check->num2text($form->{decimal})." Cents";
 }
  $form->{text_amount} .=" Only";
  
  $form->{invtotal} = $form->format_amount(\%myconfig, $form->{invtotal}, 2);
  #######


  #&print_invoice;
}


sub form_header {
#$form->dberror($form->{taxincluded});
   $form->{"title"} = $form->unescape($form->{"title"});
 
  $form->{taxincluded} = ($form->{taxincluded}) ? "checked" : "";
#australia
$form->{AR}=$form->{AR1};
	 
#IS->last_invoice(\%myconfig, \%$form);
 #    $form->dberror($form->{selectAR});

#set option selected
  foreach $item (qw(AR customer currency)) {
$form->{"$item"} =~ s/\(/;brak/g;
$form->{"select$item"} =~ s/\(/;brak/g;

$form->{"$item"} =~ s/\)/;2brak/g;
$form->{"select$item"} =~ s/\)/;2brak/g;

$form->{"$item"} =~ s/\[/;brek/g;
$form->{"select$item"} =~ s/\[/;brek/g;

$form->{"$item"} =~ s/\]/;2brek/g;
$form->{"select$item"} =~ s/\]/;2brek/g;

$form->{"$item"} =~ s/'/&#39;/g;
$form->{"select$item"} =~ s/'/&#39;/g;

#'australia
    $form->{"select$item"} = $form->unescape($form->{"select$item"});
    $form->{"$item"} = $form->unescape($form->{"$item"});
# 
    $form->{"select$item"} =~ s/ selected//;
    $form->{"select$item"} =~ s/option value=\"$form->{"$item"}\">\Q$form->{"$item"}\E/option selected value=\"$form->{"$item"}\">$form->{"$item"}/;
   #' if($item eq "AR" &&  !$form->{"accno1_2"}){
    #  $form->{"accno1_2"}=$form->{$item};
    #  $form->{"select$item"}="";
   # }
   
   $form->{"$item"} =~ s/;brak/\(/g;
$form->{"select$item"} =~ s/;brak/\(/g;

$form->{"$item"} =~ s/;2brak/\)/g;
$form->{"select$item"} =~ s/;2brak/\)/g;

   $form->{"$item"} =~ s/;brek/\[/g;
$form->{"select$item"} =~ s/;brek/\[/g;

$form->{"$item"} =~ s/;2brek/\]/g;
$form->{"select$item"} =~ s/;2brek/\]/g;

  }

  ###new added 2002-07-07
 $customer =  qq|<input onkeydown='setnextfocus(this)' onfocus='setfocus(this);' name=customer value="$form->{customer}" size=35>|;

  $form->{exchangerate} = $form->format_amount(\%myconfig, $form->{exchangerate});

  $exchangerate = qq|&nbsp;|;
  if ($form->{currency} ne $form->{defaultcurrency}) {
    if ($form->{forex}) {
      $exchangerate = qq|<input type=hidden name=exchangerate value=$form->{exchangerate}>$form->{exchangerate}|;
    } else {
      $exchangerate = qq|<input onkeydown='setnextfocus(this)' onfocus='setfocus(this);' name=exchangerate size=10 value=$form->{exchangerate}>|;
    }
  }
  $exchangerate .= qq|
<input type=hidden name=forex value=$form->{forex}>
|;

  $form->header;

  $form->{title1}=qq|$form->{title} [ Inv No : $form->{invnumber}, Customer : $form->{AR}, Date : $form->{invdate} ]|;




  print qq|
<script>
<!--
function stb(){document.myform.$form->{nextfocus}.focus();parent.document.title ="$form->{title1}";}

function autoComplete (field, select, property, forcematch) {
	var found = false;
	for (var i = 0; i < select.options.length; i++) {
	if (select.options[i][property].toUpperCase().indexOf(field.value.toUpperCase()) == 0) {
		found=true; break;
		}
	}
	if (found) { select.selectedIndex = i; }
	else { select.selectedIndex = -1; }
	if (field.createTextRange) {
		if (forcematch && !found) {
			field.value=field.value.substring(0,field.value.length-1); 
			return;
			}
		var cursorKeys ="8;46;37;38;39;40;33;34;35;36;45;";
		if (cursorKeys.indexOf(event.keyCode+";") == -1) {
			var r1 = field.createTextRange();
			var oldValue = r1.text;
			var newValue = found ? select.options[i][property] : oldValue;
			if (newValue != field.value) {
				field.value = newValue;
				var rNew = field.createTextRange();
				rNew.moveStart('character', oldValue.length) ;
				rNew.select();
				}
			}
		}
	}
	
// -->
</script><body bgcolor=ffffff   onLoad=stb()>

<form method=post action=$form->{script} name=myform>

<input type=hidden name=id value=$form->{id}>
<input type=hidden name=new_form value=$form->{new_form}>
<input type=hidden name=orderid value=$form->{orderid}>
<input type=hidden name=title value="$form->{title}">
<input type=hidden name=group value="$form->{group}">

<input type=hidden name=customer_id value=$form->{customer_id}>
<input type=hidden name=customer_id3 value=$form->{customer_id}>

<input type=hidden name=discount value=$form->{discount}>
<input type=hidden name=creditlimit value=$form->{creditlimit}>
<input type=hidden name=creditremaining value=$form->{creditremaining}>
<input type=hidden name=lastinvnumber value=$form->{lastinvnumber}>

<input type=hidden name=closedto value=$form->{closedto}>
<input type=hidden name=locked value=$form->{locked}>
<input type=hidden name=must_select_item value=$form->{must_select_item}>
<input type=hidden name=show_all_price value=$form->{show_all_price}>
<input type=hidden name=pagebreak value=$form->{pagebreak}>
<input type=hidden name=print_invoice_mod value=$form->{print_invoice_mod}>
<input type=hidden name=print_pl_mod value=$form->{print_pl_mod}>
<input type=hidden name=printtitle value='$form->{printtitle}'>
<input type=hidden name=no_new_part value='$form->{no_new_part}'>

<table border=0 ><tr><td>

<table border=1 >
<tr class=listtop bgcolor="#ffffff"><th>
<font color=ffffff>$form->{title} </font></th></tr>

<tr valign=top>

<td>
<table callspacing=0 cellpadding=0  border=0 width=100% >
<tr >
  <th align=right>|.$locale->text('Trans No.').qq|</th>
  <td nowrap >&nbsp;<input onkeydown='setnextfocus(this)' onfocus='setfocus(this);' name=transtype  size=4 value="$form->{transtype}"><input onkeydown='setnextfocus(this)' onfocus='setfocus(this);' name=batch size=6 value="$form->{batch}"><input onkeydown='setnextfocus(this)' onfocus='setfocus(this);' name=transno  size=4 value="$form->{transno}"><input onkeydown='setnextfocus(this)' onfocus='setfocus(this);' name=subtransno  size=2 value="$form->{subtransno}"></td>

  <th align=right nowrap>|.$locale->text('Sub No.').qq|<input onkeydown='setnextfocus(this)' onfocus='setfocus(this);' name=subb  size=4 value="$form->{subb}"> </th>
  
   <th align=left nowrap>|.$locale->text('Project No.').qq|<input onkeydown='setnextfocus(this)' onfocus='setfocus(this);' name=project  size=4 value="$form->{project}"></th>
</tr>

<tr>

	   <td align=right>
	     <b>|.$locale->text('Customer').qq|</b>
	   </td>
	   <td colspan=3 nowrap>
	  <input type=hidden name=keys>

	  &nbsp;<select  onkeypress="selectKeyPress();" onkeydown="setsubmit(this);selectKeyDown();" onblur="clr();" onfocus="clr();"  name="AR" >$form->{selectAR}</select>
		
	
	  </td>
	  <input type=hidden name=selectAR value='$form->{selectAR}'>
	  <input type=hidden name=chartAR value='$form->{chartAR}'>
	  <input type=hidden name=taxaccounts_vc value='$form->{taxaccounts_vc}'>

 </tr>





		    <tr>

		      <th align=right>|.$locale->text('Credit Limit').qq|</th>
		      <td align=left>$form->{creditlimit}</td>

		      <th align=right>|.$locale->text('Remaining').qq|</th>
		      <td align=left>$form->{creditremaining}</td>
		    </tr>





<input type=hidden name=selectcustomer value="$form->{selectcustomer}">

|;

  $colspan=8;


 
  print qq|
 <tr>
 	   <td  align=right> 
	    <b>|.$locale->text('Currency').qq|</b>
	   </td>
  <td  align=left nowrap>

  &nbsp;<select  onkeypress="selectKeyPress();" onkeydown="setsubmit(this);selectKeyDown();" onblur="clr();" onfocus="clr();"  name=currency>$form->{selectcurrency}</select>&nbsp;
  
  </td>

 	   <td align=right >
	    <b>|.$locale->text('Exchangerate').qq|</b>
	   </td>

	    <td align=left nowrap>

  $exchangerate
  
  </td>

	   <input type=hidden name=selectcurrency value='$form->{selectcurrency}'>
  <input type=hidden name=defaultcurrency value='$form->{defaultcurrency}'>
  <input type=hidden name=fxgain_accno value=$form->{fxgain_accno}>
  <input type=hidden name=fxloss_accno value=$form->{fxloss_accno}>
</tr>
<tr>
 	   <td align=right>
	     <b>|.$locale->text('Invoice Number').qq|</b>
	   </td>

	   <td nowrap>

	   &nbsp;<input onkeydown='setnextfocus(this)' onfocus='setfocus(this);' name=invnumber size=11 value="$form->{invnumber}">&nbsp;
   <b>|.$locale->text('Last Invoice').qq| : $form->{lastinvnumber}</b>

	   </td>
	   
	    <td align=right>
	     <b>|.$locale->text('Order Number').qq|</b>
	   </td>
	   <td nowrap>

	   &nbsp;<input onkeydown='setnextfocus(this)' onfocus='setfocus(this);' name=ordnumber size=11 value="$form->{ordnumber}">&nbsp;</b>

	   </td>

</tr>



<tr>
	   <td align=right>
	    <b>|.$locale->text('Invoice Date').qq|</b>
	   </td>
  <td  nowrap>


  &nbsp;<input onkeydown='setnextfocus(this)' onfocus='setfocus(this);' name=invdate size=11 value='$form->{invdate}' title="($myconfig{dateformat})">&nbsp;
         <link rel="stylesheet" media="screen" href="javascript/dynCalendar.css" />
<script language="javascript" type="text/javascript" src="javascript/browserSniffer.js"></script>
<script language="javascript" type="text/javascript" src="javascript/dynCalendar.js"></script>
 
   <script language="JavaScript" type="text/javascript">
    <!--
        /**
        * Example callback function
        */
        function calendar1Callback(date, month, year)
        {
            document.forms['myform'].invdate.value = formatDate(new Date(getDateFromFormat(year + '-' + month + '-' + date,'yyyy-M-d')),'$myconfig{dateformat}');
        }

        calendar1 = new dynCalendar('calendar1', 'calendar1Callback', 'javascript/images/');
    //-->
    </script>
    
  </td>
  
  	   <td align=right>
	    <b>|.$locale->text('Date Due').qq|
	   </td>
 <td   nowrap>
  &nbsp;<input onkeydown='setnextfocus(this)' onfocus='setfocus(this);' name=duedate size=11 value='$form->{duedate}' title="($myconfig{dateformat})">

  </td>



</tr>

<tr>
 	   <td align=right>
	     <b>|.$locale->text('Freight').qq|</b>
	   </td>

	   <td  nowrap>
 &nbsp;<input onkeydown='setnextfocus(this)' onfocus='setfocus(this);' name=shippingpoint size=35 value="$form->{shippingpoint}">

  </td>
  
    	   <td align=right>
	    <b>|.$locale->text('Terms').qq|
	   </td>
 <td   nowrap>
  &nbsp;<input onkeydown='setnextfocus(this)' onfocus='setfocus(this);' name=terms size=3 value=$form->{terms}> Days

  </td>
</tr>
<tr>
 	   <td align=right>
	     <b>|.$locale->text('Sales Person').qq|</b>
	   </td>

	   <td colspan=3 nowrap>
 &nbsp;<input onkeydown='setnextfocus(this)' onfocus='setfocus(this);' name=salesperson size=35 value="$form->{salesperson}"><input onkeydown='setnextfocus(this)' onfocus='setfocus(this);' name=salesperson2 type=hidden value="$form->{salesperson2}">

  </td>
  
  </tr>
  <tr>
 	   <td align=right>
	     <b>|.$locale->text('Import From').qq|</b>
	   </td>

	   <td  nowrap>
 &nbsp;<input onkeydown='setnextfocus(this)' onfocus='setfocus(this);' name=ttype size=3 value="$form->{ttype}"><input onkeydown='setnextfocus(this)' onfocus='setfocus(this);' name=onumber  value="">
 
  </td>

  </tr>



<!--tr>
 	   <td align=right>
	     <b>|.$locale->text('D/O No.').qq|</b>
	   </td>
  <td colspan=2 nowrap valigh=top>
  &nbsp;<textarea name="invoiceto" rows=2 cols=20 wrap=soft>$form->{"invoiceto"}</textarea>

     </td>
</tr-->
|;

    print qq|
<input type=hidden name=taxaccounts value="$form->{taxaccounts}">
|;
  foreach $item (split / /, $form->{taxaccounts}) {
    print qq|
    
<input type=hidden name="${item}_rate" value="$form->{"${item}_rate"}">
<input type=hidden name="${item}_description" value="$form->{"${item}_description"}">
<input type=hidden name="${item}_taxnumber" value="$form->{"${item}_taxnumber"}">
|;
  }
  #&email_options;

print qq|  </table>
  <table>|;
}



sub form_footer {

  $form->{DF}{$form->{format}} = "checked";
  $form->{OP}{$form->{media}} = "checked";
  $form->{SM}{$form->{sendmode}} = "checked";
  
  $form->{invtotal} = $form->{invsubtotal};
  
   map { $form->{"${_}_base"} = $form->{taxtotal} } (split / /, $form->{"taxaccounts_vc"}) if !$form->{taxincluded};

  
    
    foreach $item (split / /, $form->{taxaccounts}) {
      if ($form->{"${item}_base"}) {
	$form->{"${item}_total"} = $form->round_amount($form->{"${item}_base"} * $form->{"${item}_rate"}, 2);
	$form->{invtotal} += $form->{"${item}_total"};
	$form->{"${item}_total"} = $form->format_amount(\%myconfig, $form->{"${item}_total"}, 2);
	
	$tax .= qq|
	    <input type=hidden name="${item}_base1" value="$form->{"${item}_base"}">
	    <input type=hidden name="${item}_rate1" value="$form->{"${item}_rate"}">
     	    <input type=hidden name="${item}_description1" value="$form->{"${item}_description"}">
	    <input type=hidden name="${item}_total1" value="$form->{"${item}_total"}">


	|;
      }
    }


  if (!$form->{taxincluded}) {
    foreach $item (split / /, $form->{taxaccounts_vc}) {
	
	$tax .= qq|
	<tr>

	  <th align=right>$form->{"${item}_description"}</th>
	  <td align=right>$form->{"${item}_total"}</td>

	</tr>
	|;
      
    }


    
    $form->{invsubtotal} = $form->format_amount(\%myconfig, $form->{invsubtotal}, 2);
    #$form->{taxtotal} = $form->format_amount(\%myconfig, $form->{taxtotal}, 2);
    
    $subtotal = qq|
      <tr>

	<th align=right>|.$locale->text('Subtotal').qq|</th>
      <td align=right>|.$form->format_amount(\%myconfig,$form->{taxtotal},2).qq|</td>
  
      </tr>
|;

  }

 $whole=$form->format_amount(\%myconfig, $form->{invtotal}, 2);
  
  $whole =~ s/,//g;
  
    ($whole, $form->{decimal}) = split /\./, $whole;
  
  $check = new IS $myconfig{countrycode};
  $check->init;
  $form->{text_amount} = $check->num2text($whole);
 # $form->dberror($form->{text_amount});
 if(   $form->{decimal}>0){
	 $form->{text_amount} .= " And ". $check->num2text($form->{decimal})." Cents";
 }
  $form->{text_amount} .=" Only";
  
  if (($rows = $form->numtextrows($form->{notes}, 50, 8)) < 2) {
    $rows = 2;
  }
  $notes = qq|<textarea name=notes rows=$rows cols=50 wrap=soft>$form->{notes}</textarea><br>$form->{text_amount}<input type=hidden name="text_amount" value="$form->{text_amount}">|;


  $form->{invtotal} = $form->format_amount(\%myconfig, $form->{invtotal}, 2);
  $x=$form->{rowcount}-1;
  
  if(!$form->{"show_all_price"}){
  	$form->{"title2_$x"}="";
  }
  

  print qq|
<tr>
  <td colspan=7>
  <table>
  <tr>
    <td>
      <table>
        $subtotal
	
	$tax
      
	<tr>
 	    <input type=hidden name="invsubtotal" value=$form->{invsubtotal}>

	  <th align=right>|.$locale->text('Total').qq|</th>
	  <td align=right>$form->{invtotal}</td>

	</tr>
      </table>
    </td>|,
    
    qq|<td>
      <table>
	<tr>
	  <th>|.$locale->text('Notes').qq|</th>
	</tr>

	<tr>
	  <td>$notes<br><input onkeydown='setnextfocus(this)' onfocus='setfocus(this);' name=taxincluded class=checkbox type=checkbox value=1 $form->{taxincluded}>&nbsp;<b>|.$locale->text('Tax Included').qq|</td>

	<td>$form->{"title2_$x"}</td>
	</tr>
      </table>
    </td>

  </tr>
  </table>
</tr>
|;

#$form->dberror($query);
  @column_index = qw(datepaid paid exchangerate AR_paid source);
if(!$form->{subtype}){
  print qq|

<tr>
  <td colspan=10>
    <table width=100% >
    <tr class=listheading bgcolor=336666>
    <th colspan=5><font color=ffffff>|.$locale->text('Payments')
    .qq|</font></th>
    </tr>
|;
  $column_data{datepaid} = "<th>".$locale->text('Date')."</th>";
  $column_data{paid} = "<th>".$locale->text('Amount')."</th>";
  $column_data{exchangerate} = "<th>".$locale->text('Exch')."</th>";
  $column_data{AR_paid} = "<th>".$locale->text('Account')."</th>";
  $column_data{source} = "<th>".$locale->text('Source')."</th>";
  
  print "<tr>";
  map { print "$column_data{$_}\n" } @column_index;
  print "</tr>";
      $form->{"selectAR_paid"} = $form->unescape($form->{"selectAR_paid"});
 
  $totalpaid=0;
  	  $form->{paidaccounts}++ if ($form->{"paid_$form->{paidaccounts}"});
	  for $i (1 .. $form->{paidaccounts}) {
    $form->{"AR_paid_$i"} = $form->unescape($form->{"AR_paid_$i"});
	
	    print "<tr>\n";
	# $form->dberror($query);
	
	    $form->{"selectAR_paid_$i"} = $form->{selectAR_paid};
	    $form->{"selectAR_paid_$i"} =~ s/option value='$form->{"AR_paid_$i"}'>\Q$form->{"AR_paid_$i"}\E/option selected  value='$form->{"AR_paid_$i"}'>$form->{"AR_paid_$i"}/;
	    
	    # format amounts
	    $totalpaid+=     $form->{"paid_$i"};
	    $form->{"paid_$i"} = $form->format_amount(\%myconfig, $form->{"paid_$i"}, 2);
	    $form->{"exchangerate_$i"} = $form->format_amount(\%myconfig, $form->{"exchangerate_$i"});
	
	    $exchangerate = qq|&nbsp;|;
	    if ($form->{currency} ne $form->{defaultcurrency}) {
	      if ($form->{"forex_$i"}) {
		$exchangerate = qq|<input type=hidden name="exchangerate_$i" value=$form->{"exchangerate_$i"}>$form->{"exchangerate_$i"}|;
	      } else {
		$exchangerate = qq|<input onkeydown='setnextfocus(this)' onfocus='setfocus(this);' name="exchangerate_$i" size=10 value=$form->{"exchangerate_$i"}>|;
	      }
	    }
	
	    $exchangerate .= qq|
	<input type=hidden name="forex_$i" value=$form->{"forex_$i"}>
	|;
	
	    $column_data{"paid_$i"} = qq|<td align=center><input onkeydown='setnextfocus(this)' onfocus='setfocus(this);' name="paid_$i" size=10 value=$form->{"paid_$i"}></td>|;
	    $column_data{"exchangerate_$i"} = qq|<td align=center>$exchangerate</td>|;
	    $column_data{"AR_paid_$i"} = qq|<td align=center><select  onkeypress="selectKeyPress();" onkeydown="setsubmit(this);selectKeyDown();" onblur="clr();" onfocus="clr();"  name="AR_paid_$i">$form->{"selectAR_paid_$i"}</select></td>|;
	    $column_data{"datepaid_$i"} = qq|<td align=center><input onkeydown='setnextfocus(this)' onfocus='setfocus(this);' name="datepaid_$i" size=11 title=$myconfig{dateformat} value='$form->{"datepaid_$i"}' >
	    
				   <script language="JavaScript" type="text/javascript">
				    <!--
					/**
					* Example callback function
					*/
					function calendar2Callback(date, month, year)
					{
					    document.forms['myform'].datepaid_$i.value = formatDate(new Date(getDateFromFormat(year + '-' + month + '-' + date,'yyyy-M-d')),'$myconfig{dateformat}');
					}
				
					calendar2 = new dynCalendar('calendar2', 'calendar2Callback', 'javascript/images/');
				    //-->
				    </script>
				    </td>|;
	    $column_data{"source_$i"} = qq|<td align=center><input onkeydown='setnextfocus(this)' onfocus='setfocus(this);' name="source_$i" size=10 value="$form->{"source_$i"}"></td>|;
	
	    map { print qq|$column_data{"${_}_$i"}\n| } @column_index;
	    print "</tr>\n";
	  }
  

  $due=$form->parse_amount($myconfig, $form->{invtotal})-$form->parse_amount($myconfig, $totalpaid);
    $column_data{attenddate} = "<th></th>";
  $column_data{datepaid} = "<th>".$locale->text('Total Paid')."</th>";
  $column_data{paid} = "<th>".$form->format_amount(\%myconfig, $totalpaid, 2)."</th>";
  $column_data{exchangerate} = "<th></th>";
  $column_data{AR_paid} = "<th>".$locale->text('Due')."</th>";
  $column_data{source} = "<th>".$form->format_amount(\%myconfig, $due, 2)."</th>";
 	    print "<tr>\n";
   	    map { print qq|$column_data{"${_}"}\n| } @column_index;
	    print "</tr>\n";
}
	    
	    print qq|
  
    
  
    <input type=hidden name=paidaccounts value=$form->{paidaccounts}>
    <input type=hidden name=subtype value=$form->{subtype}>
    <input type=hidden name=AR_paid value=$form->{AR_paid}>
     <input type=hidden name=source value="$form->{source}">
   <input type=hidden name=selectAR_paid value="$form->{selectAR_paid}">
<input type=hidden name=nextfocus value=$form->{nextfocus}>

    </table>
  </td>
</tr>

</table>

</td>
</tr>

</table>
			  <input type=hidden name=action value=update_form2>

|;
   #####australia modify

  if(!$form->{readonly}){
# &print_options;

  $invdate = $form->datetonum($form->{invdate}, \%myconfig);
  $closedto = $form->datetonum($form->{closedto}, \%myconfig);
  
   if ($form->{id}) {
    print qq|
    <input class=submit type=submit name=action value="|.$locale->text('Update').qq|">
    |;
   #####australia modify
   if($form->{pagebreak}){
  		print qq|<br>|;
		for $j (1 ..(( $i/$form->{pagerows})+1) ) {
			  print qq|
			  <input class=submit type=submit name=page value=' $j '>	  
			  |;
		  }
  		print qq|<br>|;
   }
  print qq|
   <input class=submit type=submit name=action value="|.$locale->text('Print').qq|">
    <input class=submit type=submit name=action value="|.$locale->text('Delivery Order').qq|">
|;

    if (!$form->{revtrans}) {
      if (!$form->{locked}) {
	print qq|
	<input class=submit type=submit name=action value="|.$locale->text('Save').qq|">
	<input class=submit type=submit name=action value="|.$locale->text('Delete').qq|">
   <input class=submit type=submit name=action value="|.$locale->text('Search Order').qq|">
|;
      }
    }

    if ($invdate > $closedto) {
      print qq|
      <input class=submit type=submit name=action value="|.$locale->text('Post As New Invoice').qq|">
|;
    }

  } else {
    if ($invdate > $closedto) {
      print qq|
      <input class=submit type=submit name=action value="|.$locale->text('Update').qq|">
   |;
    #####australia modify
    if($form->{pagebreak}){
		print qq|<br>|;
		for $j (1 ..(( $i/$form->{pagerows})+1) ) {
			  print qq|
			  <input class=submit type=submit name=page value=' $j '>	  
			  |;
		  }
  		print qq|<br>|;
    }
  print qq|
      <input class=submit type=submit name=action value="|.$locale->text('Print').qq|">
      <input class=submit type=submit name=action value="|.$locale->text('Delivery Order').qq|">
      <input class=submit type=submit name=action value="|.$locale->text('Save').qq|">
    <input class=submit type=submit name=action value="|.$locale->text('Search Order').qq|">|;
    }
  }
  }

  print qq|

</td>
</tr>

</table>


<input type=hidden name=rowcount value=$form->{rowcount}>

<input onkeydown='setnextfocus(this)' onfocus='setfocus(this);' name=callback type=hidden value="$form->{callback}">

<input type=hidden name=path value=$form->{path}>
<input type=hidden name=login value=$form->{login}>
<input type=hidden name=sessionid value=$form->{sessionid}>

  </form>
|
#<input type=hidden name=printinvoicerowcount value=$form->{printinvoicerowcount}>

.$locale->text('Enter a number or description and click on "Update Form"')
.qq|<br>|
.$locale->text('To remove any items delete the number and click on "Update Form"')

.qq|

</body>
</html>
|;

}


sub print_invoice {
  map { $form->{$_} = $myconfig{$_} } (qw(company address tel fax businessnumber nativecurr fy email name));
  $form->{address} =~ s/\\n/<br>/g;
  $form->{notes} =~ s/\n/<br>/g;

  $form->{employeename} = $form->{name};

  $form->{type} = "invoice";
  $form->{label} = $locale->text('Invoice');
  $form->{vc} = "customer";
  $form->{printpage}=1;
  
  
  
  $form->header;

  $r=0;
  $form->{currentrow}=0;
  $form->{page}=1;
  $terms=$form->{terms};
  
  IS->customer_details(\%myconfig, \%$form);
  $form->{terms11}=$terms;

  print qq|<body bgcolor="#ffffff">|;

  &print_form_header;
  for $i (1 .. $form->{rowcount}-1) {
	  $form->{"description_$i"} =~ s/\n/<br>/g;
	 # $form->dberror( $form->{"description_$i"});
	  $form->{currentrow}++;
	    $r++;
	    if($form->{printinvoicerowcount} > $r){
		    &print_form_row;
	    }else{
		    &print_form_row;
		     &print_page_footer;
		    print qq| <p style="page-break-before: always">&nbsp;</p>|;
		    $form->{page}++;
		    &print_form_header;
		     &print_page_header;
		    $r=0;
	    
	   }
	  
  }
  
  &print_form_footer;
  print qq|    </body>|;
#&print_form;
}


sub delivery_order {
   map { $form->{$_} = $myconfig{$_} } (qw(company address tel fax businessnumber nativecurr fy));
  $form->{address} =~ s/\\n/<br>/g;
  $form->{notes} =~ s/\n/<br>/g;

  $form->{type} = "packing_list";
  $form->{label} = $locale->text('Packing List');
  $form->{vc} = "customer";
  $form->{printpage}=1;
  
  $form->header;

  $terms=$form->{terms};
  
  IS->customer_details(\%myconfig, \%$form);
  $form->{terms11}=$terms;

  print qq|<body bgcolor=ffffff>|;
 		    $form->{page}=1;
  &print_pk_form_header;
  for $i (1 .. $form->{rowcount}-1) {
	  $form->{currentrow}++;
	  $form->{"description_$i"} =~ s/\n/<br>/g;
	    $r++;
	    if($form->{printinvoicerowcount} > $r){
		    &print_pk_form_row;
	    }else{
		    &print_pk_form_row;
		     &print_pk_page_footer;
		    print qq| <p style="page-break-before: always">&nbsp;</p>|;
		    $form->{page}++;
		    &print_pk_form_header;
		     &print_pk_page_header;
		    $r=0;
	    
	   }
	  
  }
  
  &print_pk_form_footer;
}


sub search_order{
#$form->dberror("asdfsdfasd");
$form->{vc}="customer";
$form->{sort}="transdate";

$form->{AR1}=$form->{AR};
		 ($form->{AR}) = split /--/, $form->{AR};
		  IS->get_customerid(\%myconfig, \%$form);
		  $form->{customer_id}=$form->{customer_id2};
		  $form->{vc}="customer";

 IS->retrieve_orders(\%myconfig, \%$form);
#$form->{AR}=$form->{AR2};
	 # $form->dberror( $form->{AR});

&select_oe;

}


   #####australia modify
sub update_form {
 IS->last_invoice(\%myconfig, \%$form);
#$form->{lastinvnumber}--;

   $form->{page}=$form->{focus}/$form->{pagerows};

#$form->dberror($form->{taxincluded});
($form->{page},$dec) = split(/\./,$form->{page});
if($dec >=0){
	  $form->{page}++;	  
  }

  
&update_form2;
}
   #####australia modify

sub update_form2 {
 
 
# &check_name(customer);
  #the following statement must be coresspondent to the io.pl sub form_row();
  #this statment will reorder the sequence of rows
  $form->{AR1}=$form->{AR};
  ( $form->{AR},$null ) = split /--/, $form->{AR};

  for $j(1..$form->{rowcount}){
	  if($form->{"sr_$j"} ne $form->{"sr2_$j"}){
	  for ($i=$form->{"sr2_$j"};$i > $form->{"sr_$j"};--$i){
	       @column_index = qw(partnumber description onhand qty unit   sellprice  lastcost discount bin part_ordnumber last_parts_qty ord_parts qty po_details partnotes id inventory_Accno bin	      income_accno expense_accno listprice assembly taxaccounts parts_id linetotal po delivery_date  remark2);

	          map { $form->{$_."t"} =  $form->{$_."_$form->{\"sr2_$i\"}"} } @column_index;

		  $k=$i-1;
		  map { $form->{$_."_$form->{\"sr2_$i\"}"} =  $form->{$_."_$form->{\"sr2_$k\"}"} } @column_index;

		  map { $form->{$_."_$form->{\"sr2_$k\"}"} =  $form->{$_."t"} } @column_index;

		 
	  }
	  }
	  
 


  }
  ###end of statement of reorder
# $form->{selectAR}=$form->{AR};

IS->get_customerid(\%myconfig, \%$form);

	  $taxincluded=$form->{taxincluded};
   $sp=$form->{salesperson};

if ($form->{customer_id2} ne $form->{customer_id3} || $form->{terms} eq '' ) {
    # delete tax accounts
    $form->{terms} = '';
    $sp='';
    $form->{taxincluded} = '';
 } 

 $form->{customer_id} = $form->{customer_id2};
   map { delete $form->{"${_}_rate"} } (split / /, $form->{taxaccounts});
   map { delete $form->{"${_}_rate"} } (split / /, $form->{taxaccounts_vc});

    IS->get_customer(\%myconfig, \%$form);
$form->{salesperson}=$sp if $sp;
    
    $form->{taxincluded}=$taxincluded if $taxincluded;
#$form->dberror($form->{salesperson});

     $form->{creditlimit} = $form->format_amount(\%myconfig, $form->{creditlimit}, 0);
    $form->{creditremaining} = $form->format_amount(\%myconfig, $form->{creditremaining}, 0);
    #if($form->{salesperson2} ne $form->{salesperson1} ){
	#    $form->{salesperson}=$form->{salesperson1};
	#    $form->{salesperson2}=$form->{salesperson1};
    #}

 

  $form->{exchangerate} = $exchangerate if ($form->{forex} = ($exchangerate = $form->check_exchangerate(\%myconfig, $form->{currency}, $form->{invdate}, 'buy')));
  
  $form->{exchangerate} = $form->parse_amount(\%myconfig, $form->{exchangerate});
  for $i (1 .. $form->{paidaccounts}) {
    if ($form->{"paid_$i"}) {
      map { $form->{"${_}_$i"} = $form->parse_amount(\%myconfig, $form->{"${_}_$i"}) } qw(paid exchangerate);

      $form->{"exchangerate_$i"} = $exchangerate if ($form->{"forex_$i"} = ($exchangerate = $form->check_exchangerate(\%myconfig, $form->{currency}, $form->{"datepaid_$i"}, 'buy')));
    }
  }

   #####australia modify
  $form->{focus}=$form->{rowcount};
#	$form->{"nextfocus"}  = "partnumber_$i";
if($form->{onumber}){
IS->import_item(\%myconfig, \%$form);

}
  $i = $form->{rowcount};

  # if last row empty, check the form otherwise retrieve new item
  if (($form->{"partnumber_$i"} eq "") && ($form->{"description_$i"} eq "")) {

    &check_form;

  } else {
$form->{"partnumber_$i"} =~ s/'/\\'/g;
$form->{"description_$i"} =~ s/'/\\'/g;

    IS->retrieve_item(\%myconfig, \%$form);
    $form->{i} = $i;
    $rows = scalar @{ $form->{item_list} };

    $form->{"discount_$i"}	= $form->format_amount(\%myconfig, $form->{discount} * 100);

    if ($rows) {
      $form->{"qty_$i"}		= ($form->{"qty_$i"} * 1) ? $form->{"qty_$i"} : 1;

      if ($rows > 1 || $form->{must_select_item}) {
	&select_item;
	exit;
      } else {

	map { $form->{item_list}[$i]{$_} =~ s/"/&quot;/g } qw(partnumber description unit);
	map { $form->{"${_}_$i"} = $form->{item_list}[0]{$_} } keys %{ $form->{item_list}[0] };

	($dec) = ($form->{"sellprice_$i"} =~ /\.(\d+)/);
	$dec = length $dec;
	$decimalplaces = ($dec > 2) ? $dec : 2;

	# if there is an exchange rate adjust sellprice
	if (($form->{exchangerate} * 1) != 0) {
	  $form->{"sellprice_$i"} /= $form->{exchangerate};
	  $form->{"listprice_$i"} /= $form->{exchangerate};
	}

	map { $form->{"${_}_$i"} = $form->format_amount(\%myconfig, $form->{"${_}_$i"}, $decimalplaces) } qw(sellprice listprice);
	
	$form->{"qty_$i"} =  $form->format_amount(\%myconfig, $form->{"qty_$i"});

      }
      

      
 # if(!$form->{"part_ordnumber_$i"}){
 # if($form->{"partnumber_$i"}){
 # $form->{"part_ordnumber_$i"} = $form->{"ordnumber"};
# }
# }
   IS->get_poqty(\%myconfig, \%$form);


      &display_form;

    } else {
      # ok, so this is a new part
      # ask if it is a part or service item

      $form->{"id_$i"}          = 0;
      $form->{"unit_$i"}        = $locale->text('ea');

      if (!$form->{no_new_part}){
      &new_item ;
      }else{
	  $form->header;
	 print qq|
	<body bgcolor=ffffff>
	
	<h4><font color=red>|.$locale->text('Item not on file!').qq|</font>
	</body>
	</html>
	|;
      }
    }
  }
 # $form->dberror($form->{"part_ordnumber_$i"});

}



sub post_invoice {

  $form->isblank("invnumber", $locale->text('Invoice Number missing!'));
  $form->isblank("invdate", $locale->text('Invoice Date missing!'));

  &validate_items;
  $taxincluded = $form->{taxincluded};
 ($form->{AR}) = split /--/, $form->{AR};
 $salesperson = $form->{salesperson};
  IS->get_customerid(\%myconfig, \%$form);
  $form->{customer_id}=$form->{customer_id2};
  
  &customer_details;
  $form->{salesperson} = $salesperson;

 $form->{taxincluded}=$taxincluded;

  $closedto = $form->datetonum($form->{closedto}, \%myconfig);
  $invdate = $form->datetonum($form->{invdate}, \%myconfig);
  
  $form->error($locale->text('Cannot post invoice for a closed period!')) if ($invdate <= $closedto);

  $form->isblank("exchangerate", $locale->text('Exchangerate missing!')) if ($form->{currency} ne $form->{defaultcurrency});
  
  for $i (1 .. $form->{paidaccounts}) {
    if ($form->{"paid_$i"}) {
      $datepaid = $form->datetonum($form->{"datepaid_$i"}, \%myconfig);

      $form->isblank("datepaid_$i", $locale->text('Payment date missing!'));
      
      $form->error($locale->text('Cannot post payment for a closed period!')) if ($datepaid <= $closedto);

      if ($form->{currency} ne $form->{defaultcurrency}) {
	$form->{"exchangerate_$i"} = $form->{exchangerate} if ($invdate == $datepaid);
	$form->isblank("exchangerate_$i", $locale->text('Exchangerate for payment missing!'));
      }
    }
  }

      
  ($form->{AR_paid}) = split /--/, $form->{AR_paid};
  
  $form->{label} = $locale->text('Invoice');
  

  if (IS->post_invoice(\%myconfig, \%$form)) {

    if ($form->{orderid}) {

      $form->{script} = "oe.pl";
      &keeporder;
      
    } else {
      if ($form->{new_form}) {
		    
	$form->header;

	print qq|
<body bgcolor=ffffff>

<form method=post action=$form->{script}>
|;

	print qq|
<h2><font color=blue>|.$locale->text('Confirm!').qq|</font></h2>

<h4>|.$locale->text('Do you want to create another Invoice?').qq|</h4>

<input onkeydown='setnextfocus(this)' onfocus='setfocus(this);' name=action class=submit type=submit value="|.$locale->text('Yes').qq|">
<input onkeydown='setnextfocus(this)' onfocus='setfocus(this);' name=action class=submit type=submit value="|.$locale->text('No').qq|">

<input onkeydown='setnextfocus(this)' onfocus='setfocus(this);' name=callback type=hidden value="$form->{callback}&nextfocus=transtype&group=$form->{group}">


<input type=hidden name=path value=$form->{path}>
<input type=hidden name=login value=$form->{login}>
<input type=hidden name=sessionid value=$form->{sessionid}>

</form>
|;

      } else {
	 #    $form->{callback}= $form->unescape($form->{callback});
# $form->dberror($form->{callback}); 
	$form->isposted(1);
      }
    }
  }
  	
}



sub edit {
   #####australia modify
 if(!$form->{page} ||	!$form->{pagerows}){
	 $form->{pagerows}=5;
	$form->{page}=1;
 }
 
  $form->{title} = $locale->text('Edit Customer Invoice');
  
  &invoice_links;
   #   $form->{"accno1_2"}=$form->{AR};
  &prepare_invoice;
  
}



sub delete_invoice {

  $form->header;

  print qq|
<body bgcolor=ffffff>

<form method=post action=$form->{script}>
|;

  # delete action variable
  delete $form->{action};

  foreach $key (keys %$form) {
    $form->{$key} =~ s/"/&quot;/g;
    print qq|<input type=hidden name=$key value="$form->{$key}">\n|;
  }

  print qq|
<h2><font color=blue>|.$locale->text('Confirm!').qq|</font></h2>

<h4>|.$locale->text('Are you sure you want to delete Invoice Number').qq| $form->{invnumber}
</h4>

<p>
<input onkeydown='setnextfocus(this)' onfocus='setfocus(this);' name=action class=submit type=submit value="|.$locale->text('Yes Delete Invoice').qq|">
</form>
|;


}

sub new_invoice {

  $form->header;

  print qq|
<body bgcolor=ffffff>

<form method=post action=$form->{script}>
|;

  # delete action variable
  delete $form->{action};

  foreach $key (keys %$form) {
    $form->{$key} =~ s/"/&quot;/g;
    print qq|<input type=hidden name=$key value="$form->{$key}">\n|;
  }

  print qq|
<h2><font color=blue>|.$locale->text('Confirm!').qq|</font></h2>

<h4>|.$locale->text('Create a new invoice?').qq| $form->{invnumber}
</h4>

<p>
<input onkeydown='setnextfocus(this)' onfocus='setfocus(this);' name=action class=submit type=submit value="|.$locale->text('Yes New Invoice').qq|">
</form>
|;


}

sub yes_new_invoice {

 &add();

}

sub yes_delete_invoice {

  $form->isdeleted(IS->delete_invoice(\%myconfig, \%$form));

}


