#=====================================================================
# SQL-Ledger Accounting
# Copyright (C) 2001
#
#  Author: Dieter Simader
#   Email: dsimader@sql-ledger.org
#     Web: http://www.sql-ledger.org
#
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License as published by
# the Free Software Foundation; either version 2 of the License, or
# (at your option) any later version.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
#======================================================================
#
# module for Chart of Accounts, Income Statement and Balance Sheet
# search and edit transactions posted by the GL, AR and AP
# 
#======================================================================


use SL::CA;

1;
# end of main

# this is for our long dates
# $locale->text('January')
# $locale->text('February')
# $locale->text('March')
# $locale->text('April')
# $locale->text('May ')
# $locale->text('June')
# $locale->text('July')
# $locale->text('August')
# $locale->text('September')
# $locale->text('October')
# $locale->text('November')
# $locale->text('December')

# this is for our short month
# $locale->text('Jan')
# $locale->text('Feb')
# $locale->text('Mar')
# $locale->text('Apr')
# $locale->text('May')
# $locale->text('Jun')
# $locale->text('Jul')
# $locale->text('Aug')
# $locale->text('Sep')
# $locale->text('Oct')
# $locale->text('Nov')
# $locale->text('Dec')


sub chart_of_accounts {

  CA->all_accounts(\%myconfig, \%$form);

  @column_index = qw(accno gifi_accno description debit credit);

  $column_header{accno} = qq|<th><font color=ffffff>|.$locale->text('Account').qq|</th>\n|;
  $column_header{gifi_accno} = qq|<th><font color=ffffff>|.$locale->text('GIFI').qq|</th>\n|;
  $column_header{description} = qq|<th><font color=ffffff>|.$locale->text('Description').qq|</th>\n|;
  $column_header{debit} = qq|<th><font color=ffffff>|.$locale->text('Debit').qq|</th>\n|;
  $column_header{credit} = qq|<th><font color=ffffff>|.$locale->text('Credit').qq|</th>\n|;
  

  $form->{title} = $locale->text('Chart of Accounts');

  $colspan = $#column_index + 1;
  
  $form->header;

  print qq|
  <script>
<!--
function stb(){parent.document.title ="$form->{title}";}

	// -->
</script>

<body bgcolor=ffffff  onLoad=stb()>
  
<table border=0 width=100%>
<tr><th class=listtop bgcolor=000000 colspan=$colspan><font color=ffffff>$form->{title}</font></th></tr>

<tr class=listheading bgcolor=336666>|;

  map { print $column_header{$_} } @column_index;

  print qq|
</tr>
|;

  
  foreach $ca (@{ $form->{CA} }) {

    $description = $form->escape($ca->{description});
    $gifi_description = $form->escape($ca->{gifi_description});
    
    $href = qq|$form->{script}?path=$form->{path}&action=list&accno=$ca->{accno}&login=$form->{login}&sessionid=$form->{sessionid}&description=$description&gifi_accno=$ca->{gifi_accno}&gifi_description=$gifi_description|;
    
    if ($ca->{charttype} eq "H") {
      print qq|<tr class=listheading bgcolor=336666>|;
      map { $column_data{$_} = "<th><font color=ffffff>$ca->{$_}</th>"; } qw(accno description);
      $column_data{gifi_accno} = "<th><font color=ffffff>$ca->{gifi_accno}&nbsp;</font></th>";
    } else {
      $i++; $i %= 2;
      print qq|<tr class=listrow$i>|;
      $column_data{accno} = "<td><a href=$href>$ca->{accno}</a></td>";
      $column_data{gifi_accno} = "<td><a href=$href&accounttype=gifi>$ca->{gifi_accno}</a>&nbsp;</td>";
      $column_data{description} = "<td>$ca->{description}</td>";
    }
      
    $column_data{debit} = "<td align=right>".$form->format_amount(\%myconfig, $ca->{debit}, 2, "&nbsp;")."</td>\n";
    $column_data{credit} = "<td align=right>".$form->format_amount(\%myconfig, $ca->{credit}, 2, "&nbsp;")."</td>\n";
    
    $totaldebit += $ca->{debit};
    $totalcredit += $ca->{credit};

    map { print $column_data{$_} } @column_index;

    print qq|
</tr>
|;
  }

  map { $column_data{$_} = "<td>&nbsp;</td>"; } qw(accno gifi_accno description);

  $column_data{debit} = "<th align=right><font color=ffffff>".$form->format_amount(\%myconfig, $totaldebit, 2, "&nbsp;")."</font></th>";
  $column_data{credit} = "<th align=right><font color=ffffff>".$form->format_amount(\%myconfig, $totalcredit, 2, "&nbsp;")."</font></th>";
  
  print "<tr class=listtotal bgcolor=000000>";

  map { print $column_data{$_} } @column_index;

  print qq|
</tr>

</table>

<br>|.$locale->text('Click on account number to display transactions')

.qq|

</body>
</html>
|;

}


sub list {

  $form->{title} = $locale->text('List Transactions');
  if ($form->{accounttype} eq 'gifi') {
    $form->{title} .= " - ".$locale->text('GIFI')." $form->{gifi_accno}";
  } else {
    $form->{title} .= " - ".$locale->text('Account')." $form->{accno}";
  }
  
  $form->header;
  
  map { $form->{$_} =~ s/"/&quot;/g; } qw(description gifi_description);
 
  print qq|
<body bgcolor=ffffff>

<form method=post action=$form->{script}>

<input type=hidden name=accno value=$form->{accno}>
<input type=hidden name=description value="$form->{description}">
<input type=hidden name=sort value=transdate>

<input type=hidden name=accounttype value=$form->{accounttype}>
<input type=hidden name=gifi_accno value=$form->{gifi_accno}>
<input type=hidden name=gifi_description value="$form->{gifi_description}">

<table border=1>
<tr><th class=listtop bgcolor=000000><font color=ffffff>$form->{title}</font></th></tr>

<tr valign=top>
<td>
<table>

<tr>

  <th align=right>|.$locale->text('From').qq| ($myconfig{dateformat})</th>
  <td><input name=fromdate size=11></td>
  <th align=right>|.$locale->text('To').qq|</th>
  <td><input name=todate size=11></td>

</tr>

<tr>

  <th align=right>|.$locale->text('Include in Report').qq|</th>
  <td colspan=3>
  <input name=l_subtotal class=checkbox type=checkbox value=Y>&nbsp;|.$locale->text('Subtotal').qq|</td>

</tr>
</table>
</td>

</tr>
</table>

<p>
<input type=hidden name=login value=$form->{login}>
<input type=hidden name=path value=$form->{path}>
<input type=hidden name=sessionid value=$form->{sessionid}>

<p><input class=submit type=submit name=action value="|.$locale->text('List Transactions').qq|">
</form>

<p>|.$locale->text('To display all transactions, leave fields blank')

.qq|

</body>
</html>
|;

}


sub list_transactions {

  CA->all_transactions(\%myconfig, \%$form);

  $description = $form->escape($form->{description});
  $gifi_description = $form->escape($form->{gifi_description});

  # construct href
  $href = "$form->{script}?path=$form->{path}&action=list_transactions&accno=$form->{accno}&login=$form->{login}&sessionid=$form->{sessionid}&fromdate=$form->{fromdate}&todate=$form->{todate}&l_subtotal=$form->{l_subtotal}&description=$description&accounttype=$form->{accounttype}&gifi_accno=$form->{gifi_accno}&gifi_description=$gifi_description";

  # construct callback
  $callback = "$form->{script}?path=$form->{path}&action=list_transactions&accno=$form->{accno}&description=$form->{description}&login=$form->{login}&sessionid=$form->{sessionid}&fromdate=$form->{fromdate}&todate=$form->{todate}&subtotal=$form->{l_subtotal}&accounttype=$form->{accounttype}&gifi_accno=$form->{gifi_accno}&gifi_description=$form->{gifi_description}";

  # figure out which column comes first
  $column_header{transdate} = qq|<th><a class=listheading href=$href&sort=transdate><font color=ffffff>|.$locale->text('Date').qq|</a></th>|;
  $column_header{source} = qq|<th><a class=listheading href=$href&sort=source><font color=ffffff>|.$locale->text('Source').qq|</a></th>|;
  $column_header{description} = qq|<th><a class=listheading href=$href&sort=description><font color=ffffff>|.$locale->text('Description').qq|</a></th>|;
  $column_header{debit} = qq|<th><font color=ffffff>|.$locale->text('Debit').qq|</th>|;
  $column_header{credit} = qq|<th><font color=ffffff>|.$locale->text('Credit').qq|</th>|;

  @column_index = $form->sort_columns(qw(transdate source description debit credit));
  
  if ($form->{accounttype} eq 'gifi') {
    map { $form->{$_} = $form->{"gifi_$_"} } qw(accno description);
  }
    
  $form->{title} = ($form->{accounttype} eq 'gifi') ? $locale->text('GIFI') : $locale->text('Account');
  
  $form->{title} .= " $form->{accno} - $form->{description}";
 
 
  if ($form->{fromdate} || $form->{todate}) {
    if ($form->{fromdate}) {
      $fromdate = $locale->date(\%myconfig, $form->{fromdate}, 1);
    }
    if ($form->{todate}) {
      $todate = $locale->date(\%myconfig, $form->{todate}, 1);
    }
    
    $form->{period} = "$fromdate - $todate";
  } else {
    $form->{period} = $locale->date(\%myconfig, $form->current_date(\%myconfig),1);
  }

      if ($form->{project}) {
      $form->{period} .= "<br>".$locale->text('Project')." : $form->{project}";
    }
    if ($form->{sub}) {
      $form->{period} .= "<br>".$locale->text('Sub')." : $form->{sub}";
    }
  $form->header;
  $colspan = $#column_index + 1;

  print qq|
<body bgcolor=ffffff>

<table border=0 width=100%>
<tr><th class=listtop bgcolor=000000 colspan=$colspan><font color=ffffff>$form->{title}</font></th></tr>

<tr><td colspan=$colspan>$form->{period}</td></tr>

<tr class=listheading bgcolor=336666>
|;

map { print "$column_header{$_}\n" } @column_index;

print qq|</tr>|;


  # add sort to callback
  $callback = $form->escape($callback . "&sort=$form->{sort}");

  if (@{ $form->{CA} }) {
    $sameitem = $form->{CA}->[0]->{$form->{sort}};
  }

  foreach $ca (@{ $form->{CA} }) {

    if ($form->{l_subtotal} eq 'Y') {
      if ($sameitem ne $ca->{$form->{sort}}) {
	&ca_subtotal;
      }
    }
    #addjust here
    # construct link to source
    $href = "<a href=$ca->{module}.pl?transdate=$ca->{transdate}&type=$ca->{type}&vc=$ca->{vc}&path=$form->{path}&action=edit&id=$ca->{id}&login=$form->{login}&sessionid=$form->{sessionid}&nextfocus=transtype&callback=$callback>$ca->{source}</a>";

    
    $column_data{debit} = "<td align=right>".$form->format_amount(\%myconfig, $ca->{debit}, 2, "&nbsp;")."</td>";
    $column_data{credit} = "<td align=right>".$form->format_amount(\%myconfig, $ca->{credit}, 2, "&nbsp;")."</td>";

    $subtotaldebit += $ca->{debit};
    $subtotalcredit += $ca->{credit};
    
    $totaldebit += $ca->{debit};
    $totalcredit += $ca->{credit};
    
    $column_data{transdate} = qq|<td>$ca->{transdate}</td>|;
    $column_data{source} = qq|<td>$href</td>|;
    $column_data{description} = qq|<td>$ca->{description}</td>|;
  
    $i++; $i %= 2;
    print "<tr class=listrow$i>";

    map { print $column_data{$_} } @column_index;

    print qq|</tr>
|;

  }
 

  if ($form->{l_subtotal} eq 'Y') {
    &ca_subtotal;
  }
 

  map { $column_data{$_} = "<td>&nbsp;</td>" } @column_index;

  $column_data{debit} = "<th align=right><font color=ffffff>".$form->format_amount(\%myconfig, $totaldebit, 2, "&nbsp;")."</font></th>";
  $column_data{credit} = "<th align=right><font color=ffffff>".$form->format_amount(\%myconfig, $totalcredit, 2, "&nbsp;")."</font></th>";

  print qq|
<tr class=listtotal bgcolor=000000>
|;

  map { print $column_data{$_} } @column_index;

  print qq|
</tr>

|;

  map { $column_data{$_} = "<td>&nbsp;</td>" } @column_index;

  if($totaldebit-$totalcredit < 0){
 	 $column_data{debit} = "<th align=right><font color=ffffff></font></th>";
  	$column_data{credit} = "<th align=right><font color=ffffff>".$form->format_amount(\%myconfig, ($totaldebit-$totalcredit)*-1, 2, "&nbsp;")."</font></th>";
 }else{
 	 $column_data{debit} = "<th align=right><font color=ffffff>".$form->format_amount(\%myconfig, $totaldebit-$totalcredit, 2, "&nbsp;")."</font></th>";
  	$column_data{credit} = "<th align=right><font color=ffffff></font></th>";

 }
  print qq|
<tr class=listtotal bgcolor=000000>
|;

  map { print $column_data{$_} } @column_index;

  print qq|
</tr>
</table>

</body>
</html>
|;
  
}


sub ca_subtotal {

  map { $column_data{$_} = "<td>&nbsp;</td>" } @column_index;

  $column_data{debit} = "<th align=right><font color=ffffff>".$form->format_amount(\%myconfig, $subtotaldebit, 2, "&nbsp;") . "</font></th>";
  $column_data{credit} = "<th align=right><font color=ffffff>".$form->format_amount(\%myconfig, $subtotalcredit, 2, "&nbsp;") . "</font></th>";

  $subtotaldebit = 0;
  $subtotalcredit = 0;

  $sameitem = $ca->{$form->{sort}};

  print "<tr class=listsubtotal bgcolor=333366>";

  map { print "$column_data{$_}\n" } @column_index;

  print "
</tr>
";

}

