
#=====================================================================
# SQL-Ledger Accounting
# Copyright (C) 2001
#
#  Author: Dieter Simader
#   Email: dsimader@sql-ledger.org
#     Web: http://www.sql-ledger.org
#
#  Contributors:
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License as published by
# the Free Software Foundation; either version 2 of the License, or
# (at your option) any later version.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
#======================================================================
#
# General ledger backend code
#
# CHANGE LOG:
#   DS. 2000-07-04  Created
#   DS. 2001-06-12  Changed relations from accno to chart_id
#
#======================================================================

package ob_report;

sub all_transactions {
  my ($self, $myconfig, $form) = @_;

  # connect to database
  my $dbh = $form->dbconnect($myconfig);

  my ($glwhere, $gpwhere, $apwhere) = ("1 = 1", "1 = 1", "1 = 1");

 if ($form->{datefrom}) {
    $glwhere .= " AND acc_trans.transdate = '$form->{datefrom}'";
    $gpwhere .= " AND ou_trans.transdate = '$form->{datefrom}'";
  }

  #if ($form->{description}) {
  #  my $description = $form->like(lc $form->{description});
  #  $glwhere .= " AND lower(description) LIKE '$description'";
#    $arwhere .= " AND lower(customer.name) LIKE '$description'";
#    $apwhere .= " AND lower(vendor.name) LIKE '$description'";
  #}

  my $false = ($myconfig->{dbdriver} eq 'Pg') ? FALSE : q|'0'|;

 # my $sortorder = join ', ', $form->sort_columns(qw(invnumber ordnumber transdate accno partnumber description qty price subtotal1 qtykg customer login ));
  my %ordinal = ( transdate => 6,
                  invnumber => 4,
		  accno => 5 );
  map { $sortorder =~ s/$_/$ordinal{$_}/ } keys %ordinal;
  my $query = qq| select accno,accdesc,sum(amount) as amount from(

		SELECT gl.id, '$form->{transtype1}' AS type, $false AS invoice, gl.source,
                 gl.description, acc_trans.transdate,
		 acc_trans.amount, chart.accno, chart.description as accdesc,chart.gifi_accno, transtype, batch,transno,subtransno,project, subb
                 FROM gl, acc_trans, chart
                 WHERE $glwhere and transtype='$form->{transtype1}'
		 AND acc_trans.chart_id = chart.id
		 AND gl.id = acc_trans.trans_id
UNION ALL
	         SELECT ou.id, '$form->{transtype2}' AS type, $false, ou_trans.source,
		 ou_trans.description, ou_trans.transdate,
		 ou_trans.amount, chart.accno, chart.description as accdesc,chart.gifi_accno,transtype, batch,transno,subtransno,'',''
		 FROM ou,  chart, ou_trans
		 WHERE $gpwhere
		 AND ou_trans.chart_id = chart.id

		 AND ou.id = ou_trans.id

   ) as foo group by accno,accdesc

  |;
  my $sth = $dbh->prepare($query);
#$form->dberror($query);

  $sth->execute || $form->dberror($query);

  while (my $ref = $sth->fetchrow_hashref(NAME_lc)) {

    push @{ $form->{report} }, $ref;

  }

  $sth->finish;


  $dbh->disconnect;

}

1;
